"use strict";
exports.__esModule = true;
var electron_1 = require("electron");
var IpcRendererEventBus_1 = require("./IpcRendererEventBus");
var IpcMainEventBus = /** @class */ (function () {
    function IpcMainEventBus(ipc) {
        this.ipc = ipc;
    }
    IpcMainEventBus.prototype.subscribe = function (subscribeEvent, callback) {
        var _this = this;
        console.log('subscribing', subscribeEvent.topic);
        this.ipc.on(subscribeEvent.topic, function (event, arg) {
            _this.client = event.sender;
            callback(arg);
        });
    };
    IpcMainEventBus.prototype.unsubscribeAll = function (event) {
        console.log('unsubscribeAll', event.topic);
        this.ipc.removeAllListeners(event.topic);
    };
    IpcMainEventBus.prototype.unsubscribe = function (event, callback) {
        throw new Error('Not implemented'); // Todo: implement
    };
    IpcMainEventBus.prototype.emit = function (event, msg) {
        if (!this.client.isDestroyed()) {
            this.client.send(event.topic, msg);
        }
    };
    return IpcMainEventBus;
}());
exports.rendererEvents = new IpcRendererEventBus_1.IpcRendererEventBus(electron_1.ipcRenderer);
exports.backendEvents = new IpcMainEventBus(electron_1.ipcMain);
//# sourceMappingURL=EventBus.js.map