"use strict";
exports.__esModule = true;
var Base64 = require('js-base64').Base64;
var Base64Message = /** @class */ (function () {
    function Base64Message(base64Str) {
        this.base64Message = base64Str;
        this.unicodeValue = Base64.decode(base64Str);
        this.length = base64Str.length;
    }
    Base64Message.toUnicodeString = function (message) {
        return message.unicodeValue || '';
    };
    Base64Message.fromBuffer = function (buffer) {
        return new Base64Message(buffer.toString('base64'));
    };
    Base64Message.fromString = function (str) {
        return new Base64Message(Base64.encode(str));
    };
    Base64Message.toDataUri = function (message, mimeType) {
        return "data:" + mimeType + ";base64," + message.base64Message;
    };
    return Base64Message;
}());
exports.Base64Message = Base64Message;
//# sourceMappingURL=Base64Message.js.map