"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
exports.__esModule = true;
var events_1 = require("../../../events");
var DataSourceStateMachine = /** @class */ (function () {
    function DataSourceStateMachine() {
        this.onUpdate = new events_1.EventDispatcher();
        this.state = {
            error: undefined,
            connected: false,
            connecting: false
        };
    }
    DataSourceStateMachine.prototype.setConnected = function (connected) {
        this.state = {
            connected: connected,
            error: undefined,
            connecting: false
        };
        this.onUpdate.dispatch(this.state);
    };
    DataSourceStateMachine.prototype.setError = function (error) {
        this.state = __assign({}, this.state, { error: error.message });
        this.onUpdate.dispatch(this.state);
    };
    DataSourceStateMachine.prototype.setConnecting = function () {
        this.state = __assign({}, this.state, { connected: false, connecting: true });
        this.onUpdate.dispatch(this.state);
    };
    DataSourceStateMachine.prototype.toJSON = function () {
        return this.state;
    };
    return DataSourceStateMachine;
}());
exports.DataSourceStateMachine = DataSourceStateMachine;
//# sourceMappingURL=DataSourceState.js.map