"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var FileAsync = require("lowdb/adapters/FileAsync");
var fs = require("fs-extra");
var lowdb = require("lowdb");
var path = require("path");
var events_1 = require("../../events");
var StorageEvents_1 = require("../../events/StorageEvents");
var ConfigStorage = /** @class */ (function () {
    function ConfigStorage(file) {
        this.file = file;
    }
    ConfigStorage.prototype.getDb = function () {
        return __awaiter(this, void 0, void 0, function () {
            var pathInfo, adapter, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        pathInfo = path.parse(this.file);
                        // Ensure that Settings dir exists
                        return [4 /*yield*/, fs.mkdirp(pathInfo.dir)];
                    case 1:
                        // Ensure that Settings dir exists
                        _b.sent();
                        adapter = new FileAsync(this.file);
                        if (!!this.database) return [3 /*break*/, 3];
                        _a = this;
                        return [4 /*yield*/, lowdb(adapter)];
                    case 2:
                        _a.database = _b.sent();
                        _b.label = 3;
                    case 3: return [2 /*return*/, this.database];
                }
            });
        });
    };
    ConfigStorage.prototype.init = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                events_1.backendEvents.subscribe(StorageEvents_1.storageStoreEvent, function (event) { return __awaiter(_this, void 0, void 0, function () {
                    var ack, db, error_1;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                ack = StorageEvents_1.makeStorageAcknowledgementEvent(event.transactionId);
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 4, , 5]);
                                return [4 /*yield*/, this.getDb()];
                            case 2:
                                db = _a.sent();
                                return [4 /*yield*/, db.set(event.store, event.data).write()];
                            case 3:
                                _a.sent();
                                events_1.backendEvents.emit(ack, undefined);
                                return [3 /*break*/, 5];
                            case 4:
                                error_1 = _a.sent();
                                events_1.backendEvents.emit(ack, {
                                    error: error_1,
                                    transactionId: event.transactionId,
                                    store: event.store
                                });
                                throw error_1;
                            case 5: return [2 /*return*/];
                        }
                    });
                }); });
                events_1.backendEvents.subscribe(StorageEvents_1.storageLoadEvent, function (event) { return __awaiter(_this, void 0, void 0, function () {
                    var responseEvent, db, data, error_2;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                responseEvent = StorageEvents_1.makeStorageResponseEvent(event.transactionId);
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 4, , 5]);
                                return [4 /*yield*/, this.getDb()];
                            case 2:
                                db = _a.sent();
                                return [4 /*yield*/, db.get(event.store).value()];
                            case 3:
                                data = _a.sent();
                                events_1.backendEvents.emit(responseEvent, {
                                    data: data,
                                    transactionId: event.transactionId,
                                    store: event.store
                                });
                                return [3 /*break*/, 5];
                            case 4:
                                error_2 = _a.sent();
                                events_1.backendEvents.emit(responseEvent, {
                                    error: error_2,
                                    transactionId: event.transactionId,
                                    store: event.store
                                });
                                throw error_2;
                            case 5: return [2 /*return*/];
                        }
                    });
                }); });
                events_1.backendEvents.subscribe(StorageEvents_1.storageClearEvent, function (event) { return __awaiter(_this, void 0, void 0, function () {
                    var db, keys, _i, keys_1, key, error_3;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                _a.trys.push([0, 7, , 8]);
                                return [4 /*yield*/, this.getDb()];
                            case 1:
                                db = _a.sent();
                                return [4 /*yield*/, db.keys().value()];
                            case 2:
                                keys = _a.sent();
                                _i = 0, keys_1 = keys;
                                _a.label = 3;
                            case 3:
                                if (!(_i < keys_1.length)) return [3 /*break*/, 6];
                                key = keys_1[_i];
                                return [4 /*yield*/, db.unset(key).write()];
                            case 4:
                                _a.sent();
                                _a.label = 5;
                            case 5:
                                _i++;
                                return [3 /*break*/, 3];
                            case 6:
                                events_1.backendEvents.emit(StorageEvents_1.makeStorageAcknowledgementEvent(event.transactionId), undefined);
                                return [3 /*break*/, 8];
                            case 7:
                                error_3 = _a.sent();
                                events_1.backendEvents.emit(StorageEvents_1.makeStorageAcknowledgementEvent(event.transactionId), {
                                    error: error_3,
                                    transactionId: event.transactionId
                                });
                                throw error_3;
                            case 8: return [2 /*return*/];
                        }
                    });
                }); });
                return [2 /*return*/];
            });
        });
    };
    return ConfigStorage;
}());
exports["default"] = ConfigStorage;
//# sourceMappingURL=ConfigStorage.js.map