import style from './style';
import compose from './compose';

function transform(value) {
  return value <= 1 ? "".concat(value * 100, "%") : value;
}

export var width = style({
  prop: 'width',
  transform: transform
});
export var maxWidth = style({
  prop: 'maxWidth',
  transform: transform
});
export var minWidth = style({
  prop: 'minWidth',
  transform: transform
});
export var height = style({
  prop: 'height',
  transform: transform
});
export var maxHeight = style({
  prop: 'maxHeight',
  transform: transform
});
export var minHeight = style({
  prop: 'minHeight',
  transform: transform
});
export var sizeWidth = style({
  prop: 'size',
  cssProperty: 'width',
  transform: transform
});
export var sizeHeight = style({
  prop: 'size',
  cssProperty: 'height',
  transform: transform
});
var sizing = compose(width, maxWidth, minWidth, height, maxHeight, minHeight);
export default sizing;