import _extends from "@babel/runtime/helpers/extends";
import warning from 'warning';
import { getDisplayName } from '@material-ui/utils';

function mergeClasses() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var baseClasses = options.baseClasses,
      newClasses = options.newClasses,
      Component = options.Component;

  if (!newClasses) {
    return baseClasses;
  }

  var nextClasses = _extends({}, baseClasses);

  if (process.env.NODE_ENV !== 'production' && typeof newClasses === 'string') {
    process.env.NODE_ENV !== "production" ? warning(false, ["Material-UI: the value `".concat(newClasses, "` ") + "provided to the classes property of ".concat(getDisplayName(Component), " is incorrect."), 'You might want to use the className property instead.'].join('\n')) : void 0;
    return baseClasses;
  }

  Object.keys(newClasses).forEach(function (key) {
    process.env.NODE_ENV !== "production" ? warning(baseClasses[key] || !newClasses[key], ["Material-UI: the key `".concat(key, "` ") + "provided to the classes property is not implemented in ".concat(getDisplayName(Component), "."), "You can only override one of the following: ".concat(Object.keys(baseClasses).join(','), ".")].join('\n')) : void 0;
    process.env.NODE_ENV !== "production" ? warning(!newClasses[key] || typeof newClasses[key] === 'string', ["Material-UI: the key `".concat(key, "` ") + "provided to the classes property is not valid for ".concat(getDisplayName(Component), "."), "You need to provide a non empty string instead of: ".concat(newClasses[key], ".")].join('\n')) : void 0;

    if (newClasses[key]) {
      nextClasses[key] = "".concat(baseClasses[key], " ").concat(newClasses[key]);
    }
  });
  return nextClasses;
}

export default mergeClasses;