import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
// @inheritedComponent Tooltip
import React from 'react';
import PropTypes from 'prop-types';
import clsx from 'clsx';
import { emphasize, withStyles } from '@material-ui/core/styles';
import Fab from '@material-ui/core/Fab';
import Tooltip from '@material-ui/core/Tooltip';
import { withForwardedRef } from '@material-ui/core/utils';
export var styles = function styles(theme) {
  return {
    /* Styles applied to the `Button` component. */
    button: {
      margin: 8,
      color: theme.palette.text.secondary,
      backgroundColor: theme.palette.common.white,
      '&:hover': {
        backgroundColor: emphasize(theme.palette.common.white, 0.15)
      },
      transition: "".concat(theme.transitions.create('transform', {
        duration: theme.transitions.duration.shorter
      }), ", opacity 0.8s"),
      opacity: 1
    },

    /* Styles applied to the `Button` component if `open={false}`. */
    buttonClosed: {
      opacity: 0,
      transform: 'scale(0)'
    }
  };
};

var SpeedDialAction =
/*#__PURE__*/
function (_React$Component) {
  _inherits(SpeedDialAction, _React$Component);

  function SpeedDialAction(props) {
    var _this;

    _classCallCheck(this, SpeedDialAction);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(SpeedDialAction).call(this));

    _this.handleTooltipClose = function () {
      if (_this.props.tooltipOpen) return;

      _this.setState({
        tooltipOpen: false
      });
    };

    _this.handleTooltipOpen = function () {
      if (_this.props.tooltipOpen) return;

      _this.setState({
        tooltipOpen: true
      });
    };

    _this.componentDidUpdate = function (prevProps) {
      if (!_this.props.tooltipOpen || prevProps.open === _this.props.open) return;

      if (!_this.state.tooltipOpen) {
        _this.timeout = setTimeout(function () {
          return _this.setState({
            tooltipOpen: true
          });
        }, _this.props.delay + 100);
      }
    };

    _this.componentWillUnmount = function () {
      return clearTimeout(_this.timeout);
    };

    _this.state = {
      tooltipOpen: props.tooltipOpen
    };
    return _this;
  }

  _createClass(SpeedDialAction, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          ButtonProps = _this$props.ButtonProps,
          classes = _this$props.classes,
          className = _this$props.className,
          delay = _this$props.delay,
          icon = _this$props.icon,
          id = _this$props.id,
          innerRef = _this$props.innerRef,
          onClick = _this$props.onClick,
          onKeyDown = _this$props.onKeyDown,
          open = _this$props.open,
          tooltipTitle = _this$props.tooltipTitle,
          TooltipClasses = _this$props.TooltipClasses,
          tooltipPlacement = _this$props.tooltipPlacement,
          tooltipOpen = _this$props.tooltipOpen,
          other = _objectWithoutProperties(_this$props, ["ButtonProps", "classes", "className", "delay", "icon", "id", "innerRef", "onClick", "onKeyDown", "open", "tooltipTitle", "TooltipClasses", "tooltipPlacement", "tooltipOpen"]);

      var clickProp = {
        onClick: onClick
      };

      if (typeof document !== 'undefined' && 'ontouchstart' in document.documentElement) {
        var startTime;
        clickProp = {
          onTouchStart: function onTouchStart() {
            startTime = new Date();
          },
          onTouchEnd: function onTouchEnd(event) {
            // only perform action if the touch is a tap, i.e. not long press
            if (new Date() - startTime < 500) {
              onClick(event);
            }
          }
        };
      }

      return React.createElement(Tooltip, _extends({
        id: id,
        title: tooltipTitle,
        placement: tooltipPlacement,
        onClose: this.handleTooltipClose,
        onOpen: this.handleTooltipOpen,
        open: open && this.state.tooltipOpen,
        classes: TooltipClasses
      }, other), React.createElement(Fab, _extends({
        size: "small",
        className: clsx(className, classes.button, !open && classes.buttonClosed),
        style: {
          transitionDelay: "".concat(delay, "ms")
        },
        tabIndex: -1,
        role: "menuitem",
        onKeyDown: onKeyDown
      }, ButtonProps, clickProp), icon));
    }
  }]);

  return SpeedDialAction;
}(React.Component);

SpeedDialAction.getDerivedStateFromProps = function (props, state) {
  if (!props.open && state.tooltipOpen) {
    return {
      tooltipOpen: false
    };
  }

  return null;
};

process.env.NODE_ENV !== "production" ? SpeedDialAction.propTypes = {
  /**
   * Properties applied to the [`Button`](/api/button/) component.
   */
  ButtonProps: PropTypes.object,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: PropTypes.object.isRequired,

  /**
   * @ignore
   */
  className: PropTypes.string,

  /**
   * Adds a transition delay, to allow a series of SpeedDialActions to be animated.
   */
  delay: PropTypes.number,

  /**
   * The Icon to display in the SpeedDial Floating Action Button.
   */
  icon: PropTypes.node.isRequired,

  /**
   * @ignore
   */
  id: PropTypes.string,

  /**
   * @ignore
   * from `withForwardRef`
   */
  innerRef: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),

  /**
   * @ignore
   */
  onClick: PropTypes.func,

  /**
   * @ignore
   */
  onKeyDown: PropTypes.func,

  /**
   * @ignore
   */
  open: PropTypes.bool,

  /**
   * Classes applied to the [`Tooltip`](/api/tooltip/) element.
   */
  TooltipClasses: PropTypes.object,

  /**
   * Make the tooltip always visible when the SpeedDial is open.
   */
  tooltipOpen: PropTypes.bool,

  /**
   * Placement of the tooltip.
   */
  tooltipPlacement: PropTypes.oneOf(['bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),

  /**
   * Label to display in the tooltip.
   */
  tooltipTitle: PropTypes.node.isRequired
} : void 0;
SpeedDialAction.defaultProps = {
  delay: 0,
  open: false,
  tooltipPlacement: 'left',
  tooltipOpen: false
};
export default withStyles(styles, {
  name: 'MuiSpeedDialAction'
})(withForwardedRef(SpeedDialAction));