"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _warning = _interopRequireDefault(require("warning"));

var _clsx = _interopRequireDefault(require("clsx"));

var _isValueSelected = _interopRequireDefault(require("./isValueSelected"));

var _styles = require("@material-ui/core/styles");

var styles = function styles(theme) {
  return {
    /* Styles applied to the root element. */
    root: {
      backgroundColor: theme.palette.background.paper,
      borderRadius: 2,
      display: 'inline-flex'
    }
  };
};

exports.styles = styles;

var ToggleButtonGroup = _react.default.forwardRef(function ToggleButton(props, ref) {
  var children = props.children,
      className = props.className,
      classes = props.classes,
      exclusive = props.exclusive,
      onChange = props.onChange,
      size = props.size,
      value = props.value,
      other = (0, _objectWithoutProperties2.default)(props, ["children", "className", "classes", "exclusive", "onChange", "size", "value"]);

  var handleChange = function handleChange(event, buttonValue) {
    if (!onChange) {
      return;
    }

    var index = value && value.indexOf(buttonValue);
    var newValue;

    if (value && index >= 0) {
      newValue = (0, _toConsumableArray2.default)(value);
      newValue.splice(index, 1);
    } else {
      newValue = value ? [].concat((0, _toConsumableArray2.default)(value), [buttonValue]) : [buttonValue];
    }

    onChange(event, newValue);
  };

  var handleExclusiveChange = function handleExclusiveChange(event, buttonValue) {
    if (!onChange) {
      return;
    }

    onChange(event, value === buttonValue ? null : buttonValue);
  };

  return _react.default.createElement("div", (0, _extends2.default)({
    className: (0, _clsx.default)(classes.root, className),
    ref: ref
  }, other), _react.default.Children.map(children, function (child) {
    if (!_react.default.isValidElement(child)) {
      return null;
    }

    process.env.NODE_ENV !== "production" ? (0, _warning.default)(child.type !== _react.default.Fragment, ["Material-UI: the ToggleButtonGroup component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n')) : void 0;
    var _child$props = child.props,
        buttonSelected = _child$props.selected,
        buttonValue = _child$props.value;
    var selected = buttonSelected === undefined ? (0, _isValueSelected.default)(buttonValue, value) : buttonSelected;
    return _react.default.cloneElement(child, {
      selected: selected,
      onChange: exclusive ? handleExclusiveChange : handleChange,
      size: size
    });
  }));
});

process.env.NODE_ENV !== "production" ? ToggleButtonGroup.propTypes = {
  /**
   * The content of the button.
   */
  children: _propTypes.default.node.isRequired,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object.isRequired,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * If `true`, only allow one of the child ToggleButton values to be selected.
   */
  exclusive: _propTypes.default.bool,

  /**
   * Callback fired when the value changes.
   *
   * @param {object} event The event source of the callback
   * @param {object} value of the selected buttons. When `exclusive` is true
   * this is a single value; when false an array of selected values. If no value
   * is selected and `exclusive` is true the value is null; when false an empty array.
   */
  onChange: _propTypes.default.func,

  /**
   * The size of the buttons.
   */
  size: _propTypes.default.oneOf(['small', 'medium', 'large']),

  /**
   * The currently selected value within the group or an array of selected
   * values when `exclusive` is false.
   */
  value: _propTypes.default.any
} : void 0;
ToggleButtonGroup.defaultProps = {
  exclusive: false,
  size: 'medium'
};

var _default = (0, _styles.withStyles)(styles, {
  name: 'MuiToggleButtonGroup'
})(ToggleButtonGroup);

exports.default = _default;