"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _styles = require("@material-ui/core/styles");

var _Fab = _interopRequireDefault(require("@material-ui/core/Fab"));

var _Tooltip = _interopRequireDefault(require("@material-ui/core/Tooltip"));

var _utils = require("@material-ui/core/utils");

// @inheritedComponent Tooltip
var styles = function styles(theme) {
  return {
    /* Styles applied to the `Button` component. */
    button: {
      margin: 8,
      color: theme.palette.text.secondary,
      backgroundColor: theme.palette.common.white,
      '&:hover': {
        backgroundColor: (0, _styles.emphasize)(theme.palette.common.white, 0.15)
      },
      transition: "".concat(theme.transitions.create('transform', {
        duration: theme.transitions.duration.shorter
      }), ", opacity 0.8s"),
      opacity: 1
    },

    /* Styles applied to the `Button` component if `open={false}`. */
    buttonClosed: {
      opacity: 0,
      transform: 'scale(0)'
    }
  };
};

exports.styles = styles;

var SpeedDialAction =
/*#__PURE__*/
function (_React$Component) {
  (0, _inherits2.default)(SpeedDialAction, _React$Component);

  function SpeedDialAction(props) {
    var _this;

    (0, _classCallCheck2.default)(this, SpeedDialAction);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(SpeedDialAction).call(this));

    _this.handleTooltipClose = function () {
      if (_this.props.tooltipOpen) return;

      _this.setState({
        tooltipOpen: false
      });
    };

    _this.handleTooltipOpen = function () {
      if (_this.props.tooltipOpen) return;

      _this.setState({
        tooltipOpen: true
      });
    };

    _this.componentDidUpdate = function (prevProps) {
      if (!_this.props.tooltipOpen || prevProps.open === _this.props.open) return;

      if (!_this.state.tooltipOpen) {
        _this.timeout = setTimeout(function () {
          return _this.setState({
            tooltipOpen: true
          });
        }, _this.props.delay + 100);
      }
    };

    _this.componentWillUnmount = function () {
      return clearTimeout(_this.timeout);
    };

    _this.state = {
      tooltipOpen: props.tooltipOpen
    };
    return _this;
  }

  (0, _createClass2.default)(SpeedDialAction, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          ButtonProps = _this$props.ButtonProps,
          classes = _this$props.classes,
          className = _this$props.className,
          delay = _this$props.delay,
          icon = _this$props.icon,
          id = _this$props.id,
          innerRef = _this$props.innerRef,
          onClick = _this$props.onClick,
          onKeyDown = _this$props.onKeyDown,
          open = _this$props.open,
          tooltipTitle = _this$props.tooltipTitle,
          TooltipClasses = _this$props.TooltipClasses,
          tooltipPlacement = _this$props.tooltipPlacement,
          tooltipOpen = _this$props.tooltipOpen,
          other = (0, _objectWithoutProperties2.default)(_this$props, ["ButtonProps", "classes", "className", "delay", "icon", "id", "innerRef", "onClick", "onKeyDown", "open", "tooltipTitle", "TooltipClasses", "tooltipPlacement", "tooltipOpen"]);
      var clickProp = {
        onClick: onClick
      };

      if (typeof document !== 'undefined' && 'ontouchstart' in document.documentElement) {
        var startTime;
        clickProp = {
          onTouchStart: function onTouchStart() {
            startTime = new Date();
          },
          onTouchEnd: function onTouchEnd(event) {
            // only perform action if the touch is a tap, i.e. not long press
            if (new Date() - startTime < 500) {
              onClick(event);
            }
          }
        };
      }

      return _react.default.createElement(_Tooltip.default, (0, _extends2.default)({
        id: id,
        title: tooltipTitle,
        placement: tooltipPlacement,
        onClose: this.handleTooltipClose,
        onOpen: this.handleTooltipOpen,
        open: open && this.state.tooltipOpen,
        classes: TooltipClasses
      }, other), _react.default.createElement(_Fab.default, (0, _extends2.default)({
        size: "small",
        className: (0, _clsx.default)(className, classes.button, !open && classes.buttonClosed),
        style: {
          transitionDelay: "".concat(delay, "ms")
        },
        tabIndex: -1,
        role: "menuitem",
        onKeyDown: onKeyDown
      }, ButtonProps, clickProp), icon));
    }
  }]);
  return SpeedDialAction;
}(_react.default.Component);

SpeedDialAction.getDerivedStateFromProps = function (props, state) {
  if (!props.open && state.tooltipOpen) {
    return {
      tooltipOpen: false
    };
  }

  return null;
};

process.env.NODE_ENV !== "production" ? SpeedDialAction.propTypes = {
  /**
   * Properties applied to the [`Button`](/api/button/) component.
   */
  ButtonProps: _propTypes.default.object,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object.isRequired,

  /**
   * @ignore
   */
  className: _propTypes.default.string,

  /**
   * Adds a transition delay, to allow a series of SpeedDialActions to be animated.
   */
  delay: _propTypes.default.number,

  /**
   * The Icon to display in the SpeedDial Floating Action Button.
   */
  icon: _propTypes.default.node.isRequired,

  /**
   * @ignore
   */
  id: _propTypes.default.string,

  /**
   * @ignore
   * from `withForwardRef`
   */
  innerRef: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * @ignore
   */
  onClick: _propTypes.default.func,

  /**
   * @ignore
   */
  onKeyDown: _propTypes.default.func,

  /**
   * @ignore
   */
  open: _propTypes.default.bool,

  /**
   * Classes applied to the [`Tooltip`](/api/tooltip/) element.
   */
  TooltipClasses: _propTypes.default.object,

  /**
   * Make the tooltip always visible when the SpeedDial is open.
   */
  tooltipOpen: _propTypes.default.bool,

  /**
   * Placement of the tooltip.
   */
  tooltipPlacement: _propTypes.default.oneOf(['bottom-end', 'bottom-start', 'bottom', 'left-end', 'left-start', 'left', 'right-end', 'right-start', 'right', 'top-end', 'top-start', 'top']),

  /**
   * Label to display in the tooltip.
   */
  tooltipTitle: _propTypes.default.node.isRequired
} : void 0;
SpeedDialAction.defaultProps = {
  delay: 0,
  open: false,
  tooltipPlacement: 'left',
  tooltipOpen: false
};

var _default = (0, _styles.withStyles)(styles, {
  name: 'MuiSpeedDialAction'
})((0, _utils.withForwardedRef)(SpeedDialAction));

exports.default = _default;