"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clsx = _interopRequireDefault(require("clsx"));

var _warning = _interopRequireDefault(require("warning"));

var _Menu = _interopRequireDefault(require("../Menu/Menu"));

var _utils = require("../InputBase/utils");

var _reactHelpers = require("../utils/reactHelpers");

function areEqualValues(a, b) {
  if ((0, _typeof2.default)(b) === 'object' && b !== null) {
    return a === b;
  }

  return String(a) === String(b);
}
/**
 * @ignore - internal component.
 */


var SelectInput = _react.default.forwardRef(function SelectInput(props, ref) {
  var autoFocus = props.autoFocus,
      autoWidth = props.autoWidth,
      children = props.children,
      classes = props.classes,
      className = props.className,
      disabled = props.disabled,
      displayEmpty = props.displayEmpty,
      IconComponent = props.IconComponent,
      inputRef = props.inputRef,
      _props$MenuProps = props.MenuProps,
      MenuProps = _props$MenuProps === void 0 ? {} : _props$MenuProps,
      multiple = props.multiple,
      name = props.name,
      onBlur = props.onBlur,
      onChange = props.onChange,
      onClose = props.onClose,
      onFocus = props.onFocus,
      onOpen = props.onOpen,
      openProp = props.open,
      readOnly = props.readOnly,
      renderValue = props.renderValue,
      required = props.required,
      SelectDisplayProps = props.SelectDisplayProps,
      tabIndexProp = props.tabIndex,
      _props$type = props.type,
      type = _props$type === void 0 ? 'hidden' : _props$type,
      value = props.value,
      variant = props.variant,
      other = (0, _objectWithoutProperties2.default)(props, ["autoFocus", "autoWidth", "children", "classes", "className", "disabled", "displayEmpty", "IconComponent", "inputRef", "MenuProps", "multiple", "name", "onBlur", "onChange", "onClose", "onFocus", "onOpen", "open", "readOnly", "renderValue", "required", "SelectDisplayProps", "tabIndex", "type", "value", "variant"]);

  var displayRef = _react.default.useRef(null);

  var ignoreNextBlur = _react.default.useRef(false);

  var _React$useRef = _react.default.useRef(props.open != null),
      isOpenControlled = _React$useRef.current;

  var _React$useState = _react.default.useState(),
      _React$useState2 = (0, _slicedToArray2.default)(_React$useState, 2),
      menuMinWidthState = _React$useState2[0],
      setMenuMinWidthState = _React$useState2[1];

  var _React$useState3 = _react.default.useState(false),
      _React$useState4 = (0, _slicedToArray2.default)(_React$useState3, 2),
      openState = _React$useState4[0],
      setOpenState = _React$useState4[1];

  var _React$useState5 = _react.default.useState(0),
      _React$useState6 = (0, _slicedToArray2.default)(_React$useState5, 2),
      forceUpdate = _React$useState6[1];

  var handleRef = (0, _reactHelpers.useForkRef)(ref, inputRef);

  _react.default.useImperativeHandle(handleRef, function () {
    return {
      focus: function focus() {
        displayRef.current.focus();
      },
      node: inputRef ? inputRef.current : null,
      value: value
    };
  }, [inputRef, value]);

  _react.default.useEffect(function () {
    if (isOpenControlled && openProp) {
      // Focus the display node so the focus is restored on this element once
      // the menu is closed.
      displayRef.current.focus(); // Rerender with the resolve `displayRef` reference.

      forceUpdate(function (n) {
        return !n;
      });
    }

    if (autoFocus) {
      displayRef.current.focus();
    }
  }, [autoFocus, isOpenControlled, openProp]);

  var update = function update(open, event) {
    if (open) {
      if (onOpen) {
        onOpen(event);
      }
    } else if (onClose) {
      onClose(event);
    }

    if (!isOpenControlled) {
      setMenuMinWidthState(autoWidth ? null : displayRef.current.clientWidth);
      setOpenState(open);
    }
  };

  var handleClick = function handleClick(event) {
    // Opening the menu is going to blur the. It will be focused back when closed.
    ignoreNextBlur.current = true;
    update(true, event);
  };

  var handleClose = function handleClose(event) {
    update(false, event);
  };

  var handleItemClick = function handleItemClick(child) {
    return function (event) {
      if (!multiple) {
        update(false, event);
      }

      if (onChange) {
        var newValue;

        if (multiple) {
          newValue = Array.isArray(value) ? (0, _toConsumableArray2.default)(value) : [];
          var itemIndex = value.indexOf(child.props.value);

          if (itemIndex === -1) {
            newValue.push(child.props.value);
          } else {
            newValue.splice(itemIndex, 1);
          }
        } else {
          newValue = child.props.value;
        }

        event.persist();
        event.target = {
          value: newValue,
          name: name
        };
        onChange(event, child);
      }
    };
  };

  var handleBlur = function handleBlur(event) {
    if (ignoreNextBlur.current === true) {
      // The parent components are relying on the bubbling of the event.
      event.stopPropagation();
      ignoreNextBlur.current = false;
      return;
    }

    if (onBlur) {
      event.persist();
      event.target = {
        value: value,
        name: name
      };
      onBlur(event);
    }
  };

  var handleKeyDown = function handleKeyDown(event) {
    if (!readOnly) {
      var validKeys = [' ', 'ArrowUp', 'ArrowDown', // The native select doesn't respond to enter on MacOS, but it's recommended by
      // https://www.w3.org/TR/wai-aria-practices/examples/listbox/listbox-collapsible.html
      'Enter'];

      if (validKeys.indexOf(event.key) !== -1) {
        event.preventDefault(); // Opening the menu is going to blur the. It will be focused back when closed.

        ignoreNextBlur.current = true;
        update(true, event);
      }
    }
  };

  var open = isOpenControlled && displayRef.current ? openProp : openState;
  delete other['aria-invalid'];
  var display;
  var displaySingle = '';
  var displayMultiple = [];
  var computeDisplay = false; // No need to display any value if the field is empty.

  if ((0, _utils.isFilled)(props) || displayEmpty) {
    if (renderValue) {
      display = renderValue(value);
    } else {
      computeDisplay = true;
    }
  }

  var items = _react.default.Children.map(children, function (child) {
    if (!_react.default.isValidElement(child)) {
      return null;
    }

    process.env.NODE_ENV !== "production" ? (0, _warning.default)(child.type !== _react.default.Fragment, ["Material-UI: the Select component doesn't accept a Fragment as a child.", 'Consider providing an array instead.'].join('\n')) : void 0;
    var selected;

    if (multiple) {
      if (!Array.isArray(value)) {
        throw new Error('Material-UI: the `value` property must be an array ' + 'when using the `Select` component with `multiple`.');
      }

      selected = value.some(function (v) {
        return areEqualValues(v, child.props.value);
      });

      if (selected && computeDisplay) {
        displayMultiple.push(child.props.children);
      }
    } else {
      selected = areEqualValues(value, child.props.value);

      if (selected && computeDisplay) {
        displaySingle = child.props.children;
      }
    }

    return _react.default.cloneElement(child, {
      onClick: handleItemClick(child),
      role: 'option',
      selected: selected,
      value: undefined,
      // The value is most likely not a valid HTML attribute.
      'data-value': child.props.value // Instead, we provide it as a data attribute.

    });
  });

  if (computeDisplay) {
    display = multiple ? displayMultiple.join(', ') : displaySingle;
  } // Avoid performing a layout computation in the render method.


  var menuMinWidth = menuMinWidthState;

  if (!autoWidth && isOpenControlled.current && displayRef.current) {
    menuMinWidth = displayRef.current.clientWidth;
  }

  var tabIndex;

  if (typeof tabIndexProp !== 'undefined') {
    tabIndex = tabIndexProp;
  } else {
    tabIndex = disabled ? null : 0;
  }

  return _react.default.createElement("div", {
    className: classes.root
  }, _react.default.createElement("div", (0, _extends2.default)({
    className: (0, _clsx.default)(classes.select, classes.selectMenu, className, disabled && classes.disabled, variant === 'filled' && classes.filled, variant === 'outlined' && classes.outlined),
    ref: displayRef,
    "aria-pressed": open ? 'true' : 'false',
    tabIndex: tabIndex,
    role: "button",
    "aria-owns": open ? "menu-".concat(name || '') : undefined,
    "aria-haspopup": "true",
    onKeyDown: handleKeyDown,
    onBlur: handleBlur,
    onClick: disabled || readOnly ? null : handleClick,
    onFocus: onFocus // The id can help with end-to-end testing automation.
    ,
    id: name ? "select-".concat(name) : undefined
  }, SelectDisplayProps), display != null ? display : _react.default.createElement("span", {
    dangerouslySetInnerHTML: {
      __html: '&#8203;'
    }
  })), _react.default.createElement("input", (0, _extends2.default)({
    value: Array.isArray(value) ? value.join(',') : value,
    name: name,
    ref: handleRef,
    type: type,
    autoFocus: autoFocus
  }, other)), _react.default.createElement(IconComponent, {
    className: classes.icon
  }), _react.default.createElement(_Menu.default, (0, _extends2.default)({
    id: "menu-".concat(name || ''),
    anchorEl: displayRef.current,
    open: open,
    onClose: handleClose
  }, MenuProps, {
    MenuListProps: (0, _extends2.default)({
      role: 'listbox',
      disableListWrap: true
    }, MenuProps.MenuListProps),
    PaperProps: (0, _extends2.default)({}, MenuProps.PaperProps, {
      style: (0, _extends2.default)({
        minWidth: menuMinWidth
      }, MenuProps.PaperProps != null ? MenuProps.PaperProps.style : null)
    })
  }), items));
});

process.env.NODE_ENV !== "production" ? SelectInput.propTypes = {
  /**
   * @ignore
   */
  autoFocus: _propTypes.default.bool,

  /**
   * If true, the width of the popover will automatically be set according to the items inside the
   * menu, otherwise it will be at least the width of the select input.
   */
  autoWidth: _propTypes.default.bool,

  /**
   * The option elements to populate the select with.
   * Can be some `<MenuItem>` elements.
   */
  children: _propTypes.default.node,

  /**
   * Override or extend the styles applied to the component.
   * See [CSS API](#css) below for more details.
   */
  classes: _propTypes.default.object.isRequired,

  /**
   * The CSS class name of the select element.
   */
  className: _propTypes.default.string,

  /**
   * If `true`, the select will be disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * If `true`, the selected item is displayed even if its value is empty.
   */
  displayEmpty: _propTypes.default.bool,

  /**
   * The icon that displays the arrow.
   */
  IconComponent: _propTypes.default.elementType,

  /**
   * Use that property to pass a ref callback to the native select element.
   */
  inputRef: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Properties applied to the [`Menu`](/api/menu/) element.
   */
  MenuProps: _propTypes.default.object,

  /**
   * If true, `value` must be an array and the menu will support multiple selections.
   */
  multiple: _propTypes.default.bool,

  /**
   * Name attribute of the `select` or hidden `input` element.
   */
  name: _propTypes.default.string,

  /**
   * @ignore
   */
  onBlur: _propTypes.default.func,

  /**
   * Callback function fired when a menu item is selected.
   *
   * @param {object} event The event source of the callback.
   * You can pull out the new value by accessing `event.target.value`.
   * @param {object} [child] The react element that was selected.
   */
  onChange: _propTypes.default.func,

  /**
   * Callback fired when the component requests to be closed.
   * Use in controlled mode (see open).
   *
   * @param {object} event The event source of the callback
   */
  onClose: _propTypes.default.func,

  /**
   * @ignore
   */
  onFocus: _propTypes.default.func,

  /**
   * Callback fired when the component requests to be opened.
   * Use in controlled mode (see open).
   *
   * @param {object} event The event source of the callback
   */
  onOpen: _propTypes.default.func,

  /**
   * Control `select` open state.
   */
  open: _propTypes.default.bool,

  /**
   * @ignore
   */
  readOnly: _propTypes.default.bool,

  /**
   * Render the selected value.
   *
   * @param {*} value The `value` provided to the component.
   * @returns {ReactElement}
   */
  renderValue: _propTypes.default.func,

  /**
   * @ignore
   */
  required: _propTypes.default.bool,

  /**
   * Properties applied to the clickable div element.
   */
  SelectDisplayProps: _propTypes.default.object,

  /**
   * @ignore
   */
  tabIndex: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * @ignore
   */
  type: _propTypes.default.string,

  /**
   * The input value.
   */
  value: _propTypes.default.any.isRequired,

  /**
   * The variant to use.
   */
  variant: _propTypes.default.oneOf(['standard', 'outlined', 'filled'])
} : void 0;
var _default = SelectInput;
exports.default = _default;