"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.styles = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var styles = {
  /* Styles applied to the root element. */
  root: {
    zIndex: -1,
    position: 'fixed',
    right: 0,
    bottom: 0,
    top: 0,
    left: 0,
    backgroundColor: 'rgba(0, 0, 0, 0.5)',
    // Remove grey highlight
    WebkitTapHighlightColor: 'transparent',
    // Disable scroll capabilities.
    touchAction: 'none'
  },

  /* Styles applied to the root element if `invisible={true}`. */
  invisible: {
    backgroundColor: 'transparent'
  }
};
/**
 * @ignore - internal component.
 */

exports.styles = styles;

var SimpleBackdrop = _react.default.forwardRef(function SimpleBackdrop(props, ref) {
  var invisible = props.invisible,
      open = props.open,
      other = (0, _objectWithoutProperties2.default)(props, ["invisible", "open"]);
  return open ? _react.default.createElement("div", (0, _extends2.default)({
    "aria-hidden": true,
    ref: ref
  }, other, {
    style: (0, _extends2.default)({}, styles.root, invisible ? styles.invisible : {}, other.style)
  })) : null;
});

process.env.NODE_ENV !== "production" ? SimpleBackdrop.propTypes = {
  /**
   * If `true`, the backdrop is invisible.
   * It can be used when rendering a popover or a custom select component.
   */
  invisible: _propTypes.default.bool,

  /**
   * If `true`, the backdrop is open.
   */
  open: _propTypes.default.bool.isRequired
} : void 0;
SimpleBackdrop.defaultProps = {
  invisible: false
};
var _default = SimpleBackdrop;
exports.default = _default;