"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _styles = require("../styles");

var _utils = require("@material-ui/utils");

var useStyles = (0, _styles.makeStyles)(function (theme) {
  return {
    '@global': {
      html: {
        WebkitFontSmoothing: 'antialiased',
        // Antialiasing.
        MozOsxFontSmoothing: 'grayscale',
        // Antialiasing.
        // Change from `box-sizing: content-box` so that `width`
        // is not affected by `padding` or `border`.
        boxSizing: 'border-box'
      },
      '*, *::before, *::after': {
        boxSizing: 'inherit'
      },
      'strong, b': {
        fontWeight: 'bolder'
      },
      body: (0, _extends2.default)({
        margin: 0,
        // Remove the margin in all browsers.
        color: theme.palette.text.primary
      }, theme.typography.body2, {
        backgroundColor: theme.palette.background.default,
        '@media print': {
          // Save printer ink.
          backgroundColor: theme.palette.common.white
        }
      })
    }
  };
}, {
  name: 'MuiCssBaseline'
});
/**
 * Kickstart an elegant, consistent, and simple baseline to build upon.
 */

function CssBaseline(props) {
  var _props$children = props.children,
      children = _props$children === void 0 ? null : _props$children;
  useStyles();
  return _react.default.createElement(_react.default.Fragment, null, children);
}

process.env.NODE_ENV !== "production" ? CssBaseline.propTypes = {
  /**
   * You can wrap a node.
   */
  children: _propTypes.default.node
} : void 0;

if (process.env.NODE_ENV !== 'production') {
  // eslint-disable-next-line
  CssBaseline['propTypes' + ''] = (0, _utils.exactProp)(CssBaseline.propTypes);
}

var _default = CssBaseline;
exports.default = _default;