/*
 * Decompiled with CFR 0.152.
 */
package davmail.util;

import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public final class StringUtil {
    private static final Pattern AMP_PATTERN = Pattern.compile("&");
    private static final Pattern PLUS_PATTERN = Pattern.compile("\\+");
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern CR_PATTERN = Pattern.compile("\r");
    private static final Pattern LF_PATTERN = Pattern.compile("\n");
    private static final List<PatternMap> URLENCODED_PATTERNS = new ArrayList<PatternMap>();
    private static final List<PatternMap> URLENCODE_PATTERNS;
    private static final List<PatternMap> XML_DECODE_PATTERNS;
    private static final List<PatternMap> XML_ENCODE_PATTERNS;
    private static final Pattern SLASH_PATTERN;
    private static final Pattern UNDERSCORE_PATTERN;
    private static final Pattern DASH_PATTERN;
    private static final Pattern APOS_PATTERN;

    private StringUtil() {
    }

    public static String getToken(String value, String startDelimiter, String endDelimiter) {
        int endIndex;
        int startIndex;
        String token = null;
        if (value != null && (startIndex = value.indexOf(startDelimiter)) >= 0 && (endIndex = value.indexOf(endDelimiter, startIndex += startDelimiter.length())) >= 0) {
            token = value.substring(startIndex, endIndex);
        }
        return token;
    }

    public static String getLastToken(String value, String startDelimiter, String endDelimiter) {
        int endIndex;
        int startIndex;
        String token = null;
        if (value != null && (startIndex = value.lastIndexOf(startDelimiter)) >= 0 && (endIndex = value.indexOf(endDelimiter, startIndex += startDelimiter.length())) >= 0) {
            token = value.substring(startIndex, endIndex);
        }
        return token;
    }

    public static String replaceToken(String value, String startDelimiter, String endDelimiter, String newToken) {
        int endIndex;
        int startIndex;
        String result = null;
        if (value != null && (startIndex = value.indexOf(startDelimiter)) >= 0 && (endIndex = value.indexOf(endDelimiter, startIndex += startDelimiter.length())) >= 0) {
            result = value.substring(0, startIndex) + newToken + value.substring(endIndex);
        }
        return result;
    }

    public static String join(Set<String> values, String separator) {
        if (values != null && !values.isEmpty()) {
            StringBuilder result = new StringBuilder();
            for (String value : values) {
                if (result.length() > 0) {
                    result.append(separator);
                }
                result.append(value);
            }
            return result.toString();
        }
        return null;
    }

    public static String xmlEncode(String name) {
        String result = name;
        if (result != null) {
            for (PatternMap patternMap : XML_ENCODE_PATTERNS) {
                result = patternMap.replaceAll(result);
            }
        }
        return result;
    }

    public static String xmlEncodeAttribute(String name) {
        String result = StringUtil.xmlEncode(name);
        if (result != null) {
            if (result.indexOf(34) >= 0) {
                result = QUOTE_PATTERN.matcher(result).replaceAll("&#x22;");
            }
            if (result.indexOf(13) >= 0) {
                result = CR_PATTERN.matcher(result).replaceAll("&#x0D;");
            }
            if (result.indexOf(10) >= 0) {
                result = LF_PATTERN.matcher(result).replaceAll("&#x0A;");
            }
        }
        return result;
    }

    public static String xmlDecode(String name) {
        String result = name;
        if (result != null) {
            for (PatternMap patternMap : XML_DECODE_PATTERNS) {
                result = patternMap.replaceAll(result);
            }
        }
        return result;
    }

    public static String base64ToHex(String value) {
        String hexValue = null;
        if (value != null) {
            hexValue = new String(Hex.encodeHex(Base64.decodeBase64(value.getBytes(StandardCharsets.UTF_8))));
        }
        return hexValue;
    }

    public static String hexToBase64(String value) throws DecoderException {
        String base64Value = null;
        if (value != null) {
            base64Value = new String(Base64.encodeBase64(Hex.decodeHex(value.toCharArray())), StandardCharsets.UTF_8);
        }
        return base64Value;
    }

    public static String encodeUrlcompname(String value) {
        String result = value;
        if (result != null) {
            for (PatternMap patternMap : URLENCODE_PATTERNS) {
                result = patternMap.replaceAll(result);
            }
        }
        return result;
    }

    public static String decodeUrlcompname(String urlcompname) {
        String result = urlcompname;
        if (result != null) {
            for (PatternMap patternMap : URLENCODED_PATTERNS) {
                result = patternMap.replaceAll(result);
            }
        }
        return result;
    }

    public static String encodePlusSign(String value) {
        String result = value;
        if (result.indexOf(43) >= 0) {
            result = PLUS_PATTERN.matcher(result).replaceAll("%2B");
        }
        return result;
    }

    public static String base64ToUrl(String value) {
        String result = value;
        if (result != null) {
            if (result.indexOf(43) >= 0) {
                result = PLUS_PATTERN.matcher(result).replaceAll("-");
            }
            if (result.indexOf(47) >= 0) {
                result = SLASH_PATTERN.matcher(result).replaceAll("_");
            }
        }
        return result;
    }

    public static String urlToBase64(String value) {
        String result = value;
        if (result.indexOf(45) >= 0) {
            result = DASH_PATTERN.matcher(result).replaceAll("+");
        }
        if (result.indexOf(95) >= 0) {
            result = UNDERSCORE_PATTERN.matcher(result).replaceAll("/");
        }
        return result;
    }

    public static String davSearchEncode(String value) {
        return StringUtil.escapeQuotes(value);
    }

    public static String escapeQuotes(String value) {
        String result = value;
        if (result.indexOf(39) >= 0) {
            result = APOS_PATTERN.matcher(result).replaceAll("''");
        }
        return result;
    }

    public static String convertZuluDateTimeToAllDay(String value) {
        String result = value;
        if (value != null && value.length() != 8) {
            try {
                Calendar calendar = Calendar.getInstance();
                SimpleDateFormat dateParser = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
                calendar.setTime(dateParser.parse(value));
                calendar.add(11, 12);
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd");
                result = dateFormatter.format(calendar.getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String parseQuotedImapString(String quoted) throws ParseException {
        if (null == quoted) {
            return null;
        }
        char[] quotedChars = quoted.toCharArray();
        if (quotedChars.length < 2) {
            throw new ParseException("Not a valid imap quoted string (too short): " + quoted, 0);
        }
        if ('\"' != quotedChars[0]) {
            throw new ParseException("Not a valid imap quoted string (does not start with double quote): " + quoted, 0);
        }
        char[] resultChars = new char[quotedChars.length - 2];
        int resultPos = 0;
        boolean backslashMode = false;
        for (int i = 1; i < quotedChars.length - 1; ++i) {
            if (backslashMode) {
                if ('\\' == quotedChars[i] || '\"' == quotedChars[i]) {
                    resultChars[resultPos++] = quotedChars[i];
                    backslashMode = false;
                    continue;
                }
                throw new ParseException("Not a valid imap quoted string (only '\"' and '\\' allowed after '\\') at index " + i + ": " + quoted, i);
            }
            if ('\\' == quotedChars[i]) {
                backslashMode = true;
                continue;
            }
            resultChars[resultPos++] = quotedChars[i];
        }
        if (backslashMode) {
            throw new ParseException("Not a valid imap quoted string (outer ending quote is backslashed): " + quoted, quotedChars.length - 1);
        }
        if ('\"' != quotedChars[quotedChars.length - 1]) {
            throw new ParseException("Not a valid imap quoted string (does not end with double quotes): " + quoted, quotedChars.length - 1);
        }
        return new String(resultChars, 0, resultPos);
    }

    public static String removeQuotes(String value) {
        String result = value;
        if (result != null) {
            if (result.startsWith("\"") || result.startsWith("{") || result.startsWith("(")) {
                result = result.substring(1);
            }
            if (result.endsWith("\"") || result.endsWith("}") || result.endsWith(")")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }

    public static String decodeFolderName(String folderName) {
        if (folderName.contains("_xF8FF_")) {
            return folderName.replace("_xF8FF_", "/");
        }
        if (folderName.contains("_x003E_")) {
            return folderName.replace("_x003E_", ">");
        }
        return folderName;
    }

    public static String encodeFolderName(String folderName) {
        if (folderName.contains("/")) {
            folderName = folderName.replace("/", "_xF8FF_");
        }
        if (folderName.contains(">")) {
            folderName = folderName.replace(">", "_x003E_");
        }
        return folderName;
    }

    static {
        URLENCODED_PATTERNS.add(new PatternMap(String.valueOf('\uf8ff'), "_xF8FF_"));
        URLENCODED_PATTERNS.add(new PatternMap("%26", "&"));
        URLENCODED_PATTERNS.add(new PatternMap("%2B", "+"));
        URLENCODED_PATTERNS.add(new PatternMap("%3A", ":"));
        URLENCODED_PATTERNS.add(new PatternMap("%3B", ";"));
        URLENCODED_PATTERNS.add(new PatternMap("%3C", "<"));
        URLENCODED_PATTERNS.add(new PatternMap("%3E", ">"));
        URLENCODED_PATTERNS.add(new PatternMap("%22", "\""));
        URLENCODED_PATTERNS.add(new PatternMap("%23", "#"));
        URLENCODED_PATTERNS.add(new PatternMap("%2A", "*"));
        URLENCODED_PATTERNS.add(new PatternMap("%7C", "|"));
        URLENCODED_PATTERNS.add(new PatternMap("%3F", "?"));
        URLENCODED_PATTERNS.add(new PatternMap("%7E", "~"));
        URLENCODED_PATTERNS.add(new PatternMap("\n", "_x000D__x000A_"));
        URLENCODED_PATTERNS.add(new PatternMap("%25", "%"));
        URLENCODE_PATTERNS = new ArrayList<PatternMap>();
        URLENCODE_PATTERNS.add(new PatternMap("%", "%25"));
        URLENCODE_PATTERNS.add(new PatternMap("_xF8FF_", String.valueOf('\uf8ff')));
        URLENCODE_PATTERNS.add(new PatternMap("&", AMP_PATTERN, "%26"));
        URLENCODE_PATTERNS.add(new PatternMap("+", PLUS_PATTERN, "%2B"));
        URLENCODE_PATTERNS.add(new PatternMap(":", "%3A"));
        URLENCODE_PATTERNS.add(new PatternMap(";", "%3B"));
        URLENCODE_PATTERNS.add(new PatternMap("<", "%3C"));
        URLENCODE_PATTERNS.add(new PatternMap(">", "%3E"));
        URLENCODE_PATTERNS.add(new PatternMap("\"", "%22"));
        URLENCODE_PATTERNS.add(new PatternMap("#", "%23"));
        URLENCODE_PATTERNS.add(new PatternMap("~", "%7E"));
        URLENCODE_PATTERNS.add(new PatternMap("*", "\\*", "%2A"));
        URLENCODE_PATTERNS.add(new PatternMap("|", "\\|", "%7C"));
        URLENCODE_PATTERNS.add(new PatternMap("?", "\\?", "%3F"));
        URLENCODE_PATTERNS.add(new PatternMap("_x000D__x000A_", "\r\n"));
        XML_DECODE_PATTERNS = new ArrayList<PatternMap>();
        XML_DECODE_PATTERNS.add(new PatternMap("&amp;", "&"));
        XML_DECODE_PATTERNS.add(new PatternMap("&lt;", "<"));
        XML_DECODE_PATTERNS.add(new PatternMap("&gt;", ">"));
        XML_ENCODE_PATTERNS = new ArrayList<PatternMap>();
        XML_ENCODE_PATTERNS.add(new PatternMap("&", AMP_PATTERN, "&amp;"));
        XML_ENCODE_PATTERNS.add(new PatternMap("<", "&lt;"));
        XML_ENCODE_PATTERNS.add(new PatternMap(">", "&gt;"));
        SLASH_PATTERN = Pattern.compile("/");
        UNDERSCORE_PATTERN = Pattern.compile("_");
        DASH_PATTERN = Pattern.compile("-");
        APOS_PATTERN = Pattern.compile("'");
    }

    static class PatternMap {
        protected String match;
        protected String value;
        protected Pattern pattern;

        protected PatternMap(String match, String value) {
            this.match = match;
            this.value = value;
            this.pattern = Pattern.compile(match);
        }

        protected PatternMap(String match, String escapedMatch, String value) {
            this.match = match;
            this.value = value;
            this.pattern = Pattern.compile(escapedMatch);
        }

        protected PatternMap(String match, Pattern pattern, String value) {
            this.match = match;
            this.value = value;
            this.pattern = pattern;
        }

        protected String replaceAll(String string) {
            if (string != null && string.contains(this.match)) {
                return this.pattern.matcher(string).replaceAll(this.value);
            }
            return string;
        }
    }
}

