/*
 * Decompiled with CFR 0.152.
 */
package davmail.util;

import davmail.Settings;
import davmail.util.IOUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class StringEncryptor {
    static final String ALGO = "PBEWithHmacSHA256AndAES_128";
    static final String DEFAULT_FINGERPRINT = "davmailgateway!&";
    private final String password;

    public StringEncryptor(String password) {
        this.password = password;
    }

    public String encryptString(String value) throws IOException {
        try {
            byte[] plaintext = value.getBytes(StandardCharsets.UTF_8);
            Cipher enc = Cipher.getInstance(ALGO);
            enc.init(1, (Key)this.getSecretKey(), this.getPBEParameterSpec());
            byte[] encrypted = enc.doFinal(plaintext);
            return "{AES}" + IOUtil.encodeBase64AsString(encrypted);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String decryptString(String value) throws IOException {
        if (value != null && value.startsWith("{AES}")) {
            try {
                byte[] encrypted = IOUtil.decodeBase64(value.substring(5));
                Cipher dec = Cipher.getInstance(ALGO);
                dec.init(2, (Key)this.getSecretKey(), this.getPBEParameterSpec());
                byte[] decrypted = dec.doFinal(encrypted);
                return new String(decrypted, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return value;
    }

    private SecretKey getSecretKey() throws InvalidKeySpecException, NoSuchAlgorithmException {
        PBEKeySpec keySpec = new PBEKeySpec(this.password.toCharArray());
        SecretKeyFactory kf = SecretKeyFactory.getInstance(ALGO);
        return kf.generateSecret(keySpec);
    }

    private PBEParameterSpec getPBEParameterSpec() {
        byte[] bytes = Settings.getProperty("davmail.oauth.fingerprint", DEFAULT_FINGERPRINT).getBytes(StandardCharsets.UTF_8);
        return new PBEParameterSpec(bytes, 10000, new IvParameterSpec(bytes));
    }
}

