/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui.tray;

import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.Settings;
import davmail.ui.AboutFrame;
import davmail.ui.SettingsFrame;
import davmail.ui.tray.DavGatewayTray;
import davmail.ui.tray.DavGatewayTrayInterface;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

public class SwtGatewayTray
implements DavGatewayTrayInterface {
    private static final Logger LOGGER = Logger.getLogger(SwtGatewayTray.class);
    private static final Object LOCK = new Object();
    static SettingsFrame settingsFrame;
    static AboutFrame aboutFrame;
    private static TrayItem trayItem;
    private static ArrayList<Image> frameIcons;
    private static org.eclipse.swt.graphics.Image image;
    private static org.eclipse.swt.graphics.Image image2;
    private static org.eclipse.swt.graphics.Image inactiveImage;
    private static Display display;
    private static Shell shell;
    private boolean isActive = true;
    private static boolean isReady;
    private static Error error;
    private boolean firstMessage = true;

    protected SwtGatewayTray() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initDisplay() {
        if (isReady) return;
        Thread swtThread = new Thread("SWT"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    display = Display.getDefault();
                    shell = new Shell(display);
                    Object object = LOCK;
                    synchronized (object) {
                        isReady = true;
                        LOCK.notifyAll();
                    }
                    while (!shell.isDisposed()) {
                        if (display.readAndDispatch()) continue;
                        display.sleep();
                    }
                    if (settingsFrame != null) {
                        settingsFrame.dispose();
                    }
                    if (aboutFrame != null) {
                        aboutFrame.dispose();
                    }
                    System.exit(0);
                }
                catch (Throwable e) {
                    LOGGER.error((Object)"Error in SWT thread", e);
                    error = new Error(e);
                }
            }
        };
        swtThread.start();
        while (true) {
            try {
                while (true) {
                    Object object = LOCK;
                    synchronized (object) {
                        if (error != null) {
                            throw error;
                        }
                        if (isReady) {
                            return;
                        }
                        LOCK.wait(1000L);
                    }
                }
            }
            catch (InterruptedException e) {
                DavGatewayTray.error(new BundleMessage("LOG_ERROR_WAITING_FOR_SWT_INIT", new Object[0]), e);
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    @Override
    public List<Image> getFrameIcons() {
        return frameIcons;
    }

    @Override
    public void switchIcon() {
        this.isActive = true;
        display.syncExec(() -> {
            org.eclipse.swt.graphics.Image currentImage = trayItem.getImage();
            if (currentImage != null && currentImage.equals((Object)image)) {
                trayItem.setImage(image2);
            } else {
                trayItem.setImage(image);
            }
        });
    }

    @Override
    public void resetIcon() {
        display.syncExec(() -> trayItem.setImage(image));
    }

    @Override
    public void inactiveIcon() {
        this.isActive = false;
        display.syncExec(() -> trayItem.setImage(inactiveImage));
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void displayMessage(String message, Level level) {
        if (trayItem != null) {
            display.asyncExec(() -> {
                int messageType = 0;
                if (level.equals((Object)Level.INFO)) {
                    messageType = 2;
                } else if (level.equals((Object)Level.WARN)) {
                    messageType = 8;
                } else if (level.equals((Object)Level.ERROR)) {
                    messageType = 1;
                }
                if (messageType != 0) {
                    ToolTip toolTip = new ToolTip(shell, 0x1000 | messageType);
                    toolTip.setText(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]));
                    toolTip.setMessage(message);
                    trayItem.setToolTip(toolTip);
                    if (this.firstMessage) {
                        this.firstMessage = false;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    toolTip.setVisible(true);
                }
                trayItem.setToolTipText(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]) + '\n' + message);
            });
        }
    }

    public static org.eclipse.swt.graphics.Image loadSwtImage(String fileName) {
        org.eclipse.swt.graphics.Image result = null;
        try {
            ClassLoader classloader = DavGatewayTray.class.getClassLoader();
            URL imageUrl = classloader.getResource(fileName);
            if (imageUrl == null) {
                throw new IOException("fileName");
            }
            try (InputStream inputStream = imageUrl.openStream();){
                result = new org.eclipse.swt.graphics.Image((Device)display, inputStream);
            }
        }
        catch (IOException e) {
            DavGatewayTray.warn(new BundleMessage("LOG_UNABLE_TO_LOAD_IMAGE", new Object[0]), e);
        }
        return result;
    }

    public static org.eclipse.swt.graphics.Image loadSwtImage(String fileName, int targetSize) {
        int padding = 0;
        org.eclipse.swt.graphics.Image result = null;
        try {
            byte[] imageBytes;
            ClassLoader classloader = DavGatewayTray.class.getClassLoader();
            URL imageUrl = classloader.getResource(fileName);
            if (imageUrl == null) {
                throw new IOException(fileName);
            }
            BufferedImage bufferedImage = Settings.getBooleanProperty("davmail.trayGrayscale", false) ? DavGatewayTray.convertGrayscale(ImageIO.read(imageUrl)) : ImageIO.read(imageUrl);
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)bufferedImage, "png", os);
                imageBytes = os.toByteArray();
            }
            var9_9 = null;
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);){
                org.eclipse.swt.graphics.Image loadedImage = new org.eclipse.swt.graphics.Image((Device)display, (InputStream)inputStream);
                ImageData resultImageData = new ImageData(targetSize, targetSize, 24, new PaletteData(0xFF0000, 65280, 255));
                resultImageData.setAlpha(0, 0, 0);
                result = new org.eclipse.swt.graphics.Image((Device)display, resultImageData);
                GC gc = new GC((Drawable)result);
                gc.setAntialias(1);
                gc.setInterpolation(2);
                gc.drawImage(loadedImage, 0, 0, loadedImage.getBounds().width, loadedImage.getBounds().height, padding, padding, result.getBounds().width - padding, result.getBounds().height - padding);
                gc.dispose();
                loadedImage.dispose();
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            DavGatewayTray.warn(new BundleMessage("LOG_UNABLE_TO_LOAD_IMAGE", new Object[0]), e);
        }
        return result;
    }

    @Override
    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            DavGatewayTray.warn(new BundleMessage("LOG_UNABLE_TO_SET_LOOK_AND_FEEL", new Object[0]));
        }
        SwtGatewayTray.initDisplay();
        display.asyncExec(() -> {
            try {
                Tray tray = display.getSystemTray();
                if (tray != null) {
                    trayItem = new TrayItem(tray, 0);
                    trayItem.setToolTipText(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]));
                    frameIcons = new ArrayList();
                    frameIcons.add(DavGatewayTray.adjustTrayIcon(DavGatewayTray.loadImage("tray128.png")));
                    frameIcons.add(DavGatewayTray.adjustTrayIcon(DavGatewayTray.loadImage("tray.png")));
                    image = SwtGatewayTray.loadSwtImage("tray128.png", 128);
                    image2 = SwtGatewayTray.loadSwtImage("tray128active.png", 128);
                    inactiveImage = SwtGatewayTray.loadSwtImage("tray128inactive.png", 128);
                    trayItem.setImage(image);
                    trayItem.addDisposeListener(e -> {
                        if (image != null && !image.isDisposed()) {
                            image.dispose();
                        }
                        if (image2 != null && !image2.isDisposed()) {
                            image2.dispose();
                        }
                        if (inactiveImage != null && !inactiveImage.isDisposed()) {
                            inactiveImage.dispose();
                        }
                    });
                    Menu popup = new Menu((Decorations)shell, 8);
                    trayItem.addListener(35, event -> display.asyncExec(() -> popup.setVisible(true)));
                    MenuItem aboutItem = new MenuItem(popup, 8);
                    aboutItem.setText(BundleMessage.format("UI_ABOUT", new Object[0]));
                    aboutItem.addListener(13, event -> SwingUtilities.invokeLater(() -> {
                        if (aboutFrame == null) {
                            aboutFrame = new AboutFrame();
                        }
                        aboutFrame.update();
                        aboutFrame.setVisible(true);
                        aboutFrame.toFront();
                        aboutFrame.requestFocus();
                    }));
                    trayItem.addListener(14, event -> SwingUtilities.invokeLater(() -> this.openSettingsFrame()));
                    MenuItem defaultItem = new MenuItem(popup, 8);
                    defaultItem.setText(BundleMessage.format("UI_SETTINGS", new Object[0]));
                    defaultItem.addListener(13, event -> SwingUtilities.invokeLater(() -> this.openSettingsFrame()));
                    MenuItem exitItem = new MenuItem(popup, 8);
                    exitItem.setText(BundleMessage.format("UI_EXIT", new Object[0]));
                    exitItem.addListener(13, event -> DavGateway.stop());
                    if (Settings.isFirstStart()) {
                        SwingUtilities.invokeLater(() -> {
                            if (settingsFrame == null) {
                                settingsFrame = new SettingsFrame();
                            }
                            settingsFrame.setVisible(true);
                            settingsFrame.toFront();
                            settingsFrame.requestFocus();
                        });
                    }
                }
            }
            catch (Exception exc) {
                DavGatewayTray.error(exc);
            }
            catch (Error exc) {
                error = exc;
                throw exc;
            }
        });
    }

    private void openSettingsFrame() {
        if (settingsFrame == null) {
            settingsFrame = new SettingsFrame();
        }
        settingsFrame.reload();
        settingsFrame.setVisible(true);
        settingsFrame.toFront();
        settingsFrame.requestFocus();
    }

    @Override
    public void dispose() {
        shell.dispose();
    }

    static {
        isReady = false;
    }
}

