/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui.tray;

import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.Settings;
import davmail.ui.AboutFrame;
import davmail.ui.SettingsFrame;
import davmail.ui.tray.DavGatewayTray;
import davmail.ui.tray.DavGatewayTrayInterface;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Level;

public class AwtGatewayTray
implements DavGatewayTrayInterface {
    protected static final String TRAY_PNG = "tray.png";
    protected static final String TRAY_ACTIVE_PNG = "tray2.png";
    protected static final String TRAY_INACTIVE_PNG = "trayinactive.png";
    protected static final String TRAY128_PNG = "tray128.png";
    protected static final String TRAY128_ACTIVE_PNG = "tray128active.png";
    protected static final String TRAY128_INACTIVE_PNG = "tray128inactive.png";
    static AboutFrame aboutFrame;
    static SettingsFrame settingsFrame;
    ActionListener settingsListener;
    static TrayIcon trayIcon;
    protected static ArrayList<Image> frameIcons;
    protected static BufferedImage image;
    protected static BufferedImage activeImage;
    protected static BufferedImage inactiveImage;
    private boolean isActive = true;

    protected AwtGatewayTray() {
    }

    @Override
    public List<Image> getFrameIcons() {
        return frameIcons;
    }

    @Override
    public void switchIcon() {
        this.isActive = true;
        SwingUtilities.invokeLater(() -> {
            if (trayIcon.getImage().equals(image)) {
                trayIcon.setImage(activeImage);
            } else {
                trayIcon.setImage(image);
            }
        });
    }

    @Override
    public void resetIcon() {
        SwingUtilities.invokeLater(() -> trayIcon.setImage(image));
    }

    @Override
    public void inactiveIcon() {
        this.isActive = false;
        SwingUtilities.invokeLater(() -> trayIcon.setImage(inactiveImage));
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void displayMessage(String message, Level level) {
        SwingUtilities.invokeLater(() -> {
            if (trayIcon != null) {
                TrayIcon.MessageType messageType = null;
                if (level.equals((Object)Level.INFO)) {
                    messageType = TrayIcon.MessageType.INFO;
                } else if (level.equals((Object)Level.WARN)) {
                    messageType = TrayIcon.MessageType.WARNING;
                } else if (level.equals((Object)Level.ERROR)) {
                    messageType = TrayIcon.MessageType.ERROR;
                }
                if (messageType != null) {
                    trayIcon.displayMessage(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]), message, messageType);
                }
                trayIcon.setToolTip(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]) + '\n' + message);
            }
        });
    }

    public void about() {
        SwingUtilities.invokeLater(() -> {
            aboutFrame.update();
            aboutFrame.setVisible(true);
            aboutFrame.toFront();
            aboutFrame.requestFocus();
        });
    }

    public void preferences() {
        SwingUtilities.invokeLater(() -> {
            settingsFrame.reload();
            settingsFrame.setVisible(true);
            settingsFrame.toFront();
            settingsFrame.repaint();
            settingsFrame.requestFocus();
        });
    }

    @Override
    public void init() {
        SwingUtilities.invokeLater(this::createAndShowGUI);
    }

    @Override
    public void dispose() {
        SystemTray.getSystemTray().remove(trayIcon);
        settingsFrame.dispose();
        aboutFrame.dispose();
    }

    protected void loadIcons() {
        image = DavGatewayTray.adjustTrayIcon(DavGatewayTray.loadImage(TRAY_PNG));
        activeImage = DavGatewayTray.adjustTrayIcon(DavGatewayTray.loadImage(TRAY_ACTIVE_PNG));
        inactiveImage = DavGatewayTray.adjustTrayIcon(DavGatewayTray.loadImage(TRAY_INACTIVE_PNG));
        frameIcons = new ArrayList();
        frameIcons.add(DavGatewayTray.loadImage(TRAY128_PNG));
        frameIcons.add(DavGatewayTray.loadImage(TRAY_PNG));
    }

    protected void createAndShowGUI() {
        System.setProperty("swing.defaultlaf", UIManager.getSystemLookAndFeelClassName());
        SystemTray tray = SystemTray.getSystemTray();
        this.loadIcons();
        PopupMenu popup = new PopupMenu();
        aboutFrame = new AboutFrame();
        ActionListener aboutListener = e -> this.about();
        MenuItem aboutItem = new MenuItem(BundleMessage.format("UI_ABOUT", new Object[0]));
        aboutItem.addActionListener(aboutListener);
        popup.add(aboutItem);
        settingsFrame = new SettingsFrame();
        this.settingsListener = e -> this.preferences();
        MenuItem defaultItem = new MenuItem(BundleMessage.format("UI_SETTINGS", new Object[0]));
        defaultItem.addActionListener(this.settingsListener);
        popup.add(defaultItem);
        ActionListener exitListener = e -> {
            try {
                DavGateway.stop();
            }
            catch (Exception exc) {
                DavGatewayTray.error(exc);
            }
            System.exit(0);
        };
        MenuItem exitItem = new MenuItem(BundleMessage.format("UI_EXIT", new Object[0]));
        exitItem.addActionListener(exitListener);
        popup.add(exitItem);
        trayIcon = new TrayIcon(image, BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]), popup);
        trayIcon.addActionListener(this.settingsListener);
        try {
            tray.add(trayIcon);
        }
        catch (AWTException e2) {
            DavGatewayTray.warn(new BundleMessage("LOG_UNABLE_TO_CREATE_TRAY", new Object[0]), e2);
        }
        if (Settings.isFirstStart()) {
            settingsFrame.setVisible(true);
            settingsFrame.toFront();
            settingsFrame.repaint();
            settingsFrame.requestFocus();
        }
    }
}

