/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui;

import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.Settings;
import davmail.ui.OSXInfoPlist;
import davmail.ui.browser.DesktopBrowser;
import davmail.ui.tray.DavGatewayTray;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Level;

public class SettingsFrame
extends JFrame {
    static final Level[] LOG_LEVELS = new Level[]{Level.OFF, Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.ALL};
    protected JTextField urlField;
    protected JTextField popPortField;
    protected JCheckBox popPortCheckBox;
    protected JCheckBox popNoSSLCheckBox;
    protected JTextField imapPortField;
    protected JCheckBox imapPortCheckBox;
    protected JCheckBox imapNoSSLCheckBox;
    protected JTextField smtpPortField;
    protected JCheckBox smtpPortCheckBox;
    protected JCheckBox smtpNoSSLCheckBox;
    protected JTextField caldavPortField;
    protected JCheckBox caldavPortCheckBox;
    protected JCheckBox caldavNoSSLCheckBox;
    protected JTextField ldapPortField;
    protected JCheckBox ldapPortCheckBox;
    protected JCheckBox ldapNoSSLCheckBox;
    protected JTextField keepDelayField;
    protected JTextField sentKeepDelayField;
    protected JTextField caldavPastDelayField;
    protected JCheckBox caldavAutoScheduleCheckBox;
    protected JTextField imapIdleDelayField;
    protected JCheckBox useSystemProxiesField;
    protected JCheckBox enableProxyField;
    protected JTextField httpProxyField;
    protected JTextField httpProxyPortField;
    protected JTextField httpProxyUserField;
    protected JTextField httpProxyPasswordField;
    protected JTextField noProxyForField;
    protected JCheckBox allowRemoteField;
    protected JTextField bindAddressField;
    protected JTextField clientSoTimeoutField;
    protected JTextField certHashField;
    protected JCheckBox disableUpdateCheck;
    protected JComboBox<String> keystoreTypeCombo;
    protected JTextField keystoreFileField;
    protected JPasswordField keystorePassField;
    protected JPasswordField keyPassField;
    protected JComboBox<String> clientKeystoreTypeCombo;
    protected JTextField clientKeystoreFileField;
    protected JPasswordField clientKeystorePassField;
    protected JTextField pkcs11LibraryField;
    protected JTextArea pkcs11ConfigField;
    protected JComboBox<Level> rootLoggingLevelField;
    protected JComboBox<Level> davmailLoggingLevelField;
    protected JComboBox<Level> httpclientLoggingLevelField;
    protected JComboBox<Level> wireLoggingLevelField;
    protected JTextField logFilePathField;
    protected JTextField logFileSizeField;
    protected JCheckBox caldavEditNotificationsField;
    protected JTextField caldavAlarmSoundField;
    protected JCheckBox forceActiveSyncUpdateCheckBox;
    protected JTextField defaultDomainField;
    protected JCheckBox showStartupBannerCheckBox;
    protected JCheckBox disableGuiNotificationsCheckBox;
    protected JCheckBox disableTrayActivitySwitchCheckBox;
    protected JCheckBox imapAutoExpungeCheckBox;
    protected JCheckBox enableKeepAliveCheckBox;
    protected JCheckBox popMarkReadOnRetrCheckBox;
    protected JComboBox<String> modeComboBox;
    protected JCheckBox enableKerberosCheckBox;
    protected JTextField folderSizeLimitField;
    protected JCheckBox smtpSaveInSentCheckBox;
    protected JCheckBox imapAlwaysApproxMsgSizeCheckBox;
    protected JTextField oauthTenantIdField;
    protected JTextField oauthClientIdField;
    protected JTextField oauthRedirectUriField;
    protected JTextField oauthTldField;
    JCheckBox osxHideFromDockCheckBox;

    protected void addSettingComponent(JPanel panel, String label, JComponent component) {
        this.addSettingComponent(panel, label, component, null);
    }

    protected JLabel buildFieldLabel(String label, String toolTipText) {
        JLabel fieldLabel = new JLabel(label);
        fieldLabel.setHorizontalAlignment(4);
        fieldLabel.setVerticalAlignment(0);
        if (toolTipText != null) {
            fieldLabel.setToolTipText(toolTipText);
        }
        return fieldLabel;
    }

    protected void addSettingComponent(JPanel panel, String label, JComponent component, String toolTipText) {
        panel.add(this.buildFieldLabel(label, toolTipText));
        component.setMaximumSize(component.getPreferredSize());
        JPanel innerPanel = new JPanel();
        innerPanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        innerPanel.setLayout(new BoxLayout(innerPanel, 0));
        innerPanel.add(component);
        panel.add(innerPanel);
        if (toolTipText != null) {
            component.setToolTipText(toolTipText);
        }
    }

    protected void addPortSettingComponent(JPanel panel, String label, JComponent component, JComponent checkboxComponent, JComponent checkboxSSLComponent, String toolTipText) {
        panel.add(this.buildFieldLabel(label, toolTipText));
        component.setMaximumSize(component.getPreferredSize());
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 0));
        innerPanel.add(checkboxComponent);
        innerPanel.add(component);
        innerPanel.add(checkboxSSLComponent);
        panel.add(innerPanel);
        if (toolTipText != null) {
            component.setToolTipText(toolTipText);
        }
    }

    protected JPanel getSettingsPanel() {
        JPanel settingsPanel = new JPanel(new GridLayout(7, 2));
        settingsPanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_GATEWAY", new Object[0])));
        this.modeComboBox = new JComboBox();
        this.modeComboBox.addItem("EWS");
        this.modeComboBox.addItem("O365");
        this.modeComboBox.addItem("O365Modern");
        this.modeComboBox.addItem("O365Interactive");
        this.modeComboBox.addItem("O365Manual");
        this.modeComboBox.addItem("WebDav");
        this.modeComboBox.addItem("Auto");
        this.modeComboBox.setSelectedItem(Settings.getProperty("davmail.mode", "EWS"));
        this.modeComboBox.addActionListener(evt -> {
            String selectedItem = (String)this.modeComboBox.getSelectedItem();
            this.modeComboBox.setToolTipText(BundleMessage.format("UI_" + selectedItem + "_HELP", new Object[0]));
            if (selectedItem != null && selectedItem.startsWith("O365")) {
                this.urlField.setEnabled(false);
                this.urlField.setText(Settings.getO365Url());
            } else {
                this.urlField.setEnabled(true);
            }
        });
        this.urlField = new JTextField(Settings.getProperty("davmail.url", Settings.getO365Url()), 20);
        this.popPortField = new JTextField(Settings.getProperty("davmail.popPort"), 4);
        this.popPortCheckBox = new JCheckBox();
        this.popNoSSLCheckBox = new JCheckBox(BundleMessage.format("UI_NO_SSL", new Object[0]), Settings.getBooleanProperty("davmail.ssl.nosecurepop"));
        this.popPortCheckBox.setSelected(Settings.getProperty("davmail.popPort") != null && !Settings.getProperty("davmail.popPort").isEmpty());
        this.popPortField.setEnabled(this.popPortCheckBox.isSelected());
        this.popNoSSLCheckBox.setEnabled(this.popPortCheckBox.isSelected() && this.isSslEnabled());
        this.popPortCheckBox.addActionListener(evt -> {
            this.popPortField.setEnabled(this.popPortCheckBox.isSelected());
            this.popNoSSLCheckBox.setEnabled(this.popPortCheckBox.isSelected() && this.isSslEnabled());
        });
        this.imapPortField = new JTextField(Settings.getProperty("davmail.imapPort"), 4);
        this.imapPortCheckBox = new JCheckBox();
        this.imapNoSSLCheckBox = new JCheckBox(BundleMessage.format("UI_NO_SSL", new Object[0]), Settings.getBooleanProperty("davmail.ssl.nosecureimap"));
        this.imapPortCheckBox.setSelected(Settings.getProperty("davmail.imapPort") != null && !Settings.getProperty("davmail.imapPort").isEmpty());
        this.imapPortField.setEnabled(this.imapPortCheckBox.isSelected());
        this.imapNoSSLCheckBox.setEnabled(this.imapPortCheckBox.isSelected() && this.isSslEnabled());
        this.imapPortCheckBox.addActionListener(evt -> {
            this.imapPortField.setEnabled(this.imapPortCheckBox.isSelected());
            this.imapNoSSLCheckBox.setEnabled(this.imapPortCheckBox.isSelected() && this.isSslEnabled());
        });
        this.smtpPortField = new JTextField(Settings.getProperty("davmail.smtpPort"), 4);
        this.smtpPortCheckBox = new JCheckBox();
        this.smtpNoSSLCheckBox = new JCheckBox(BundleMessage.format("UI_NO_SSL", new Object[0]), Settings.getBooleanProperty("davmail.ssl.nosecuresmtp"));
        this.smtpPortCheckBox.setSelected(Settings.getProperty("davmail.smtpPort") != null && !Settings.getProperty("davmail.smtpPort").isEmpty());
        this.smtpPortField.setEnabled(this.smtpPortCheckBox.isSelected());
        this.smtpNoSSLCheckBox.setEnabled(this.smtpPortCheckBox.isSelected() && this.isSslEnabled());
        this.smtpPortCheckBox.addActionListener(evt -> {
            this.smtpPortField.setEnabled(this.smtpPortCheckBox.isSelected());
            this.smtpNoSSLCheckBox.setEnabled(this.smtpPortCheckBox.isSelected() && this.isSslEnabled());
        });
        this.caldavPortField = new JTextField(Settings.getProperty("davmail.caldavPort"), 4);
        this.caldavPortCheckBox = new JCheckBox();
        this.caldavNoSSLCheckBox = new JCheckBox(BundleMessage.format("UI_NO_SSL", new Object[0]), Settings.getBooleanProperty("davmail.ssl.nosecurecaldav"));
        this.caldavPortCheckBox.setSelected(Settings.getProperty("davmail.caldavPort") != null && !Settings.getProperty("davmail.caldavPort").isEmpty());
        this.caldavPortField.setEnabled(this.caldavPortCheckBox.isSelected());
        this.caldavNoSSLCheckBox.setEnabled(this.caldavPortCheckBox.isSelected() && this.isSslEnabled());
        this.caldavPortCheckBox.addActionListener(evt -> {
            this.caldavPortField.setEnabled(this.caldavPortCheckBox.isSelected());
            this.caldavNoSSLCheckBox.setEnabled(this.caldavPortCheckBox.isSelected() && this.isSslEnabled());
        });
        this.ldapPortField = new JTextField(Settings.getProperty("davmail.ldapPort"), 4);
        this.ldapPortCheckBox = new JCheckBox();
        this.ldapNoSSLCheckBox = new JCheckBox(BundleMessage.format("UI_NO_SSL", new Object[0]), Settings.getBooleanProperty("davmail.ssl.nosecureldap"));
        this.ldapPortCheckBox.setSelected(Settings.getProperty("davmail.ldapPort") != null && !Settings.getProperty("davmail.ldapPort").isEmpty());
        this.ldapPortField.setEnabled(this.ldapPortCheckBox.isSelected());
        this.ldapNoSSLCheckBox.setEnabled(this.ldapPortCheckBox.isSelected() && this.isSslEnabled());
        this.ldapPortCheckBox.addActionListener(evt -> {
            this.ldapPortField.setEnabled(this.ldapPortCheckBox.isSelected());
            this.ldapNoSSLCheckBox.setEnabled(this.ldapPortCheckBox.isSelected() && this.isSslEnabled());
        });
        this.addSettingComponent(settingsPanel, BundleMessage.format("UI_ENABLE_EWS", new Object[0]), this.modeComboBox, BundleMessage.format("UI_ENABLE_EWS_HELP", new Object[0]));
        this.addSettingComponent(settingsPanel, BundleMessage.format("UI_OWA_URL", new Object[0]), this.urlField, BundleMessage.format("UI_OWA_URL_HELP", new Object[0]));
        this.addPortSettingComponent(settingsPanel, BundleMessage.format("UI_POP_PORT", new Object[0]), this.popPortField, this.popPortCheckBox, this.popNoSSLCheckBox, BundleMessage.format("UI_POP_PORT_HELP", new Object[0]));
        this.addPortSettingComponent(settingsPanel, BundleMessage.format("UI_IMAP_PORT", new Object[0]), this.imapPortField, this.imapPortCheckBox, this.imapNoSSLCheckBox, BundleMessage.format("UI_IMAP_PORT_HELP", new Object[0]));
        this.addPortSettingComponent(settingsPanel, BundleMessage.format("UI_SMTP_PORT", new Object[0]), this.smtpPortField, this.smtpPortCheckBox, this.smtpNoSSLCheckBox, BundleMessage.format("UI_SMTP_PORT_HELP", new Object[0]));
        this.addPortSettingComponent(settingsPanel, BundleMessage.format("UI_CALDAV_PORT", new Object[0]), this.caldavPortField, this.caldavPortCheckBox, this.caldavNoSSLCheckBox, BundleMessage.format("UI_CALDAV_PORT_HELP", new Object[0]));
        this.addPortSettingComponent(settingsPanel, BundleMessage.format("UI_LDAP_PORT", new Object[0]), this.ldapPortField, this.ldapPortCheckBox, this.ldapNoSSLCheckBox, BundleMessage.format("UI_LDAP_PORT_HELP", new Object[0]));
        return settingsPanel;
    }

    protected JPanel getDelaysPanel() {
        JPanel delaysPanel = new JPanel(new GridLayout(4, 2));
        delaysPanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_DELAYS", new Object[0])));
        this.keepDelayField = new JTextField(Settings.getProperty("davmail.keepDelay"), 4);
        this.sentKeepDelayField = new JTextField(Settings.getProperty("davmail.sentKeepDelay"), 4);
        this.caldavPastDelayField = new JTextField(Settings.getProperty("davmail.caldavPastDelay"), 4);
        this.imapIdleDelayField = new JTextField(Settings.getProperty("davmail.imapIdleDelay"), 4);
        this.addSettingComponent(delaysPanel, BundleMessage.format("UI_KEEP_DELAY", new Object[0]), this.keepDelayField, BundleMessage.format("UI_KEEP_DELAY_HELP", new Object[0]));
        this.addSettingComponent(delaysPanel, BundleMessage.format("UI_SENT_KEEP_DELAY", new Object[0]), this.sentKeepDelayField, BundleMessage.format("UI_SENT_KEEP_DELAY_HELP", new Object[0]));
        this.addSettingComponent(delaysPanel, BundleMessage.format("UI_CALENDAR_PAST_EVENTS", new Object[0]), this.caldavPastDelayField, BundleMessage.format("UI_CALENDAR_PAST_EVENTS_HELP", new Object[0]));
        this.addSettingComponent(delaysPanel, BundleMessage.format("UI_IMAP_IDLE_DELAY", new Object[0]), this.imapIdleDelayField, BundleMessage.format("UI_IMAP_IDLE_DELAY_HELP", new Object[0]));
        return delaysPanel;
    }

    protected JPanel getProxyPanel() {
        JPanel proxyPanel = new JPanel(new GridLayout(7, 2));
        proxyPanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_PROXY", new Object[0])));
        boolean useSystemProxies = Settings.getBooleanProperty("davmail.useSystemProxies", Boolean.FALSE);
        boolean enableProxy = Settings.getBooleanProperty("davmail.enableProxy");
        this.useSystemProxiesField = new JCheckBox();
        this.useSystemProxiesField.setSelected(useSystemProxies);
        this.enableProxyField = new JCheckBox();
        this.enableProxyField.setSelected(enableProxy);
        this.httpProxyField = new JTextField(Settings.getProperty("davmail.proxyHost"), 15);
        this.httpProxyPortField = new JTextField(Settings.getProperty("davmail.proxyPort"), 4);
        this.httpProxyUserField = new JTextField(Settings.getProperty("davmail.proxyUser"), 10);
        this.httpProxyPasswordField = new JPasswordField(Settings.getProperty("davmail.proxyPassword"), 10);
        this.noProxyForField = new JTextField(Settings.getProperty("davmail.noProxyFor"), 15);
        this.enableProxyField.setEnabled(!useSystemProxies);
        this.httpProxyField.setEnabled(enableProxy);
        this.httpProxyPortField.setEnabled(enableProxy);
        this.httpProxyUserField.setEnabled(enableProxy || useSystemProxies);
        this.httpProxyPasswordField.setEnabled(enableProxy || useSystemProxies);
        this.noProxyForField.setEnabled(enableProxy);
        this.useSystemProxiesField.addActionListener(evt -> {
            boolean newUseSystemProxies = this.useSystemProxiesField.isSelected();
            if (newUseSystemProxies) {
                this.enableProxyField.setSelected(false);
                this.enableProxyField.setEnabled(false);
                this.httpProxyField.setEnabled(false);
                this.httpProxyPortField.setEnabled(false);
                this.httpProxyUserField.setEnabled(true);
                this.httpProxyPasswordField.setEnabled(true);
                this.noProxyForField.setEnabled(false);
            } else {
                this.enableProxyField.setEnabled(true);
                this.httpProxyUserField.setEnabled(false);
                this.httpProxyPasswordField.setEnabled(false);
            }
        });
        this.enableProxyField.addActionListener(evt -> {
            boolean newEnableProxy = this.enableProxyField.isSelected();
            this.httpProxyField.setEnabled(newEnableProxy);
            this.httpProxyPortField.setEnabled(newEnableProxy);
            this.httpProxyUserField.setEnabled(newEnableProxy);
            this.httpProxyPasswordField.setEnabled(newEnableProxy);
            this.noProxyForField.setEnabled(newEnableProxy);
        });
        this.addSettingComponent(proxyPanel, BundleMessage.format("UI_USE_SYSTEM_PROXIES", new Object[0]), this.useSystemProxiesField);
        this.addSettingComponent(proxyPanel, BundleMessage.format("UI_ENABLE_PROXY", new Object[0]), this.enableProxyField);
        this.addSettingComponent(proxyPanel, BundleMessage.format("UI_PROXY_SERVER", new Object[0]), this.httpProxyField);
        this.addSettingComponent(proxyPanel, BundleMessage.format("UI_PROXY_PORT", new Object[0]), this.httpProxyPortField);
        this.addSettingComponent(proxyPanel, BundleMessage.format("UI_PROXY_USER", new Object[0]), this.httpProxyUserField);
        this.addSettingComponent(proxyPanel, BundleMessage.format("UI_PROXY_PASSWORD", new Object[0]), this.httpProxyPasswordField);
        this.addSettingComponent(proxyPanel, BundleMessage.format("UI_NO_PROXY", new Object[0]), this.noProxyForField);
        this.updateMaximumSize(proxyPanel);
        return proxyPanel;
    }

    protected JPanel getKeystorePanel() {
        JPanel keyStorePanel = new JPanel(new GridLayout(4, 2));
        keyStorePanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_DAVMAIL_SERVER_CERTIFICATE", new Object[0])));
        this.keystoreTypeCombo = new JComboBox<String>(new String[]{"JKS", "PKCS12"});
        this.keystoreTypeCombo.setSelectedItem(Settings.getProperty("davmail.ssl.keystoreType"));
        this.keystoreFileField = new JTextField(Settings.getProperty("davmail.ssl.keystoreFile"), 20);
        this.keystorePassField = new JPasswordField(Settings.getProperty("davmail.ssl.keystorePass"), 20);
        this.keyPassField = new JPasswordField(Settings.getProperty("davmail.ssl.keyPass"), 20);
        this.addSettingComponent(keyStorePanel, BundleMessage.format("UI_KEY_STORE_TYPE", new Object[0]), this.keystoreTypeCombo, BundleMessage.format("UI_KEY_STORE_TYPE_HELP", new Object[0]));
        this.addSettingComponent(keyStorePanel, BundleMessage.format("UI_KEY_STORE", new Object[0]), this.keystoreFileField, BundleMessage.format("UI_KEY_STORE_HELP", new Object[0]));
        this.addSettingComponent(keyStorePanel, BundleMessage.format("UI_KEY_STORE_PASSWORD", new Object[0]), this.keystorePassField, BundleMessage.format("UI_KEY_STORE_PASSWORD_HELP", new Object[0]));
        this.addSettingComponent(keyStorePanel, BundleMessage.format("UI_KEY_PASSWORD", new Object[0]), this.keyPassField, BundleMessage.format("UI_KEY_PASSWORD_HELP", new Object[0]));
        this.updateMaximumSize(keyStorePanel);
        return keyStorePanel;
    }

    protected JPanel getSmartCardPanel() {
        JPanel clientKeystorePanel = new JPanel(new GridLayout(2, 1));
        clientKeystorePanel.setLayout(new BoxLayout(clientKeystorePanel, 1));
        clientKeystorePanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_CLIENT_CERTIFICATE", new Object[0])));
        this.clientKeystoreTypeCombo = System.getProperty("os.name").toLowerCase().startsWith("windows") ? new JComboBox<String>(new String[]{"MSCAPI", "PKCS11", "JKS", "PKCS12"}) : new JComboBox<String>(new String[]{"PKCS11", "JKS", "PKCS12"});
        this.clientKeystoreTypeCombo.setSelectedItem(Settings.getProperty("davmail.ssl.clientKeystoreType"));
        this.clientKeystoreFileField = new JTextField(Settings.getProperty("davmail.ssl.clientKeystoreFile"), 20);
        this.clientKeystorePassField = new JPasswordField(Settings.getProperty("davmail.ssl.clientKeystorePass"), 20);
        this.pkcs11LibraryField = new JTextField(Settings.getProperty("davmail.ssl.pkcs11Library"), 20);
        this.pkcs11ConfigField = new JTextArea(2, 20);
        this.pkcs11ConfigField.setText(Settings.getProperty("davmail.ssl.pkcs11Config"));
        this.pkcs11ConfigField.setBorder(this.pkcs11LibraryField.getBorder());
        this.pkcs11ConfigField.setFont(this.pkcs11LibraryField.getFont());
        JPanel clientKeystoreTypePanel = new JPanel(new GridLayout(1, 2));
        this.addSettingComponent(clientKeystoreTypePanel, BundleMessage.format("UI_CLIENT_KEY_STORE_TYPE", new Object[0]), this.clientKeystoreTypeCombo, BundleMessage.format("UI_CLIENT_KEY_STORE_TYPE_HELP", new Object[0]));
        clientKeystorePanel.add(clientKeystoreTypePanel);
        JPanel cardPanel = new JPanel(new CardLayout());
        clientKeystorePanel.add(cardPanel);
        JPanel clientKeystoreFilePanel = new JPanel(new GridLayout(2, 2));
        this.addSettingComponent(clientKeystoreFilePanel, BundleMessage.format("UI_CLIENT_KEY_STORE", new Object[0]), this.clientKeystoreFileField, BundleMessage.format("UI_CLIENT_KEY_STORE_HELP", new Object[0]));
        this.addSettingComponent(clientKeystoreFilePanel, BundleMessage.format("UI_CLIENT_KEY_STORE_PASSWORD", new Object[0]), this.clientKeystorePassField, BundleMessage.format("UI_CLIENT_KEY_STORE_PASSWORD_HELP", new Object[0]));
        JPanel wrapperPanel = new JPanel();
        wrapperPanel.add(clientKeystoreFilePanel);
        cardPanel.add((Component)wrapperPanel, "FILE");
        JPanel pkcs11Panel = new JPanel(new GridLayout(2, 2));
        this.addSettingComponent(pkcs11Panel, BundleMessage.format("UI_PKCS11_LIBRARY", new Object[0]), this.pkcs11LibraryField, BundleMessage.format("UI_PKCS11_LIBRARY_HELP", new Object[0]));
        this.addSettingComponent(pkcs11Panel, BundleMessage.format("UI_PKCS11_CONFIG", new Object[0]), this.pkcs11ConfigField, BundleMessage.format("UI_PKCS11_CONFIG_HELP", new Object[0]));
        cardPanel.add((Component)pkcs11Panel, "PKCS11");
        ((CardLayout)cardPanel.getLayout()).show(cardPanel, (String)this.clientKeystoreTypeCombo.getSelectedItem());
        this.clientKeystoreTypeCombo.addItemListener(event -> {
            CardLayout cardLayout = (CardLayout)cardPanel.getLayout();
            if ("PKCS11".equals(event.getItem())) {
                cardLayout.show(cardPanel, "PKCS11");
            } else {
                cardLayout.show(cardPanel, "FILE");
            }
        });
        this.updateMaximumSize(clientKeystorePanel);
        return clientKeystorePanel;
    }

    protected JPanel getOauthPanel() {
        JPanel oAuthPanel = new JPanel(new GridLayout(4, 2));
        oAuthPanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_OAUTH", new Object[0])));
        this.oauthTenantIdField = new JTextField(Settings.getProperty("davmail.oauth.tenantId"), 20);
        this.oauthClientIdField = new JTextField(Settings.getProperty("davmail.oauth.clientId"), 20);
        this.oauthRedirectUriField = new JTextField(Settings.getProperty("davmail.oauth.redirectUri"), 20);
        this.oauthTldField = new JTextField(Settings.getProperty("davmail.tld"), 20);
        this.addSettingComponent(oAuthPanel, BundleMessage.format("UI_OAUTH_TENANTID", new Object[0]), this.oauthTenantIdField, BundleMessage.format("UI_OAUTH_TENANTID_HELP", new Object[0]));
        this.addSettingComponent(oAuthPanel, BundleMessage.format("UI_OAUTH_CLIENTID", new Object[0]), this.oauthClientIdField, BundleMessage.format("UI_OAUTH_CLIENTID_HELP", new Object[0]));
        this.addSettingComponent(oAuthPanel, BundleMessage.format("UI_OAUTH_REDIRECTURI", new Object[0]), this.oauthRedirectUriField, BundleMessage.format("UI_OAUTH_REDIRECTURI_HELP", new Object[0]));
        this.addSettingComponent(oAuthPanel, BundleMessage.format("UI_OAUTH_TLD", new Object[0]), this.oauthTldField, BundleMessage.format("UI_OAUTH_TLD_HELP", new Object[0]));
        this.updateMaximumSize(oAuthPanel);
        return oAuthPanel;
    }

    protected JPanel getNetworkSettingsPanel() {
        JPanel networkSettingsPanel = new JPanel(new GridLayout(4, 2));
        networkSettingsPanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_NETWORK", new Object[0])));
        this.allowRemoteField = new JCheckBox();
        this.allowRemoteField.setSelected(Settings.getBooleanProperty("davmail.allowRemote"));
        this.bindAddressField = new JTextField(Settings.getProperty("davmail.bindAddress"), 15);
        this.clientSoTimeoutField = new JTextField(Settings.getProperty("davmail.clientSoTimeout"), 15);
        this.certHashField = new JTextField(Settings.getProperty("davmail.server.certificate.hash"), 15);
        this.addSettingComponent(networkSettingsPanel, BundleMessage.format("UI_BIND_ADDRESS", new Object[0]), this.bindAddressField, BundleMessage.format("UI_BIND_ADDRESS_HELP", new Object[0]));
        this.addSettingComponent(networkSettingsPanel, BundleMessage.format("UI_CLIENT_SO_TIMEOUT", new Object[0]), this.clientSoTimeoutField, BundleMessage.format("UI_CLIENT_SO_TIMEOUT_HELP", new Object[0]));
        this.addSettingComponent(networkSettingsPanel, BundleMessage.format("UI_ALLOW_REMOTE_CONNECTION", new Object[0]), this.allowRemoteField, BundleMessage.format("UI_ALLOW_REMOTE_CONNECTION_HELP", new Object[0]));
        this.addSettingComponent(networkSettingsPanel, BundleMessage.format("UI_SERVER_CERTIFICATE_HASH", new Object[0]), this.certHashField, BundleMessage.format("UI_SERVER_CERTIFICATE_HASH_HELP", new Object[0]));
        this.updateMaximumSize(networkSettingsPanel);
        return networkSettingsPanel;
    }

    protected JPanel getOtherSettingsPanel() {
        JPanel otherSettingsPanel = new JPanel(new GridLayout(16, 2));
        otherSettingsPanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_OTHER", new Object[0])));
        this.folderSizeLimitField = new JTextField(Settings.getProperty("davmail.folderSizeLimit"), 6);
        this.enableKerberosCheckBox = new JCheckBox();
        this.enableKerberosCheckBox.setSelected(Settings.getBooleanProperty("davmail.enableKerberos"));
        this.caldavEditNotificationsField = new JCheckBox();
        this.caldavEditNotificationsField.setSelected(Settings.getBooleanProperty("davmail.caldavEditNotifications"));
        this.caldavAlarmSoundField = new JTextField(Settings.getProperty("davmail.caldavAlarmSound"), 15);
        this.forceActiveSyncUpdateCheckBox = new JCheckBox();
        this.forceActiveSyncUpdateCheckBox.setSelected(Settings.getBooleanProperty("davmail.forceActiveSyncUpdate"));
        this.defaultDomainField = new JTextField(Settings.getProperty("davmail.defaultDomain"), 15);
        this.showStartupBannerCheckBox = new JCheckBox();
        this.showStartupBannerCheckBox.setSelected(Settings.getBooleanProperty("davmail.showStartupBanner", true));
        this.disableGuiNotificationsCheckBox = new JCheckBox();
        this.disableGuiNotificationsCheckBox.setSelected(Settings.getBooleanProperty("davmail.disableGuiNotifications", false));
        this.disableTrayActivitySwitchCheckBox = new JCheckBox();
        this.disableTrayActivitySwitchCheckBox.setSelected(Settings.getBooleanProperty("davmail.disableTrayActivitySwitch", false));
        this.imapAutoExpungeCheckBox = new JCheckBox();
        this.imapAutoExpungeCheckBox.setSelected(Settings.getBooleanProperty("davmail.imapAutoExpunge", true));
        this.imapAlwaysApproxMsgSizeCheckBox = new JCheckBox();
        this.imapAlwaysApproxMsgSizeCheckBox.setSelected(Settings.getBooleanProperty("davmail.imapAlwaysApproxMsgSize", false));
        this.enableKeepAliveCheckBox = new JCheckBox();
        this.enableKeepAliveCheckBox.setSelected(Settings.getBooleanProperty("davmail.enableKeepAlive", false));
        this.popMarkReadOnRetrCheckBox = new JCheckBox();
        this.popMarkReadOnRetrCheckBox.setSelected(Settings.getBooleanProperty("davmail.popMarkReadOnRetr", false));
        this.smtpSaveInSentCheckBox = new JCheckBox();
        this.smtpSaveInSentCheckBox.setSelected(Settings.getBooleanProperty("davmail.smtpSaveInSent", true));
        this.disableUpdateCheck = new JCheckBox();
        this.disableUpdateCheck.setSelected(Settings.getBooleanProperty("davmail.disableUpdateCheck"));
        this.caldavAutoScheduleCheckBox = new JCheckBox();
        this.caldavAutoScheduleCheckBox.setSelected(Settings.getBooleanProperty("davmail.caldavAutoSchedule"));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_FOLDER_SIZE_LIMIT", new Object[0]), this.folderSizeLimitField, BundleMessage.format("UI_FOLDER_SIZE_LIMIT_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_ENABLE_KERBEROS", new Object[0]), this.enableKerberosCheckBox, BundleMessage.format("UI_ENABLE_KERBEROS_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_CALDAV_EDIT_NOTIFICATIONS", new Object[0]), this.caldavEditNotificationsField, BundleMessage.format("UI_CALDAV_EDIT_NOTIFICATIONS_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_CALDAV_ALARM_SOUND", new Object[0]), this.caldavAlarmSoundField, BundleMessage.format("UI_CALDAV_ALARM_SOUND_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_FORCE_ACTIVESYNC_UPDATE", new Object[0]), this.forceActiveSyncUpdateCheckBox, BundleMessage.format("UI_FORCE_ACTIVESYNC_UPDATE_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_DEFAULT_DOMAIN", new Object[0]), this.defaultDomainField, BundleMessage.format("UI_DEFAULT_DOMAIN_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_SHOW_STARTUP_BANNER", new Object[0]), this.showStartupBannerCheckBox, BundleMessage.format("UI_SHOW_STARTUP_BANNER_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_DISABLE_GUI_NOTIFICATIONS", new Object[0]), this.disableGuiNotificationsCheckBox, BundleMessage.format("UI_DISABLE_GUI_NOTIFICATIONS_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_DISABLE_TRAY_ACTIVITY_SWITCH", new Object[0]), this.disableTrayActivitySwitchCheckBox, BundleMessage.format("UI_DISABLE_TRAY_ACTIVITY_SWITCH_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_IMAP_AUTO_EXPUNGE", new Object[0]), this.imapAutoExpungeCheckBox, BundleMessage.format("UI_IMAP_AUTO_EXPUNGE_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_ALWAYS_APPROXIMATE_MSG_SIZE", new Object[0]), this.imapAlwaysApproxMsgSizeCheckBox, BundleMessage.format("UI_ALWAYS_APPROXIMATE_MSG_SIZE_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_ENABLE_KEEPALIVE", new Object[0]), this.enableKeepAliveCheckBox, BundleMessage.format("UI_ENABLE_KEEPALIVE_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_POP_MARK_READ", new Object[0]), this.popMarkReadOnRetrCheckBox, BundleMessage.format("UI_POP_MARK_READ_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_SAVE_IN_SENT", new Object[0]), this.smtpSaveInSentCheckBox, BundleMessage.format("UI_SAVE_IN_SENT_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_DISABLE_UPDATE_CHECK", new Object[0]), this.disableUpdateCheck, BundleMessage.format("UI_DISABLE_UPDATE_CHECK_HELP", new Object[0]));
        this.addSettingComponent(otherSettingsPanel, BundleMessage.format("UI_CALDAV_AUTO_SCHEDULE", new Object[0]), this.caldavAutoScheduleCheckBox, BundleMessage.format("UI_CALDAV_AUTO_SCHEDULE_HELP", new Object[0]));
        this.updateMaximumSize(otherSettingsPanel);
        return otherSettingsPanel;
    }

    protected JPanel getOSXPanel() {
        JPanel osxSettingsPanel = new JPanel(new GridLayout(1, 2));
        osxSettingsPanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_OSX", new Object[0])));
        this.osxHideFromDockCheckBox = new JCheckBox();
        this.osxHideFromDockCheckBox.setSelected(OSXInfoPlist.isHideFromDock());
        this.addSettingComponent(osxSettingsPanel, BundleMessage.format("UI_OSX_HIDE_FROM_DOCK", new Object[0]), this.osxHideFromDockCheckBox, BundleMessage.format("UI_OSX_HIDE_FROM_DOCK_HELP", new Object[0]));
        this.updateMaximumSize(osxSettingsPanel);
        return osxSettingsPanel;
    }

    protected JPanel getLoggingSettingsPanel() {
        JPanel loggingLevelPanel = new JPanel();
        JPanel leftLoggingPanel = new JPanel(new GridLayout(2, 2));
        JPanel rightLoggingPanel = new JPanel(new GridLayout(2, 2));
        loggingLevelPanel.add(leftLoggingPanel);
        loggingLevelPanel.add(rightLoggingPanel);
        this.rootLoggingLevelField = new JComboBox<Level>(LOG_LEVELS);
        this.davmailLoggingLevelField = new JComboBox<Level>(LOG_LEVELS);
        this.httpclientLoggingLevelField = new JComboBox<Level>(LOG_LEVELS);
        this.wireLoggingLevelField = new JComboBox<Level>(LOG_LEVELS);
        this.logFilePathField = new JTextField(Settings.getProperty("davmail.logFilePath"), 15);
        this.logFileSizeField = new JTextField(Settings.getProperty("davmail.logFileSize"), 15);
        this.rootLoggingLevelField.setSelectedItem(Settings.getLoggingLevel("rootLogger"));
        this.davmailLoggingLevelField.setSelectedItem(Settings.getLoggingLevel("davmail"));
        this.httpclientLoggingLevelField.setSelectedItem(Settings.getLoggingLevel("httpclient"));
        this.wireLoggingLevelField.setSelectedItem(Settings.getLoggingLevel("httpclient.wire"));
        this.addSettingComponent(leftLoggingPanel, BundleMessage.format("UI_LOG_DEFAULT", new Object[0]), this.rootLoggingLevelField);
        this.addSettingComponent(leftLoggingPanel, BundleMessage.format("UI_LOG_DAVMAIL", new Object[0]), this.davmailLoggingLevelField);
        this.addSettingComponent(rightLoggingPanel, BundleMessage.format("UI_LOG_HTTPCLIENT", new Object[0]), this.httpclientLoggingLevelField);
        this.addSettingComponent(rightLoggingPanel, BundleMessage.format("UI_LOG_WIRE", new Object[0]), this.wireLoggingLevelField);
        JPanel logFilePathPanel = new JPanel(new GridLayout(2, 2));
        this.addSettingComponent(logFilePathPanel, BundleMessage.format("UI_LOG_FILE_PATH", new Object[0]), this.logFilePathField);
        this.addSettingComponent(logFilePathPanel, BundleMessage.format("UI_LOG_FILE_SIZE", new Object[0]), this.logFileSizeField, BundleMessage.format("UI_LOG_FILE_SIZE_HELP", new Object[0]));
        JButton defaultButton = new JButton(BundleMessage.format("UI_BUTTON_DEFAULT", new Object[0]));
        defaultButton.setToolTipText(BundleMessage.format("UI_BUTTON_DEFAULT_HELP", new Object[0]));
        defaultButton.addActionListener(e -> {
            this.rootLoggingLevelField.setSelectedItem(Level.WARN);
            this.davmailLoggingLevelField.setSelectedItem(Level.DEBUG);
            this.httpclientLoggingLevelField.setSelectedItem(Level.WARN);
            this.wireLoggingLevelField.setSelectedItem(Level.WARN);
        });
        JPanel loggingPanel = new JPanel();
        loggingPanel.setLayout(new BoxLayout(loggingPanel, 1));
        loggingPanel.setBorder(BorderFactory.createTitledBorder(BundleMessage.format("UI_LOGGING_LEVELS", new Object[0])));
        loggingPanel.add(logFilePathPanel);
        loggingPanel.add(loggingLevelPanel);
        loggingPanel.add(defaultButton);
        this.updateMaximumSize(loggingPanel);
        return loggingPanel;
    }

    protected void updateMaximumSize(JPanel panel) {
        Dimension preferredSize = panel.getPreferredSize();
        preferredSize.width = Integer.MAX_VALUE;
        panel.setMaximumSize(preferredSize);
    }

    public void reload() {
        this.urlField.setText(Settings.getProperty("davmail.url", Settings.getO365Url()));
        this.popPortField.setText(Settings.getProperty("davmail.popPort"));
        this.popPortCheckBox.setSelected(Settings.getProperty("davmail.popPort") != null && !Settings.getProperty("davmail.popPort").isEmpty());
        this.popNoSSLCheckBox.setSelected(Settings.getBooleanProperty("davmail.ssl.nosecurepop"));
        this.imapPortField.setText(Settings.getProperty("davmail.imapPort"));
        this.imapPortCheckBox.setSelected(Settings.getProperty("davmail.imapPort") != null && !Settings.getProperty("davmail.imapPort").isEmpty());
        this.imapNoSSLCheckBox.setSelected(Settings.getBooleanProperty("davmail.ssl.nosecureimap"));
        this.smtpPortField.setText(Settings.getProperty("davmail.smtpPort"));
        this.smtpPortCheckBox.setSelected(Settings.getProperty("davmail.smtpPort") != null && !Settings.getProperty("davmail.smtpPort").isEmpty());
        this.smtpNoSSLCheckBox.setSelected(Settings.getBooleanProperty("davmail.ssl.nosecuresmtp"));
        this.caldavPortField.setText(Settings.getProperty("davmail.caldavPort"));
        this.caldavPortCheckBox.setSelected(Settings.getProperty("davmail.caldavPort") != null && !Settings.getProperty("davmail.caldavPort").isEmpty());
        this.caldavNoSSLCheckBox.setSelected(Settings.getBooleanProperty("davmail.ssl.nosecurecaldav"));
        this.ldapPortField.setText(Settings.getProperty("davmail.ldapPort"));
        this.ldapPortCheckBox.setSelected(Settings.getProperty("davmail.ldapPort") != null && !Settings.getProperty("davmail.ldapPort").isEmpty());
        this.ldapNoSSLCheckBox.setSelected(Settings.getBooleanProperty("davmail.ssl.nosecureldap"));
        this.keepDelayField.setText(Settings.getProperty("davmail.keepDelay"));
        this.sentKeepDelayField.setText(Settings.getProperty("davmail.sentKeepDelay"));
        this.caldavPastDelayField.setText(Settings.getProperty("davmail.caldavPastDelay"));
        this.imapIdleDelayField.setText(Settings.getProperty("davmail.imapIdleDelay"));
        boolean useSystemProxies = Settings.getBooleanProperty("davmail.useSystemProxies", Boolean.FALSE);
        this.useSystemProxiesField.setSelected(useSystemProxies);
        boolean enableProxy = Settings.getBooleanProperty("davmail.enableProxy");
        this.enableProxyField.setSelected(enableProxy);
        this.enableProxyField.setEnabled(!useSystemProxies);
        this.httpProxyField.setEnabled(enableProxy);
        this.httpProxyPortField.setEnabled(enableProxy);
        this.httpProxyUserField.setEnabled(useSystemProxies || enableProxy);
        this.httpProxyPasswordField.setEnabled(useSystemProxies || enableProxy);
        this.noProxyForField.setEnabled(enableProxy);
        this.httpProxyField.setText(Settings.getProperty("davmail.proxyHost"));
        this.httpProxyPortField.setText(Settings.getProperty("davmail.proxyPort"));
        this.httpProxyUserField.setText(Settings.getProperty("davmail.proxyUser"));
        this.httpProxyPasswordField.setText(Settings.getProperty("davmail.proxyPassword"));
        this.noProxyForField.setText(Settings.getProperty("davmail.noProxyFor"));
        this.bindAddressField.setText(Settings.getProperty("davmail.bindAddress"));
        this.allowRemoteField.setSelected(Settings.getBooleanProperty("davmail.allowRemote"));
        this.certHashField.setText(Settings.getProperty("davmail.server.certificate.hash"));
        this.disableUpdateCheck.setSelected(Settings.getBooleanProperty("davmail.disableUpdateCheck"));
        this.caldavEditNotificationsField.setSelected(Settings.getBooleanProperty("davmail.caldavEditNotifications"));
        this.clientSoTimeoutField.setText(Settings.getProperty("davmail.clientSoTimeout"));
        this.caldavAlarmSoundField.setText(Settings.getProperty("davmail.caldavAlarmSound"));
        this.forceActiveSyncUpdateCheckBox.setSelected(Settings.getBooleanProperty("davmail.forceActiveSyncUpdate"));
        this.defaultDomainField.setText(Settings.getProperty("davmail.defaultDomain"));
        this.showStartupBannerCheckBox.setSelected(Settings.getBooleanProperty("davmail.showStartupBanner", true));
        this.disableGuiNotificationsCheckBox.setSelected(Settings.getBooleanProperty("davmail.disableGuiNotifications", false));
        this.disableTrayActivitySwitchCheckBox.setSelected(Settings.getBooleanProperty("davmail.disableTrayActivitySwitch", false));
        this.imapAutoExpungeCheckBox.setSelected(Settings.getBooleanProperty("davmail.imapAutoExpunge", true));
        this.imapAlwaysApproxMsgSizeCheckBox.setSelected(Settings.getBooleanProperty("davmail.imapAlwaysApproxMsgSize", false));
        this.enableKeepAliveCheckBox.setSelected(Settings.getBooleanProperty("davmail.enableKeepAlive", false));
        this.popMarkReadOnRetrCheckBox.setSelected(Settings.getBooleanProperty("davmail.popMarkReadOnRetr", false));
        this.modeComboBox.setSelectedItem(Settings.getProperty("davmail.mode", "EWS"));
        this.smtpSaveInSentCheckBox.setSelected(Settings.getBooleanProperty("davmail.smtpSaveInSent", true));
        this.enableKerberosCheckBox.setSelected(Settings.getBooleanProperty("davmail.enableKerberos", false));
        this.folderSizeLimitField.setText(Settings.getProperty("davmail.folderSizeLimit"));
        this.keystoreTypeCombo.setSelectedItem(Settings.getProperty("davmail.ssl.keystoreType"));
        this.keystoreFileField.setText(Settings.getProperty("davmail.ssl.keystoreFile"));
        this.keystorePassField.setText(Settings.getProperty("davmail.ssl.keystorePass"));
        this.keyPassField.setText(Settings.getProperty("davmail.ssl.keyPass"));
        this.clientKeystoreTypeCombo.setSelectedItem(Settings.getProperty("davmail.ssl.clientKeystoreType"));
        this.pkcs11LibraryField.setText(Settings.getProperty("davmail.ssl.pkcs11Library"));
        this.pkcs11ConfigField.setText(Settings.getProperty("davmail.ssl.pkcs11Config"));
        this.oauthTenantIdField.setText(Settings.getProperty("davmail.oauth.tenantId"));
        this.oauthClientIdField.setText(Settings.getProperty("davmail.oauth.clientId"));
        this.oauthRedirectUriField.setText(Settings.getProperty("davmail.oauth.redirectUri"));
        this.oauthTldField.setText(Settings.getProperty("davmail.tld"));
        this.rootLoggingLevelField.setSelectedItem(Settings.getLoggingLevel("rootLogger"));
        this.davmailLoggingLevelField.setSelectedItem(Settings.getLoggingLevel("davmail"));
        this.httpclientLoggingLevelField.setSelectedItem(Settings.getLoggingLevel("httpclient"));
        this.wireLoggingLevelField.setSelectedItem(Settings.getLoggingLevel("httpclient.wire"));
        this.logFilePathField.setText(Settings.getProperty("davmail.logFilePath"));
        this.logFileSizeField.setText(Settings.getProperty("davmail.logFileSize"));
        if (this.osxHideFromDockCheckBox != null) {
            this.osxHideFromDockCheckBox.setSelected(OSXInfoPlist.isHideFromDock());
        }
    }

    protected boolean isSslEnabled() {
        if (this.keystoreFileField != null) {
            return !this.keystoreFileField.getText().isEmpty();
        }
        return Settings.getProperty("davmail.ssl.keystoreFile") != null && !Settings.getProperty("davmail.ssl.keystoreFile").isEmpty();
    }

    public SettingsFrame() {
        this.setDefaultCloseOperation(1);
        this.setTitle(BundleMessage.format("UI_DAVMAIL_SETTINGS", new Object[0]));
        try {
            this.setIconImages(DavGatewayTray.getFrameIcons());
        }
        catch (NoSuchMethodError error) {
            DavGatewayTray.debug(new BundleMessage("LOG_UNABLE_TO_SET_ICON_IMAGE", new Object[0]));
        }
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.getInputMap(1).put(KeyStroke.getKeyStroke("F1"), "help");
        tabbedPane.getActionMap().put("help", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopBrowser.browse("https://davmail.sourceforge.net");
            }
        });
        tabbedPane.addChangeListener(e -> {
            boolean isSslEnabled = this.isSslEnabled();
            this.popNoSSLCheckBox.setEnabled(Settings.getProperty("davmail.popPort") != null && isSslEnabled);
            this.imapNoSSLCheckBox.setEnabled(this.imapPortCheckBox.isSelected() && isSslEnabled);
            this.smtpNoSSLCheckBox.setEnabled(this.smtpPortCheckBox.isSelected() && isSslEnabled);
            this.caldavNoSSLCheckBox.setEnabled(this.caldavPortCheckBox.isSelected() && isSslEnabled);
            this.ldapNoSSLCheckBox.setEnabled(this.ldapPortCheckBox.isSelected() && isSslEnabled);
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.getSettingsPanel());
        mainPanel.add(this.getDelaysPanel());
        mainPanel.add(Box.createVerticalGlue());
        tabbedPane.add(BundleMessage.format("UI_TAB_MAIN", new Object[0]), mainPanel);
        JPanel proxyPanel = new JPanel();
        proxyPanel.setLayout(new BoxLayout(proxyPanel, 1));
        proxyPanel.add(this.getProxyPanel());
        proxyPanel.add(this.getNetworkSettingsPanel());
        tabbedPane.add(BundleMessage.format("UI_TAB_NETWORK", new Object[0]), proxyPanel);
        JPanel encryptionPanel = new JPanel();
        encryptionPanel.setLayout(new BoxLayout(encryptionPanel, 1));
        encryptionPanel.add(this.getKeystorePanel());
        encryptionPanel.add(this.getSmartCardPanel());
        encryptionPanel.add(this.getOauthPanel());
        encryptionPanel.add(new JPanel());
        tabbedPane.add(BundleMessage.format("UI_TAB_ENCRYPTION", new Object[0]), encryptionPanel);
        JPanel loggingPanel = new JPanel();
        loggingPanel.setLayout(new BoxLayout(loggingPanel, 1));
        loggingPanel.add(this.getLoggingSettingsPanel());
        loggingPanel.add(new JPanel());
        tabbedPane.add(BundleMessage.format("UI_TAB_LOGGING", new Object[0]), loggingPanel);
        JPanel advancedPanel = new JPanel();
        advancedPanel.setLayout(new BoxLayout(advancedPanel, 1));
        advancedPanel.add(this.getOtherSettingsPanel());
        advancedPanel.add(new JPanel());
        tabbedPane.add(BundleMessage.format("UI_TAB_ADVANCED", new Object[0]), advancedPanel);
        if (OSXInfoPlist.isOSX()) {
            JPanel osxPanel = new JPanel();
            osxPanel.setLayout(new BoxLayout(osxPanel, 1));
            osxPanel.add(this.getOSXPanel());
            osxPanel.add(new JPanel());
            tabbedPane.add(BundleMessage.format("UI_TAB_OSX", new Object[0]), osxPanel);
        }
        this.add("Center", tabbedPane);
        JPanel buttonPanel = new JPanel();
        JButton cancel = new JButton(BundleMessage.format("UI_BUTTON_CANCEL", new Object[0]));
        JButton ok = new JButton(BundleMessage.format("UI_BUTTON_SAVE", new Object[0]));
        JButton help = new JButton(BundleMessage.format("UI_BUTTON_HELP", new Object[0]));
        ActionListener save = evt -> {
            Settings.setProperty("davmail.url", this.urlField.getText().trim());
            Settings.setProperty("davmail.popPort", this.popPortCheckBox.isSelected() ? this.popPortField.getText() : "");
            Settings.setProperty("davmail.ssl.nosecurepop", String.valueOf(this.popNoSSLCheckBox.isSelected()));
            Settings.setProperty("davmail.imapPort", this.imapPortCheckBox.isSelected() ? this.imapPortField.getText() : "");
            Settings.setProperty("davmail.ssl.nosecureimap", String.valueOf(this.imapNoSSLCheckBox.isSelected()));
            Settings.setProperty("davmail.smtpPort", this.smtpPortCheckBox.isSelected() ? this.smtpPortField.getText() : "");
            Settings.setProperty("davmail.ssl.nosecuresmtp", String.valueOf(this.smtpNoSSLCheckBox.isSelected()));
            Settings.setProperty("davmail.caldavPort", this.caldavPortCheckBox.isSelected() ? this.caldavPortField.getText() : "");
            Settings.setProperty("davmail.ssl.nosecurecaldav", String.valueOf(this.caldavNoSSLCheckBox.isSelected()));
            Settings.setProperty("davmail.ldapPort", this.ldapPortCheckBox.isSelected() ? this.ldapPortField.getText() : "");
            Settings.setProperty("davmail.ssl.nosecureldap", String.valueOf(this.ldapNoSSLCheckBox.isSelected()));
            Settings.setProperty("davmail.keepDelay", this.keepDelayField.getText());
            Settings.setProperty("davmail.sentKeepDelay", this.sentKeepDelayField.getText());
            Settings.setProperty("davmail.caldavPastDelay", this.caldavPastDelayField.getText());
            Settings.setProperty("davmail.imapIdleDelay", this.imapIdleDelayField.getText());
            Settings.setProperty("davmail.useSystemProxies", String.valueOf(this.useSystemProxiesField.isSelected()));
            Settings.setProperty("davmail.enableProxy", String.valueOf(this.enableProxyField.isSelected()));
            Settings.setProperty("davmail.proxyHost", this.httpProxyField.getText());
            Settings.setProperty("davmail.proxyPort", this.httpProxyPortField.getText());
            Settings.setProperty("davmail.proxyUser", this.httpProxyUserField.getText());
            Settings.setProperty("davmail.proxyPassword", this.httpProxyPasswordField.getText());
            Settings.setProperty("davmail.noProxyFor", this.noProxyForField.getText());
            Settings.setProperty("davmail.bindAddress", this.bindAddressField.getText());
            Settings.setProperty("davmail.clientSoTimeout", String.valueOf(this.clientSoTimeoutField.getText()));
            Settings.setProperty("davmail.allowRemote", String.valueOf(this.allowRemoteField.isSelected()));
            Settings.setProperty("davmail.server.certificate.hash", this.certHashField.getText());
            Settings.setProperty("davmail.disableUpdateCheck", String.valueOf(this.disableUpdateCheck.isSelected()));
            Settings.setProperty("davmail.caldavAutoSchedule", String.valueOf(this.caldavAutoScheduleCheckBox.isSelected()));
            Settings.setProperty("davmail.caldavEditNotifications", String.valueOf(this.caldavEditNotificationsField.isSelected()));
            Settings.setProperty("davmail.caldavAlarmSound", String.valueOf(this.caldavAlarmSoundField.getText()));
            Settings.setProperty("davmail.forceActiveSyncUpdate", String.valueOf(this.forceActiveSyncUpdateCheckBox.isSelected()));
            Settings.setProperty("davmail.defaultDomain", String.valueOf(this.defaultDomainField.getText()));
            Settings.setProperty("davmail.showStartupBanner", String.valueOf(this.showStartupBannerCheckBox.isSelected()));
            Settings.setProperty("davmail.disableGuiNotifications", String.valueOf(this.disableGuiNotificationsCheckBox.isSelected()));
            Settings.setProperty("davmail.disableTrayActivitySwitch", String.valueOf(this.disableTrayActivitySwitchCheckBox.isSelected()));
            Settings.setProperty("davmail.imapAutoExpunge", String.valueOf(this.imapAutoExpungeCheckBox.isSelected()));
            Settings.setProperty("davmail.imapAlwaysApproxMsgSize", String.valueOf(this.imapAlwaysApproxMsgSizeCheckBox.isSelected()));
            Settings.setProperty("davmail.enableKeepAlive", String.valueOf(this.enableKeepAliveCheckBox.isSelected()));
            Settings.setProperty("davmail.popMarkReadOnRetr", String.valueOf(this.popMarkReadOnRetrCheckBox.isSelected()));
            Settings.setProperty("davmail.mode", (String)this.modeComboBox.getSelectedItem());
            Settings.setProperty("davmail.enableKerberos", String.valueOf(this.enableKerberosCheckBox.isSelected()));
            Settings.setProperty("davmail.folderSizeLimit", this.folderSizeLimitField.getText());
            Settings.setProperty("davmail.smtpSaveInSent", String.valueOf(this.smtpSaveInSentCheckBox.isSelected()));
            Settings.setProperty("davmail.ssl.keystoreType", (String)this.keystoreTypeCombo.getSelectedItem());
            Settings.setProperty("davmail.ssl.keystoreFile", this.keystoreFileField.getText());
            Settings.setProperty("davmail.ssl.keystorePass", String.valueOf(this.keystorePassField.getPassword()));
            Settings.setProperty("davmail.ssl.keyPass", String.valueOf(this.keyPassField.getPassword()));
            Settings.setProperty("davmail.ssl.clientKeystoreType", (String)this.clientKeystoreTypeCombo.getSelectedItem());
            Settings.setProperty("davmail.ssl.clientKeystoreFile", this.clientKeystoreFileField.getText());
            Settings.setProperty("davmail.ssl.clientKeystorePass", String.valueOf(this.clientKeystorePassField.getPassword()));
            Settings.setProperty("davmail.ssl.pkcs11Library", this.pkcs11LibraryField.getText());
            Settings.setProperty("davmail.ssl.pkcs11Config", this.pkcs11ConfigField.getText());
            Settings.setProperty("davmail.oauth.tenantId", this.oauthTenantIdField.getText());
            Settings.setProperty("davmail.oauth.clientId", this.oauthClientIdField.getText());
            Settings.setProperty("davmail.oauth.redirectUri", this.oauthRedirectUriField.getText());
            Settings.setProperty("davmail.tld", this.oauthTldField.getText());
            Settings.setLoggingLevel("rootLogger", (Level)this.rootLoggingLevelField.getSelectedItem());
            Settings.setLoggingLevel("davmail", (Level)this.davmailLoggingLevelField.getSelectedItem());
            Settings.setLoggingLevel("httpclient", (Level)this.httpclientLoggingLevelField.getSelectedItem());
            Settings.setLoggingLevel("httpclient.wire", (Level)this.wireLoggingLevelField.getSelectedItem());
            Settings.setProperty("davmail.logFilePath", this.logFilePathField.getText());
            Settings.setProperty("davmail.logFileSize", this.logFileSizeField.getText());
            this.setVisible(false);
            Settings.save();
            if (this.osxHideFromDockCheckBox != null) {
                OSXInfoPlist.setOSXHideFromDock(this.osxHideFromDockCheckBox.isSelected());
            }
            DavGateway.restart();
        };
        ok.addActionListener(save);
        cancel.addActionListener(evt -> {
            this.reload();
            this.setVisible(false);
        });
        help.addActionListener(e -> DesktopBrowser.browse("https://davmail.sourceforge.net"));
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        buttonPanel.add(help);
        this.add("South", buttonPanel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.urlField.requestFocus();
    }
}

