/*
 * Decompiled with CFR 0.152.
 */
package davmail.ui;

import davmail.BundleMessage;
import davmail.ui.tray.DavGatewayTray;
import java.awt.Component;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class PasswordPromptDialog
extends JDialog {
    final JPasswordField passwordField = new JPasswordField(20);
    protected char[] password;

    public char[] getPassword() {
        if (this.password != null) {
            return (char[])this.password.clone();
        }
        return "".toCharArray();
    }

    public PasswordPromptDialog(String prompt) {
        this(prompt, null);
    }

    public PasswordPromptDialog(String prompt, Image captchaImage) {
        this.setAlwaysOnTop(true);
        this.setTitle(BundleMessage.format("UI_PASSWORD_PROMPT", new Object[0]));
        try {
            this.setIconImages(DavGatewayTray.getFrameIcons());
        }
        catch (NoSuchMethodError error) {
            DavGatewayTray.debug(new BundleMessage("LOG_UNABLE_TO_SET_ICON_IMAGE", new Object[0]));
        }
        JPanel questionPanel = new JPanel();
        questionPanel.setLayout(new BoxLayout(questionPanel, 1));
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        imageLabel.setText(prompt);
        questionPanel.add(imageLabel);
        this.passwordField.addActionListener(e -> {
            this.password = this.passwordField.getPassword();
            this.setVisible(false);
        });
        JPanel passwordPanel = new JPanel();
        passwordPanel.setLayout(new BoxLayout(passwordPanel, 1));
        if (captchaImage != null) {
            JLabel captchaLabel = new JLabel(new ImageIcon(captchaImage));
            captchaLabel.setAlignmentX(0.5f);
            captchaLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
            passwordPanel.add(captchaLabel);
        }
        passwordPanel.add(this.passwordField);
        this.add((Component)questionPanel, "North");
        this.add((Component)passwordPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
        questionPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        passwordPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.setModal(true);
        this.pack();
        this.setLocation(this.getToolkit().getScreenSize().width / 2 - this.getSize().width / 2, this.getToolkit().getScreenSize().height / 2 - this.getSize().height / 2);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    protected JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton(BundleMessage.format("UI_BUTTON_OK", new Object[0]));
        JButton cancelButton = new JButton(BundleMessage.format("UI_BUTTON_CANCEL", new Object[0]));
        okButton.addActionListener(evt -> {
            this.password = this.passwordField.getPassword();
            this.setVisible(false);
        });
        cancelButton.addActionListener(evt -> {
            this.password = null;
            this.setVisible(false);
        });
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }
}

