/*
 * Decompiled with CFR 0.152.
 */
package davmail.imap;

import com.sun.mail.imap.protocol.BASE64MailboxDecoder;
import com.sun.mail.imap.protocol.BASE64MailboxEncoder;
import davmail.AbstractConnection;
import davmail.BundleMessage;
import davmail.DavGateway;
import davmail.Settings;
import davmail.exception.DavMailException;
import davmail.exception.HttpForbiddenException;
import davmail.exception.HttpNotFoundException;
import davmail.exception.InsufficientStorageException;
import davmail.exchange.ExchangeSession;
import davmail.exchange.ExchangeSessionFactory;
import davmail.exchange.MessageCreateThread;
import davmail.exchange.MessageLoadThread;
import davmail.ui.tray.DavGatewayTray;
import davmail.util.IOUtil;
import davmail.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.http.client.HttpResponseException;
import org.apache.log4j.Logger;

public class ImapConnection
extends AbstractConnection {
    private static final Logger LOGGER = Logger.getLogger(ImapConnection.class);
    protected String baseMailboxPath;
    ExchangeSession.Folder currentFolder;
    protected String lastCommand;
    protected int lastCommandCount;

    public ImapConnection(Socket clientSocket) {
        super(ImapConnection.class.getSimpleName(), clientSocket, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block200: {
            int imapIdleDelay = Settings.getIntProperty("davmail.imapIdleDelay") * 60;
            String capabilities = imapIdleDelay > 0 ? "CAPABILITY IMAP4REV1 AUTH=LOGIN IDLE MOVE SPECIAL-USE UIDPLUS" : "CAPABILITY IMAP4REV1 AUTH=LOGIN MOVE SPECIAL-USE UIDPLUS";
            String commandId = null;
            try {
                String line;
                ExchangeSessionFactory.checkConfig();
                this.sendClient("* OK [" + capabilities + "] IMAP4rev1 DavMail " + DavGateway.getCurrentVersion() + " server ready");
                while ((line = this.readClient()) != null) {
                    block199: {
                        ImapTokenizer tokens = new ImapTokenizer(line);
                        if (tokens.hasMoreTokens()) {
                            commandId = tokens.nextToken();
                            this.checkInfiniteLoop(line);
                            if (tokens.hasMoreTokens()) {
                                String command = tokens.nextToken();
                                if ("LOGOUT".equalsIgnoreCase(command)) {
                                    this.sendClient("* BYE Closing connection");
                                    this.sendClient(commandId + " OK LOGOUT completed");
                                    break;
                                }
                                if ("capability".equalsIgnoreCase(command)) {
                                    this.sendClient("* " + capabilities);
                                    this.sendClient(commandId + " OK CAPABILITY completed");
                                } else if ("login".equalsIgnoreCase(command)) {
                                    this.parseCredentials(tokens);
                                    this.splitUserName();
                                    try {
                                        this.session = ExchangeSessionFactory.getInstance(this.userName, this.password);
                                        this.logConnection("LOGON", this.userName);
                                        this.sendClient(commandId + " OK Authenticated");
                                        this.state = AbstractConnection.State.AUTHENTICATED;
                                    }
                                    catch (Exception e) {
                                        this.logConnection("FAILED", this.userName);
                                        DavGatewayTray.error(e);
                                        if (Settings.getBooleanProperty("davmail.enableKerberos")) {
                                            this.sendClient(commandId + " NO LOGIN Kerberos authentication failed");
                                        } else {
                                            this.sendClient(commandId + " NO LOGIN failed");
                                        }
                                        this.state = AbstractConnection.State.INITIAL;
                                    }
                                } else if ("AUTHENTICATE".equalsIgnoreCase(command)) {
                                    if (tokens.hasMoreTokens()) {
                                        String authenticationMethod = tokens.nextToken();
                                        if ("LOGIN".equalsIgnoreCase(authenticationMethod)) {
                                            try {
                                                this.sendClient("+ " + IOUtil.encodeBase64AsString("Username:"));
                                                this.state = AbstractConnection.State.LOGIN;
                                                this.userName = IOUtil.decodeBase64AsString(this.readClient());
                                                this.splitUserName();
                                                this.sendClient("+ " + IOUtil.encodeBase64AsString("Password:"));
                                                this.state = AbstractConnection.State.PASSWORD;
                                                this.password = IOUtil.decodeBase64AsString(this.readClient());
                                                this.session = ExchangeSessionFactory.getInstance(this.userName, this.password);
                                                this.logConnection("LOGON", this.userName);
                                                this.sendClient(commandId + " OK Authenticated");
                                                this.state = AbstractConnection.State.AUTHENTICATED;
                                            }
                                            catch (Exception e) {
                                                this.logConnection("FAILED", this.userName);
                                                DavGatewayTray.error(e);
                                                this.sendClient(commandId + " NO LOGIN failed");
                                                this.state = AbstractConnection.State.INITIAL;
                                            }
                                        } else {
                                            this.sendClient(commandId + " NO unsupported authentication method");
                                        }
                                    } else {
                                        this.sendClient(commandId + " BAD authentication method required");
                                    }
                                } else if (this.state != AbstractConnection.State.AUTHENTICATED) {
                                    this.sendClient(commandId + " BAD command authentication required");
                                } else {
                                    String flags;
                                    ExchangeSession.Message message;
                                    RangeIterator rangeIterator;
                                    StringBuilder buffer;
                                    String parameters;
                                    String folderName;
                                    this.session = ExchangeSessionFactory.getInstance(this.session, this.userName, this.password);
                                    if ("lsub".equalsIgnoreCase(command) || "list".equalsIgnoreCase(command)) {
                                        if (tokens.hasMoreTokens()) {
                                            String token = tokens.nextToken();
                                            boolean specialOnly = token.contains("SPECIAL-USE");
                                            if (specialOnly && tokens.hasMoreTokens()) {
                                                token = tokens.nextToken();
                                            }
                                            if (tokens.hasMoreTokens()) {
                                                String folderQuery = this.buildFolderPath(token) + this.decodeFolderPath(tokens.nextToken());
                                                if (folderQuery.endsWith("%/%") && !"/%/%".equals(folderQuery)) {
                                                    List<ExchangeSession.Folder> folders = this.session.getSubFolders(folderQuery.substring(0, folderQuery.length() - 3), false, false);
                                                    for (ExchangeSession.Folder folder : folders) {
                                                        this.sendClient("* " + command + " (" + folder.getFlags() + ") \"/\" \"" + this.encodeFolderPath(folder.folderPath) + '\"');
                                                        this.sendSubFolders(command, folder.folderPath, false, false, specialOnly);
                                                    }
                                                    this.sendClient(commandId + " OK " + command + " completed");
                                                } else if (folderQuery.endsWith("%") || folderQuery.endsWith("*")) {
                                                    if ("/*".equals(folderQuery) || "/%".equals(folderQuery) || "/%/%".equals(folderQuery)) {
                                                        if ("%/%".equals(folderQuery = folderQuery.substring(1))) {
                                                            folderQuery = folderQuery.substring(0, folderQuery.length() - 2);
                                                        }
                                                        this.sendClient("* " + command + " (\\HasChildren) \"/\" \"/public\"");
                                                    }
                                                    if ("*%".equals(folderQuery)) {
                                                        folderQuery = "*";
                                                    }
                                                    boolean wildcard = folderQuery.endsWith("%") && !folderQuery.contains("/") && !folderQuery.equals("%");
                                                    boolean recursive = folderQuery.endsWith("*");
                                                    this.sendSubFolders(command, folderQuery.substring(0, folderQuery.length() - 1), recursive, wildcard, specialOnly);
                                                    this.sendClient(commandId + " OK " + command + " completed");
                                                } else {
                                                    ExchangeSession.Folder folder = null;
                                                    try {
                                                        folder = this.session.getFolder(folderQuery);
                                                    }
                                                    catch (HttpForbiddenException e) {
                                                        DavGatewayTray.debug(new BundleMessage("LOG_FOLDER_ACCESS_FORBIDDEN", folderQuery));
                                                    }
                                                    catch (HttpNotFoundException e) {
                                                        DavGatewayTray.debug(new BundleMessage("LOG_FOLDER_NOT_FOUND", folderQuery));
                                                    }
                                                    catch (HttpResponseException e) {
                                                        DavGatewayTray.debug(new BundleMessage("LOG_FOLDER_ACCESS_ERROR", folderQuery, e.getMessage()));
                                                    }
                                                    if (folder != null) {
                                                        this.sendClient("* " + command + " (" + folder.getFlags() + ") \"/\" \"" + this.encodeFolderPath(folder.folderPath) + '\"');
                                                        this.sendClient(commandId + " OK " + command + " completed");
                                                    } else {
                                                        this.sendClient(commandId + " NO Folder not found");
                                                    }
                                                }
                                            } else {
                                                this.sendClient(commandId + " BAD missing folder argument");
                                            }
                                        } else {
                                            this.sendClient(commandId + " BAD missing folder argument");
                                        }
                                    } else if ("select".equalsIgnoreCase(command) || "examine".equalsIgnoreCase(command)) {
                                        if (tokens.hasMoreTokens()) {
                                            folderName = this.buildFolderPath(tokens.nextToken());
                                            try {
                                                this.currentFolder = this.session.getFolder(folderName);
                                                this.loadFolder(this.currentFolder);
                                                this.sendClient("* " + this.currentFolder.count() + " EXISTS");
                                                this.sendClient("* " + this.currentFolder.recent + " RECENT");
                                                this.sendClient("* OK [UIDVALIDITY 1]");
                                                if (this.currentFolder.count() == 0) {
                                                    this.sendClient("* OK [UIDNEXT 1]");
                                                } else {
                                                    this.sendClient("* OK [UIDNEXT " + this.currentFolder.getUidNext() + ']');
                                                }
                                                this.sendClient("* FLAGS (\\Answered \\Deleted \\Draft \\Flagged \\Seen $Forwarded Junk)");
                                                this.sendClient("* OK [PERMANENTFLAGS (\\Answered \\Deleted \\Draft \\Flagged \\Seen $Forwarded Junk \\*)]");
                                                if ("select".equalsIgnoreCase(command)) {
                                                    this.sendClient(commandId + " OK [READ-WRITE] " + command + " completed");
                                                    break block199;
                                                }
                                                this.sendClient(commandId + " OK [READ-ONLY] " + command + " completed");
                                            }
                                            catch (HttpNotFoundException e) {
                                                this.sendClient(commandId + " NO Not found");
                                            }
                                            catch (HttpForbiddenException e) {
                                                this.sendClient(commandId + " NO Forbidden");
                                            }
                                        } else {
                                            this.sendClient(commandId + " BAD command unrecognized");
                                        }
                                    } else if ("expunge".equalsIgnoreCase(command)) {
                                        if (this.expunge(false)) {
                                            this.session.refreshFolder(this.currentFolder);
                                        }
                                        this.sendClient(commandId + " OK " + command + " completed");
                                    } else if ("close".equalsIgnoreCase(command)) {
                                        this.expunge(true);
                                        this.currentFolder = null;
                                        this.sendClient(commandId + " OK " + command + " completed");
                                    } else if ("create".equalsIgnoreCase(command)) {
                                        if (tokens.hasMoreTokens()) {
                                            this.session.createMessageFolder(this.buildFolderPath(tokens.nextToken()));
                                            this.sendClient(commandId + " OK folder created");
                                        } else {
                                            this.sendClient(commandId + " BAD missing create argument");
                                        }
                                    } else if ("rename".equalsIgnoreCase(command)) {
                                        folderName = this.buildFolderPath(tokens.nextToken());
                                        String targetName = this.buildFolderPath(tokens.nextToken());
                                        try {
                                            this.session.moveFolder(folderName, targetName);
                                            this.sendClient(commandId + " OK rename completed");
                                        }
                                        catch (HttpResponseException e) {
                                            this.sendClient(commandId + " NO " + e.getMessage());
                                        }
                                    } else if ("delete".equalsIgnoreCase(command)) {
                                        folderName = this.buildFolderPath(tokens.nextToken());
                                        try {
                                            this.session.deleteFolder(folderName);
                                            this.sendClient(commandId + " OK folder deleted");
                                        }
                                        catch (HttpResponseException e) {
                                            this.sendClient(commandId + " NO " + e.getMessage());
                                        }
                                    } else if ("uid".equalsIgnoreCase(command)) {
                                        if (tokens.hasMoreTokens()) {
                                            UIDRangeIterator uidRangeIterator;
                                            String subcommand = tokens.nextToken();
                                            if ("fetch".equalsIgnoreCase(subcommand)) {
                                                if (this.currentFolder == null) {
                                                    this.sendClient(commandId + " NO no folder selected");
                                                } else {
                                                    String ranges = tokens.nextToken();
                                                    if (ranges == null) {
                                                        this.sendClient(commandId + " BAD missing range parameter");
                                                    } else {
                                                        parameters = null;
                                                        if (tokens.hasMoreTokens()) {
                                                            parameters = tokens.nextToken();
                                                        }
                                                        uidRangeIterator = new UIDRangeIterator(this.currentFolder.messages, ranges);
                                                        while (uidRangeIterator.hasNext()) {
                                                            DavGatewayTray.switchIcon();
                                                            ExchangeSession.Message message2 = uidRangeIterator.next();
                                                            try {
                                                                this.handleFetch(message2, uidRangeIterator.currentIndex, parameters);
                                                            }
                                                            catch (HttpNotFoundException e) {
                                                                LOGGER.warn((Object)("Ignore missing message " + uidRangeIterator.currentIndex));
                                                            }
                                                            catch (SocketException e) {
                                                                throw e;
                                                            }
                                                            catch (IOException e) {
                                                                DavGatewayTray.log(e);
                                                                LOGGER.warn((Object)("Ignore broken message " + uidRangeIterator.currentIndex + ' ' + e.getMessage()));
                                                            }
                                                        }
                                                        this.sendClient(commandId + " OK UID FETCH completed");
                                                    }
                                                }
                                            } else if ("search".equalsIgnoreCase(subcommand)) {
                                                List<Long> uidList = this.handleSearch(tokens);
                                                buffer = new StringBuilder("* SEARCH");
                                                uidRangeIterator = uidList.iterator();
                                                while (uidRangeIterator.hasNext()) {
                                                    long uid = (Long)uidRangeIterator.next();
                                                    buffer.append(' ');
                                                    buffer.append(uid);
                                                }
                                                this.sendClient(buffer.toString());
                                                this.sendClient(commandId + " OK SEARCH completed");
                                            } else if ("store".equalsIgnoreCase(subcommand)) {
                                                UIDRangeIterator uidRangeIterator2 = new UIDRangeIterator(this.currentFolder.messages, tokens.nextToken());
                                                String action = tokens.nextToken();
                                                String flags2 = tokens.nextToken();
                                                this.handleStore(commandId, uidRangeIterator2, action, flags2);
                                            } else if ("copy".equalsIgnoreCase(subcommand) || "move".equalsIgnoreCase(subcommand)) {
                                                try {
                                                    UIDRangeIterator uidRangeIterator3 = new UIDRangeIterator(this.currentFolder.messages, tokens.nextToken());
                                                    String targetName = this.buildFolderPath(tokens.nextToken());
                                                    if (!uidRangeIterator3.hasNext()) {
                                                        this.sendClient(commandId + " NO No message found");
                                                        break block199;
                                                    }
                                                    ArrayList messages = new ArrayList();
                                                    while (uidRangeIterator3.hasNext()) {
                                                        messages.add(uidRangeIterator3.next());
                                                    }
                                                    if ("copy".equalsIgnoreCase(subcommand)) {
                                                        this.session.copyMessages(messages, targetName);
                                                    } else {
                                                        this.session.moveMessages(messages, targetName);
                                                    }
                                                    this.sendClient(commandId + " OK " + subcommand + " completed");
                                                }
                                                catch (HttpNotFoundException e) {
                                                    this.sendClient(commandId + " NO [TRYCREATE] " + e.getMessage());
                                                }
                                                catch (HttpResponseException e) {
                                                    this.sendClient(commandId + " NO " + e.getMessage());
                                                }
                                            }
                                        } else {
                                            this.sendClient(commandId + " BAD command unrecognized");
                                        }
                                    } else if ("search".equalsIgnoreCase(command)) {
                                        if (this.currentFolder == null) {
                                            this.sendClient(commandId + " NO no folder selected");
                                        } else {
                                            List<Long> uidList = this.handleSearch(tokens);
                                            if (uidList.isEmpty()) {
                                                this.sendClient("* SEARCH");
                                            } else {
                                                int currentIndex = 0;
                                                buffer = new StringBuilder("* SEARCH");
                                                for (ExchangeSession.Message message2 : this.currentFolder.messages) {
                                                    ++currentIndex;
                                                    if (!uidList.contains(message2.getImapUid())) continue;
                                                    buffer.append(' ');
                                                    buffer.append(currentIndex);
                                                }
                                                this.sendClient(buffer.toString());
                                            }
                                            this.sendClient(commandId + " OK SEARCH completed");
                                        }
                                    } else if ("fetch".equalsIgnoreCase(command)) {
                                        if (this.currentFolder == null) {
                                            this.sendClient(commandId + " NO no folder selected");
                                        } else {
                                            rangeIterator = new RangeIterator(this.currentFolder.messages, tokens.nextToken());
                                            String parameters2 = null;
                                            if (tokens.hasMoreTokens()) {
                                                parameters2 = tokens.nextToken();
                                            }
                                            while (rangeIterator.hasNext()) {
                                                DavGatewayTray.switchIcon();
                                                message = rangeIterator.next();
                                                try {
                                                    this.handleFetch(message, rangeIterator.currentIndex, parameters2);
                                                }
                                                catch (HttpNotFoundException e) {
                                                    LOGGER.warn((Object)("Ignore missing message " + rangeIterator.currentIndex));
                                                }
                                                catch (SocketException e) {
                                                    throw e;
                                                }
                                                catch (IOException e) {
                                                    DavGatewayTray.log(e);
                                                    LOGGER.warn((Object)("Ignore broken message " + rangeIterator.currentIndex + ' ' + e.getMessage()));
                                                }
                                            }
                                            this.sendClient(commandId + " OK FETCH completed");
                                        }
                                    } else if ("store".equalsIgnoreCase(command)) {
                                        rangeIterator = new RangeIterator(this.currentFolder.messages, tokens.nextToken());
                                        String action = tokens.nextToken();
                                        flags = tokens.nextToken();
                                        this.handleStore(commandId, rangeIterator, action, flags);
                                    } else if ("copy".equalsIgnoreCase(command) || "move".equalsIgnoreCase(command)) {
                                        try {
                                            rangeIterator = new RangeIterator(this.currentFolder.messages, tokens.nextToken());
                                            String targetName = this.buildFolderPath(tokens.nextToken());
                                            if (!rangeIterator.hasNext()) {
                                                this.sendClient(commandId + " NO No message found");
                                                break block199;
                                            }
                                            while (rangeIterator.hasNext()) {
                                                DavGatewayTray.switchIcon();
                                                message = rangeIterator.next();
                                                if ("copy".equalsIgnoreCase(command)) {
                                                    this.session.copyMessage(message, targetName);
                                                    continue;
                                                }
                                                this.session.moveMessage(message, targetName);
                                            }
                                            this.sendClient(commandId + " OK " + command + " completed");
                                        }
                                        catch (HttpResponseException e) {
                                            this.sendClient(commandId + " NO " + e.getMessage());
                                        }
                                    } else if ("append".equalsIgnoreCase(command)) {
                                        folderName = this.buildFolderPath(tokens.nextToken());
                                        HashMap<String, String> properties = new HashMap<String, String>();
                                        flags = null;
                                        String date = null;
                                        String nextToken = tokens.nextQuotedToken();
                                        if (nextToken.startsWith("(")) {
                                            flags = StringUtil.removeQuotes(nextToken);
                                            if (tokens.hasMoreTokens()) {
                                                nextToken = tokens.nextToken();
                                                if (tokens.hasMoreTokens()) {
                                                    date = nextToken;
                                                    nextToken = tokens.nextToken();
                                                }
                                            }
                                        } else if (tokens.hasMoreTokens()) {
                                            date = StringUtil.removeQuotes(nextToken);
                                            nextToken = tokens.nextToken();
                                        }
                                        if (flags != null) {
                                            HashSet<String> keywords = null;
                                            ImapTokenizer flagtokenizer = new ImapTokenizer(flags);
                                            while (flagtokenizer.hasMoreTokens()) {
                                                String flag = flagtokenizer.nextToken();
                                                if ("\\Seen".equalsIgnoreCase(flag)) {
                                                    if (properties.containsKey("draft")) {
                                                        properties.put("draft", "9");
                                                        continue;
                                                    }
                                                    properties.put("draft", "1");
                                                    continue;
                                                }
                                                if ("\\Flagged".equalsIgnoreCase(flag)) {
                                                    properties.put("flagged", "2");
                                                    continue;
                                                }
                                                if ("\\Answered".equalsIgnoreCase(flag)) {
                                                    properties.put("answered", "102");
                                                    continue;
                                                }
                                                if ("$Forwarded".equalsIgnoreCase(flag)) {
                                                    properties.put("forwarded", "104");
                                                    continue;
                                                }
                                                if ("\\Draft".equalsIgnoreCase(flag)) {
                                                    if (properties.containsKey("draft")) {
                                                        properties.put("draft", "9");
                                                        continue;
                                                    }
                                                    properties.put("draft", "8");
                                                    continue;
                                                }
                                                if ("Junk".equalsIgnoreCase(flag)) {
                                                    properties.put("junk", "1");
                                                    continue;
                                                }
                                                if (keywords == null) {
                                                    keywords = new HashSet<String>();
                                                }
                                                keywords.add(flag);
                                            }
                                            if (keywords != null) {
                                                properties.put("keywords", this.session.convertFlagsToKeywords(keywords));
                                            }
                                        } else {
                                            properties.put("draft", "0");
                                        }
                                        if (date != null) {
                                            SimpleDateFormat dateParser = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss Z", Locale.ENGLISH);
                                            Date dateReceived = dateParser.parse(date);
                                            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                                            dateFormatter.setTimeZone(ExchangeSession.GMT_TIMEZONE);
                                            properties.put("datereceived", dateFormatter.format(dateReceived));
                                        }
                                        int size = Integer.parseInt(StringUtil.removeQuotes(nextToken));
                                        this.sendClient("+ send literal data");
                                        byte[] buffer2 = this.in.readContent(size);
                                        this.readClient();
                                        MimeMessage mimeMessage = new MimeMessage(null, (InputStream)new SharedByteArrayInputStream(buffer2));
                                        String messageName = UUID.randomUUID() + ".EML";
                                        try {
                                            ExchangeSession.Message createdMessage = MessageCreateThread.createMessage(this.session, folderName, messageName, properties, mimeMessage, this.os, capabilities);
                                            if (createdMessage != null) {
                                                long uid = createdMessage.getImapUid();
                                                this.sendClient(commandId + " OK [APPENDUID 1 " + uid + "] APPEND completed");
                                                break block199;
                                            }
                                            this.sendClient(commandId + " OK APPEND completed");
                                        }
                                        catch (InsufficientStorageException e) {
                                            this.sendClient(commandId + " NO " + e.getMessage());
                                        }
                                    } else if ("idle".equalsIgnoreCase(command) && imapIdleDelay > 0) {
                                        if (this.currentFolder != null) {
                                            this.sendClient("+ idling ");
                                            this.currentFolder.clearCache();
                                            DavGatewayTray.resetIcon();
                                            int originalTimeout = this.client.getSoTimeout();
                                            try {
                                                int count = 0;
                                                this.client.setSoTimeout(1000);
                                                while (this.in.available() == 0) {
                                                    if (++count >= imapIdleDelay) {
                                                        count = 0;
                                                        TreeMap<Long, String> previousImapFlagMap = this.currentFolder.getImapFlagMap();
                                                        if (this.session.refreshFolder(this.currentFolder)) {
                                                            this.handleRefresh(previousImapFlagMap, this.currentFolder.getImapFlagMap());
                                                        }
                                                    }
                                                    try {
                                                        byte[] byteBuffer = new byte[1];
                                                        if (this.in.read(byteBuffer) <= 0) continue;
                                                        this.in.unread(byteBuffer);
                                                    }
                                                    catch (SocketTimeoutException byteBuffer) {}
                                                }
                                                line = this.readClient();
                                                if ("DONE".equals(line)) {
                                                    this.sendClient(commandId + " OK " + command + " terminated");
                                                }
                                                this.sendClient(commandId + " BAD command unrecognized");
                                            }
                                            catch (IOException e) {
                                                throw new SocketException(e.getMessage());
                                            }
                                            finally {
                                                this.client.setSoTimeout(originalTimeout);
                                            }
                                        } else {
                                            this.sendClient(commandId + " NO no folder selected");
                                        }
                                    } else if ("noop".equalsIgnoreCase(command) || "check".equalsIgnoreCase(command)) {
                                        if (this.currentFolder != null) {
                                            DavGatewayTray.debug(new BundleMessage("LOG_IMAP_COMMAND", command, this.currentFolder.folderPath));
                                            TreeMap<Long, String> previousImapFlagMap = this.currentFolder.getImapFlagMap();
                                            if (this.session.refreshFolder(this.currentFolder)) {
                                                this.handleRefresh(previousImapFlagMap, this.currentFolder.getImapFlagMap());
                                            }
                                        }
                                        this.sendClient(commandId + " OK " + command + " completed");
                                    } else if ("subscribe".equalsIgnoreCase(command) || "unsubscribe".equalsIgnoreCase(command)) {
                                        this.sendClient(commandId + " OK " + command + " completed");
                                    } else if ("status".equalsIgnoreCase(command)) {
                                        try {
                                            String encodedFolderName = tokens.nextToken();
                                            ExchangeSession.Folder folder = this.session.getFolder(this.buildFolderPath(encodedFolderName));
                                            this.loadFolder(folder);
                                            parameters = tokens.nextToken();
                                            StringBuilder answer = new StringBuilder();
                                            ImapTokenizer parametersTokens = new ImapTokenizer(parameters);
                                            while (parametersTokens.hasMoreTokens()) {
                                                String token = parametersTokens.nextToken();
                                                if ("MESSAGES".equalsIgnoreCase(token)) {
                                                    answer.append("MESSAGES ").append(folder.count()).append(' ');
                                                }
                                                if ("RECENT".equalsIgnoreCase(token)) {
                                                    answer.append("RECENT ").append(folder.recent).append(' ');
                                                }
                                                if ("UIDNEXT".equalsIgnoreCase(token)) {
                                                    if (folder.count() == 0) {
                                                        answer.append("UIDNEXT 1 ");
                                                    } else if (folder.count() == 0) {
                                                        answer.append("UIDNEXT 1 ");
                                                    } else {
                                                        answer.append("UIDNEXT ").append(folder.getUidNext()).append(' ');
                                                    }
                                                }
                                                if ("UIDVALIDITY".equalsIgnoreCase(token)) {
                                                    answer.append("UIDVALIDITY 1 ");
                                                }
                                                if (!"UNSEEN".equalsIgnoreCase(token)) continue;
                                                answer.append("UNSEEN ").append(folder.unreadCount).append(' ');
                                            }
                                            this.sendClient("* STATUS \"" + encodedFolderName + "\" (" + answer.toString().trim() + ')');
                                            this.sendClient(commandId + " OK " + command + " completed");
                                        }
                                        catch (HttpResponseException e) {
                                            this.sendClient(commandId + " NO folder not found");
                                        }
                                    } else {
                                        this.sendClient(commandId + " BAD command unrecognized");
                                    }
                                }
                            } else {
                                this.sendClient(commandId + " BAD missing command");
                            }
                        } else {
                            this.sendClient("BAD Null command");
                        }
                    }
                    DavGatewayTray.resetIcon();
                }
                this.os.flush();
            }
            catch (SocketTimeoutException e) {
                DavGatewayTray.debug(new BundleMessage("LOG_CLOSE_CONNECTION_ON_TIMEOUT", new Object[0]));
                try {
                    this.sendClient("* BYE Closing connection");
                }
                catch (IOException e1) {
                    DavGatewayTray.debug(new BundleMessage("LOG_EXCEPTION_CLOSING_CONNECTION_ON_TIMEOUT", new Object[0]));
                }
            }
            catch (SocketException e) {
                LOGGER.warn((Object)BundleMessage.formatLog("LOG_CLIENT_CLOSED_CONNECTION", new Object[0]));
            }
            catch (Exception e) {
                DavGatewayTray.log(e);
                try {
                    String message = (e.getMessage() == null ? e.toString() : e.getMessage()).replaceAll("\\n", " ");
                    if (commandId != null) {
                        this.sendClient(commandId + " BAD unable to handle request: " + message);
                        break block200;
                    }
                    this.sendClient("* BAD unable to handle request: " + message);
                }
                catch (IOException e2) {
                    DavGatewayTray.warn(new BundleMessage("LOG_EXCEPTION_SENDING_ERROR_TO_CLIENT", new Object[0]), e2);
                }
            }
            finally {
                this.close();
            }
        }
        DavGatewayTray.resetIcon();
    }

    protected void checkInfiniteLoop(String line) throws IOException {
        int spaceIndex = line.indexOf(32);
        if (spaceIndex < 0) {
            this.lastCommand = null;
            this.lastCommandCount = 0;
        } else {
            String command = line.substring(spaceIndex + 1);
            if (command.equals(this.lastCommand)) {
                ++this.lastCommandCount;
                if (this.lastCommandCount > 100 && !"NOOP".equalsIgnoreCase(this.lastCommand) && !"IDLE".equalsIgnoreCase(this.lastCommand)) {
                    throw new IOException("Infinite loop on command " + command + " detected");
                }
            } else {
                this.lastCommand = command;
                this.lastCommandCount = 0;
            }
        }
    }

    protected void splitUserName() {
        String[] tokens = null;
        if (this.userName.indexOf(47) >= 0) {
            tokens = this.userName.split("/");
        } else if (this.userName.indexOf(92) >= 0) {
            tokens = this.userName.split("\\\\");
        }
        if (tokens != null && tokens.length == 3) {
            this.userName = tokens[0] + '\\' + tokens[1];
            this.baseMailboxPath = "/users/" + tokens[2] + '/';
        } else if (tokens != null && tokens.length == 2 && tokens[1].contains("@")) {
            this.userName = tokens[0];
            this.baseMailboxPath = "/users/" + tokens[1] + '/';
        }
    }

    protected String encodeFolderPath(String folderPath) {
        return BASE64MailboxEncoder.encode((String)folderPath).replaceAll("\"", "\\\\\"");
    }

    protected String decodeFolderPath(String folderPath) {
        return BASE64MailboxDecoder.decode((String)folderPath).replaceAll("\\\\", "");
    }

    protected String buildFolderPath(String encodedFolderPath) {
        String decodedFolderPath = this.decodeFolderPath(encodedFolderPath);
        if (this.baseMailboxPath == null || decodedFolderPath.startsWith("/")) {
            return decodedFolderPath;
        }
        return this.baseMailboxPath + decodedFolderPath;
    }

    private void handleRefresh(TreeMap<Long, String> previousImapFlagMap, TreeMap<Long, String> imapFlagMap) throws IOException {
        int index = 1;
        for (long previousImapUid : previousImapFlagMap.keySet()) {
            if (!imapFlagMap.containsKey(previousImapUid)) {
                this.sendClient("* " + index + " EXPUNGE");
                continue;
            }
            if (!previousImapFlagMap.get(previousImapUid).equals(imapFlagMap.get(previousImapUid))) {
                this.sendClient("* " + index + " FETCH (UID " + previousImapUid + " FLAGS (" + imapFlagMap.get(previousImapUid) + "))");
            }
            ++index;
        }
        this.sendClient("* " + this.currentFolder.count() + " EXISTS");
        this.sendClient("* " + this.currentFolder.recent + " RECENT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFolder(ExchangeSession.Folder folder) throws IOException {
        boolean enable = Settings.getBooleanProperty("davmail.enableKeepAlive", false);
        KeepAlive keepAlive = null;
        if (enable && folder.count() > 500) {
            Runnable progressNotifier = () -> {
                try {
                    this.sendClient("* OK in progress");
                }
                catch (IOException e) {
                    LOGGER.warn((Object)"Error while sending progress notification", (Throwable)e);
                }
            };
            keepAlive = new KeepAlive(progressNotifier);
        }
        try {
            folder.loadMessages();
        }
        finally {
            if (keepAlive != null) {
                keepAlive.cancel();
            }
        }
    }

    private void handleFetch(ExchangeSession.Message message, int currentIndex, String parameters) throws IOException, MessagingException {
        StringBuilder buffer = new StringBuilder();
        MessageWrapper messageWrapper = new MessageWrapper(this.os, buffer, message);
        buffer.append("* ").append(currentIndex).append(" FETCH (UID ").append(message.getImapUid());
        if (parameters != null) {
            parameters = this.handleFetchMacro(parameters);
            ImapTokenizer paramTokens = new ImapTokenizer(parameters);
            while (paramTokens.hasMoreTokens()) {
                int dotIndex;
                String param = paramTokens.nextToken().toUpperCase();
                if ("FLAGS".equals(param)) {
                    buffer.append(" FLAGS (").append(message.getImapFlags()).append(')');
                    continue;
                }
                if ("RFC822.SIZE".equals(param)) {
                    int size;
                    if (parameters.contains("BODY.PEEK[HEADER.FIELDS (") && !parameters.contains("X-LABEL") || parameters.equals("RFC822.SIZE RFC822.HEADER FLAGS") || Settings.getBooleanProperty("davmail.imapAlwaysApproxMsgSize")) {
                        size = message.size;
                        LOGGER.debug((Object)String.format("Message %s sent approximate size %d bytes", message.getImapUid(), size));
                    } else {
                        size = messageWrapper.getMimeMessageSize();
                    }
                    buffer.append(" RFC822.SIZE ").append(size);
                    continue;
                }
                if ("ENVELOPE".equals(param)) {
                    this.appendEnvelope(buffer, messageWrapper);
                    continue;
                }
                if ("BODYSTRUCTURE".equals(param)) {
                    this.appendBodyStructure(buffer, messageWrapper);
                    continue;
                }
                if ("INTERNALDATE".equals(param) && message.date != null && !message.date.isEmpty()) {
                    try {
                        SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                        dateParser.setTimeZone(ExchangeSession.GMT_TIMEZONE);
                        Date date = ExchangeSession.getZuluDateFormat().parse(message.date);
                        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss Z", Locale.ENGLISH);
                        buffer.append(" INTERNALDATE \"").append(dateFormatter.format(date)).append('\"');
                        continue;
                    }
                    catch (ParseException e) {
                        throw new DavMailException("EXCEPTION_INVALID_DATE", message.date);
                    }
                }
                if (!"RFC822".equals(param) && !param.startsWith("BODY[") && !param.startsWith("BODY.PEEK[") && !"RFC822.HEADER".equals(param) && !"RFC822.TEXT".equals(param)) continue;
                if (param.startsWith("BODY[") && !message.read) {
                    this.updateFlags(message, "FLAGS", "\\Seen");
                    message.read = true;
                }
                if (param.indexOf(91) >= 0) {
                    StringBuilder paramBuffer = new StringBuilder(param);
                    while (paramTokens.hasMoreTokens() && paramBuffer.indexOf("]") < 0) {
                        paramBuffer.append(' ').append(paramTokens.nextToken());
                    }
                    param = paramBuffer.toString();
                }
                int startIndex = 0;
                int maxSize = Integer.MAX_VALUE;
                int ltIndex = param.indexOf(60);
                if (ltIndex >= 0 && (dotIndex = param.indexOf(46, ltIndex)) >= 0) {
                    startIndex = Integer.parseInt(param.substring(ltIndex + 1, dotIndex));
                    maxSize = Integer.parseInt(param.substring(dotIndex + 1, param.indexOf(62)));
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream partInputStream = null;
                FilterOutputStream partOutputStream = null;
                String partIndexString = StringUtil.getToken(param, "[", "]");
                if ((partIndexString == null || partIndexString.isEmpty()) && !"RFC822.HEADER".equals(param)) {
                    partOutputStream = new PartialOutputStream(baos, startIndex, maxSize);
                    partInputStream = messageWrapper.getRawInputStream();
                } else if ("TEXT".equals(partIndexString)) {
                    partOutputStream = new PartOutputStream(baos, false, true, startIndex, maxSize);
                    partInputStream = messageWrapper.getRawInputStream();
                } else if ("RFC822.HEADER".equals(param) || partIndexString != null && partIndexString.startsWith("HEADER")) {
                    String[] requestedHeaders = this.getRequestedHeaders(partIndexString);
                    if (requestedHeaders != null && requestedHeaders.length == 1 && "content-class".equals(requestedHeaders[0]) && message.contentClass != null) {
                        baos.write("Content-class: ".getBytes(StandardCharsets.UTF_8));
                        baos.write(message.contentClass.getBytes(StandardCharsets.UTF_8));
                        baos.write(13);
                        baos.write(10);
                    } else if (requestedHeaders == null) {
                        partOutputStream = new PartOutputStream(baos, true, false, startIndex, maxSize);
                        partInputStream = messageWrapper.getRawInputStream();
                    } else {
                        Enumeration headerEnumeration = messageWrapper.getMatchingHeaderLines(requestedHeaders);
                        while (headerEnumeration.hasMoreElements()) {
                            baos.write(((String)headerEnumeration.nextElement()).getBytes(StandardCharsets.UTF_8));
                            baos.write(13);
                            baos.write(10);
                        }
                    }
                } else if (partIndexString != null) {
                    String[] partIndexStrings;
                    MimeMessage bodyPart = messageWrapper.getMimeMessage();
                    for (String subPartIndexString : partIndexStrings = partIndexString.split("\\.")) {
                        int subPartIndex;
                        if ("MIME".equals(subPartIndexString)) break;
                        try {
                            subPartIndex = Integer.parseInt(subPartIndexString);
                        }
                        catch (NumberFormatException e) {
                            throw new DavMailException("EXCEPTION_INVALID_PARAMETER", param);
                        }
                        Object mimeBody = bodyPart.getContent();
                        if (mimeBody instanceof MimeMultipart) {
                            MimeMultipart multiPart = (MimeMultipart)mimeBody;
                            if (subPartIndex - 1 < multiPart.getCount()) {
                                bodyPart = (MimePart)multiPart.getBodyPart(subPartIndex - 1);
                                continue;
                            }
                            throw new DavMailException("EXCEPTION_INVALID_PARAMETER", param);
                        }
                        if (subPartIndex == 1) continue;
                        throw new DavMailException("EXCEPTION_INVALID_PARAMETER", param);
                    }
                    partOutputStream = new PartialOutputStream(baos, startIndex, maxSize);
                    partInputStream = bodyPart instanceof MimeMessage ? bodyPart.getRawInputStream() : ((MimeBodyPart)bodyPart).getRawInputStream();
                }
                if (partInputStream != null && partOutputStream != null) {
                    IOUtil.write(partInputStream, partOutputStream);
                    partInputStream.close();
                    ((OutputStream)partOutputStream).close();
                }
                baos.close();
                if ("RFC822".equals(param)) {
                    buffer.append(" RFC822");
                } else if ("RFC822.HEADER".equals(param)) {
                    buffer.append(" RFC822.HEADER");
                } else if ("RFC822.TEXT".equals(param)) {
                    buffer.append(" RFC822.TEXT");
                } else {
                    buffer.append(" BODY[");
                    if (partIndexString != null) {
                        buffer.append(partIndexString);
                    }
                    buffer.append(']');
                }
                if (startIndex > 0 || maxSize != Integer.MAX_VALUE) {
                    buffer.append('<').append(startIndex).append('>');
                }
                buffer.append(" {").append(baos.size()).append('}');
                this.sendClient(buffer.toString());
                if (LOGGER.isDebugEnabled() && baos.size() < 2048) {
                    LOGGER.debug((Object)new String(baos.toByteArray(), StandardCharsets.UTF_8));
                }
                this.os.write(baos.toByteArray());
                this.os.flush();
                buffer.setLength(0);
            }
        }
        buffer.append(')');
        this.sendClient(buffer.toString());
        message.dropMimeMessage();
    }

    private String handleFetchMacro(String parameters) {
        if ("ALL".equals(parameters)) {
            return "FLAGS INTERNALDATE RFC822.SIZE ENVELOPE";
        }
        if ("FAST".equals(parameters)) {
            return "FLAGS INTERNALDATE RFC822.SIZE";
        }
        if ("FULL".equals(parameters)) {
            return "FLAGS INTERNALDATE RFC822.SIZE ENVELOPE BODY";
        }
        return parameters;
    }

    protected String[] getRequestedHeaders(String partIndexString) {
        if (partIndexString == null) {
            return null;
        }
        int startIndex = partIndexString.indexOf(40);
        int endIndex = partIndexString.indexOf(41);
        if (startIndex >= 0 && endIndex >= 0) {
            return partIndexString.substring(startIndex + 1, endIndex).split(" ");
        }
        return null;
    }

    protected void handleStore(String commandId, AbstractRangeIterator rangeIterator, String action, String flags) throws IOException {
        while (rangeIterator.hasNext()) {
            DavGatewayTray.switchIcon();
            ExchangeSession.Message message = (ExchangeSession.Message)rangeIterator.next();
            this.updateFlags(message, action, flags);
            this.sendClient("* " + rangeIterator.getCurrentIndex() + " FETCH (UID " + message.getImapUid() + " FLAGS (" + message.getImapFlags() + "))");
        }
        if (Settings.getBooleanProperty("davmail.imapAutoExpunge") && this.expunge(false)) {
            this.session.refreshFolder(this.currentFolder);
        }
        this.sendClient(commandId + " OK STORE completed");
    }

    protected ExchangeSession.Condition buildConditions(SearchConditions conditions, ImapTokenizer tokens) throws IOException {
        ExchangeSession.MultiCondition condition = null;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextQuotedToken().toUpperCase();
            if (token.startsWith("(") && token.endsWith(")")) {
                if (condition == null) {
                    condition = this.session.and(new ExchangeSession.Condition[0]);
                }
                condition.add(this.buildConditions(conditions, new ImapTokenizer(token.substring(1, token.length() - 1))));
                continue;
            }
            if ("OR".equals(token)) {
                condition = this.session.or(new ExchangeSession.Condition[0]);
                continue;
            }
            if (token.startsWith("OR ")) {
                condition = this.appendOrSearchParams(token, conditions);
                continue;
            }
            if ("CHARSET".equals(token)) {
                String charset = tokens.nextToken().toUpperCase();
                if ("ASCII".equals(charset) || "UTF-8".equals(charset) || "US-ASCII".equals(charset)) continue;
                throw new IOException("Unsupported charset " + charset);
            }
            if (condition == null) {
                condition = this.session.and(new ExchangeSession.Condition[0]);
            }
            condition.add(this.appendSearchParam(tokens, token, conditions));
        }
        return condition;
    }

    protected List<Long> handleSearch(ImapTokenizer tokens) throws IOException {
        AbstractRangeIterator iterator;
        ArrayList<Long> uidList = new ArrayList<Long>();
        ArrayList<Long> localMessagesUidList = null;
        SearchConditions conditions = new SearchConditions();
        ExchangeSession.Condition condition = this.buildConditions(conditions, tokens);
        this.session.refreshFolder(this.currentFolder);
        ExchangeSession.MessageList localMessages = this.currentFolder.searchMessages(condition);
        if (conditions.uidRange != null) {
            iterator = new UIDRangeIterator(localMessages, conditions.uidRange);
        } else if (conditions.indexRange != null) {
            iterator = new RangeIterator(this.currentFolder.messages, conditions.indexRange);
            localMessagesUidList = new ArrayList<Long>();
            for (ExchangeSession.Message message : localMessages) {
                localMessagesUidList.add(message.getImapUid());
            }
        } else {
            iterator = localMessages.iterator();
        }
        while (iterator.hasNext()) {
            ExchangeSession.Message message = (ExchangeSession.Message)iterator.next();
            if (conditions.flagged != null && message.flagged != conditions.flagged || conditions.answered != null && message.answered != conditions.answered || conditions.draft != null && message.draft != conditions.draft || localMessagesUidList != null && !localMessagesUidList.contains(message.getImapUid()) || !this.isNotExcluded(conditions.notUidRange, message.getImapUid())) continue;
            uidList.add(message.getImapUid());
        }
        return uidList;
    }

    private boolean isNotExcluded(String notUidRange, long imapUid) {
        if (notUidRange == null) {
            return true;
        }
        String imapUidAsString = String.valueOf(imapUid);
        for (String rangeValue : notUidRange.split(",")) {
            if (!imapUidAsString.equals(rangeValue)) continue;
            return false;
        }
        return true;
    }

    protected void appendEnvelope(StringBuilder buffer, MessageWrapper message) throws IOException {
        try {
            MimeMessage mimeMessage = message.getMimeMessage();
            buffer.append(" ENVELOPE ");
            this.appendEnvelope(buffer, (MimePart)mimeMessage);
        }
        catch (MessagingException me) {
            DavGatewayTray.warn((Exception)((Object)me));
            buffer.append(" ENVELOPE (NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL)");
        }
    }

    private void appendEnvelope(StringBuilder buffer, MimePart mimePart) throws UnsupportedEncodingException, MessagingException {
        buffer.append('(');
        this.appendEnvelopeHeader(buffer, mimePart.getHeader("Date"));
        this.appendEnvelopeHeader(buffer, mimePart.getHeader("Subject"));
        this.appendMailEnvelopeHeader(buffer, mimePart.getHeader("From"));
        this.appendMailEnvelopeHeader(buffer, mimePart.getHeader("Sender"));
        this.appendMailEnvelopeHeader(buffer, mimePart.getHeader("Reply-To"));
        this.appendMailEnvelopeHeader(buffer, mimePart.getHeader("To"));
        this.appendMailEnvelopeHeader(buffer, mimePart.getHeader("CC"));
        this.appendMailEnvelopeHeader(buffer, mimePart.getHeader("BCC"));
        this.appendEnvelopeHeader(buffer, mimePart.getHeader("In-Reply-To"));
        this.appendEnvelopeHeader(buffer, mimePart.getHeader("Message-Id"));
        buffer.append(')');
    }

    protected void appendEnvelopeHeader(StringBuilder buffer, String[] value) throws UnsupportedEncodingException {
        if (buffer.charAt(buffer.length() - 1) != '(') {
            buffer.append(' ');
        }
        if (value != null && value.length > 0) {
            this.appendEnvelopeHeaderValue(buffer, MimeUtility.unfold((String)value[0]));
        } else {
            buffer.append("NIL");
        }
    }

    protected void appendMailEnvelopeHeader(StringBuilder buffer, String[] value) {
        block10: {
            buffer.append(' ');
            if (value != null && value.length > 0) {
                try {
                    String unfoldedValue = MimeUtility.unfold((String)value[0]);
                    InternetAddress[] addresses = InternetAddress.parseHeader((String)unfoldedValue, (boolean)false);
                    if (addresses.length > 0) {
                        buffer.append('(');
                        for (InternetAddress address : addresses) {
                            buffer.append('(');
                            String personal = address.getPersonal();
                            if (personal != null) {
                                this.appendEnvelopeHeaderValue(buffer, personal);
                            } else {
                                buffer.append("NIL");
                            }
                            buffer.append(" NIL ");
                            String mail = address.getAddress();
                            int atIndex = mail.indexOf(64);
                            if (atIndex >= 0) {
                                buffer.append('\"').append(mail, 0, atIndex).append('\"');
                                buffer.append(' ');
                                buffer.append('\"').append(mail.substring(atIndex + 1)).append('\"');
                            } else {
                                buffer.append("NIL NIL");
                            }
                            buffer.append(')');
                        }
                        buffer.append(')');
                        break block10;
                    }
                    buffer.append("NIL");
                }
                catch (UnsupportedEncodingException | AddressException e) {
                    DavGatewayTray.warn((Exception)e);
                    buffer.append("NIL");
                }
            } else {
                buffer.append("NIL");
            }
        }
    }

    protected void appendEnvelopeHeaderValue(StringBuilder buffer, String value) throws UnsupportedEncodingException {
        if (value.indexOf(34) >= 0 || value.indexOf(92) >= 0) {
            buffer.append('{');
            buffer.append(value.length());
            buffer.append("}\r\n");
            buffer.append(value);
        } else {
            buffer.append('\"');
            buffer.append(MimeUtility.encodeText((String)value, (String)"UTF-8", null));
            buffer.append('\"');
        }
    }

    protected void appendBodyStructure(StringBuilder buffer, MessageWrapper message) throws IOException {
        buffer.append(" BODYSTRUCTURE ");
        try {
            MimeMessage mimeMessage = message.getMimeMessage();
            Object mimeBody = mimeMessage.getContent();
            if (mimeBody instanceof MimeMultipart) {
                this.appendBodyStructure(buffer, (MimeMultipart)mimeBody);
            } else {
                this.appendBodyStructure(buffer, (MimePart)mimeMessage);
            }
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            DavGatewayTray.warn((Exception)e);
            buffer.append("(\"TEXT\" \"PLAIN\" (\"CHARSET\" \"US-ASCII\") NIL NIL \"7BIT\" 0 0)");
        }
    }

    protected void appendBodyStructure(StringBuilder buffer, MimeMultipart multiPart) throws IOException, MessagingException {
        buffer.append('(');
        for (int i = 0; i < multiPart.getCount(); ++i) {
            MimeBodyPart bodyPart = (MimeBodyPart)multiPart.getBodyPart(i);
            try {
                Object mimeBody = bodyPart.getContent();
                if (mimeBody instanceof MimeMultipart) {
                    this.appendBodyStructure(buffer, (MimeMultipart)mimeBody);
                    continue;
                }
                this.appendBodyStructure(buffer, (MimePart)bodyPart);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.warn((Object)e);
                buffer.append("(\"TEXT\" \"PLAIN\" (\"CHARSET\" \"US-ASCII\") NIL NIL \"7BIT\" 0 0)");
                continue;
            }
            catch (MessagingException me) {
                DavGatewayTray.warn((Exception)((Object)me));
                buffer.append("(\"TEXT\" \"PLAIN\" (\"CHARSET\" \"US-ASCII\") NIL NIL \"7BIT\" 0 0)");
            }
        }
        int slashIndex = multiPart.getContentType().indexOf(47);
        if (slashIndex < 0) {
            throw new DavMailException("EXCEPTION_INVALID_CONTENT_TYPE", multiPart.getContentType());
        }
        int semiColonIndex = multiPart.getContentType().indexOf(59);
        if (semiColonIndex < 0) {
            buffer.append(" \"").append(multiPart.getContentType().substring(slashIndex + 1).toUpperCase()).append("\")");
        } else {
            buffer.append(" \"").append(multiPart.getContentType().substring(slashIndex + 1, semiColonIndex).trim().toUpperCase()).append("\")");
        }
    }

    protected void appendBodyStructure(StringBuilder buffer, MimePart bodyPart) throws IOException, MessagingException {
        String contentType = MimeUtility.unfold((String)bodyPart.getContentType());
        int slashIndex = contentType.indexOf(47);
        if (slashIndex < 0) {
            throw new DavMailException("EXCEPTION_INVALID_CONTENT_TYPE", contentType);
        }
        String type = contentType.substring(0, slashIndex).toUpperCase();
        buffer.append("(\"").append(type).append("\" \"");
        int semiColonIndex = contentType.indexOf(59);
        if (semiColonIndex < 0) {
            buffer.append(contentType.substring(slashIndex + 1).toUpperCase()).append("\" NIL");
        } else {
            buffer.append(contentType.substring(slashIndex + 1, semiColonIndex).trim().toUpperCase()).append('\"');
            int charsetindex = contentType.indexOf("charset=");
            int nameindex = contentType.indexOf("name=");
            if (charsetindex >= 0 || nameindex >= 0) {
                buffer.append(" (");
                if (charsetindex >= 0) {
                    buffer.append("\"CHARSET\" ");
                    int charsetSemiColonIndex = contentType.indexOf(59, charsetindex);
                    int charsetEndIndex = charsetSemiColonIndex > 0 ? charsetSemiColonIndex : contentType.length();
                    String charSet = contentType.substring(charsetindex + "charset=".length(), charsetEndIndex);
                    if (!charSet.startsWith("\"")) {
                        buffer.append('\"');
                    }
                    buffer.append(charSet.trim().toUpperCase());
                    if (!charSet.endsWith("\"")) {
                        buffer.append('\"');
                    }
                }
                if (nameindex >= 0) {
                    if (charsetindex >= 0) {
                        buffer.append(' ');
                    }
                    buffer.append("\"NAME\" ");
                    int nameSemiColonIndex = contentType.indexOf(59, nameindex);
                    int nameEndIndex = nameSemiColonIndex > 0 ? nameSemiColonIndex : contentType.length();
                    String name = contentType.substring(nameindex + "name=".length(), nameEndIndex).trim();
                    if (!name.startsWith("\"")) {
                        buffer.append('\"');
                    }
                    buffer.append(name.trim());
                    if (!name.endsWith("\"")) {
                        buffer.append('\"');
                    }
                }
                buffer.append(')');
            } else {
                buffer.append(" NIL");
            }
        }
        int bodySize = this.getBodyPartSize(bodyPart);
        this.appendBodyStructureValue(buffer, bodyPart.getContentID());
        this.appendBodyStructureValue(buffer, bodyPart.getDescription());
        this.appendBodyStructureValue(buffer, bodyPart.getEncoding());
        this.appendBodyStructureValue(buffer, bodySize);
        int lineCount = bodySize / 80;
        if ("TEXT".equals(type)) {
            this.appendBodyStructureValue(buffer, lineCount);
        } else if ("MESSAGE".equals(type)) {
            Object bodyPartContent = bodyPart.getContent();
            if (bodyPartContent instanceof MimeMessage) {
                MimeMessage innerMessage = (MimeMessage)bodyPartContent;
                this.appendEnvelope(buffer, (MimePart)innerMessage);
                this.appendBodyStructure(buffer, (MimePart)innerMessage);
                this.appendBodyStructureValue(buffer, lineCount);
            } else {
                this.appendBodyStructureValue(buffer, lineCount);
            }
        }
        buffer.append(')');
    }

    private int getBodyPartSize(MimePart bodyPart) {
        int bodySize = 0;
        try {
            bodySize = bodyPart.getSize();
            if (bodySize == -1) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                bodyPart.writeTo((OutputStream)baos);
                bodySize = baos.size();
            }
        }
        catch (IOException | MessagingException e) {
            LOGGER.warn((Object)("Unable to get body part size " + e.getMessage()), e);
        }
        return bodySize;
    }

    protected void appendBodyStructureValue(StringBuilder buffer, String value) {
        if (value == null) {
            buffer.append(" NIL");
        } else {
            buffer.append(" \"").append(value.toUpperCase()).append('\"');
        }
    }

    protected void appendBodyStructureValue(StringBuilder buffer, int value) {
        if (value < 0) {
            buffer.append(" 0");
        } else {
            buffer.append(' ').append(value);
        }
    }

    protected void sendSubFolders(String command, String folderPath, boolean recursive, boolean wildcard, boolean specialOnly) throws IOException {
        try {
            List<ExchangeSession.Folder> folders = this.session.getSubFolders(folderPath, recursive, wildcard);
            for (ExchangeSession.Folder folder : folders) {
                if (specialOnly && !folder.isSpecial()) continue;
                this.sendClient("* " + command + " (" + folder.getFlags() + ") \"/\" \"" + this.encodeFolderPath(folder.folderPath) + '\"');
            }
        }
        catch (HttpForbiddenException e) {
            DavGatewayTray.debug(new BundleMessage("LOG_SUBFOLDER_ACCESS_FORBIDDEN", folderPath));
        }
        catch (HttpNotFoundException e) {
            DavGatewayTray.debug(new BundleMessage("LOG_FOLDER_NOT_FOUND", folderPath));
        }
        catch (HttpResponseException e) {
            DavGatewayTray.debug(new BundleMessage("LOG_FOLDER_ACCESS_ERROR", folderPath, e.getMessage()));
        }
    }

    protected ExchangeSession.MultiCondition appendOrSearchParams(String token, SearchConditions conditions) throws IOException {
        ExchangeSession.MultiCondition orCondition = this.session.or(new ExchangeSession.Condition[0]);
        ImapTokenizer innerTokens = new ImapTokenizer(token);
        innerTokens.nextToken();
        while (innerTokens.hasMoreTokens()) {
            String innerToken = innerTokens.nextToken();
            orCondition.add(this.appendSearchParam(innerTokens, innerToken, conditions));
        }
        return orCondition;
    }

    protected ExchangeSession.Condition appendNotSearchParams(String token, SearchConditions conditions) throws IOException {
        ImapTokenizer innerTokens = new ImapTokenizer(token);
        ExchangeSession.Condition cond = this.buildConditions(conditions, innerTokens);
        if (cond == null || cond.isEmpty()) {
            return null;
        }
        return this.session.not(cond);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ExchangeSession.Condition appendSearchParam(ImapTokenizer tokens, String token, SearchConditions conditions) throws IOException {
        if ("NOT".equals(token)) {
            String nextToken = tokens.nextToken();
            if ("DELETED".equals(nextToken)) {
                return this.session.isNull("deleted");
            }
            if ("KEYWORD".equals(nextToken)) {
                return this.appendNotSearchParams(nextToken + " " + tokens.nextToken(), conditions);
            }
            if (!"UID".equals(nextToken)) return this.appendNotSearchParams(nextToken, conditions);
            conditions.notUidRange = tokens.nextToken();
            return null;
        } else {
            if (token.startsWith("OR ")) {
                return this.appendOrSearchParams(token, conditions);
            }
            if ("SUBJECT".equals(token)) {
                return this.session.contains("subject", tokens.nextToken());
            }
            if ("BODY".equals(token)) {
                return this.session.contains("body", tokens.nextToken());
            }
            if ("TEXT".equals(token)) {
                String value = tokens.nextToken();
                return this.session.or(this.session.contains("body", value), this.session.contains("subject", value), this.session.contains("from", value), this.session.contains("to", value), this.session.contains("cc", value));
            }
            if ("KEYWORD".equals(token)) {
                return this.session.isEqualTo("keywords", this.session.convertFlagToKeyword(tokens.nextToken()));
            }
            if ("FROM".equals(token)) {
                return this.session.contains("from", tokens.nextToken());
            }
            if ("TO".equals(token)) {
                return this.session.contains("to", tokens.nextToken());
            }
            if ("CC".equals(token)) {
                return this.session.contains("cc", tokens.nextToken());
            }
            if ("LARGER".equals(token)) {
                return this.session.gte("messageSize", tokens.nextToken());
            }
            if ("SMALLER".equals(token)) {
                return this.session.lt("messageSize", tokens.nextToken());
            }
            if (token.startsWith("SENT") || "SINCE".equals(token) || "BEFORE".equals(token) || "ON".equals(token)) {
                return this.appendDateSearchParam(tokens, token);
            }
            if ("SEEN".equals(token)) {
                return this.session.isTrue("read");
            }
            if ("UNSEEN".equals(token) || "NEW".equals(token)) {
                return this.session.isFalse("read");
            }
            if ("DRAFT".equals(token)) {
                conditions.draft = Boolean.TRUE;
                return null;
            } else if ("UNDRAFT".equals(token)) {
                conditions.draft = Boolean.FALSE;
                return null;
            } else {
                if ("DELETED".equals(token)) {
                    return this.session.isEqualTo("deleted", "1");
                }
                if ("UNDELETED".equals(token) || "NOT DELETED".equals(token)) {
                    return this.session.isNull("deleted");
                }
                if ("FLAGGED".equals(token)) {
                    conditions.flagged = Boolean.TRUE;
                    return null;
                } else if ("UNFLAGGED".equals(token)) {
                    conditions.flagged = Boolean.FALSE;
                    return null;
                } else if ("ANSWERED".equals(token)) {
                    conditions.answered = Boolean.TRUE;
                    return null;
                } else if ("UNANSWERED".equals(token)) {
                    conditions.answered = Boolean.FALSE;
                    return null;
                } else {
                    if ("HEADER".equals(token)) {
                        String headerName = tokens.nextToken().toLowerCase();
                        String value = tokens.nextToken();
                        if (!"message-id".equals(headerName) || value.startsWith("<")) return this.session.headerIsEqualTo(headerName, value);
                        value = '<' + value + '>';
                        return this.session.headerIsEqualTo(headerName, value);
                    }
                    if ("UID".equals(token)) {
                        String range = tokens.nextToken();
                        if ("1:*".equals(range)) return null;
                        conditions.uidRange = range;
                        return null;
                    } else {
                        if ("OLD".equals(token) || "RECENT".equals(token) || "ALL".equals(token)) return null;
                        if (token.indexOf(58) < 0 && !token.matches("\\d+") && token.indexOf(44) < 0) throw new DavMailException("EXCEPTION_INVALID_SEARCH_PARAMETERS", token);
                        conditions.indexRange = token;
                    }
                }
            }
        }
        return null;
    }

    protected ExchangeSession.Condition appendDateSearchParam(ImapTokenizer tokens, String token) throws IOException {
        Date endDate;
        Date startDate;
        SimpleDateFormat parser = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);
        parser.setTimeZone(ExchangeSession.GMT_TIMEZONE);
        String dateToken = tokens.nextToken();
        try {
            startDate = parser.parse(dateToken);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            calendar.add(5, 1);
            endDate = calendar.getTime();
        }
        catch (ParseException e) {
            throw new DavMailException("EXCEPTION_INVALID_SEARCH_PARAMETERS", dateToken);
        }
        String searchAttribute = token.startsWith("SENT") ? "date" : "lastmodified";
        if (token.endsWith("ON")) {
            return this.session.and(this.session.gt(searchAttribute, this.session.formatSearchDate(startDate)), this.session.lt(searchAttribute, this.session.formatSearchDate(endDate)));
        }
        if (token.endsWith("BEFORE")) {
            return this.session.lt(searchAttribute, this.session.formatSearchDate(startDate));
        }
        if (token.endsWith("SINCE")) {
            return this.session.gte(searchAttribute, this.session.formatSearchDate(startDate));
        }
        throw new DavMailException("EXCEPTION_INVALID_SEARCH_PARAMETERS", dateToken);
    }

    protected boolean expunge(boolean silent) throws IOException {
        boolean hasDeleted = false;
        if (this.currentFolder.messages != null) {
            int index = 1;
            for (ExchangeSession.Message message : this.currentFolder.messages) {
                if (message.deleted) {
                    message.delete();
                    hasDeleted = true;
                    if (silent) continue;
                    this.sendClient("* " + index + " EXPUNGE");
                    continue;
                }
                ++index;
            }
        }
        return hasDeleted;
    }

    protected void updateFlags(ExchangeSession.Message message, String action, String flags) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        if ("-Flags".equalsIgnoreCase(action) || "-FLAGS.SILENT".equalsIgnoreCase(action)) {
            ImapTokenizer flagtokenizer = new ImapTokenizer(flags);
            while (flagtokenizer.hasMoreTokens()) {
                String flag = flagtokenizer.nextToken();
                if ("\\Seen".equalsIgnoreCase(flag)) {
                    if (!message.read) continue;
                    properties.put("read", "0");
                    message.read = false;
                    continue;
                }
                if ("\\Flagged".equalsIgnoreCase(flag)) {
                    if (!message.flagged) continue;
                    properties.put("flagged", "0");
                    message.flagged = false;
                    continue;
                }
                if ("\\Deleted".equalsIgnoreCase(flag)) {
                    if (!message.deleted) continue;
                    properties.put("deleted", null);
                    message.deleted = false;
                    continue;
                }
                if ("Junk".equalsIgnoreCase(flag)) {
                    if (!message.junk) continue;
                    properties.put("junk", "0");
                    message.junk = false;
                    continue;
                }
                if ("$Forwarded".equalsIgnoreCase(flag)) {
                    if (!message.forwarded) continue;
                    properties.put("forwarded", null);
                    message.forwarded = false;
                    continue;
                }
                if ("\\Answered".equalsIgnoreCase(flag)) {
                    if (!message.answered) continue;
                    properties.put("answered", null);
                    message.answered = false;
                    continue;
                }
                if ("\\Draft".equalsIgnoreCase(flag) || message.keywords == null) continue;
                properties.put("keywords", message.removeFlag(flag));
            }
        } else if ("+Flags".equalsIgnoreCase(action) || "+FLAGS.SILENT".equalsIgnoreCase(action)) {
            ImapTokenizer flagtokenizer = new ImapTokenizer(flags);
            while (flagtokenizer.hasMoreTokens()) {
                String flag = flagtokenizer.nextToken();
                if ("\\Seen".equalsIgnoreCase(flag)) {
                    if (message.read) continue;
                    properties.put("read", "1");
                    message.read = true;
                    continue;
                }
                if ("\\Deleted".equalsIgnoreCase(flag)) {
                    if (message.deleted) continue;
                    message.deleted = true;
                    properties.put("deleted", "1");
                    continue;
                }
                if ("\\Flagged".equalsIgnoreCase(flag)) {
                    if (message.flagged) continue;
                    properties.put("flagged", "2");
                    message.flagged = true;
                    continue;
                }
                if ("\\Answered".equalsIgnoreCase(flag)) {
                    if (message.answered) continue;
                    properties.put("answered", "102");
                    message.answered = true;
                    continue;
                }
                if ("$Forwarded".equalsIgnoreCase(flag)) {
                    if (message.forwarded) continue;
                    properties.put("forwarded", "104");
                    message.forwarded = true;
                    continue;
                }
                if ("Junk".equalsIgnoreCase(flag)) {
                    if (message.junk) continue;
                    properties.put("junk", "1");
                    message.junk = true;
                    continue;
                }
                if ("\\Draft".equalsIgnoreCase(flag)) continue;
                properties.put("keywords", message.addFlag(flag));
            }
        } else if ("FLAGS".equalsIgnoreCase(action) || "FLAGS.SILENT".equalsIgnoreCase(action)) {
            boolean read = false;
            boolean deleted = false;
            boolean junk = false;
            boolean flagged = false;
            boolean answered = false;
            boolean forwarded = false;
            HashSet<String> keywords = null;
            ImapTokenizer flagtokenizer = new ImapTokenizer(flags);
            while (flagtokenizer.hasMoreTokens()) {
                String flag = flagtokenizer.nextToken();
                if ("\\Seen".equalsIgnoreCase(flag)) {
                    read = true;
                    continue;
                }
                if ("\\Deleted".equalsIgnoreCase(flag)) {
                    deleted = true;
                    continue;
                }
                if ("\\Flagged".equalsIgnoreCase(flag)) {
                    flagged = true;
                    continue;
                }
                if ("\\Answered".equalsIgnoreCase(flag)) {
                    answered = true;
                    continue;
                }
                if ("$Forwarded".equalsIgnoreCase(flag)) {
                    forwarded = true;
                    continue;
                }
                if ("Junk".equalsIgnoreCase(flag)) {
                    junk = true;
                    continue;
                }
                if ("\\Draft".equalsIgnoreCase(flag)) continue;
                if (keywords == null) {
                    keywords = new HashSet<String>();
                }
                keywords.add(flag);
            }
            if (keywords != null) {
                properties.put("keywords", message.setFlags(keywords));
            }
            if (read != message.read) {
                message.read = read;
                if (message.read) {
                    properties.put("read", "1");
                } else {
                    properties.put("read", "0");
                }
            }
            if (deleted != message.deleted) {
                message.deleted = deleted;
                if (message.deleted) {
                    properties.put("deleted", "1");
                } else {
                    properties.put("deleted", null);
                }
            }
            if (flagged != message.flagged) {
                message.flagged = flagged;
                if (message.flagged) {
                    properties.put("flagged", "2");
                } else {
                    properties.put("flagged", "0");
                }
            }
            if (answered != message.answered) {
                message.answered = answered;
                if (message.answered) {
                    properties.put("answered", "102");
                } else if (!forwarded) {
                    properties.put("answered", null);
                }
            }
            if (forwarded != message.forwarded) {
                message.forwarded = forwarded;
                if (message.forwarded) {
                    properties.put("forwarded", "104");
                } else if (!answered) {
                    properties.put("forwarded", null);
                }
            }
            if (junk != message.junk) {
                message.junk = junk;
                if (message.junk) {
                    properties.put("junk", "1");
                } else {
                    properties.put("junk", "0");
                }
            }
        }
        if (!properties.isEmpty()) {
            this.session.updateMessage(message, properties);
            message.recent = false;
        }
    }

    protected void parseCredentials(ImapTokenizer tokens) throws IOException {
        if (!tokens.hasMoreTokens()) {
            throw new DavMailException("EXCEPTION_INVALID_CREDENTIALS", new Object[0]);
        }
        this.userName = tokens.nextToken();
        if (!tokens.hasMoreTokens()) {
            throw new DavMailException("EXCEPTION_INVALID_CREDENTIALS", new Object[0]);
        }
        this.password = tokens.nextToken();
    }

    protected static class ImapTokenizer {
        char[] value;
        int startIndex;
        Stack<Character> quotes = new Stack();

        ImapTokenizer(String value) {
            this.value = value.toCharArray();
        }

        public String nextToken() {
            String token = this.nextQuotedToken();
            if (!token.isEmpty() && '\"' == token.charAt(0)) {
                try {
                    token = StringUtil.parseQuotedImapString(token);
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Invalid quoted token: " + token));
                    token = StringUtil.removeQuotes(token);
                }
            } else {
                token = StringUtil.removeQuotes(token);
            }
            return token;
        }

        protected boolean isQuote(char character) {
            return character == '\"' || character == '(' || character == ')' || character == '[' || character == ']' || character == '\\';
        }

        public boolean hasMoreTokens() {
            return this.startIndex < this.value.length;
        }

        public String nextQuotedToken() {
            char currentChar;
            int currentIndex;
            for (currentIndex = this.startIndex; !(currentIndex >= this.value.length || (currentChar = this.value[currentIndex]) == ' ' && this.quotes.isEmpty()); ++currentIndex) {
                if (!this.quotes.isEmpty() && this.quotes.peek().charValue() == '\\') {
                    this.quotes.pop();
                    continue;
                }
                if (!this.isQuote(currentChar)) continue;
                if (this.quotes.isEmpty()) {
                    this.quotes.push(Character.valueOf(currentChar));
                    continue;
                }
                char currentQuote = this.quotes.peek().charValue();
                if (currentChar == '\\') {
                    this.quotes.push(Character.valueOf(currentChar));
                    continue;
                }
                if (currentQuote == '\"' && currentChar == '\"' || currentQuote == '(' && currentChar == ')' || currentQuote == '[' && currentChar == ']') {
                    this.quotes.pop();
                    continue;
                }
                this.quotes.push(Character.valueOf(currentChar));
            }
            String result = new String(this.value, this.startIndex, currentIndex - this.startIndex);
            this.startIndex = currentIndex + 1;
            return result;
        }
    }

    protected static class RangeIterator
    extends AbstractRangeIterator {
        final String[] ranges;
        int currentRangeIndex;
        long startUid;
        long endUid;

        protected RangeIterator(ExchangeSession.MessageList messages, String value) {
            this.messages = messages;
            this.ranges = value.split(",");
        }

        protected long convertToLong(String value) {
            if ("*".equals(value)) {
                return Long.MAX_VALUE;
            }
            return Long.parseLong(value);
        }

        protected void skipToNextRangeStart() {
            if (this.currentRangeIndex < this.ranges.length) {
                String currentRange;
                int colonIndex;
                if ((colonIndex = (currentRange = this.ranges[this.currentRangeIndex++]).indexOf(58)) > 0) {
                    this.startUid = this.convertToLong(currentRange.substring(0, colonIndex));
                    this.endUid = this.convertToLong(currentRange.substring(colonIndex + 1));
                    if (this.endUid < this.startUid) {
                        long swap = this.endUid;
                        this.endUid = this.startUid;
                        this.startUid = swap;
                    }
                } else {
                    this.startUid = "*".equals(currentRange) ? (this.endUid = (long)this.messages.size()) : (this.endUid = this.convertToLong(currentRange));
                }
                while (this.currentIndex < this.messages.size() && (long)(this.currentIndex + 1) < this.startUid) {
                    ++this.currentIndex;
                }
            } else {
                this.currentIndex = this.messages.size();
            }
        }

        protected boolean hasNextInRange() {
            return this.hasNextIndex() && (long)this.currentIndex < this.endUid;
        }

        protected boolean hasNextIndex() {
            return this.currentIndex < this.messages.size();
        }

        protected boolean hasNextRange() {
            return this.currentRangeIndex < this.ranges.length;
        }

        @Override
        public boolean hasNext() {
            boolean hasNextInRange = this.hasNextInRange();
            if (this.hasNextRange() && !hasNextInRange) {
                this.currentIndex = 0;
            }
            while (this.hasNextIndex() && !hasNextInRange) {
                this.skipToNextRangeStart();
                hasNextInRange = this.hasNextInRange();
            }
            return this.hasNextIndex();
        }

        @Override
        public ExchangeSession.Message next() {
            if (this.currentIndex >= this.messages.size()) {
                throw new NoSuchElementException();
            }
            return (ExchangeSession.Message)this.messages.get(this.currentIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class UIDRangeIterator
    extends AbstractRangeIterator {
        final String[] ranges;
        int currentRangeIndex;
        long startUid;
        long endUid;

        protected UIDRangeIterator(ExchangeSession.MessageList messages, String value) {
            this.messages = messages;
            this.ranges = value.split(",");
        }

        protected long convertToLong(String value) {
            if ("*".equals(value)) {
                return Long.MAX_VALUE;
            }
            return Long.parseLong(value);
        }

        protected void skipToNextRangeStartUid() {
            if (this.currentRangeIndex < this.ranges.length) {
                String currentRange;
                int colonIndex;
                if ((colonIndex = (currentRange = this.ranges[this.currentRangeIndex++]).indexOf(58)) > 0) {
                    this.startUid = this.convertToLong(currentRange.substring(0, colonIndex));
                    this.endUid = this.convertToLong(currentRange.substring(colonIndex + 1));
                    if (this.endUid < this.startUid) {
                        long swap = this.endUid;
                        this.endUid = this.startUid;
                        this.startUid = swap;
                    }
                } else {
                    this.startUid = "*".equals(currentRange) ? (this.endUid = ((ExchangeSession.Message)this.messages.get(this.messages.size() - 1)).getImapUid()) : (this.endUid = this.convertToLong(currentRange));
                }
                while (this.currentIndex < this.messages.size() && ((ExchangeSession.Message)this.messages.get(this.currentIndex)).getImapUid() < this.startUid) {
                    ++this.currentIndex;
                }
            } else {
                this.currentIndex = this.messages.size();
            }
        }

        protected boolean hasNextInRange() {
            return this.hasNextIndex() && ((ExchangeSession.Message)this.messages.get(this.currentIndex)).getImapUid() <= this.endUid;
        }

        protected boolean hasNextIndex() {
            return this.currentIndex < this.messages.size();
        }

        protected boolean hasNextRange() {
            return this.currentRangeIndex < this.ranges.length;
        }

        @Override
        public boolean hasNext() {
            boolean hasNextInRange = this.hasNextInRange();
            if (this.hasNextRange() && !hasNextInRange) {
                this.currentIndex = 0;
            }
            while (this.hasNextIndex() && !hasNextInRange) {
                this.skipToNextRangeStartUid();
                hasNextInRange = this.hasNextInRange();
            }
            return this.hasNextIndex();
        }

        @Override
        public ExchangeSession.Message next() {
            ExchangeSession.Message message;
            long uid;
            if ((uid = (message = (ExchangeSession.Message)this.messages.get(this.currentIndex++)).getImapUid()) < this.startUid || uid > this.endUid) {
                throw new NoSuchElementException("Message uid " + uid + " not in range " + this.startUid + ':' + this.endUid);
            }
            return message;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static abstract class AbstractRangeIterator
    implements Iterator<ExchangeSession.Message> {
        ExchangeSession.MessageList messages;
        int currentIndex;

        protected AbstractRangeIterator() {
        }

        protected int getCurrentIndex() {
            return this.currentIndex;
        }
    }

    private static final class PartialOutputStream
    extends FilterOutputStream {
        private int size;
        private int bufferSize;
        private final int startIndex;
        private final int maxSize;

        private PartialOutputStream(OutputStream os, int startIndex, int maxSize) {
            super(os);
            this.startIndex = startIndex;
            this.maxSize = maxSize;
        }

        @Override
        public void write(int b) throws IOException {
            ++this.size;
            if (this.size > this.startIndex && this.bufferSize < this.maxSize) {
                super.write(b);
                ++this.bufferSize;
            }
        }
    }

    private static final class PartOutputStream
    extends FilterOutputStream {
        private State state = State.START;
        private int size;
        private int bufferSize;
        private final boolean writeHeaders;
        private final boolean writeBody;
        private final int startIndex;
        private final int maxSize;

        private PartOutputStream(OutputStream os, boolean writeHeaders, boolean writeBody, int startIndex, int maxSize) {
            super(os);
            this.writeHeaders = writeHeaders;
            this.writeBody = writeBody;
            this.startIndex = startIndex;
            this.maxSize = maxSize;
        }

        @Override
        public void write(int b) throws IOException {
            ++this.size;
            if ((this.state != State.BODY && this.writeHeaders || this.state == State.BODY && this.writeBody) && this.size > this.startIndex && this.bufferSize < this.maxSize) {
                super.write(b);
                ++this.bufferSize;
            }
            if (this.state == State.START) {
                if (b == 13) {
                    this.state = State.CR;
                }
            } else if (this.state == State.CR) {
                this.state = b == 10 ? State.CRLF : State.START;
            } else if (this.state == State.CRLF) {
                this.state = b == 13 ? State.CRLFCR : State.START;
            } else if (this.state == State.CRLFCR) {
                this.state = b == 10 ? State.BODY : State.START;
            }
        }

        protected static enum State {
            START,
            CR,
            CRLF,
            CRLFCR,
            BODY;

        }
    }

    protected static final class SearchConditions {
        Boolean flagged;
        Boolean answered;
        Boolean draft;
        String indexRange;
        String uidRange;
        String notUidRange;

        protected SearchConditions() {
        }
    }

    protected static class MessageWrapper {
        protected OutputStream os;
        protected StringBuilder buffer;
        protected ExchangeSession.Message message;

        protected MessageWrapper(OutputStream os, StringBuilder buffer, ExchangeSession.Message message) {
            this.os = os;
            this.buffer = buffer;
            this.message = message;
        }

        public int getMimeMessageSize() throws IOException, MessagingException {
            this.loadMessage();
            return this.message.getMimeMessageSize();
        }

        protected void loadMessage() throws IOException, MessagingException {
            if (!this.message.isLoaded()) {
                String flushString = this.buffer.toString();
                LOGGER.debug((Object)flushString);
                this.os.write(flushString.getBytes(StandardCharsets.UTF_8));
                this.buffer.setLength(0);
                MessageLoadThread.loadMimeMessage(this.message, this.os);
            }
        }

        public MimeMessage getMimeMessage() throws IOException, MessagingException {
            this.loadMessage();
            return this.message.getMimeMessage();
        }

        public InputStream getRawInputStream() throws IOException, MessagingException {
            this.loadMessage();
            return this.message.getRawInputStream();
        }

        public Enumeration getMatchingHeaderLines(String[] requestedHeaders) throws IOException, MessagingException {
            Enumeration<?> result = this.message.getMatchingHeaderLinesFromHeaders(requestedHeaders);
            if (result == null) {
                this.loadMessage();
                result = this.message.getMatchingHeaderLines(requestedHeaders);
            }
            return result;
        }
    }

    private static class KeepAlive {
        private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, r -> new Thread(r, Thread.currentThread().getName() + "-KeepAlive"));
        private ScheduledFuture<?> task;

        public KeepAlive(Runnable cb) {
            this.task = this.scheduler.scheduleAtFixedRate(cb, 20L, 20L, TimeUnit.SECONDS);
        }

        public void cancel() {
            this.task.cancel(true);
            this.scheduler.shutdown();
        }
    }
}

