/*
 * Decompiled with CFR 0.152.
 */
package davmail.http.request;

import davmail.http.HttpClientAdapter;
import davmail.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class RestRequest
extends HttpPost
implements ResponseHandler<JSONObject> {
    private static final String JSON_CONTENT_TYPE = "application/json; charset=utf-8";
    private static final Logger LOGGER = Logger.getLogger(RestRequest.class);
    private HttpResponse response;
    private JSONObject jsonBody;

    public RestRequest(String uri) {
        super(uri);
        AbstractHttpEntity httpEntity = new AbstractHttpEntity(){
            byte[] content;

            public boolean isRepeatable() {
                return true;
            }

            public long getContentLength() {
                if (this.content == null) {
                    this.content = RestRequest.this.getJsonContent();
                }
                return this.content.length;
            }

            public InputStream getContent() throws UnsupportedOperationException {
                if (this.content == null) {
                    this.content = RestRequest.this.getJsonContent();
                }
                return new ByteArrayInputStream(this.content);
            }

            public void writeTo(OutputStream outputStream) throws IOException {
                if (this.content == null) {
                    this.content = RestRequest.this.getJsonContent();
                }
                outputStream.write(this.content);
            }

            public boolean isStreaming() {
                return false;
            }
        };
        httpEntity.setContentType(JSON_CONTENT_TYPE);
        this.setEntity((HttpEntity)httpEntity);
    }

    public RestRequest(String uri, HttpEntity entity) {
        super(uri);
        this.setEntity(entity);
    }

    protected byte[] getJsonContent() {
        return this.jsonBody.toString().getBytes(Consts.UTF_8);
    }

    public void setJsonBody(JSONObject jsonBody) {
        this.jsonBody = jsonBody;
    }

    public void setRequestHeader(String name, String value) {
        this.setHeader(name, value);
    }

    public JSONObject handleResponse(HttpResponse response) throws IOException {
        JSONObject jsonResponse;
        this.response = response;
        Header contentTypeHeader = response.getFirstHeader("Content-Type");
        if (contentTypeHeader != null && (JSON_CONTENT_TYPE.equals(contentTypeHeader.getValue()) || "application/json".equals(contentTypeHeader.getValue()))) {
            try (InputStream inputStream = response.getEntity().getContent();){
                if (HttpClientAdapter.isGzipEncoded(response)) {
                    jsonResponse = this.processResponseStream(new GZIPInputStream(inputStream));
                }
                jsonResponse = this.processResponseStream(inputStream);
            }
            catch (JSONException e) {
                LOGGER.error((Object)("Error while parsing json response: " + (Object)((Object)e)), (Throwable)e);
                throw new IOException(e.getMessage(), e);
            }
        } else {
            throw new IOException("Invalid response content");
        }
        return jsonResponse;
    }

    private JSONObject processResponseStream(InputStream responseBodyAsStream) throws IOException, JSONException {
        return new JSONObject(new String(IOUtil.readFully(responseBodyAsStream), StandardCharsets.UTF_8));
    }
}

