/*
 * Decompiled with CFR 0.152.
 */
package davmail.http.request;

import davmail.exchange.XMLStreamUtil;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.log4j.Logger;

public abstract class ExchangeDavRequest
extends HttpPost
implements ResponseHandler<List<MultiStatusResponse>> {
    protected static final Logger LOGGER = Logger.getLogger(ExchangeDavRequest.class);
    private static final String XML_CONTENT_TYPE = "text/xml; charset=UTF-8";
    private HttpResponse response;
    private List<MultiStatusResponse> responses;

    public ExchangeDavRequest(String path) {
        super(path);
        AbstractHttpEntity httpEntity = new AbstractHttpEntity(){
            byte[] content;

            public boolean isRepeatable() {
                return true;
            }

            public long getContentLength() {
                if (this.content == null) {
                    this.content = ExchangeDavRequest.this.generateRequestContent();
                }
                return this.content.length;
            }

            public InputStream getContent() throws UnsupportedOperationException {
                if (this.content == null) {
                    this.content = ExchangeDavRequest.this.generateRequestContent();
                }
                return new ByteArrayInputStream(this.content);
            }

            public void writeTo(OutputStream outputStream) throws IOException {
                if (this.content == null) {
                    this.content = ExchangeDavRequest.this.generateRequestContent();
                }
                outputStream.write(this.content);
            }

            public boolean isStreaming() {
                return false;
            }
        };
        httpEntity.setContentType(XML_CONTENT_TYPE);
        this.setEntity((HttpEntity)httpEntity);
    }

    protected abstract byte[] generateRequestContent();

    public List<MultiStatusResponse> handleResponse(HttpResponse response) {
        this.response = response;
        Header contentTypeHeader = response.getFirstHeader("Content-Type");
        if (contentTypeHeader != null && "text/xml".equals(contentTypeHeader.getValue())) {
            this.responses = new ArrayList<MultiStatusResponse>();
            try {
                XMLStreamReader reader = XMLStreamUtil.createXMLStreamReader(new FilterInputStream(response.getEntity().getContent()){
                    final byte[] lastbytes;
                    {
                        this.lastbytes = new byte[3];
                    }

                    @Override
                    public int read(byte[] bytes, int off, int len) throws IOException {
                        int count = this.in.read(bytes, off, len);
                        for (int i = 0; i < count; ++i) {
                            byte currentByte = bytes[off + i];
                            if (this.lastbytes[0] == 60 && currentByte >= 48 && currentByte <= 57) {
                                bytes[off + i] = (byte)(currentByte + 49);
                            }
                            this.lastbytes[0] = this.lastbytes[1];
                            this.lastbytes[1] = this.lastbytes[2];
                            this.lastbytes[2] = currentByte;
                        }
                        return count;
                    }
                });
                while (reader.hasNext()) {
                    reader.next();
                    if (!XMLStreamUtil.isStartTag(reader, "response")) continue;
                    this.handleResponse(reader);
                }
            }
            catch (IOException | XMLStreamException e) {
                LOGGER.error((Object)("Error while parsing soap response: " + e), (Throwable)e);
            }
        }
        return this.responses;
    }

    protected void handleResponse(XMLStreamReader reader) throws XMLStreamException {
        MultiStatusResponse multiStatusResponse = null;
        String href = null;
        String responseStatus = "";
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "response")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            if ("href".equals(tagLocalName)) {
                href = reader.getElementText();
                continue;
            }
            if ("status".equals(tagLocalName)) {
                responseStatus = reader.getElementText();
                continue;
            }
            if (!"propstat".equals(tagLocalName)) continue;
            if (multiStatusResponse == null) {
                multiStatusResponse = new MultiStatusResponse(href, responseStatus);
            }
            this.handlePropstat(reader, multiStatusResponse);
        }
        if (multiStatusResponse != null) {
            this.responses.add(multiStatusResponse);
        }
    }

    protected void handlePropstat(XMLStreamReader reader, MultiStatusResponse multiStatusResponse) throws XMLStreamException {
        int propstatStatus = 0;
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "propstat")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            if ("status".equals(tagLocalName)) {
                if ("HTTP/1.1 200 OK".equals(reader.getElementText())) {
                    propstatStatus = 200;
                    continue;
                }
                propstatStatus = 0;
                continue;
            }
            if (!"prop".equals(tagLocalName) || propstatStatus != 200) continue;
            this.handleProperty(reader, multiStatusResponse);
        }
    }

    protected void handleProperty(XMLStreamReader reader, MultiStatusResponse multiStatusResponse) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "prop")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            Namespace namespace = Namespace.getNamespace((String)reader.getNamespaceURI());
            String tagLocalName = reader.getLocalName();
            if (reader.getAttributeCount() > 0 && "mv.string".equals(reader.getAttributeValue(0))) {
                this.handleMultiValuedProperty(reader, multiStatusResponse);
                continue;
            }
            String tagContent = this.getTagContent(reader);
            if (tagContent == null) continue;
            multiStatusResponse.add((DavProperty)new DefaultDavProperty(tagLocalName, (Object)tagContent, namespace));
        }
    }

    protected void handleMultiValuedProperty(XMLStreamReader reader, MultiStatusResponse multiStatusResponse) throws XMLStreamException {
        String tagLocalName = reader.getLocalName();
        Namespace namespace = Namespace.getNamespace((String)reader.getNamespaceURI());
        ArrayList<String> values = new ArrayList<String>();
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, tagLocalName)) {
            String tagContent;
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader) || (tagContent = this.getTagContent(reader)) == null) continue;
            values.add(tagContent);
        }
        multiStatusResponse.add((DavProperty)new DefaultDavProperty(tagLocalName, values, namespace));
    }

    protected String getTagContent(XMLStreamReader reader) throws XMLStreamException {
        String value = null;
        String tagLocalName = reader.getLocalName();
        while (reader.hasNext() && (reader.getEventType() != 2 || !tagLocalName.equals(reader.getLocalName()))) {
            reader.next();
            if (reader.getEventType() != 4) continue;
            value = reader.getText();
        }
        if (!reader.hasNext()) {
            throw new XMLStreamException("End element for " + tagLocalName + " not found");
        }
        return value;
    }

    public MultiStatusResponse[] getResponses() throws HttpResponseException {
        if (this.responses == null) {
            throw new HttpResponseException(this.response.getStatusLine().getStatusCode(), this.response.getStatusLine().getReasonPhrase());
        }
        return this.responses.toArray(new MultiStatusResponse[0]);
    }

    public MultiStatusResponse getResponse() throws HttpResponseException {
        if (this.responses == null || this.responses.size() != 1) {
            throw new HttpResponseException(this.response.getStatusLine().getStatusCode(), this.response.getStatusLine().getReasonPhrase());
        }
        return this.responses.get(0);
    }

    public int getResponseStatusCode() throws HttpResponseException {
        String responseDescription = this.getResponse().getResponseDescription();
        if ("HTTP/1.1 201 Created".equals(responseDescription)) {
            return 201;
        }
        return 200;
    }
}

