/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;

public final class SunPKCS11ProviderHandler {
    private SunPKCS11ProviderHandler() {
    }

    public static void registerProvider(String pkcs11Config) {
        Provider p;
        try {
            Class<?> sunPkcs11Class = Class.forName("sun.security.pkcs11.SunPKCS11");
            Constructor<?> sunPkcs11Constructor = sunPkcs11Class.getDeclaredConstructor(InputStream.class);
            p = (Provider)sunPkcs11Constructor.newInstance(new ByteArrayInputStream(pkcs11Config.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchMethodException e) {
            p = SunPKCS11ProviderHandler.configurePkcs11Provider(pkcs11Config);
        }
        catch (Exception e) {
            throw new PKCS11ProviderException(SunPKCS11ProviderHandler.buildErrorMessage(e));
        }
        Security.addProvider(p);
    }

    private static Provider configurePkcs11Provider(String pkcs11Config) {
        Provider p;
        try {
            p = Security.getProvider("SunPKCS11");
            Method configureMethod = Provider.class.getDeclaredMethod("configure", String.class);
            configureMethod.invoke((Object)p, "--" + pkcs11Config);
        }
        catch (Exception e) {
            throw new PKCS11ProviderException(SunPKCS11ProviderHandler.buildErrorMessage(e));
        }
        return p;
    }

    private static String buildErrorMessage(Exception e) {
        StringBuilder errorMessage = new StringBuilder("Unable to configure SunPKCS11 provider");
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            errorMessage.append(" ").append(cause.getMessage());
        }
        return errorMessage.toString();
    }

    static final class PKCS11ProviderException
    extends RuntimeException {
        public PKCS11ProviderException(String message) {
            super(message);
        }
    }
}

