/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

public class NTLMMessageDecoder {
    static final int NTLMSSP_KEY_56 = Integer.MIN_VALUE;
    static final int NTLMSSP_KEY_EXCHANGE = 0x40000000;
    static final int NTLMSSP_KEY_128 = 0x20000000;
    static final int NTLMSSP_TARGET_INFO = 0x800000;
    static final int NTLMSSP_NTLM2_KEY = 524288;
    static final int NTLMSSP_CHALL_NOT_NT = 262144;
    static final int NTLMSSP_CHALL_ACCEPT = 131072;
    static final int NTLMSSP_CHALL_INIT = 65536;
    static final int NTLMSSP_ALWAYS_SIGN = 32768;
    static final long NTLMSSP_NEGOTIATE_UNICODE = 1L;
    static final long NTLMSSP_REQUEST_TARGET = 4L;
    static final long NTLMSSP_NEGOTIATE_OEM_DOMAIN_SUPPLIED = 4096L;
    static final long NTLMSSP_NEGOTIATE_OEM_WORKSTATION_SUPPLIED = 8192L;
    static final long NTLMSSP_NEGOTIATE_TARGET_INFO = 0x800000L;
    static final long NTLMSSP_NEGOTIATE_ALWAYS_SIGN = 32768L;
    static final long NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY = 524288L;
    static final int NTLMSSP_LOCAL_CALL = 16384;
    static final int NTLMSSP_WORKSTATION = 8192;
    static final int NTLMSSP_DOMAIN = 4096;
    static final int NTLMSSP_NTLM_KEY = 512;
    static final int NTLMSSP_NETWARE = 256;
    static final int NTLMSSP_LM_KEY = 128;
    static final int NTLMSSP_DATAGRAM = 64;
    static final int NTLMSSP_SEAL = 32;
    static final int NTLMSSP_SIGN = 16;
    static final int NTLMSSP_TARGET = 4;
    static final int NTLMSSP_OEM = 2;
    static final int NTLMSSP_UNICODE = 1;
    private final String base64Message;

    public static String decode(String message) {
        return new NTLMMessageDecoder(message).decodeMessage();
    }

    NTLMMessageDecoder(String base64Message) {
        this.base64Message = base64Message;
    }

    public String decodeMessage() {
        StringBuilder buffer = new StringBuilder();
        byte[] message = Base64.decodeBase64(this.base64Message.getBytes());
        String prefix = new String(message, 0, 7);
        if (!"NTLMSSP".equals(prefix) || message[7] != 0) {
            buffer.append("Invalid Prefix: ");
        } else {
            int messageType = this.getInt(message, 8);
            buffer.append("NTLM type: ").append(messageType);
            if (messageType == 1) {
                buffer.append(this.getFlags(message, 12));
                buffer.append(" domain: ").append(this.getStringValue(message, 16, "ASCII"));
                buffer.append(" host: ").append(this.getStringValue(message, 24, "ASCII"));
            } else if (messageType == 2) {
                buffer.append(" target: ").append(this.getStringValue(message, 12, "UnicodeLittleUnmarked"));
                buffer.append(this.getFlags(message, 20));
                byte[] challenge = this.getBytes(message, 24, 8);
                buffer.append(" challenge: ").append(this.toHexString(challenge));
                if (message.length > 32) {
                    buffer.append(" context: 0x").append(Integer.toHexString(this.getInt(message, 32))).append(" 0x").append(Integer.toHexString(this.getInt(message, 36)));
                }
                if (message.length > 40) {
                    buffer.append(" target info: ").append(this.getValues(message, 40, "UnicodeLittleUnmarked"));
                }
                if (message.length > 48) {
                    buffer.append(this.getOSVersion(message, 48));
                }
            } else if (messageType == 3) {
                buffer.append(" lm response: ").append(this.getByteValue(message, 12));
                buffer.append(" ntlm response: ").append(this.getByteValue(message, 20));
                buffer.append(" target name: ").append(this.getStringValue(message, 28, "UnicodeLittleUnmarked"));
                buffer.append(" user name: ").append(this.getStringValue(message, 36, "UnicodeLittleUnmarked"));
                buffer.append(" workstation name: ").append(this.getStringValue(message, 44, "UnicodeLittleUnmarked"));
                if (this.getShort(message, 32) > 52) {
                    buffer.append(" session key: ").append(this.getByteValue(message, 52));
                }
                if (this.getShort(message, 32) > 60) {
                    buffer.append(this.getFlags(message, 60));
                }
                if (this.getShort(message, 32) > 64) {
                    buffer.append(this.getOSVersion(message, 64));
                }
            }
        }
        return buffer.toString();
    }

    public int getShort(byte[] data, int offset) {
        return (data[offset] & 0xFF) + ((data[offset + 1] & 0xFF) << 8);
    }

    public int getInt(byte[] data, int offset) {
        return (data[offset] & 0xFF) + ((data[offset + 1] & 0xFF) << 8) + ((data[offset + 2] & 0xFF) << 16) + ((data[offset + 3] & 0xFF) << 24);
    }

    public String getStringValue(byte[] data, int offset, String encoding) {
        int length = this.getShort(data, offset);
        int maxLength = this.getShort(data, offset + 2);
        int valueOffset = this.getInt(data, offset + 4);
        String value = "";
        if (valueOffset + length <= data.length) {
            try {
                value = new String(data, valueOffset, length, encoding);
            }
            catch (UnsupportedEncodingException e) {
                value = "[Invalid encoding " + encoding + "]";
            }
        }
        return "(length: " + length + " maxLength: " + maxLength + " offset: " + valueOffset + " value:" + value + ")";
    }

    public String getValueType(int valueType) {
        if (valueType == 0) {
            return "EOL";
        }
        if (valueType == 1) {
            return "NBCOMPUTERNAME";
        }
        if (valueType == 2) {
            return "NBDOMAINNAME";
        }
        if (valueType == 3) {
            return "DNSCOMPUTERNAME";
        }
        if (valueType == 4) {
            return "DNSDOMAINNAME";
        }
        if (valueType == 5) {
            return "DNSTREENAME";
        }
        if (valueType == 6) {
            return "FLAGS";
        }
        if (valueType == 7) {
            return "TIMESTAMP";
        }
        if (valueType == 8) {
            return "SINGLEHOST";
        }
        if (valueType == 9) {
            return "TARGETNAME";
        }
        if (valueType == 10) {
            return "CHANNELBINDING";
        }
        return String.valueOf(valueType);
    }

    public String getValues(byte[] data, int offset, String encoding) {
        StringBuilder buffer = new StringBuilder();
        int length = this.getShort(data, offset);
        int maxLength = this.getShort(data, offset + 2);
        int valueOffset = this.getInt(data, offset + 4);
        int valueType = this.getShort(data, valueOffset);
        int valueLength = this.getShort(data, valueOffset + 2);
        while (valueLength > 0) {
            String value;
            if (valueType == 7) {
                long timestamp = ByteBuffer.wrap(data, valueOffset + 4, valueLength).order(ByteOrder.LITTLE_ENDIAN).getLong();
                value = timestamp + " " + new Date((timestamp - 116444736000000000L) / 10000L);
            } else {
                try {
                    value = new String(data, valueOffset + 4, valueLength, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    value = "[Invalid encoding " + encoding + "]";
                }
            }
            buffer.append("(").append(this.getValueType(valueType)).append(": ").append(value).append(")");
            valueType = this.getShort(data, valueOffset += valueLength + 4);
            valueLength = this.getShort(data, valueOffset + 2);
        }
        return buffer.toString();
    }

    public String getByteValue(byte[] data, int offset) {
        int length = this.getShort(data, offset);
        int maxLength = this.getShort(data, offset + 2);
        int valueOffset = this.getInt(data, offset + 4);
        byte[] value = this.getBytes(data, valueOffset, length);
        return "(length: " + length + " maxLength: " + maxLength + " offset: " + valueOffset + " value:" + this.toHexString(value) + ")";
    }

    public byte[] getBytes(byte[] data, int offset, int length) {
        byte[] value = null;
        if (offset + length <= data.length) {
            value = new byte[length];
            System.arraycopy(data, offset, value, 0, length);
        }
        return value;
    }

    public String getFlags(byte[] data, int offset) {
        StringBuilder buffer = new StringBuilder();
        int flags = this.getInt(data, offset);
        buffer.append(" flags: 0x").append(Integer.toHexString(flags));
        if ((flags & Integer.MIN_VALUE) != 0) {
            buffer.append(" NTLMSSP_KEY_56");
        }
        if ((flags & 0x40000000) != 0) {
            buffer.append(" NTLMSSP_KEY_EXCHANGE");
        }
        if ((flags & 0x20000000) != 0) {
            buffer.append(" NTLMSSP_KEY_128");
        }
        if ((flags & 0x800000) != 0) {
            buffer.append(" NTLMSSP_TARGET_INFO");
        }
        if ((flags & 0x80000) != 0) {
            buffer.append(" NTLMSSP_NTLM2_KEY");
        }
        if ((flags & 0x40000) != 0) {
            buffer.append(" NTLMSSP_CHALL_NOT_NT");
        }
        if ((flags & 0x20000) != 0) {
            buffer.append(" NTLMSSP_CHALL_ACCEPT");
        }
        if ((flags & 0x10000) != 0) {
            buffer.append(" NTLMSSP_CHALL_INIT");
        }
        if ((flags & 0x8000) != 0) {
            buffer.append(" NTLMSSP_ALWAYS_SIGN");
        }
        if ((flags & 0x4000) != 0) {
            buffer.append(" NTLMSSP_LOCAL_CALL");
        }
        if ((flags & 0x2000) != 0) {
            buffer.append(" NTLMSSP_WORKSTATION");
        }
        if ((flags & 0x1000) != 0) {
            buffer.append(" NTLMSSP_DOMAIN");
        }
        if ((flags & 0x200) != 0) {
            buffer.append(" NTLMSSP_NTLM_KEY");
        }
        if ((flags & 0x100) != 0) {
            buffer.append(" NTLMSSP_NETWARE");
        }
        if ((flags & 0x80) != 0) {
            buffer.append(" NTLMSSP_LM_KEY");
        }
        if ((flags & 0x40) != 0) {
            buffer.append(" NTLMSSP_DATAGRAM");
        }
        if ((flags & 0x20) != 0) {
            buffer.append(" NTLMSSP_SEAL");
        }
        if ((flags & 0x10) != 0) {
            buffer.append(" NTLMSSP_SIGN");
        }
        if ((flags & 4) != 0) {
            buffer.append(" NTLMSSP_TARGET");
        }
        if ((flags & 2) != 0) {
            buffer.append(" NTLMSSP_OEM");
        }
        if ((flags & 1) != 0) {
            buffer.append(" NTLMSSP_UNICODE");
        }
        return buffer.toString();
    }

    public String getOSVersion(byte[] data, int offset) {
        return " os version: " + data[offset] + '.' + data[offset + 1] + ' ' + this.getShort(data, offset + 2);
    }

    public String toHexString(byte[] data) {
        StringBuilder buffer = new StringBuilder();
        for (byte b : data) {
            if ((b & 0xF0) == 0) {
                buffer.append('0');
            }
            buffer.append(Integer.toHexString(b & 0xFF));
        }
        return buffer.toString();
    }
}

