/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.log4j.Logger;

public class KerberosLoginConfiguration
extends Configuration {
    protected static final Logger LOGGER = Logger.getLogger(KerberosLoginConfiguration.class);
    protected static final AppConfigurationEntry[] CLIENT_LOGIN_MODULE;
    protected static final AppConfigurationEntry[] SERVER_LOGIN_MODULE;

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        if ("spnego-client".equals(name)) {
            return CLIENT_LOGIN_MODULE;
        }
        if ("spnego-server".equals(name)) {
            return SERVER_LOGIN_MODULE;
        }
        return null;
    }

    @Override
    public void refresh() {
    }

    static {
        HashMap<String, String> clientLoginModuleOptions = new HashMap<String, String>();
        if (LOGGER.isDebugEnabled()) {
            clientLoginModuleOptions.put("debug", "true");
        }
        clientLoginModuleOptions.put("useTicketCache", "true");
        clientLoginModuleOptions.put("renewTGT", "true");
        String krb5ccName = System.getenv().get("KRB5CCNAME");
        if (krb5ccName != null && !krb5ccName.isEmpty()) {
            clientLoginModuleOptions.put("ticketCache", krb5ccName);
        }
        CLIENT_LOGIN_MODULE = new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, clientLoginModuleOptions)};
        HashMap<String, String> serverLoginModuleOptions = new HashMap<String, String>();
        if (LOGGER.isDebugEnabled()) {
            serverLoginModuleOptions.put("debug", "true");
        }
        serverLoginModuleOptions.put("isInitiator", "false");
        serverLoginModuleOptions.put("useKeyTab", "false");
        serverLoginModuleOptions.put("storeKey", "true");
        SERVER_LOGIN_MODULE = new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, serverLoginModuleOptions)};
    }
}

