/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import davmail.http.KerberosHelper;
import java.security.Security;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.http.auth.Credentials;
import org.apache.http.impl.auth.SPNegoScheme;
import org.apache.log4j.Logger;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class DavMailSPNegoScheme
extends SPNegoScheme {
    protected static final Logger LOGGER = Logger.getLogger(DavMailSPNegoScheme.class);
    protected static final Object LOCK = new Object();
    protected static final KerberosHelper.KerberosCallbackHandler KERBEROS_CALLBACK_HANDLER;
    private static LoginContext clientLoginContext;

    public DavMailSPNegoScheme(boolean stripPort, boolean useCanonicalHostname) {
        super(stripPort, useCanonicalHostname);
    }

    public DavMailSPNegoScheme(boolean stripPort) {
        super(stripPort);
    }

    public DavMailSPNegoScheme() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] generateGSSToken(byte[] input, Oid oid, String authServer, Credentials credentials) throws GSSException {
        String protocol = "HTTP";
        LOGGER.debug((Object)("KerberosHelper.initSecurityContext " + protocol + '@' + authServer + ' ' + input.length + " bytes token"));
        Object object = LOCK;
        synchronized (object) {
            if (clientLoginContext != null) {
                for (KerberosTicket kerberosTicket : clientLoginContext.getSubject().getPrivateCredentials(KerberosTicket.class)) {
                    if (!kerberosTicket.getServer().getName().startsWith("krbtgt") || kerberosTicket.isCurrent()) continue;
                    LOGGER.debug((Object)"KerberosHelper.clientLogin cached TGT expired, try to relogin");
                    clientLoginContext = null;
                }
            }
            if (clientLoginContext == null) {
                try {
                    LoginContext localLoginContext = new LoginContext("spnego-client", KERBEROS_CALLBACK_HANDLER);
                    localLoginContext.login();
                    clientLoginContext = localLoginContext;
                }
                catch (LoginException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    throw new GSSException(11);
                }
            }
            for (KerberosTicket kerberosTicket : clientLoginContext.getSubject().getPrivateCredentials(KerberosTicket.class)) {
                LOGGER.debug((Object)("KerberosHelper.clientLogin ticket for " + kerberosTicket.getServer().getName() + " expires at " + kerberosTicket.getEndTime()));
                if (kerberosTicket.getEndTime().getTime() >= System.currentTimeMillis() + 10000L) continue;
                if (kerberosTicket.isRenewable()) {
                    try {
                        kerberosTicket.refresh();
                    }
                    catch (RefreshFailedException e) {
                        LOGGER.debug((Object)("KerberosHelper.clientLogin failed to renew ticket " + kerberosTicket));
                    }
                    continue;
                }
                LOGGER.debug((Object)"KerberosHelper.clientLogin ticket is not renewable");
            }
            Object result = this.internalGenerateGSSToken(input, oid, authServer, credentials);
            if (result instanceof GSSException) {
                LOGGER.info((Object)("KerberosHelper.initSecurityContext exception code " + ((GSSException)result).getMajor() + " minor code " + ((GSSException)result).getMinor() + " message " + ((Throwable)result).getMessage()));
                throw (GSSException)result;
            }
            LOGGER.debug((Object)("KerberosHelper.initSecurityContext return " + ((byte[])result).length + " bytes token"));
            return (byte[])result;
        }
    }

    protected Object internalGenerateGSSToken(byte[] input, Oid oid, String authServer, Credentials credentials) {
        return Subject.doAs(clientLoginContext.getSubject(), () -> {
            Object result;
            try {
                result = super.generateGSSToken(input, oid, authServer, credentials);
            }
            catch (GSSException e) {
                result = e;
            }
            return result;
        });
    }

    static {
        Security.setProperty("login.configuration.provider", "davmail.http.KerberosLoginConfiguration");
        KERBEROS_CALLBACK_HANDLER = new KerberosHelper.KerberosCallbackHandler();
    }
}

