/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.log4j.Logger;

public class DavMailIdleConnectionEvictor {
    static final Logger LOGGER = Logger.getLogger(DavMailIdleConnectionEvictor.class);
    private static final HashSet<HttpClientConnectionManager> connectionManagers = new HashSet();
    private static final long sleepTimeMs = 60000L;
    private static final long maxIdleTimeMs = 300000L;
    private static ScheduledExecutorService scheduler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initEvictorThread() {
        HashSet<HttpClientConnectionManager> hashSet = connectionManagers;
        synchronized (hashSet) {
            if (scheduler == null) {
                scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){
                    int count = 0;

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r, "PoolEvictor-" + this.count++);
                        thread.setDaemon(true);
                        thread.setUncaughtExceptionHandler((t, e) -> LOGGER.error((Object)e.getMessage(), e));
                        return thread;
                    }
                });
                scheduler.scheduleAtFixedRate(() -> {
                    HashSet<HttpClientConnectionManager> hashSet = connectionManagers;
                    synchronized (hashSet) {
                        for (HttpClientConnectionManager connectionManager : connectionManagers) {
                            connectionManager.closeExpiredConnections();
                            connectionManager.closeIdleConnections(300000L, TimeUnit.MILLISECONDS);
                        }
                    }
                }, 60000L, 60000L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() throws InterruptedException {
        HashSet<HttpClientConnectionManager> hashSet = connectionManagers;
        synchronized (hashSet) {
            scheduler.shutdown();
            if (!scheduler.awaitTermination(60000L, TimeUnit.MILLISECONDS)) {
                LOGGER.warn((Object)"Timed out waiting for tasks to complete");
            }
            scheduler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConnectionManager(HttpClientConnectionManager connectionManager) {
        HashSet<HttpClientConnectionManager> hashSet = connectionManagers;
        synchronized (hashSet) {
            DavMailIdleConnectionEvictor.initEvictorThread();
            connectionManagers.add(connectionManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConnectionManager(HttpClientConnectionManager connectionManager) {
        HashSet<HttpClientConnectionManager> hashSet = connectionManagers;
        synchronized (hashSet) {
            connectionManagers.remove(connectionManager);
        }
    }
}

