/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.ui.AcceptCertificateDialog;
import davmail.ui.tray.DavGatewayTray;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class DavGatewayX509TrustManager
implements X509TrustManager {
    private final X509TrustManager standardTrustManager;

    public DavGatewayX509TrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init((KeyStore)null);
        TrustManager[] trustManagers = factory.getTrustManagers();
        if (trustManagers.length == 0) {
            throw new NoSuchAlgorithmException("No trust manager found");
        }
        this.standardTrustManager = (X509TrustManager)trustManagers[0];
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        try {
            this.standardTrustManager.checkServerTrusted(x509Certificates, authType);
        }
        catch (CertificateException e) {
            if (x509Certificates != null && x509Certificates.length > 0) {
                this.userCheckServerTrusted(x509Certificates);
            }
            throw e;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(x509Certificates, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }

    protected void userCheckServerTrusted(X509Certificate[] x509Certificates) throws CertificateException {
        String acceptedCertificateHash = Settings.getProperty("davmail.server.certificate.hash");
        String certificateHash = DavGatewayX509TrustManager.getFormattedHash(x509Certificates[0]);
        if (acceptedCertificateHash != null && !acceptedCertificateHash.isEmpty() && acceptedCertificateHash.equalsIgnoreCase(certificateHash)) {
            DavGatewayTray.debug(new BundleMessage("LOG_FOUND_ACCEPTED_CERTIFICATE", acceptedCertificateHash));
        } else {
            boolean isCertificateTrusted = Settings.getBooleanProperty("davmail.server") || GraphicsEnvironment.isHeadless() ? this.isCertificateTrusted(x509Certificates[0]) : AcceptCertificateDialog.isCertificateTrusted(x509Certificates[0]);
            if (!isCertificateTrusted) {
                throw new CertificateException("User rejected certificate");
            }
            Settings.saveProperty("davmail.server.certificate.hash", certificateHash);
        }
    }

    protected boolean isCertificateTrusted(X509Certificate certificate) {
        BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in));
        String answer = null;
        String yes = BundleMessage.format("UI_ANSWER_YES", new Object[0]);
        String no = BundleMessage.format("UI_ANSWER_NO", new Object[0]);
        StringBuilder buffer = new StringBuilder();
        buffer.append(BundleMessage.format("UI_SERVER_CERTIFICATE", new Object[0])).append(":\n");
        buffer.append(BundleMessage.format("UI_ISSUED_TO", new Object[0])).append(": ").append(DavGatewayX509TrustManager.getRDN(certificate.getSubjectX500Principal())).append('\n');
        buffer.append(BundleMessage.format("UI_ISSUED_BY", new Object[0])).append(": ").append(DavGatewayX509TrustManager.getRDN(certificate.getIssuerX500Principal())).append('\n');
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        String notBefore = formatter.format(certificate.getNotBefore());
        buffer.append(BundleMessage.format("UI_VALID_FROM", new Object[0])).append(": ").append(notBefore).append('\n');
        String notAfter = formatter.format(certificate.getNotAfter());
        buffer.append(BundleMessage.format("UI_VALID_UNTIL", new Object[0])).append(": ").append(notAfter).append('\n');
        buffer.append(BundleMessage.format("UI_SERIAL", new Object[0])).append(": ").append(DavGatewayX509TrustManager.getFormattedSerial(certificate)).append('\n');
        String sha1Hash = DavGatewayX509TrustManager.getFormattedHash(certificate);
        buffer.append(BundleMessage.format("UI_FINGERPRINT", new Object[0])).append(": ").append(sha1Hash).append('\n');
        buffer.append('\n');
        buffer.append(BundleMessage.format("UI_UNTRUSTED_CERTIFICATE", new Object[0])).append('\n');
        try {
            while (!yes.equals(answer) && !no.equals(answer)) {
                System.out.println(buffer);
                answer = inReader.readLine();
                if (answer == null) {
                    answer = no;
                }
                answer = answer.toLowerCase();
            }
        }
        catch (IOException e) {
            System.err.println(e + " " + e.getMessage());
        }
        return yes.equals(answer);
    }

    public static String getRDN(Principal principal) {
        String dn = principal.getName();
        int start = dn.indexOf(61);
        int end = dn.indexOf(44);
        if (start >= 0 && end >= 0) {
            return dn.substring(start + 1, end);
        }
        return dn;
    }

    public static String getFormattedSerial(X509Certificate certificate) {
        StringBuilder builder = new StringBuilder();
        String serial = certificate.getSerialNumber().toString(16);
        for (int i = 0; i < serial.length(); ++i) {
            if (i > 0 && i % 2 == 0) {
                builder.append(' ');
            }
            builder.append(serial.charAt(i));
        }
        return builder.toString().toUpperCase();
    }

    public static String getFormattedHash(X509Certificate certificate) {
        String sha1Hash;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] digest = md.digest(certificate.getEncoded());
            sha1Hash = DavGatewayX509TrustManager.formatHash(digest);
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException nsa) {
            sha1Hash = nsa.getMessage();
        }
        return sha1Hash;
    }

    protected static String formatHash(byte[] buffer) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < buffer.length; ++i) {
            if (i > 0) {
                builder.append(':');
            }
            builder.append(String.format("%02x", buffer[i] & 0xFF));
        }
        return builder.toString().toUpperCase();
    }
}

