/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import davmail.Settings;
import davmail.http.DavGatewayX509TrustManager;
import davmail.http.DavMailX509KeyManager;
import davmail.http.SunPKCS11ProviderHandler;
import davmail.ui.PasswordPromptDialog;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.callback.PasswordCallback;
import org.apache.log4j.Logger;

public class DavGatewaySSLSocketFactory
extends SSLSocketFactory {
    static final Logger LOGGER = Logger.getLogger(DavGatewaySSLSocketFactory.class);
    private SSLContext sslcontext;

    private SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, InvalidAlgorithmParameterException {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext();
        }
        return this.sslcontext;
    }

    private SSLContext createSSLContext() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, KeyManagementException, KeyStoreException {
        String algorithm;
        String pkcs11Library = Settings.getProperty("davmail.ssl.pkcs11Library");
        String clientKeystoreType = Settings.getProperty("davmail.ssl.clientKeystoreType");
        if (clientKeystoreType == null || clientKeystoreType.isEmpty()) {
            clientKeystoreType = "PKCS11";
        }
        if (pkcs11Library != null && !pkcs11Library.isEmpty() && "PKCS11".equals(clientKeystoreType)) {
            StringBuilder pkcs11Buffer = new StringBuilder();
            pkcs11Buffer.append("name=DavMail\n");
            pkcs11Buffer.append("library=").append(pkcs11Library).append('\n');
            String pkcs11Config = Settings.getProperty("davmail.ssl.pkcs11Config");
            if (pkcs11Config != null && !pkcs11Config.isEmpty()) {
                pkcs11Buffer.append(pkcs11Config).append('\n');
            }
            SunPKCS11ProviderHandler.registerProvider(pkcs11Buffer.toString());
        }
        if ("SunX509".equals(algorithm = KeyManagerFactory.getDefaultAlgorithm())) {
            algorithm = "NewSunX509";
        } else if ("IbmX509".equals(algorithm)) {
            algorithm = "NewIbmX509";
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
        ArrayList<KeyStore.Builder> keyStoreBuilders = new ArrayList<KeyStore.Builder>();
        KeyStore.Builder scBuilder = KeyStore.Builder.newInstance("PKCS11", null, this.getProtectionParameter(null));
        keyStoreBuilders.add(scBuilder);
        String clientKeystoreFile = Settings.getProperty("davmail.ssl.clientKeystoreFile");
        String clientKeystorePass = Settings.getProperty("davmail.ssl.clientKeystorePass");
        if (clientKeystoreFile != null && !clientKeystoreFile.isEmpty() && ("PKCS12".equals(clientKeystoreType) || "JKS".equals(clientKeystoreType))) {
            KeyStore.Builder fsBuilder = KeyStore.Builder.newInstance(clientKeystoreType, null, new File(clientKeystoreFile), this.getProtectionParameter(clientKeystorePass));
            keyStoreBuilders.add(fsBuilder);
        }
        if ("MSCAPI".equals(clientKeystoreType)) {
            try {
                KeyStore keyStore = KeyStore.getInstance("Windows-MY");
                keyStore.load(null, null);
                keyStoreBuilders.add(KeyStore.Builder.newInstance(keyStore, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(null)));
            }
            catch (Exception keyStore) {
                // empty catch block
            }
        }
        KeyStoreBuilderParameters keyStoreBuilderParameters = new KeyStoreBuilderParameters(keyStoreBuilders);
        keyManagerFactory.init(keyStoreBuilderParameters);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        for (int i = 0; i < keyManagers.length; ++i) {
            KeyManager keyManager = keyManagers[i];
            if (!(keyManager instanceof X509KeyManager)) continue;
            keyManagers[i] = new DavMailX509KeyManager((X509KeyManager)keyManager);
        }
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagers, new TrustManager[]{new DavGatewayX509TrustManager()}, null);
        return context;
    }

    private KeyStore.ProtectionParameter getProtectionParameter(String password) {
        if (password != null && !password.isEmpty()) {
            return new KeyStore.PasswordProtection(password.toCharArray());
        }
        return new KeyStore.CallbackHandlerProtection(callbacks -> {
            if (callbacks.length > 0 && callbacks[0] instanceof PasswordCallback) {
                if (Settings.getBooleanProperty("davmail.server") || GraphicsEnvironment.isHeadless()) {
                    System.out.print(((PasswordCallback)callbacks[0]).getPrompt() + ": ");
                    String password1 = new BufferedReader(new InputStreamReader(System.in)).readLine();
                    ((PasswordCallback)callbacks[0]).setPassword(password1.toCharArray());
                } else {
                    PasswordPromptDialog passwordPromptDialog = new PasswordPromptDialog(((PasswordCallback)callbacks[0]).getPrompt());
                    ((PasswordCallback)callbacks[0]).setPassword(passwordPromptDialog.getPassword());
                }
            }
        });
    }

    @Override
    public String[] getDefaultCipherSuites() {
        try {
            return this.getSSLContext().getSocketFactory().getDefaultCipherSuites();
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    @Override
    public String[] getSupportedCipherSuites() {
        try {
            return this.getSSLContext().getSocketFactory().getSupportedCipherSuites();
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        LOGGER.debug((Object)("createSocket " + host + " " + port));
        try {
            return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
        }
        catch (InvalidAlgorithmParameterException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IOException(e + " " + e.getMessage());
        }
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        LOGGER.debug((Object)("createSocket " + host + " " + port));
        try {
            return this.getSSLContext().getSocketFactory().createSocket(host, port);
        }
        catch (InvalidAlgorithmParameterException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IOException(e + " " + e.getMessage());
        }
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException {
        LOGGER.debug((Object)("createSocket " + host + " " + port + " " + clientHost + " " + clientPort));
        try {
            return this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
        }
        catch (InvalidAlgorithmParameterException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IOException(e + " " + e.getMessage());
        }
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        LOGGER.debug((Object)("createSocket " + host + " " + port));
        try {
            return this.getSSLContext().getSocketFactory().createSocket(host, port);
        }
        catch (InvalidAlgorithmParameterException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IOException(e + " " + e.getMessage());
        }
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress clientHost, int clientPort) throws IOException {
        LOGGER.debug((Object)("createSocket " + host + " " + port + " " + clientHost + " " + clientPort));
        try {
            return this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
        }
        catch (InvalidAlgorithmParameterException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IOException(e + " " + e.getMessage());
        }
    }
}

