/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import davmail.Settings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class DavGatewayProxySelector
extends ProxySelector {
    static final Logger LOGGER = Logger.getLogger(DavGatewayProxySelector.class);
    static final List<Proxy> DIRECT = Collections.singletonList(Proxy.NO_PROXY);
    ProxySelector proxySelector;

    public DavGatewayProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
    }

    @Override
    public List<Proxy> select(URI uri) {
        boolean useSystemProxies = Settings.getBooleanProperty("davmail.useSystemProxies", Boolean.FALSE);
        boolean enableProxy = Settings.getBooleanProperty("davmail.enableProxy");
        String proxyHost = Settings.getProperty("davmail.proxyHost");
        int proxyPort = Settings.getIntProperty("davmail.proxyPort");
        String scheme = uri.getScheme();
        if ("socket".equals(scheme)) {
            return DIRECT;
        }
        if (useSystemProxies) {
            List<Proxy> proxyes = this.proxySelector.select(uri);
            LOGGER.debug((Object)("Selected " + proxyes + " proxy for " + uri));
            return proxyes;
        }
        if (enableProxy && proxyHost != null && proxyHost.length() > 0 && proxyPort > 0 && !this.isNoProxyFor(uri) && ("http".equals(scheme) || "https".equals(scheme))) {
            ArrayList<Proxy> proxies = new ArrayList<Proxy>();
            proxies.add(new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(proxyHost, proxyPort)));
            return proxies;
        }
        return DIRECT;
    }

    private boolean isNoProxyFor(URI uri) {
        String noProxyFor = Settings.getProperty("davmail.noProxyFor");
        if (noProxyFor != null) {
            String[] domains;
            String urihost = uri.getHost().toLowerCase();
            for (String domain : domains = noProxyFor.toLowerCase().split(",\\s*")) {
                if (!urihost.endsWith(domain)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        LOGGER.debug((Object)("Connection to " + uri + " failed, socket address " + sa + " " + ioe));
        this.proxySelector.connectFailed(uri, sa, ioe);
    }
}

