/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.graph;

import davmail.exception.HttpForbiddenException;
import davmail.exception.HttpNotFoundException;
import davmail.http.HttpClientAdapter;
import davmail.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JsonResponseHandler
implements ResponseHandler<JSONObject> {
    public JSONObject handleResponse(HttpResponse response) throws IOException {
        JSONObject jsonResponse = null;
        Header contentTypeHeader = response.getFirstHeader("Content-Type");
        if (contentTypeHeader != null && contentTypeHeader.getValue().startsWith("application/json")) {
            try {
                jsonResponse = new JSONObject(new String(this.readResponse(response), StandardCharsets.UTF_8));
            }
            catch (JSONException e) {
                throw new IOException(e.getMessage(), e);
            }
        } else {
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                try {
                    return new JSONObject().put("response", (Object)new String(this.readResponse(response), StandardCharsets.UTF_8));
                }
                catch (JSONException e) {
                    throw new IOException("Invalid response content");
                }
            }
        }
        if (response.getStatusLine().getStatusCode() >= 400) {
            String errorMessage = null;
            if (jsonResponse != null && jsonResponse.optJSONObject("error") != null) {
                try {
                    JSONObject jsonError = jsonResponse.getJSONObject("error");
                    errorMessage = jsonError.optString("code") + " " + jsonError.optString("message");
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            if (errorMessage == null) {
                errorMessage = response.getStatusLine().getReasonPhrase();
            }
            if (response.getStatusLine().getStatusCode() == 403) {
                throw new HttpForbiddenException(errorMessage);
            }
            if (response.getStatusLine().getStatusCode() == 404) {
                throw new HttpNotFoundException(errorMessage);
            }
            throw new IOException(errorMessage);
        }
        return jsonResponse;
    }

    protected byte[] readResponse(HttpResponse response) throws IOException {
        byte[] content;
        try (InputStream inputStream = response.getEntity().getContent();){
            content = HttpClientAdapter.isGzipEncoded(response) ? IOUtil.readFully(new GZIPInputStream(inputStream)) : IOUtil.readFully(inputStream);
        }
        return content;
    }
}

