/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.graph;

import davmail.exchange.ExchangeSession;
import davmail.exchange.ews.ExtendedFieldURI;
import davmail.exchange.ews.FieldURI;
import davmail.util.IOUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class GraphRequestBuilder {
    protected static final Logger LOGGER = Logger.getLogger((String)"davmail.exchange.graph.GraphRequestBuilder");
    String method = "POST";
    String contentType = "application/json";
    String baseUrl = "https://graph.microsoft.com";
    String version = "beta";
    String mailbox;
    String objectType;
    String childType;
    String childId;
    String childSuffix;
    String select;
    String filter;
    String startDateTime;
    String endDateTime;
    String timeZone;
    Set<FieldURI> expandFields;
    String accessToken;
    JSONObject jsonBody = null;
    byte[] mimeContent;
    private String objectId;

    public GraphRequestBuilder setProperty(String name, String value) throws JSONException {
        if (this.jsonBody == null) {
            this.jsonBody = new JSONObject();
        }
        this.jsonBody.put(name, (Object)value);
        return this;
    }

    public GraphRequestBuilder setJsonBody(JSONObject jsonBody) {
        this.jsonBody = jsonBody;
        return this;
    }

    public GraphRequestBuilder setExpandFields(Set<FieldURI> expandFields) {
        this.expandFields = expandFields;
        return this;
    }

    public GraphRequestBuilder setObjectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    public GraphRequestBuilder setChildType(String childType) {
        this.childType = childType;
        return this;
    }

    public GraphRequestBuilder setChildId(String childId) {
        this.childId = childId;
        return this;
    }

    public GraphRequestBuilder setChildSuffix(String childSuffix) {
        this.childSuffix = childSuffix;
        return this;
    }

    public GraphRequestBuilder setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public GraphRequestBuilder setFilter(ExchangeSession.Condition condition) {
        if (condition != null && !condition.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            condition.appendTo(buffer);
            LOGGER.debug((Object)("filter: " + this.filter));
            this.filter = buffer.toString();
        }
        return this;
    }

    public GraphRequestBuilder setStartDateTime(String startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    public GraphRequestBuilder setEndDateTime(String endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    public GraphRequestBuilder setTimezone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public GraphRequestBuilder setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public GraphRequestBuilder setMethod(String method) {
        this.method = method;
        return this;
    }

    public GraphRequestBuilder setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public GraphRequestBuilder setMimeContent(byte[] mimeContent) {
        this.mimeContent = mimeContent;
        return this;
    }

    public GraphRequestBuilder setMailbox(String mailbox) {
        this.mailbox = mailbox;
        return this;
    }

    public GraphRequestBuilder setObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    public GraphRequestBuilder setSelect(String select) {
        this.select = select;
        return this;
    }

    protected String buildPath() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("/").append(this.version);
        if (this.mailbox != null) {
            buffer.append("/users/").append(this.mailbox);
        } else {
            buffer.append("/me");
        }
        if (this.objectType != null) {
            buffer.append("/").append(this.objectType);
        }
        if (this.objectId != null) {
            buffer.append("/").append(this.objectId);
        }
        if (this.childType != null) {
            buffer.append("/").append(this.childType);
        }
        if (this.childId != null) {
            buffer.append("/").append(this.childId);
        }
        if (this.childSuffix != null) {
            buffer.append("/").append(this.childSuffix);
        }
        return buffer.toString();
    }

    private String buildExpand() {
        ArrayList<String> singleValueProperties = new ArrayList<String>();
        ArrayList<String> multiValueProperties = new ArrayList<String>();
        for (FieldURI fieldURI : this.expandFields) {
            String graphId;
            if (fieldURI.isMultiValued()) {
                multiValueProperties.add(fieldURI.getGraphId());
                continue;
            }
            if (!(fieldURI instanceof ExtendedFieldURI) || !(graphId = fieldURI.getGraphId()).contains(" ")) continue;
            singleValueProperties.add(fieldURI.getGraphId());
        }
        StringBuilder expand = new StringBuilder();
        if (!singleValueProperties.isEmpty()) {
            expand.append("singleValueExtendedProperties($filter=");
            this.appendExpandProperties(expand, singleValueProperties);
            expand.append(")");
        }
        if (!multiValueProperties.isEmpty()) {
            if (!singleValueProperties.isEmpty()) {
                expand.append(",");
            }
            expand.append("multiValueExtendedProperties($filter=");
            this.appendExpandProperties(expand, multiValueProperties);
            expand.append(")");
        }
        return expand.toString();
    }

    protected void appendExpandProperties(StringBuilder buffer, List<String> properties) {
        boolean first = true;
        for (String id : properties) {
            if (first) {
                first = false;
            } else {
                buffer.append(" or ");
            }
            buffer.append("id eq '").append(id).append("'");
        }
    }

    public HttpRequestBase build() throws IOException {
        try {
            Object httpRequest;
            URIBuilder uriBuilder = new URIBuilder(this.baseUrl).setPath(this.buildPath());
            if (this.select != null) {
                uriBuilder.addParameter("$select", this.select);
            }
            if (this.expandFields != null) {
                uriBuilder.addParameter("$expand", this.buildExpand());
            }
            if (this.filter != null) {
                uriBuilder.addParameter("$filter", this.filter);
            }
            if (this.startDateTime != null) {
                uriBuilder.addParameter("startDateTime", this.startDateTime);
            }
            if (this.endDateTime != null) {
                uriBuilder.addParameter("endDateTime", this.endDateTime);
            }
            if ("POST".equals(this.method)) {
                httpRequest = new HttpPost(uriBuilder.build());
                if (this.mimeContent != null) {
                    httpRequest.setEntity((HttpEntity)new ByteArrayEntity(this.mimeContent));
                } else if (this.jsonBody != null) {
                    httpRequest.setEntity((HttpEntity)new ByteArrayEntity(IOUtil.convertToBytes(this.jsonBody)));
                }
            } else if ("PUT".equals(this.method)) {
                httpRequest = new HttpPut(uriBuilder.build());
                if (this.mimeContent != null) {
                    ((HttpPut)httpRequest).setEntity((HttpEntity)new ByteArrayEntity(this.mimeContent));
                }
            } else if ("PATCH".equals(this.method)) {
                httpRequest = new HttpPatch(uriBuilder.build());
                if (this.jsonBody != null) {
                    ((HttpPatch)httpRequest).setEntity((HttpEntity)new ByteArrayEntity(IOUtil.convertToBytes(this.jsonBody)));
                }
            } else {
                httpRequest = "DELETE".equals(this.method) ? new HttpDelete(uriBuilder.build()) : new HttpGet(uriBuilder.build());
            }
            httpRequest.setHeader("Content-Type", this.contentType);
            httpRequest.setHeader("Authorization", "Bearer " + this.accessToken);
            if (this.timeZone != null) {
                httpRequest.setHeader("Prefer", "outlook.timezone=\"" + this.timeZone + "\"");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(httpRequest.getMethod() + " " + httpRequest.getURI()));
                if (this.jsonBody != null) {
                    LOGGER.debug((Object)this.jsonBody.toString());
                }
            }
            return httpRequest;
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

