/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.graph;

import davmail.exception.DavMailException;
import davmail.exchange.ews.Field;
import davmail.exchange.ews.FieldURI;
import davmail.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class GraphObject {
    protected final JSONObject jsonObject;
    protected int statusCode;

    public GraphObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public String optString(String key) {
        JSONArray singleValueExtendedProperties;
        String value = this.jsonObject.optString(key, null);
        if ("keywords".equals(key) || "categories".equals(key)) {
            JSONArray categoriesArray = this.jsonObject.optJSONArray("categories");
            HashSet<String> keywords = new HashSet<String>();
            for (int j = 0; j < categoriesArray.length(); ++j) {
                keywords.add(categoriesArray.optString(j));
            }
            value = StringUtil.join(keywords, ",");
        } else if ("changeKey".equals(key) && value == null) {
            String odataEtag = this.optString("@odata.etag");
            if (odataEtag != null && odataEtag.startsWith("W/\"") && odataEtag.endsWith("\"")) {
                value = odataEtag.substring(3, odataEtag.length() - 1);
            }
        } else if (value == null && (value = this.jsonObject.optString(key = Field.get(key).getGraphId(), null)) == null && (singleValueExtendedProperties = this.jsonObject.optJSONArray("singleValueExtendedProperties")) != null) {
            for (int i = 0; i < singleValueExtendedProperties.length(); ++i) {
                JSONObject singleValueObject = singleValueExtendedProperties.optJSONObject(i);
                if (singleValueObject == null || !key.equals(singleValueObject.optString("id"))) continue;
                value = singleValueObject.optString("value");
            }
        }
        return value;
    }

    public JSONArray optJSONArray(String key) {
        return this.jsonObject.optJSONArray(key);
    }

    public void put(String alias, String value) throws JSONException {
        FieldURI field = Field.get(alias);
        String key = field.getGraphId();
        if (key.contains(" ")) {
            if (field.isNumber() && value == null) {
                value = "0";
            }
            this.getSingleValueExtendedProperties().put((Object)new JSONObject().put("id", (Object)key).put("value", value == null ? JSONObject.NULL : value));
        } else {
            this.jsonObject.put(key, value == null ? JSONObject.NULL : value);
        }
    }

    public void put(String alias, boolean value) throws JSONException {
        FieldURI field = Field.get(alias);
        String key = field.getGraphId();
        if (key.contains(" ")) {
            this.getSingleValueExtendedProperties().put((Object)new JSONObject().put("id", (Object)key).put("value", value));
        } else {
            this.jsonObject.put(key, value);
        }
    }

    public void put(String key, JSONArray values) throws JSONException {
        this.jsonObject.put(key, (Object)values);
    }

    public void setCategories(String values) throws JSONException {
        if (values != null) {
            this.setCategories(values.split(","));
        } else {
            this.jsonObject.put("categories", (Object)new JSONArray());
        }
    }

    public void setCategories(String[] values) throws JSONException {
        JSONArray jsonValues = new JSONArray();
        for (String singleValue : values) {
            jsonValues.put((Object)singleValue);
        }
        this.jsonObject.put("categories", (Object)jsonValues);
    }

    public String toString(int indentFactor) throws JSONException {
        return this.jsonObject.toString(indentFactor);
    }

    protected JSONArray getSingleValueExtendedProperties() throws JSONException {
        JSONArray singleValueExtendedProperties = this.jsonObject.optJSONArray("singleValueExtendedProperties");
        if (singleValueExtendedProperties == null) {
            singleValueExtendedProperties = new JSONArray();
            this.jsonObject.put("singleValueExtendedProperties", (Object)singleValueExtendedProperties);
        }
        return singleValueExtendedProperties;
    }

    public String getString(String key) throws JSONException {
        String value = this.optString(key);
        if (value == null) {
            throw new JSONException("JSONObject[" + key + "] not found.");
        }
        return value;
    }

    public String optString(String section, String key) {
        JSONObject sectionObject = this.jsonObject.optJSONObject(section);
        if (sectionObject != null) {
            return sectionObject.optString(key, null);
        }
        return null;
    }

    public JSONObject optJSONObject(String key) {
        return this.jsonObject.optJSONObject(key);
    }

    public Date optDateTimeTimeZone(String key) throws DavMailException {
        JSONObject sectionObject = this.jsonObject.optJSONObject(key);
        if (sectionObject != null) {
            String timeZone = sectionObject.optString("timeZone");
            String dateTime = sectionObject.optString("dateTime");
            if (timeZone != null && dateTime != null) {
                try {
                    SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS");
                    parser.setTimeZone(TimeZone.getTimeZone(timeZone));
                    return parser.parse(dateTime);
                }
                catch (ParseException e) {
                    throw new DavMailException("EXCEPTION_INVALID_DATE", dateTime);
                }
            }
        }
        return null;
    }

    public static String convertTimezoneFromExchange(String exchangeTimezone) {
        ResourceBundle tzidsBundle = ResourceBundle.getBundle("stdtimezones");
        if (tzidsBundle.containsKey(exchangeTimezone)) {
            return tzidsBundle.getString(exchangeTimezone);
        }
        return exchangeTimezone;
    }
}

