/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.graph;

import davmail.Settings;
import davmail.exception.HttpNotFoundException;
import davmail.exchange.ExchangeSession;
import davmail.exchange.auth.O365Token;
import davmail.exchange.ews.EwsExchangeSession;
import davmail.exchange.ews.ExtendedFieldURI;
import davmail.exchange.ews.Field;
import davmail.exchange.ews.FieldURI;
import davmail.exchange.ews.IndexedFieldURI;
import davmail.exchange.graph.GraphRequestBuilder;
import davmail.exchange.graph.JsonResponseHandler;
import davmail.http.HttpClientAdapter;
import davmail.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class GraphExchangeSessionDraft
extends ExchangeSession {
    HttpClientAdapter httpClient;
    O365Token token;
    String apiVersion = "beta";
    String baseUrl;
    protected static final HashSet<FieldURI> FOLDER_PROPERTIES = new HashSet();

    public GraphExchangeSessionDraft(HttpClientAdapter httpClient, O365Token token, String userName) {
        this.httpClient = httpClient;
        this.token = token;
        this.userName = userName;
        this.baseUrl = "https://graph.microsoft.com";
    }

    public Folder getFolderByName(String folderName) throws URISyntaxException, IOException, JSONException {
        Folder folder = null;
        HttpRequestBase httpRequest = new GraphRequestBuilder().setMethod("GET").setAccessToken(this.token.getAccessToken()).setObjectType("mailFolders").setObjectId(folderName).setExpandFields(FOLDER_PROPERTIES).build();
        JSONObject jsonResponse = this.executeRequest(httpRequest);
        folder = new Folder();
        folder.folderPath = folderName;
        folder.displayName = jsonResponse.optString("displayName");
        LOGGER.debug((Object)("urlcompname " + Field.get("urlcompname").getGraphId()));
        LOGGER.debug((Object)("folderDisplayName " + jsonResponse.optString("displayName")));
        LOGGER.debug((Object)("lastmodified " + Field.get("lastmodified").getGraphId()));
        LOGGER.debug((Object)("folderclass " + Field.get("folderclass").getGraphId()));
        LOGGER.debug((Object)("ctag " + Field.get("ctag").getGraphId()));
        LOGGER.debug((Object)("count " + Field.get("count").getGraphId()));
        LOGGER.debug((Object)("unread " + Field.get("unread").getGraphId()));
        LOGGER.debug((Object)("hassubs " + Field.get("hassubs").getGraphId()));
        LOGGER.debug((Object)("uidNext " + Field.get("uidNext").getGraphId()));
        LOGGER.debug((Object)("highestUid " + Field.get("highestUid").getGraphId()));
        JSONArray singleValueExtendedProperties = jsonResponse.optJSONArray("singleValueExtendedProperties");
        if (singleValueExtendedProperties != null) {
            for (int i = 0; i < singleValueExtendedProperties.length(); ++i) {
                JSONObject singleValueProperty = singleValueExtendedProperties.getJSONObject(i);
                String singleValueId = singleValueProperty.getString("id");
                String singleValue = singleValueProperty.getString("value");
                if (Field.get("lastmodified").getGraphId().equals(singleValueId)) {
                    folder.lastModified = singleValue;
                    continue;
                }
                if (Field.get("folderclass").getGraphId().equals(singleValueId)) {
                    folder.folderClass = singleValue;
                    continue;
                }
                if (Field.get("uidNext").getGraphId().equals(singleValueId)) {
                    folder.uidNext = Long.parseLong(singleValue);
                    continue;
                }
                if (Field.get("ctag").getGraphId().equals(singleValueId)) {
                    folder.ctag = singleValue;
                    continue;
                }
                LOGGER.warn((Object)("Unknown property " + singleValueId));
            }
        }
        folder.messageCount = jsonResponse.getInt("totalItemCount");
        folder.unreadCount = jsonResponse.getInt("unreadItemCount");
        folder.hasChildren = jsonResponse.getInt("childFolderCount") > 0;
        return folder;
    }

    private String buildExpand(HashSet<FieldURI> fields) {
        ArrayList<String> singleValueProperties = new ArrayList<String>();
        ArrayList<String> multiValueProperties = new ArrayList<String>();
        for (FieldURI fieldURI : fields) {
            if (fieldURI instanceof ExtendedFieldURI) {
                singleValueProperties.add(fieldURI.getGraphId());
                continue;
            }
            if (!(fieldURI instanceof IndexedFieldURI)) continue;
            multiValueProperties.add(fieldURI.getGraphId());
        }
        StringBuilder expand = new StringBuilder();
        if (!singleValueProperties.isEmpty()) {
            expand.append("singleValueExtendedProperties($filter=");
            this.appendExpandProperties(expand, singleValueProperties);
            expand.append(")");
        }
        if (!multiValueProperties.isEmpty()) {
            if (!singleValueProperties.isEmpty()) {
                expand.append(",");
            }
            expand.append("multiValueExtendedProperties($filter=");
            this.appendExpandProperties(expand, multiValueProperties);
            expand.append(")");
        }
        return expand.toString();
    }

    public void appendExpandProperties(StringBuilder buffer, List<String> properties) {
        boolean first = true;
        for (String id : properties) {
            if (first) {
                first = false;
            } else {
                buffer.append(" or ");
            }
            buffer.append("id eq '").append(id).append("'");
        }
    }

    @Override
    public void close() {
    }

    @Override
    public String formatSearchDate(Date date) {
        return null;
    }

    @Override
    protected void buildSessionInfo(URI uri) throws IOException {
    }

    @Override
    public ExchangeSession.Message createMessage(String folderPath, String messageName, HashMap<String, String> properties, MimeMessage mimeMessage) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            mimeMessage.writeTo((OutputStream)baos);
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
        baos.close();
        byte[] mimeContent = IOUtil.encodeBase64(baos.toByteArray());
        try {
            String folderId = this.getFolderIdIfExists(folderPath);
            String path = "/beta/me/mailFolders/" + folderId + "/messages";
            path = "/beta/me/messages";
            HttpPost httpPost = new HttpPost(new URIBuilder(this.baseUrl).setPath(path).build());
            httpPost.setHeader("Content-Type", "text/plain");
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(mimeContent));
            JSONObject response = this.executeRequest((HttpRequestBase)httpPost);
            path = "/beta/me/messages/" + response.get("id");
            HttpPatch httpPatch = new HttpPatch(new URIBuilder(this.baseUrl).setPath(path).build());
            httpPatch.setHeader("Content-Type", "application/json");
            response.put("singleValueExtendedProperties", (Object)new JSONArray().put((Object)new JSONObject().put("id", (Object)Field.get("messageFlags").getGraphId()).put("value", (Object)"4")));
            httpPatch.setEntity((HttpEntity)new ByteArrayEntity(response.toString().getBytes(StandardCharsets.UTF_8)));
            response = this.executeRequest((HttpRequestBase)httpPatch);
            response = this.moveMessage(response.getString("id"), folderId);
            this.getMessage(response.getString("id"));
        }
        catch (URISyntaxException | JSONException e) {
            throw new IOException(e);
        }
        return null;
    }

    private JSONObject updateMessage(String id, HashMap<String, String> properties) throws IOException {
        try {
            String path = "/beta/me/messages/" + id;
            HttpPatch httpPatch = new HttpPatch(new URIBuilder(this.baseUrl).setPath(path).build());
            httpPatch.setHeader("Content-Type", "application/json");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("isDraft", false);
            jsonObject.put("singleValueExtendedProperties", (Object)new JSONArray().put((Object)new JSONObject().put("id", (Object)Field.get("messageFlags").getGraphId()).put("value", (Object)"4")));
            httpPatch.setEntity((HttpEntity)new ByteArrayEntity(jsonObject.toString().getBytes(StandardCharsets.UTF_8)));
            JSONObject response = this.executeRequest((HttpRequestBase)httpPatch);
            return response;
        }
        catch (URISyntaxException | JSONException e) {
            throw new IOException(e);
        }
    }

    private JSONObject moveMessage(String id, String folderId) throws IOException {
        try {
            String path = "/beta/me/messages/" + id + "/move/";
            HttpPost httpPost = new HttpPost(new URIBuilder(this.baseUrl).setPath(path).build());
            httpPost.setHeader("Content-Type", "application/json");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("destinationId", (Object)folderId);
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(jsonObject.toString().getBytes(StandardCharsets.UTF_8)));
            JSONObject response = this.executeRequest((HttpRequestBase)httpPost);
            return response;
        }
        catch (URISyntaxException | JSONException e) {
            throw new IOException(e);
        }
    }

    private ExchangeSession.Message getMessage(String id) throws URISyntaxException, IOException, JSONException {
        HashSet<FieldURI> messageProperties = new HashSet<FieldURI>();
        messageProperties.add(Field.get("messageFlags"));
        messageProperties.add(Field.get("imapUid"));
        ExchangeSession.Message message = null;
        URIBuilder uriBuilder = new URIBuilder(this.baseUrl).setPath("/beta/me/messages/" + id).addParameter("$expand", this.buildExpand(messageProperties));
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        httpGet.setHeader("Authorization", "Bearer " + this.token.getAccessToken());
        try (CloseableHttpResponse response = this.httpClient.execute((HttpRequestBase)httpGet);){
            JSONObject jsonResponse = new JsonResponseHandler().handleResponse((HttpResponse)response);
            JSONArray singleValueExtendedProperties = jsonResponse.optJSONArray("singleValueExtendedProperties");
            if (singleValueExtendedProperties != null) {
                for (int i = 0; i < singleValueExtendedProperties.length(); ++i) {
                    JSONObject singleValueProperty = singleValueExtendedProperties.getJSONObject(i);
                    String singleValueId = singleValueProperty.getString("id");
                    String singleValue = singleValueProperty.getString("value");
                    if (Field.get("messageFlags").getGraphId().equals(singleValueId)) {
                        System.out.println("messageFlags: " + singleValue);
                        continue;
                    }
                    if (Field.get("imapUid").getGraphId().equals(singleValueId)) {
                        System.out.println("imapUid: " + singleValue);
                        continue;
                    }
                    LOGGER.warn((Object)("Unknown property " + singleValueId));
                }
            }
        }
        return message;
    }

    public void getMessageBody(String id) throws URISyntaxException, IOException, MessagingException {
        MimeMessage mimeMessage = null;
        URIBuilder uriBuilder = new URIBuilder(this.baseUrl).setPath("/beta/me/messages/" + id + "/$value");
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        httpGet.setHeader("Authorization", "Bearer " + this.token.getAccessToken());
        try (CloseableHttpResponse response = this.httpClient.execute((HttpRequestBase)httpGet);){
            try (InputStream inputStream = response.getEntity().getContent();){
                mimeMessage = HttpClientAdapter.isGzipEncoded((HttpResponse)response) ? new MimeMessage(null, (InputStream)new SharedByteArrayInputStream(IOUtil.readFully(new GZIPInputStream(inputStream)))) : new MimeMessage(null, (InputStream)new SharedByteArrayInputStream(IOUtil.readFully(inputStream)));
            }
            catch (MessagingException e) {
                throw new IOException(e.getMessage(), e);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            mimeMessage.writeTo((OutputStream)baos);
            System.out.println(baos.toString("UTF-8"));
        }
    }

    @Override
    public void updateMessage(ExchangeSession.Message message, Map<String, String> properties) throws IOException {
    }

    @Override
    public void deleteMessage(ExchangeSession.Message message) throws IOException {
    }

    @Override
    protected byte[] getContent(ExchangeSession.Message message) throws IOException {
        return new byte[0];
    }

    @Override
    public ExchangeSession.MessageList searchMessages(String folderName, Set<String> attributes, ExchangeSession.Condition condition) throws IOException {
        return null;
    }

    @Override
    public ExchangeSession.MultiCondition and(ExchangeSession.Condition ... condition) {
        return null;
    }

    @Override
    public ExchangeSession.MultiCondition or(ExchangeSession.Condition ... condition) {
        return null;
    }

    @Override
    public ExchangeSession.Condition not(ExchangeSession.Condition condition) {
        return null;
    }

    @Override
    public ExchangeSession.Condition isEqualTo(String attributeName, String value) {
        return null;
    }

    @Override
    public ExchangeSession.Condition isEqualTo(String attributeName, int value) {
        return null;
    }

    @Override
    public ExchangeSession.Condition headerIsEqualTo(String headerName, String value) {
        return null;
    }

    @Override
    public ExchangeSession.Condition gte(String attributeName, String value) {
        return null;
    }

    @Override
    public ExchangeSession.Condition gt(String attributeName, String value) {
        return null;
    }

    @Override
    public ExchangeSession.Condition lt(String attributeName, String value) {
        return null;
    }

    @Override
    public ExchangeSession.Condition lte(String attributeName, String value) {
        return null;
    }

    @Override
    public ExchangeSession.Condition contains(String attributeName, String value) {
        return null;
    }

    @Override
    public ExchangeSession.Condition startsWith(String attributeName, String value) {
        return null;
    }

    @Override
    public ExchangeSession.Condition isNull(String attributeName) {
        return null;
    }

    @Override
    public ExchangeSession.Condition exists(String attributeName) {
        return null;
    }

    @Override
    public ExchangeSession.Condition isTrue(String attributeName) {
        return null;
    }

    @Override
    public ExchangeSession.Condition isFalse(String attributeName) {
        return null;
    }

    @Override
    public List<ExchangeSession.Folder> getSubFolders(String folderName, ExchangeSession.Condition condition, boolean recursive) throws IOException {
        ArrayList<ExchangeSession.Folder> folders = new ArrayList<ExchangeSession.Folder>();
        try {
            String folderId = this.getFolderId(folderName);
            HttpGet httpGet = new HttpGet(new URIBuilder(this.baseUrl).setPath("/beta/me/mailFolders/" + folderId + "/childFolders").addParameter("$expand", this.buildExpand(FOLDER_PROPERTIES)).build());
            JSONObject jsonResponse = this.executeRequest((HttpRequestBase)httpGet);
            JSONArray jsonValues = jsonResponse.optJSONArray("value");
            for (int i = 0; i < jsonValues.length(); ++i) {
                Folder folder = this.buildFolder(jsonValues.getJSONObject(i));
                folder.folderPath = folderName + '/' + EwsExchangeSession.encodeFolderName(folder.displayName);
                folders.add(folder);
            }
        }
        catch (URISyntaxException | JSONException e) {
            throw new IOException(e);
        }
        return folders;
    }

    @Override
    public void sendMessage(MimeMessage mimeMessage) throws IOException, MessagingException {
    }

    @Override
    protected Folder internalGetFolder(String folderPath) throws IOException {
        String folderId = this.getFolderId(folderPath);
        JSONObject jsonResponse = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(this.baseUrl).setPath("/beta/me/mailFolders/" + folderId).addParameter("$expand", this.buildExpand(FOLDER_PROPERTIES));
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            httpGet.setHeader("Authorization", "Bearer " + this.token.getAccessToken());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpRequestBase)httpGet);){
                jsonResponse = new JsonResponseHandler().handleResponse((HttpResponse)response);
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        if (jsonResponse == null) {
            throw new HttpNotFoundException("Folder " + folderPath + " not found");
        }
        Folder folder = this.buildFolder(jsonResponse);
        folder.folderPath = folderPath;
        return folder;
    }

    private String internalGetFolderId(String folderName) throws IOException {
        String folderId;
        try {
            URIBuilder uriBuilder = new URIBuilder(this.baseUrl).setPath("/beta/me/mailFolders/" + folderName).addParameter("$select", "id");
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            httpGet.setHeader("Authorization", "Bearer " + this.token.getAccessToken());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpRequestBase)httpGet);){
                JSONObject jsonResponse = new JsonResponseHandler().handleResponse((HttpResponse)response);
                folderId = jsonResponse.getString("id");
            }
        }
        catch (URISyntaxException | JSONException e) {
            throw new IOException(e);
        }
        return folderId;
    }

    protected String getFolderIdIfExists(String folderPath) throws IOException {
        String[] pathElements;
        String parentFolderId = this.internalGetFolderId("msgfolderroot");
        if ("msgfolderroot".equals(folderPath)) {
            return parentFolderId;
        }
        Object folderId = null;
        for (String pathElement : pathElements = folderPath.split("/")) {
            try {
                String displayName = EwsExchangeSession.decodeFolderName(pathElement);
                URIBuilder uriBuilder = new URIBuilder(this.baseUrl).setPath("/beta/me/mailFolders/" + parentFolderId + "/childFolders").addParameter("$select", "id, displayName").addParameter("$filter", "displayName eq '" + displayName + "'");
                HttpGet httpGet = new HttpGet(uriBuilder.build());
                httpGet.setHeader("Authorization", "Bearer " + this.token.getAccessToken());
                try (CloseableHttpResponse response = this.httpClient.execute((HttpRequestBase)httpGet);){
                    JSONObject jsonResponse = new JsonResponseHandler().handleResponse((HttpResponse)response);
                    JSONArray jsonFolders = jsonResponse.getJSONArray("value");
                    String currentFolderId = null;
                    for (int i = 0; i < jsonFolders.length(); ++i) {
                        JSONObject jsonFolder = jsonFolders.getJSONObject(i);
                        if (!displayName.equals(jsonFolder.optString("displayName"))) continue;
                        currentFolderId = jsonFolder.getString("id");
                    }
                    parentFolderId = currentFolderId;
                    if (currentFolderId != null) continue;
                    break;
                }
            }
            catch (URISyntaxException | JSONException e) {
                throw new IOException(e);
            }
        }
        return parentFolderId;
    }

    protected String getFolderId(String folderPath) throws IOException {
        String folderId = this.getFolderIdIfExists(folderPath);
        if (folderId == null) {
            throw new HttpNotFoundException("Folder '" + folderPath + "' not found");
        }
        return folderId;
    }

    private Folder buildFolder(JSONObject jsonResponse) throws IOException {
        Folder folder = new Folder();
        try {
            folder.displayName = jsonResponse.optString("displayName");
            folder.messageCount = jsonResponse.getInt("totalItemCount");
            folder.unreadCount = jsonResponse.getInt("unreadItemCount");
            folder.hasChildren = jsonResponse.getInt("childFolderCount") > 0;
            folder.id = jsonResponse.getString("id");
            JSONArray singleValueExtendedProperties = jsonResponse.optJSONArray("singleValueExtendedProperties");
            if (singleValueExtendedProperties != null) {
                for (int i = 0; i < singleValueExtendedProperties.length(); ++i) {
                    JSONObject singleValueProperty = singleValueExtendedProperties.getJSONObject(i);
                    String singleValueId = singleValueProperty.getString("id");
                    String singleValue = singleValueProperty.getString("value");
                    if (Field.get("lastmodified").getGraphId().equals(singleValueId)) {
                        folder.lastModified = singleValue;
                        continue;
                    }
                    if (Field.get("folderclass").getGraphId().equals(singleValueId)) {
                        folder.folderClass = singleValue;
                        continue;
                    }
                    if (Field.get("uidNext").getGraphId().equals(singleValueId)) {
                        folder.uidNext = Long.parseLong(singleValue);
                        continue;
                    }
                    if (Field.get("ctag").getGraphId().equals(singleValueId)) {
                        folder.ctag = singleValue;
                        continue;
                    }
                    LOGGER.warn((Object)("Unknown property " + singleValueId));
                }
            }
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        return folder;
    }

    @Override
    public int createFolder(String folderPath, String folderClass, Map<String, String> properties) throws IOException {
        String folderName;
        String parentFolderId;
        if ("IPF.Appointment".equals(folderClass) && folderPath.startsWith("calendars")) {
            try {
                HttpPost httpPost = new HttpPost(new URIBuilder(this.baseUrl).setPath("/beta/me/calendars").build());
                httpPost.setHeader("Content-Type", "application/json");
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("name", (Object)folderPath);
                httpPost.setEntity((HttpEntity)new ByteArrayEntity(jsonObject.toString().getBytes(StandardCharsets.UTF_8)));
                this.executeRequest((HttpRequestBase)httpPost);
            }
            catch (URISyntaxException | JSONException e) {
                throw new IOException(e);
            }
        }
        if (folderPath.contains("/")) {
            String parentFolderPath = folderPath.substring(0, folderPath.lastIndexOf(47));
            parentFolderId = this.getFolderId(parentFolderPath);
            folderName = EwsExchangeSession.decodeFolderName(folderPath.substring(folderPath.lastIndexOf(47) + 1));
        } else {
            parentFolderId = this.getFolderId("msgfolderroot");
            folderName = EwsExchangeSession.decodeFolderName(folderPath);
        }
        try {
            HttpPost httpPost = new HttpPost(new URIBuilder(this.baseUrl).setPath("/beta/me/mailFolders/" + parentFolderId + "/childFolders").build());
            httpPost.setHeader("Content-Type", "application/json");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("displayName", (Object)folderName);
            if (folderClass != null) {
                JSONArray singleValueExtendedProperties = new JSONArray();
                singleValueExtendedProperties.put((Object)new JSONObject().put("id", (Object)Field.get("folderclass").getGraphId()).put("value", (Object)folderClass));
                jsonObject.put("singleValueExtendedProperties", (Object)singleValueExtendedProperties);
            }
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(jsonObject.toString().getBytes(StandardCharsets.UTF_8)));
            this.executeRequest((HttpRequestBase)httpPost);
        }
        catch (URISyntaxException | JSONException e) {
            throw new IOException(e);
        }
        return 201;
    }

    @Override
    public int updateFolder(String folderName, Map<String, String> properties) throws IOException {
        return 0;
    }

    @Override
    public void deleteFolder(String folderPath) throws IOException {
        String folderId = this.getFolderId(folderPath);
        try {
            HttpDelete httpDelete = new HttpDelete(new URIBuilder(this.baseUrl).setPath("/beta/me/mailFolders/" + folderId).build());
            this.executeRequest((HttpRequestBase)httpDelete);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void copyMessage(ExchangeSession.Message message, String targetFolder) throws IOException {
    }

    @Override
    public void moveMessage(ExchangeSession.Message message, String targetFolder) throws IOException {
    }

    @Override
    public void moveFolder(String folderName, String targetName) throws IOException {
    }

    @Override
    public void moveItem(String sourcePath, String targetPath) throws IOException {
    }

    @Override
    protected void moveToTrash(ExchangeSession.Message message) throws IOException {
    }

    @Override
    protected Set<String> getItemProperties() {
        return null;
    }

    @Override
    public List<ExchangeSession.Contact> searchContacts(String folderPath, Set<String> attributes, ExchangeSession.Condition condition, int maxCount) throws IOException {
        return null;
    }

    @Override
    public List<ExchangeSession.Event> getEventMessages(String folderPath) throws IOException {
        return null;
    }

    @Override
    protected ExchangeSession.Condition getCalendarItemCondition(ExchangeSession.Condition dateCondition) {
        return null;
    }

    @Override
    public List<ExchangeSession.Event> searchEvents(String folderPath, Set<String> attributes, ExchangeSession.Condition condition) throws IOException {
        return null;
    }

    @Override
    public ExchangeSession.Item getItem(String folderPath, String itemName) throws IOException {
        return null;
    }

    @Override
    public ExchangeSession.ContactPhoto getContactPhoto(ExchangeSession.Contact contact) throws IOException {
        return null;
    }

    @Override
    public void deleteItem(String folderPath, String itemName) throws IOException {
    }

    @Override
    public void processItem(String folderPath, String itemName) throws IOException {
    }

    @Override
    public int sendEvent(String icsBody) throws IOException {
        return 0;
    }

    @Override
    protected ExchangeSession.Contact buildContact(String folderPath, String itemName, Map<String, String> properties, String etag, String noneMatch) throws IOException {
        return null;
    }

    @Override
    protected ExchangeSession.ItemResult internalCreateOrUpdateEvent(String folderPath, String itemName, String contentClass, String icsBody, String etag, String noneMatch) throws IOException {
        return null;
    }

    @Override
    public boolean isSharedFolder(String folderPath) {
        return false;
    }

    @Override
    public boolean isMainCalendar(String folderPath) throws IOException {
        return false;
    }

    @Override
    public Map<String, ExchangeSession.Contact> galFind(ExchangeSession.Condition condition, Set<String> returningAttributes, int sizeLimit) throws IOException {
        return null;
    }

    @Override
    protected String getFreeBusyData(String attendee, String start, String end, int interval) throws IOException {
        return null;
    }

    @Override
    protected void loadVtimezone() {
        try {
            String timezoneId = null;
            JSONObject mailboxSettings = this.getMailboxSettings();
            if (mailboxSettings != null) {
                timezoneId = mailboxSettings.optString("timeZone", null);
            }
            if (timezoneId == null) {
                timezoneId = Settings.getProperty("davmail.timezoneId");
            }
            if (timezoneId == null) {
                LOGGER.warn((Object)"Unable to get user timezone, using GMT Standard Time. Set davmail.timezoneId setting to override this.");
                timezoneId = "GMT Standard Time";
            }
            this.deleteFolder("davmailtemp");
            this.createCalendarFolder("davmailtemp", null);
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Unable to get VTIMEZONE info: " + e), (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOGGER.warn((Object)("Unable to get VTIMEZONE info: " + e), (Throwable)e);
        }
    }

    public JSONObject getMailboxSettings() throws IOException, URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(this.baseUrl).setPath("/beta/me/mailboxsettings");
        return this.executeRequest((HttpRequestBase)new HttpGet(uriBuilder.build()));
    }

    public JSONArray getSupportedTimeZones(String timeZoneStandard) throws IOException, URISyntaxException, JSONException {
        if (timeZoneStandard == null) {
            timeZoneStandard = "Windows";
        }
        URIBuilder uriBuilder = new URIBuilder(this.baseUrl).setPath("/beta/me/outlook/supportedTimeZones(TimeZoneStandard=microsoft.graph.timeZoneStandard'" + timeZoneStandard + "')");
        JSONObject response = this.executeRequest((HttpRequestBase)new HttpGet(uriBuilder.build()));
        return response.getJSONArray("value");
    }

    private JSONObject executeRequest(HttpRequestBase request) throws IOException {
        JSONObject jsonResponse;
        request.setHeader("Authorization", "Bearer " + this.token.getAccessToken());
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            jsonResponse = new JsonResponseHandler().handleResponse((HttpResponse)response);
        }
        return jsonResponse;
    }

    static {
        FOLDER_PROPERTIES.add(Field.get("urlcompname"));
        FOLDER_PROPERTIES.add(Field.get("folderDisplayName"));
        FOLDER_PROPERTIES.add(Field.get("lastmodified"));
        FOLDER_PROPERTIES.add(Field.get("folderclass"));
        FOLDER_PROPERTIES.add(Field.get("ctag"));
        FOLDER_PROPERTIES.add(Field.get("uidNext"));
        FOLDER_PROPERTIES.add(Field.get("highestUid"));
    }

    protected class Folder
    extends ExchangeSession.Folder {
        public String lastModified;
        public String id;

        protected Folder() {
        }
    }
}

