/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.graph;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.exception.DavMailException;
import davmail.exception.HttpForbiddenException;
import davmail.exception.HttpNotFoundException;
import davmail.exchange.ExchangeSession;
import davmail.exchange.VCalendar;
import davmail.exchange.VObject;
import davmail.exchange.VProperty;
import davmail.exchange.auth.O365Token;
import davmail.exchange.ews.ExtendedFieldURI;
import davmail.exchange.ews.Field;
import davmail.exchange.ews.FieldURI;
import davmail.exchange.ews.SearchExpression;
import davmail.exchange.graph.GraphObject;
import davmail.exchange.graph.GraphRequestBuilder;
import davmail.exchange.graph.JsonResponseHandler;
import davmail.http.HttpClientAdapter;
import davmail.http.URIUtil;
import davmail.ui.tray.DavGatewayTray;
import davmail.util.IOUtil;
import davmail.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;

public class GraphExchangeSession
extends ExchangeSession {
    protected static HashMap<String, String> wellKnownFolderMap = new HashMap();
    protected static final HashSet<FieldURI> IMAP_MESSAGE_ATTRIBUTES;
    protected static final HashSet<FieldURI> CONTACT_ATTRIBUTES;
    private static final Set<FieldURI> TODO_PROPERTIES;
    protected static final String EVENT_SELECT = "allowNewTimeProposals,attendees,body,bodyPreview,cancelledOccurrences,categories,changeKey,createdDateTime,end,exceptionOccurrences,hasAttachments,iCalUId,id,importance,isAllDay,isOnlineMeeting,isOrganizer,isReminderOn,lastModifiedDateTime,location,organizer,originalStart,recurrence,reminderMinutesBeforeStart,responseRequested,sensitivity,showAs,start,subject,type";
    protected static final HashSet<FieldURI> EVENT_ATTRIBUTES;
    HttpClientAdapter httpClient;
    O365Token token;
    protected static final HashSet<FieldURI> FOLDER_PROPERTIES;
    protected static final String USERS_ROOT = "/users/";
    protected static final String ARCHIVE_ROOT = "/archive/";
    protected static final Set<String> ITEM_PROPERTIES;
    protected static final HashSet<String> EVENT_REQUEST_PROPERTIES;
    protected static final HashSet<String> CALENDAR_ITEM_REQUEST_PROPERTIES;

    private String convertHtmlToText(String htmlText) {
        StringBuilder builder = new StringBuilder();
        HtmlCleaner cleaner = new HtmlCleaner();
        cleaner.getProperties().setDeserializeEntities(true);
        try {
            TagNode node = cleaner.clean((Reader)new StringReader(htmlText));
            for (TagNode childNode : node.getAllElementsList(true)) {
                builder.append(childNode.getText());
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error converting html to text", (Throwable)e);
        }
        return builder.toString();
    }

    private VProperty convertBodyToVproperty(String propertyName, GraphObject graphObject) {
        VProperty vProperty;
        JSONObject jsonBody = graphObject.optJSONObject("body");
        if (jsonBody == null) {
            return new VProperty(propertyName, "");
        }
        String content = jsonBody.optString("content");
        String contentType = jsonBody.optString("contentType");
        if ("text".equals(contentType)) {
            vProperty = new VProperty(propertyName, content);
        } else if (content != null) {
            vProperty = new VProperty(propertyName, this.convertHtmlToText(content));
            content = content.replace("\n", "").replace("\r", "");
            vProperty.addParam("ALTREP", "data:text/html," + URIUtil.encodeWithinQuery(content));
        } else {
            vProperty = new VProperty(propertyName, null);
        }
        return vProperty;
    }

    private VProperty convertDateTimeTimeZoneToVproperty(String vPropertyName, JSONObject jsonDateTimeTimeZone) throws DavMailException {
        if (jsonDateTimeTimeZone != null) {
            String timeZone = jsonDateTimeTimeZone.optString("timeZone");
            String dateTime = jsonDateTimeTimeZone.optString("dateTime");
            VProperty vProperty = new VProperty(vPropertyName, this.convertDateFromExchange(dateTime));
            vProperty.addParam("TZID", timeZone);
            return vProperty;
        }
        return new VProperty(vPropertyName, null);
    }

    private VProperty convertEmailAddressToVproperty(String propertyName, JSONObject jsonEmailAddress) {
        VProperty attendeeProperty = new VProperty(propertyName, "mailto:" + jsonEmailAddress.optString("address"));
        attendeeProperty.addParam("CN", jsonEmailAddress.optString("name"));
        return attendeeProperty;
    }

    private String convertDateTimeTimeZoneToTaskDate(Date exchangeDateValue) {
        String zuluDateValue = null;
        if (exchangeDateValue != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
            dateFormat.setTimeZone(GMT_TIMEZONE);
            zuluDateValue = dateFormat.format(exchangeDateValue);
        }
        return zuluDateValue;
    }

    private String convertZuluToIso(String value) {
        if (value != null) {
            return value.replace(".000Z", "Z");
        }
        return value;
    }

    private String convertZuluToDate(String value) {
        if (value != null && value.contains("T")) {
            return value.substring(0, value.indexOf("T"));
        }
        return value;
    }

    public GraphExchangeSession(HttpClientAdapter httpClient, O365Token token, String userName) throws IOException {
        this.httpClient = httpClient;
        this.token = token;
        this.userName = userName;
        this.buildSessionInfo(httpClient.getUri());
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    @Override
    public String formatSearchDate(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        dateFormatter.setTimeZone(GMT_TIMEZONE);
        return dateFormatter.format(date);
    }

    @Override
    protected void buildSessionInfo(URI uri) throws IOException {
        this.currentMailboxPath = USERS_ROOT + this.userName.toLowerCase();
        this.email = this.userName;
        this.alias = this.userName.substring(0, this.email.indexOf("@"));
        LOGGER.debug((Object)("Current user email is " + this.email + ", alias is " + this.alias));
    }

    @Override
    public ExchangeSession.Message createMessage(String folderPath, String messageName, HashMap<String, String> properties, MimeMessage mimeMessage) throws IOException {
        byte[] mimeContent = IOUtil.encodeBase64(mimeMessage);
        boolean isDraft = properties != null && ("8".equals(properties.get("draft")) || "9".equals(properties.get("draft")));
        FolderId folderId = this.getFolderId(folderPath);
        GraphObject graphResponse = this.executeGraphRequest(new GraphRequestBuilder().setMethod("POST").setContentType("text/plain").setMimeContent(mimeContent).setChildType("messages"));
        if (isDraft) {
            try {
                graphResponse = this.executeGraphRequest(new GraphRequestBuilder().setMethod("POST").setMailbox(folderId.mailbox).setObjectType("messages").setObjectId(graphResponse.optString("id")).setChildType("move").setJsonBody(new JSONObject().put("destinationId", (Object)folderId.id)));
                this.applyMessageProperties(graphResponse, properties);
                graphResponse = this.executeGraphRequest(new GraphRequestBuilder().setMethod("PATCH").setMailbox(folderId.mailbox).setObjectType("messages").setObjectId(graphResponse.optString("id")).setJsonBody(graphResponse.jsonObject));
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
        }
        String draftMessageId = null;
        try {
            draftMessageId = graphResponse.getString("id");
            graphResponse.put("singleValueExtendedProperties", new JSONArray().put((Object)new JSONObject().put("id", (Object)Field.get("messageFlags").getGraphId()).put("value", (Object)"4")));
            this.applyMessageProperties(graphResponse, properties);
            graphResponse = this.executeGraphRequest(new GraphRequestBuilder().setMethod("POST").setMailbox(folderId.mailbox).setObjectType("mailFolders").setObjectId(folderId.id).setJsonBody(graphResponse.jsonObject).setChildType("messages"));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        finally {
            if (draftMessageId != null) {
                this.executeJsonRequest(new GraphRequestBuilder().setMethod("DELETE").setObjectType("messages").setObjectId(draftMessageId));
            }
        }
        return this.buildMessage(this.executeJsonRequest(new GraphRequestBuilder().setMethod("GET").setObjectType("messages").setMailbox(folderId.mailbox).setObjectId(graphResponse.optString("id")).setExpandFields(IMAP_MESSAGE_ATTRIBUTES)));
    }

    private void applyMessageProperties(GraphObject graphResponse, Map<String, String> properties) throws JSONException {
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if ("read".equals(entry.getKey())) {
                    graphResponse.put(entry.getKey(), "1".equals(entry.getValue()));
                    continue;
                }
                if ("junk".equals(entry.getKey())) {
                    graphResponse.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if ("flagged".equals(entry.getKey())) {
                    graphResponse.put("flagStatus", entry.getValue());
                    continue;
                }
                if ("answered".equals(entry.getKey())) {
                    graphResponse.put("lastVerbExecuted", entry.getValue());
                    if (!"102".equals(entry.getValue())) continue;
                    graphResponse.put("iconIndex", "261");
                    continue;
                }
                if ("forwarded".equals(entry.getKey())) {
                    graphResponse.put("lastVerbExecuted", entry.getValue());
                    if (!"104".equals(entry.getValue())) continue;
                    graphResponse.put("iconIndex", "262");
                    continue;
                }
                if ("deleted".equals(entry.getKey())) {
                    graphResponse.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if ("datereceived".equals(entry.getKey())) {
                    graphResponse.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (!"keywords".equals(entry.getKey())) continue;
                graphResponse.setCategories(entry.getValue());
            }
        }
    }

    private Message buildMessage(JSONObject response) {
        JSONArray multiValueExtendedProperties;
        Message message = new Message();
        try {
            message.id = response.getString("id");
            message.changeKey = response.getString("changeKey");
            message.read = response.getBoolean("isRead");
            message.draft = response.getBoolean("isDraft");
            message.date = this.convertDateFromExchange(response.getString("receivedDateTime"));
            String lastmodified = this.convertDateFromExchange(response.optString("lastModifiedDateTime"));
            message.recent = !message.read && lastmodified != null && lastmodified.equals(message.date);
        }
        catch (DavMailException | JSONException e) {
            LOGGER.warn((Object)("Error parsing message " + e.getMessage()), e);
        }
        JSONArray singleValueExtendedProperties = response.optJSONArray("singleValueExtendedProperties");
        if (singleValueExtendedProperties != null) {
            for (int i = 0; i < singleValueExtendedProperties.length(); ++i) {
                try {
                    JSONObject responseValue = singleValueExtendedProperties.getJSONObject(i);
                    String responseId = responseValue.optString("id");
                    if (Field.get("imapUid").getGraphId().equals(responseId)) {
                        message.imapUid = responseValue.getLong("value");
                        continue;
                    }
                    if ("Integer 0xe08".equals(responseId)) {
                        message.size = responseValue.getInt("value");
                        continue;
                    }
                    if ("Binary 0xff9".equals(responseId)) {
                        message.uid = responseValue.getString("value");
                        continue;
                    }
                    if ("String 0x670E".equals(responseId)) {
                        message.permanentUrl = responseValue.getString("value");
                        continue;
                    }
                    if ("Integer 0x1081".equals(responseId)) {
                        String lastVerbExecuted = responseValue.getString("value");
                        message.answered = "102".equals(lastVerbExecuted) || "103".equals(lastVerbExecuted);
                        message.forwarded = "104".equals(lastVerbExecuted);
                        continue;
                    }
                    if ("String {00020386-0000-0000-C000-000000000046} Name content-class".equals(responseId)) {
                        message.contentClass = responseValue.getString("value");
                        continue;
                    }
                    if ("Integer 0x1083".equals(responseId)) {
                        message.junk = "1".equals(responseValue.getString("value"));
                        continue;
                    }
                    if ("Integer 0x1090".equals(responseId)) {
                        message.flagged = "2".equals(responseValue.getString("value"));
                        continue;
                    }
                    if (!"Integer {00062008-0000-0000-c000-000000000046} Name 0x8570".equals(responseId)) continue;
                    message.deleted = "1".equals(responseValue.getString("value"));
                    continue;
                }
                catch (JSONException e) {
                    LOGGER.warn((Object)"Error parsing json response value");
                }
            }
        }
        if ((multiValueExtendedProperties = response.optJSONArray("multiValueExtendedProperties")) != null) {
            for (int i = 0; i < multiValueExtendedProperties.length(); ++i) {
                try {
                    JSONObject responseValue = multiValueExtendedProperties.getJSONObject(i);
                    String responseId = responseValue.optString("id");
                    if (!Field.get("keywords").getGraphId().equals(responseId)) continue;
                    JSONArray keywordsJsonArray = responseValue.getJSONArray("value");
                    HashSet<String> keywords = new HashSet<String>();
                    for (int j = 0; j < keywordsJsonArray.length(); ++j) {
                        keywords.add(keywordsJsonArray.getString(j));
                    }
                    message.keywords = StringUtil.join(keywords, ",");
                    continue;
                }
                catch (JSONException e) {
                    LOGGER.warn((Object)"Error parsing json response value");
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Message");
            if (message.imapUid != 0L) {
                buffer.append(" IMAP uid: ").append(message.imapUid);
            }
            if (message.uid != null) {
                buffer.append(" uid: ").append(message.uid);
            }
            buffer.append(" ItemId: ").append(message.id);
            buffer.append(" ChangeKey: ").append(message.changeKey);
            LOGGER.debug((Object)buffer.toString());
        }
        return message;
    }

    protected String convertDateFromExchange(String exchangeDateValue) throws DavMailException {
        if (exchangeDateValue == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (exchangeDateValue.length() >= 25 || exchangeDateValue.length() == 20 || exchangeDateValue.length() == 10) {
            for (int i = 0; i < exchangeDateValue.length(); ++i) {
                if (i == 4 || i == 7 || i == 13 || i == 16) {
                    ++i;
                } else if (exchangeDateValue.length() >= 25 && i == 19) {
                    i = exchangeDateValue.length() - 1;
                }
                buffer.append(exchangeDateValue.charAt(i));
            }
            if (exchangeDateValue.length() == 10) {
                buffer.append("T000000Z");
            }
        } else {
            throw new DavMailException("EXCEPTION_INVALID_DATE", exchangeDateValue);
        }
        return buffer.toString();
    }

    @Override
    public void updateMessage(ExchangeSession.Message message, Map<String, String> properties) throws IOException {
        try {
            GraphObject graphObject = new GraphObject(new JSONObject());
            this.applyMessageProperties(graphObject, properties);
            this.executeJsonRequest(new GraphRequestBuilder().setMethod("PATCH").setMailbox(((Message)message).folderId.mailbox).setObjectType("messages").setObjectId(((Message)message).id).setJsonBody(graphObject.jsonObject));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteMessage(ExchangeSession.Message message) throws IOException {
        this.executeJsonRequest(new GraphRequestBuilder().setMethod("DELETE").setMailbox(((Message)message).folderId.mailbox).setObjectType("messages").setObjectId(((Message)message).id));
    }

    @Override
    protected byte[] getContent(final ExchangeSession.Message message) throws IOException {
        byte[] mimeContent;
        GraphRequestBuilder graphRequestBuilder = new GraphRequestBuilder().setMethod("GET").setMailbox(((Message)message).folderId.mailbox).setObjectType("messages").setObjectId(message.getPermanentId()).setChildType("$value").setAccessToken(this.token.getAccessToken());
        try (CloseableHttpResponse response = this.httpClient.execute(graphRequestBuilder.build());
             InputStream inputStream = response.getEntity().getContent();){
            FilterInputStream filterInputStream = new FilterInputStream(inputStream){
                int totalCount;
                int lastLogCount;

                @Override
                public int read(byte[] buffer, int offset, int length) throws IOException {
                    int count = super.read(buffer, offset, length);
                    this.totalCount += count;
                    if (this.totalCount - this.lastLogCount > 131072) {
                        DavGatewayTray.debug(new BundleMessage("LOG_DOWNLOAD_PROGRESS", String.valueOf(this.totalCount / 1024), message.getPermanentId()));
                        DavGatewayTray.switchIcon();
                        this.lastLogCount = this.totalCount;
                    }
                    return count;
                }
            };
            mimeContent = HttpClientAdapter.isGzipEncoded((HttpResponse)response) ? IOUtil.readFully(new GZIPInputStream(filterInputStream)) : IOUtil.readFully(filterInputStream);
        }
        return mimeContent;
    }

    @Override
    public ExchangeSession.MessageList searchMessages(String folderName, Set<String> attributes, ExchangeSession.Condition condition) throws IOException {
        ExchangeSession.MessageList messageList = new ExchangeSession.MessageList();
        FolderId folderId = this.getFolderId(folderName);
        GraphRequestBuilder httpRequestBuilder = new GraphRequestBuilder().setMethod("GET").setMailbox(folderId.mailbox).setObjectType("mailFolders").setObjectId(folderId.id).setChildType("messages").setExpandFields(IMAP_MESSAGE_ATTRIBUTES).setFilter(condition);
        LOGGER.debug((Object)("searchMessages " + folderId.mailbox + " " + folderName));
        GraphIterator graphIterator = this.executeSearchRequest(httpRequestBuilder);
        while (graphIterator.hasNext()) {
            Message message = this.buildMessage(graphIterator.next());
            message.messageList = messageList;
            message.folderId = folderId;
            messageList.add(message);
        }
        Collections.sort(messageList);
        return messageList;
    }

    @Override
    public ExchangeSession.MultiCondition and(ExchangeSession.Condition ... conditions) {
        return new MultiCondition(ExchangeSession.Operator.And, conditions);
    }

    @Override
    public ExchangeSession.MultiCondition or(ExchangeSession.Condition ... conditions) {
        return new MultiCondition(ExchangeSession.Operator.Or, conditions);
    }

    @Override
    public ExchangeSession.Condition not(ExchangeSession.Condition condition) {
        return new NotCondition(condition);
    }

    @Override
    public ExchangeSession.Condition isEqualTo(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsEqualTo, value);
    }

    @Override
    public ExchangeSession.Condition isEqualTo(String attributeName, int value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsEqualTo, String.valueOf(value));
    }

    @Override
    public ExchangeSession.Condition headerIsEqualTo(String headerName, String value) {
        return new HeaderCondition(headerName, value);
    }

    @Override
    public ExchangeSession.Condition gte(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsGreaterThanOrEqualTo, value);
    }

    @Override
    public ExchangeSession.Condition gt(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsGreaterThan, value);
    }

    @Override
    public ExchangeSession.Condition lt(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsLessThan, value);
    }

    @Override
    public ExchangeSession.Condition lte(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsLessThanOrEqualTo, value);
    }

    @Override
    public ExchangeSession.Condition contains(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.Contains, value);
    }

    @Override
    public ExchangeSession.Condition startsWith(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.StartsWith, value);
    }

    @Override
    public ExchangeSession.Condition isNull(String attributeName) {
        return new IsNullCondition(attributeName);
    }

    @Override
    public ExchangeSession.Condition exists(String attributeName) {
        return new ExistsCondition(attributeName);
    }

    @Override
    public ExchangeSession.Condition isTrue(String attributeName) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsEqualTo, "true");
    }

    @Override
    public ExchangeSession.Condition isFalse(String attributeName) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsEqualTo, "false");
    }

    @Override
    public List<ExchangeSession.Folder> getSubFolders(String folderPath, ExchangeSession.Condition condition, boolean recursive) throws IOException {
        int index;
        String baseFolderPath = folderPath;
        if (baseFolderPath.startsWith(USERS_ROOT) && (index = baseFolderPath.indexOf(47, USERS_ROOT.length())) >= 0) {
            baseFolderPath = baseFolderPath.substring(index + 1);
        }
        ArrayList<ExchangeSession.Folder> folders = new ArrayList<ExchangeSession.Folder>();
        this.appendSubFolders(folders, baseFolderPath, this.getFolderId(folderPath), condition, recursive);
        return folders;
    }

    protected void appendSubFolders(List<ExchangeSession.Folder> folders, String parentFolderPath, FolderId parentFolderId, ExchangeSession.Condition condition, boolean recursive) throws IOException {
        GraphRequestBuilder httpRequestBuilder = new GraphRequestBuilder().setMethod("GET").setObjectType("mailFolders").setMailbox(parentFolderId.mailbox).setObjectId(parentFolderId.id).setChildType("childFolders").setExpandFields(FOLDER_PROPERTIES).setFilter(condition);
        LOGGER.debug((Object)("appendSubFolders " + (parentFolderId.mailbox != null ? parentFolderId.mailbox : "me") + " " + parentFolderPath));
        GraphIterator graphIterator = this.executeSearchRequest(httpRequestBuilder);
        while (graphIterator.hasNext()) {
            Folder folder = this.buildFolder(graphIterator.next());
            folder.folderId.mailbox = parentFolderId.mailbox;
            if (parentFolderId.id.equals(folder.folderId.parentFolderId)) {
                folder.folderPath = !parentFolderPath.isEmpty() ? (parentFolderPath.endsWith("/") ? parentFolderPath + folder.displayName : parentFolderPath + '/' + folder.displayName) : folder.displayName;
                folders.add(folder);
                if (!recursive || !folder.hasChildren) continue;
                this.appendSubFolders(folders, folder.folderPath, folder.folderId, condition, true);
                continue;
            }
            LOGGER.debug((Object)("appendSubFolders skip " + folder.folderId.mailbox + " " + folder.folderId.id + " " + folder.displayName + " not a child of " + parentFolderPath));
        }
    }

    @Override
    public void sendMessage(MimeMessage mimeMessage) throws IOException, MessagingException {
        this.executeJsonRequest(new GraphRequestBuilder().setMethod("POST").setObjectType("sendMail").setContentType("text/plain").setMimeContent(IOUtil.encodeBase64(mimeMessage)));
    }

    @Override
    protected Folder internalGetFolder(String folderPath) throws IOException {
        FolderId folderId = this.getFolderId(folderPath);
        GraphRequestBuilder httpRequestBuilder = new GraphRequestBuilder().setMethod("GET").setMailbox(folderId.mailbox).setObjectId(folderId.id);
        if ("IPF.Appointment".equals(folderId.folderClass)) {
            httpRequestBuilder.setExpandFields(FOLDER_PROPERTIES).setObjectType("calendars");
        } else if ("IPF.Task".equals(folderId.folderClass)) {
            httpRequestBuilder.setObjectType("todo/lists");
        } else if ("IPF.Contact".equals(folderId.folderClass)) {
            httpRequestBuilder.setExpandFields(FOLDER_PROPERTIES).setObjectType("contactFolders");
        } else {
            httpRequestBuilder.setExpandFields(FOLDER_PROPERTIES).setObjectType("mailFolders");
        }
        JSONObject jsonResponse = this.executeJsonRequest(httpRequestBuilder);
        Folder folder = this.buildFolder(jsonResponse);
        folder.folderPath = folderPath;
        return folder;
    }

    private Folder buildFolder(JSONObject jsonResponse) throws IOException {
        try {
            Folder folder = new Folder();
            folder.folderId = new FolderId();
            folder.folderId.id = jsonResponse.getString("id");
            folder.folderId.parentFolderId = jsonResponse.optString("parentFolderId", null);
            if (folder.folderId.parentFolderId == null) {
                folder.displayName = StringUtil.encodeFolderName(jsonResponse.optString("name"));
            } else {
                String wellKnownName = wellKnownFolderMap.get(jsonResponse.optString("wellKnownName"));
                if ("INBOX".equals(wellKnownName)) {
                    folder.displayName = wellKnownName;
                } else {
                    if (wellKnownName != null) {
                        folder.setSpecialFlag(wellKnownName);
                    }
                    folder.displayName = StringUtil.encodeFolderName(jsonResponse.getString("displayName"));
                }
                folder.messageCount = jsonResponse.optInt("totalItemCount");
                folder.recent = folder.unreadCount = jsonResponse.optInt("unreadItemCount");
                folder.hasChildren = jsonResponse.optInt("childFolderCount") > 0;
            }
            JSONArray singleValueExtendedProperties = jsonResponse.optJSONArray("singleValueExtendedProperties");
            if (singleValueExtendedProperties != null) {
                for (int i = 0; i < singleValueExtendedProperties.length(); ++i) {
                    JSONObject singleValueProperty = singleValueExtendedProperties.getJSONObject(i);
                    String singleValueId = singleValueProperty.getString("id");
                    String singleValue = singleValueProperty.getString("value");
                    if (Field.get("lastmodified").getGraphId().equals(singleValueId)) {
                        folder.etag = singleValue;
                        continue;
                    }
                    if (Field.get("folderclass").getGraphId().equals(singleValueId)) {
                        folder.folderId.folderClass = folder.folderClass = singleValue;
                        continue;
                    }
                    if (Field.get("uidNext").getGraphId().equals(singleValueId)) {
                        folder.uidNext = Long.parseLong(singleValue);
                        continue;
                    }
                    if (!Field.get("ctag").getGraphId().equals(singleValueId)) continue;
                    folder.ctag = singleValue;
                }
            }
            return folder;
        }
        catch (JSONException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private FolderId getFolderId(String folderPath) throws IOException {
        FolderId folderId = this.getFolderIdIfExists(folderPath);
        if (folderId == null) {
            throw new HttpNotFoundException("Folder '" + folderPath + "' not found");
        }
        return folderId;
    }

    private FolderId getFolderIdIfExists(String folderPath) throws IOException {
        String lowerCaseFolderPath = folderPath.toLowerCase();
        if (lowerCaseFolderPath.equals(this.currentMailboxPath)) {
            return this.getSubFolderIdIfExists(null, "");
        }
        if (lowerCaseFolderPath.startsWith(this.currentMailboxPath + '/')) {
            return this.getSubFolderIdIfExists(null, folderPath.substring(this.currentMailboxPath.length() + 1));
        }
        if (folderPath.startsWith(USERS_ROOT)) {
            String subFolderPath;
            String mailbox;
            int slashIndex = folderPath.indexOf(47, USERS_ROOT.length());
            if (slashIndex >= 0) {
                mailbox = folderPath.substring(USERS_ROOT.length(), slashIndex);
                subFolderPath = folderPath.substring(slashIndex + 1);
            } else {
                mailbox = folderPath.substring(USERS_ROOT.length());
                subFolderPath = "";
            }
            return this.getSubFolderIdIfExists(mailbox, subFolderPath);
        }
        return this.getSubFolderIdIfExists(null, folderPath);
    }

    private FolderId getSubFolderIdIfExists(String mailbox, String folderPath) throws IOException {
        String[] folderNames;
        FolderId currentFolderId;
        if ("/public".equals(folderPath)) {
            throw new UnsupportedOperationException("public folders not supported on Graph");
        }
        if ("/archive".equals(folderPath)) {
            return this.getWellKnownFolderId(mailbox, WellKnownFolderName.archive);
        }
        if (this.isSubFolderOf(folderPath, "/public/")) {
            throw new UnsupportedOperationException("public folders not supported on Graph");
        }
        if (this.isSubFolderOf(folderPath, ARCHIVE_ROOT)) {
            currentFolderId = this.getWellKnownFolderId(mailbox, WellKnownFolderName.archive);
            folderNames = folderPath.substring(ARCHIVE_ROOT.length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "INBOX") || this.isSubFolderOf(folderPath, "inbox") || this.isSubFolderOf(folderPath, "Inbox")) {
            currentFolderId = this.getWellKnownFolderId(mailbox, WellKnownFolderName.inbox);
            folderNames = folderPath.substring("INBOX".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "calendar")) {
            currentFolderId = new FolderId(mailbox, WellKnownFolderName.calendar, "IPF.Appointment");
            folderNames = folderPath.substring("calendar".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "tasks")) {
            currentFolderId = this.getWellKnownFolderId(mailbox, WellKnownFolderName.tasks);
            folderNames = folderPath.substring("tasks".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "contacts")) {
            currentFolderId = new FolderId(mailbox, WellKnownFolderName.contacts, "IPF.Contact");
            folderNames = folderPath.substring("contacts".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "Sent")) {
            currentFolderId = new FolderId(mailbox, WellKnownFolderName.sentitems);
            folderNames = folderPath.substring("Sent".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "Drafts")) {
            currentFolderId = new FolderId(mailbox, WellKnownFolderName.drafts);
            folderNames = folderPath.substring("Drafts".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "Trash")) {
            currentFolderId = new FolderId(mailbox, WellKnownFolderName.deleteditems);
            folderNames = folderPath.substring("Trash".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "Junk")) {
            currentFolderId = new FolderId(mailbox, WellKnownFolderName.junkemail);
            folderNames = folderPath.substring("Junk".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "Unsent Messages")) {
            currentFolderId = new FolderId(mailbox, WellKnownFolderName.outbox);
            folderNames = folderPath.substring("Unsent Messages".length()).split("/");
        } else {
            currentFolderId = this.getWellKnownFolderId(mailbox, WellKnownFolderName.msgfolderroot);
            folderNames = folderPath.split("/");
        }
        String folderClass = currentFolderId.folderClass;
        for (String folderName : folderNames) {
            if (folderName.isEmpty()) continue;
            if ((currentFolderId = this.getSubFolderByName(currentFolderId, folderName)) == null) break;
            currentFolderId.folderClass = folderClass;
        }
        return currentFolderId;
    }

    private FolderId getWellKnownFolderId(String mailbox, WellKnownFolderName wellKnownFolderName) throws IOException {
        if (wellKnownFolderName == WellKnownFolderName.tasks) {
            GraphIterator graphIterator = this.executeSearchRequest(new GraphRequestBuilder().setMethod("GET").setMailbox(mailbox).setObjectType("todo/lists"));
            while (graphIterator.hasNext()) {
                JSONObject jsonResponse = graphIterator.next();
                if (!jsonResponse.optString("wellknownListName").equals("defaultList")) continue;
                return new FolderId(mailbox, jsonResponse.optString("id"), "IPF.Task");
            }
            throw new HttpNotFoundException("Folder '" + wellKnownFolderName.name() + "' not found");
        }
        JSONObject jsonResponse = this.executeJsonRequest(new GraphRequestBuilder().setMethod("GET").setMailbox(mailbox).setObjectType("mailFolders").setObjectId(wellKnownFolderName.name()).setExpandFields(FOLDER_PROPERTIES));
        return new FolderId(mailbox, jsonResponse.optString("id"), "IPF.Note");
    }

    protected FolderId getSubFolderByName(FolderId currentFolderId, String folderName) throws IOException {
        GraphRequestBuilder httpRequestBuilder;
        if ("IPF.Appointment".equals(currentFolderId.folderClass)) {
            httpRequestBuilder = new GraphRequestBuilder().setMethod("GET").setMailbox(currentFolderId.mailbox).setObjectType("calendars").setExpandFields(FOLDER_PROPERTIES).setFilter("name eq '" + StringUtil.escapeQuotes(StringUtil.decodeFolderName(folderName)) + "'");
        } else if ("IPF.Task".equals(currentFolderId.folderClass)) {
            httpRequestBuilder = new GraphRequestBuilder().setMethod("GET").setMailbox(currentFolderId.mailbox).setObjectType("todo/lists").setExpandFields(FOLDER_PROPERTIES).setFilter("displayName eq '" + StringUtil.escapeQuotes(StringUtil.decodeFolderName(folderName)) + "'");
        } else {
            String objectType = "mailFolders";
            if ("IPF.Contact".equals(currentFolderId.folderClass)) {
                objectType = "contactFolders";
            }
            httpRequestBuilder = new GraphRequestBuilder().setMethod("GET").setMailbox(currentFolderId.mailbox).setObjectType(objectType).setObjectId(currentFolderId.id).setChildType("childFolders").setExpandFields(FOLDER_PROPERTIES).setFilter("displayName eq '" + StringUtil.escapeQuotes(StringUtil.decodeFolderName(folderName)) + "'");
        }
        JSONObject jsonResponse = this.executeJsonRequest(httpRequestBuilder);
        FolderId folderId = null;
        try {
            JSONArray values = jsonResponse.getJSONArray("value");
            if (values.length() > 0) {
                folderId = new FolderId(currentFolderId.mailbox, values.getJSONObject(0).getString("id"), currentFolderId.folderClass);
                folderId.parentFolderId = currentFolderId.id;
            }
        }
        catch (JSONException e) {
            throw new IOException(e.getMessage(), e);
        }
        return folderId;
    }

    private boolean isSubFolderOf(String folderPath, String baseFolder) {
        if ("/public/".equals(baseFolder) || ARCHIVE_ROOT.equals(baseFolder)) {
            return folderPath.startsWith(baseFolder);
        }
        return folderPath.startsWith(baseFolder) && (folderPath.length() == baseFolder.length() || folderPath.charAt(baseFolder.length()) == '/');
    }

    @Override
    public int createFolder(String folderPath, String folderClass, Map<String, String> properties) throws IOException {
        String folderName;
        FolderId parentFolderId;
        if ("IPF.Appointment".equals(folderClass) && folderPath.startsWith("calendar/")) {
            String calendarName = folderPath.substring(folderPath.indexOf(47) + 1);
            try {
                this.executeJsonRequest(new GraphRequestBuilder().setMethod("POST").setObjectType("calendars").setJsonBody(new JSONObject().put("name", (Object)calendarName)));
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
        }
        if (folderPath.contains("/")) {
            String parentFolderPath = folderPath.substring(0, folderPath.lastIndexOf(47));
            parentFolderId = this.getFolderId(parentFolderPath);
            folderName = StringUtil.decodeFolderName(folderPath.substring(folderPath.lastIndexOf(47) + 1));
        } else {
            parentFolderId = this.getFolderId("");
            folderName = StringUtil.decodeFolderName(folderPath);
        }
        try {
            String objectType = "mailFolders";
            if ("IPF.Contact".equals(folderClass)) {
                objectType = "contactFolders";
            }
            this.executeJsonRequest(new GraphRequestBuilder().setMethod("POST").setMailbox(parentFolderId.mailbox).setObjectType(objectType).setObjectId(parentFolderId.id).setChildType("childFolders").setJsonBody(new JSONObject().put("displayName", (Object)folderName)));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        return 201;
    }

    @Override
    public int updateFolder(String folderName, Map<String, String> properties) throws IOException {
        return 0;
    }

    @Override
    public void deleteFolder(String folderPath) throws IOException {
        FolderId folderId = this.getFolderIdIfExists(folderPath);
        if (folderPath.startsWith("calendar/")) {
            if (folderId != null) {
                this.executeJsonRequest(new GraphRequestBuilder().setMethod("DELETE").setObjectType("calendars").setObjectId(folderId.id));
            }
        } else if (folderId != null) {
            String objectType = "mailFolders";
            if ("IPF.Contact".equals(folderId.folderClass)) {
                objectType = "contactFolders";
            }
            this.executeJsonRequest(new GraphRequestBuilder().setMethod("DELETE").setMailbox(folderId.mailbox).setObjectType(objectType).setObjectId(folderId.id));
        }
    }

    @Override
    public void copyMessage(ExchangeSession.Message message, String targetFolder) throws IOException {
        try {
            FolderId targetFolderId = this.getFolderId(targetFolder);
            this.executeJsonRequest(new GraphRequestBuilder().setMethod("POST").setMailbox(((Message)message).folderId.mailbox).setObjectType("messages").setObjectId(((Message)message).id).setChildType("copy").setJsonBody(new JSONObject().put("destinationId", (Object)targetFolderId.id)));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void moveMessage(ExchangeSession.Message message, String targetFolder) throws IOException {
        try {
            FolderId targetFolderId = this.getFolderId(targetFolder);
            this.executeJsonRequest(new GraphRequestBuilder().setMethod("POST").setMailbox(((Message)message).folderId.mailbox).setObjectType("messages").setObjectId(((Message)message).id).setChildType("move").setJsonBody(new JSONObject().put("destinationId", (Object)targetFolderId.id)));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void moveFolder(String folderPath, String targetFolderPath) throws IOException {
        String targetFolderName;
        String targetFolderParentPath;
        FolderId folderId = this.getFolderId(folderPath);
        if (targetFolderPath.contains("/")) {
            targetFolderParentPath = targetFolderPath.substring(0, targetFolderPath.lastIndexOf(47));
            targetFolderName = StringUtil.decodeFolderName(targetFolderPath.substring(targetFolderPath.lastIndexOf(47) + 1));
        } else {
            targetFolderParentPath = "";
            targetFolderName = StringUtil.decodeFolderName(targetFolderPath);
        }
        FolderId targetFolderId = this.getFolderId(targetFolderParentPath);
        try {
            this.executeJsonRequest(new GraphRequestBuilder().setMethod("PATCH").setMailbox(folderId.mailbox).setObjectType("mailFolders").setObjectId(folderId.id).setJsonBody(new JSONObject().put("displayName", (Object)targetFolderName)));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        try {
            this.executeJsonRequest(new GraphRequestBuilder().setMethod("POST").setMailbox(folderId.mailbox).setObjectType("mailFolders").setObjectId(folderId.id).setChildType("move").setJsonBody(new JSONObject().put("destinationId", (Object)targetFolderId.id)));
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void moveItem(String sourcePath, String targetPath) throws IOException {
    }

    @Override
    protected void moveToTrash(ExchangeSession.Message message) throws IOException {
        this.moveMessage(message, WellKnownFolderName.deleteditems.name());
    }

    @Override
    protected Set<String> getItemProperties() {
        return ITEM_PROPERTIES;
    }

    @Override
    public List<ExchangeSession.Contact> searchContacts(String folderPath, Set<String> attributes, ExchangeSession.Condition condition, int maxCount) throws IOException {
        ArrayList<ExchangeSession.Contact> contactList = new ArrayList<ExchangeSession.Contact>();
        FolderId folderId = this.getFolderId(folderPath);
        GraphRequestBuilder httpRequestBuilder = new GraphRequestBuilder().setMethod("GET").setMailbox(folderId.mailbox).setObjectType("contactFolders").setObjectId(folderId.id).setChildType("contacts").setExpandFields(CONTACT_ATTRIBUTES).setFilter(condition);
        LOGGER.debug((Object)("searchContacts " + folderId.mailbox + " " + folderPath));
        GraphIterator graphIterator = this.executeSearchRequest(httpRequestBuilder);
        while (graphIterator.hasNext()) {
            Contact contact = new Contact(new GraphObject(graphIterator.next()));
            contact.folderId = folderId;
            contactList.add(contact);
        }
        return contactList;
    }

    @Override
    public List<ExchangeSession.Event> getEventMessages(String folderPath) throws IOException {
        return null;
    }

    @Override
    protected ExchangeSession.Condition getCalendarItemCondition(ExchangeSession.Condition dateCondition) {
        return dateCondition;
    }

    @Override
    public List<ExchangeSession.Event> searchTasksOnly(String folderPath) throws IOException {
        ArrayList<ExchangeSession.Event> eventList = new ArrayList<ExchangeSession.Event>();
        FolderId folderId = this.getFolderId(folderPath);
        GraphRequestBuilder httpRequestBuilder = new GraphRequestBuilder().setMethod("GET").setMailbox(folderId.mailbox).setObjectType("todo/lists").setObjectId(folderId.id).setChildType("tasks").setExpandFields(TODO_PROPERTIES);
        LOGGER.debug((Object)("searchTasksOnly " + folderId.mailbox + " " + folderPath));
        GraphIterator graphIterator = this.executeSearchRequest(httpRequestBuilder);
        while (graphIterator.hasNext()) {
            Event event = new Event(folderId, new GraphObject(graphIterator.next()));
            eventList.add(event);
        }
        return eventList;
    }

    @Override
    public List<ExchangeSession.Event> searchEvents(String folderPath, Set<String> attributes, ExchangeSession.Condition condition) throws IOException {
        ArrayList<ExchangeSession.Event> eventList = new ArrayList<ExchangeSession.Event>();
        FolderId folderId = this.getFolderId(folderPath);
        GraphRequestBuilder httpRequestBuilder = new GraphRequestBuilder().setMethod("GET").setMailbox(folderId.mailbox).setObjectType("calendars").setObjectId(folderId.id).setChildType("events").setExpandFields(EVENT_ATTRIBUTES).setTimezone(this.getVTimezone().getPropertyValue("TZID")).setFilter(condition);
        LOGGER.debug((Object)("searchEvents " + folderId.mailbox + " " + folderPath));
        GraphIterator graphIterator = this.executeSearchRequest(httpRequestBuilder);
        while (graphIterator.hasNext()) {
            Event event = new Event(folderId, new GraphObject(graphIterator.next()));
            eventList.add(event);
        }
        return eventList;
    }

    @Override
    public ExchangeSession.Item getItem(String folderPath, String itemName) throws IOException {
        FolderId folderId = this.getFolderId(folderPath);
        if ("IPF.Contact".equals(folderId.folderClass)) {
            JSONObject jsonResponse = this.getContactIfExists(folderId, itemName);
            if (jsonResponse != null) {
                Contact contact = new Contact(new GraphObject(jsonResponse));
                contact.folderId = folderId;
                return contact;
            }
            throw new IOException("Item " + folderPath + " " + itemName + " not found");
        }
        if ("IPF.Appointment".equals(folderId.folderClass)) {
            JSONObject jsonResponse = this.getEventIfExists(folderId, itemName);
            if (jsonResponse != null) {
                return new Event(folderId, new GraphObject(jsonResponse));
            }
            throw new IOException("Item " + folderPath + " " + itemName + " not found");
        }
        throw new UnsupportedOperationException("Item type " + folderId.folderClass + " not supported");
    }

    private JSONObject getEventIfExists(FolderId folderId, String itemName) throws IOException {
        if (!GraphExchangeSession.isItemId(itemName)) {
            return null;
        }
        String itemId = itemName.substring(0, itemName.length() - 4);
        try {
            return this.executeJsonRequest(new GraphRequestBuilder().setMethod("GET").setMailbox(folderId.mailbox).setObjectType("events").setObjectId(itemId).setSelect(EVENT_SELECT).setExpandFields(EVENT_ATTRIBUTES).setTimezone(this.getVTimezone().getPropertyValue("TZID")));
        }
        catch (HttpNotFoundException e) {
            FolderId taskFolderId = this.getFolderId("tasks");
            return this.executeJsonRequest(new GraphRequestBuilder().setMethod("GET").setMailbox(folderId.mailbox).setObjectType("todo/lists").setObjectId(taskFolderId.id).setChildType("tasks").setChildId(itemId).setExpandFields(TODO_PROPERTIES));
        }
    }

    private JSONObject getContactIfExists(FolderId folderId, String itemName) throws IOException {
        if (GraphExchangeSession.isItemId(itemName)) {
            return this.executeJsonRequest(new GraphRequestBuilder().setMethod("GET").setMailbox(folderId.mailbox).setObjectType("contactFolders").setObjectId(folderId.id).setChildType("contacts").setChildId(itemName.substring(0, itemName.length() - ".EML".length())).setExpandFields(CONTACT_ATTRIBUTES));
        }
        JSONObject jsonResponse = this.executeJsonRequest(new GraphRequestBuilder().setMethod("GET").setMailbox(folderId.mailbox).setObjectType("contactFolders").setObjectId(folderId.id).setChildType("contacts").setFilter(this.isEqualTo("urlcompname", this.convertItemNameToEML(itemName))).setExpandFields(CONTACT_ATTRIBUTES));
        JSONArray values = jsonResponse.optJSONArray("value");
        if (values != null && values.length() > 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Contact " + values.optJSONObject(0)));
            }
            return values.optJSONObject(0);
        }
        return null;
    }

    @Override
    public ExchangeSession.ContactPhoto getContactPhoto(ExchangeSession.Contact contact) throws IOException {
        byte[] contactPhotoBytes;
        GraphRequestBuilder graphRequestBuilder = new GraphRequestBuilder().setMethod("GET").setMailbox(((Contact)contact).folderId.mailbox).setObjectType("contactFolders").setObjectId(((Contact)contact).folderId.id).setChildType("contacts").setChildId(((Contact)contact).id).setChildSuffix("photo/$value");
        try (CloseableHttpResponse response = this.httpClient.execute(graphRequestBuilder.build());
             InputStream inputStream = response.getEntity().getContent();){
            contactPhotoBytes = HttpClientAdapter.isGzipEncoded((HttpResponse)response) ? IOUtil.readFully(new GZIPInputStream(inputStream)) : IOUtil.readFully(inputStream);
        }
        ExchangeSession.ContactPhoto contactPhoto = new ExchangeSession.ContactPhoto();
        contactPhoto.contentType = "image/jpeg";
        contactPhoto.content = IOUtil.encodeBase64AsString(contactPhotoBytes);
        return contactPhoto;
    }

    @Override
    public void deleteItem(String folderPath, String itemName) throws IOException {
    }

    @Override
    public void processItem(String folderPath, String itemName) throws IOException {
    }

    @Override
    public int sendEvent(String icsBody) throws IOException {
        return 0;
    }

    @Override
    protected Contact buildContact(String folderPath, String itemName, Map<String, String> properties, String etag, String noneMatch) throws IOException {
        return new Contact(folderPath, itemName, properties, StringUtil.removeQuotes(etag), noneMatch);
    }

    @Override
    protected ExchangeSession.ItemResult internalCreateOrUpdateEvent(String folderPath, String itemName, String contentClass, String icsBody, String etag, String noneMatch) throws IOException {
        return new Event(folderPath, itemName, contentClass, icsBody, StringUtil.removeQuotes(etag), noneMatch).createOrUpdate();
    }

    @Override
    public boolean isSharedFolder(String folderPath) {
        return false;
    }

    @Override
    public boolean isMainCalendar(String folderPath) throws IOException {
        FolderId folderId = this.getFolderIdIfExists(folderPath);
        return folderId.parentFolderId == null && WellKnownFolderName.calendar.name().equals(folderId.id);
    }

    @Override
    public Map<String, ExchangeSession.Contact> galFind(ExchangeSession.Condition condition, Set<String> returningAttributes, int sizeLimit) throws IOException {
        return null;
    }

    @Override
    protected String getFreeBusyData(String attendee, String start, String end, int interval) throws IOException {
        return null;
    }

    @Override
    protected void loadVtimezone() {
        try {
            String timezoneId = Settings.getProperty("davmail.timezoneId", null);
            if (timezoneId == null) {
                try {
                    timezoneId = this.getMailboxSettings().optString("timeZone", null);
                }
                catch (HttpForbiddenException e) {
                    LOGGER.warn((Object)"token does not grant MailboxSettings.Read");
                }
            }
            if (timezoneId == null) {
                LOGGER.warn((Object)"Unable to get user timezone, using GMT Standard Time. Set davmail.timezoneId setting to override this.");
                timezoneId = "GMT Standard Time";
            }
            this.vTimezone = new VObject(ResourceBundle.getBundle("vtimezones").getString(timezoneId));
        }
        catch (IOException | MissingResourceException e) {
            LOGGER.warn((Object)("Unable to get VTIMEZONE info: " + e), (Throwable)e);
        }
    }

    private JSONObject getMailboxSettings() throws IOException {
        return this.executeJsonRequest(new GraphRequestBuilder().setMethod("GET").setObjectType("mailboxSettings"));
    }

    private GraphIterator executeSearchRequest(GraphRequestBuilder httpRequestBuilder) throws IOException {
        try {
            return new GraphIterator(this.executeJsonRequest(httpRequestBuilder));
        }
        catch (JSONException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private JSONObject executeJsonRequest(GraphRequestBuilder httpRequestBuilder) throws IOException {
        JSONObject jsonResponse;
        HttpRequestBase request = httpRequestBuilder.setAccessToken(this.token.getAccessToken()).build();
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            if (response.getStatusLine().getStatusCode() == 400) {
                LOGGER.warn((Object)("Request returned " + response.getStatusLine()));
            }
            jsonResponse = new JsonResponseHandler().handleResponse((HttpResponse)response);
        }
        return jsonResponse;
    }

    private GraphObject executeGraphRequest(GraphRequestBuilder httpRequestBuilder) throws IOException {
        GraphObject graphObject;
        HttpRequestBase request = httpRequestBuilder.setAccessToken(this.token.getAccessToken()).build();
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            if (response.getStatusLine().getStatusCode() == 400) {
                LOGGER.warn((Object)("Request returned " + response.getStatusLine()));
            }
            graphObject = new GraphObject(new JsonResponseHandler().handleResponse((HttpResponse)response));
            graphObject.statusCode = response.getStatusLine().getStatusCode();
        }
        return graphObject;
    }

    protected static boolean isItemId(String itemName) {
        return itemName.length() >= 140 && itemName.matches("^([A-Za-z0-9-_]{4})*([A-Za-z0-9-_]{4}|[A-Za-z0-9-_]{3}=|[A-Za-z0-9-_]{2}==)\\.EML$") && itemName.indexOf(32) < 0;
    }

    static {
        wellKnownFolderMap.put(WellKnownFolderName.inbox.name(), "INBOX");
        wellKnownFolderMap.put(WellKnownFolderName.archive.name(), "Archive");
        wellKnownFolderMap.put(WellKnownFolderName.drafts.name(), "Drafts");
        wellKnownFolderMap.put(WellKnownFolderName.junkemail.name(), "Junk");
        wellKnownFolderMap.put(WellKnownFolderName.sentitems.name(), "Sent");
        wellKnownFolderMap.put(WellKnownFolderName.deleteditems.name(), "Trash");
        IMAP_MESSAGE_ATTRIBUTES = new HashSet();
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("permanenturl"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("urlcompname"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("uid"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("messageSize"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("imapUid"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("junk"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("flagStatus"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("messageFlags"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("lastVerbExecuted"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("read"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("deleted"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("date"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("lastmodified"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("contentclass"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("keywords"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("to"));
        IMAP_MESSAGE_ATTRIBUTES.add(Field.get("messageheaders"));
        CONTACT_ATTRIBUTES = new HashSet();
        CONTACT_ATTRIBUTES.add(Field.get("imapUid"));
        CONTACT_ATTRIBUTES.add(Field.get("etag"));
        CONTACT_ATTRIBUTES.add(Field.get("urlcompname"));
        CONTACT_ATTRIBUTES.add(Field.get("extensionattribute1"));
        CONTACT_ATTRIBUTES.add(Field.get("extensionattribute2"));
        CONTACT_ATTRIBUTES.add(Field.get("extensionattribute3"));
        CONTACT_ATTRIBUTES.add(Field.get("extensionattribute4"));
        CONTACT_ATTRIBUTES.add(Field.get("bday"));
        CONTACT_ATTRIBUTES.add(Field.get("anniversary"));
        CONTACT_ATTRIBUTES.add(Field.get("businesshomepage"));
        CONTACT_ATTRIBUTES.add(Field.get("personalHomePage"));
        CONTACT_ATTRIBUTES.add(Field.get("cn"));
        CONTACT_ATTRIBUTES.add(Field.get("co"));
        CONTACT_ATTRIBUTES.add(Field.get("department"));
        CONTACT_ATTRIBUTES.add(Field.get("facsimiletelephonenumber"));
        CONTACT_ATTRIBUTES.add(Field.get("givenName"));
        CONTACT_ATTRIBUTES.add(Field.get("homeCity"));
        CONTACT_ATTRIBUTES.add(Field.get("homeCountry"));
        CONTACT_ATTRIBUTES.add(Field.get("homePhone"));
        CONTACT_ATTRIBUTES.add(Field.get("homePostalCode"));
        CONTACT_ATTRIBUTES.add(Field.get("homeState"));
        CONTACT_ATTRIBUTES.add(Field.get("homeStreet"));
        CONTACT_ATTRIBUTES.add(Field.get("homepostofficebox"));
        CONTACT_ATTRIBUTES.add(Field.get("l"));
        CONTACT_ATTRIBUTES.add(Field.get("manager"));
        CONTACT_ATTRIBUTES.add(Field.get("mobile"));
        CONTACT_ATTRIBUTES.add(Field.get("namesuffix"));
        CONTACT_ATTRIBUTES.add(Field.get("nickname"));
        CONTACT_ATTRIBUTES.add(Field.get("o"));
        CONTACT_ATTRIBUTES.add(Field.get("pager"));
        CONTACT_ATTRIBUTES.add(Field.get("personaltitle"));
        CONTACT_ATTRIBUTES.add(Field.get("postalcode"));
        CONTACT_ATTRIBUTES.add(Field.get("postofficebox"));
        CONTACT_ATTRIBUTES.add(Field.get("profession"));
        CONTACT_ATTRIBUTES.add(Field.get("roomnumber"));
        CONTACT_ATTRIBUTES.add(Field.get("secretarycn"));
        CONTACT_ATTRIBUTES.add(Field.get("sn"));
        CONTACT_ATTRIBUTES.add(Field.get("spousecn"));
        CONTACT_ATTRIBUTES.add(Field.get("st"));
        CONTACT_ATTRIBUTES.add(Field.get("street"));
        CONTACT_ATTRIBUTES.add(Field.get("telephoneNumber"));
        CONTACT_ATTRIBUTES.add(Field.get("title"));
        CONTACT_ATTRIBUTES.add(Field.get("description"));
        CONTACT_ATTRIBUTES.add(Field.get("im"));
        CONTACT_ATTRIBUTES.add(Field.get("middlename"));
        CONTACT_ATTRIBUTES.add(Field.get("lastmodified"));
        CONTACT_ATTRIBUTES.add(Field.get("otherstreet"));
        CONTACT_ATTRIBUTES.add(Field.get("otherstate"));
        CONTACT_ATTRIBUTES.add(Field.get("otherpostofficebox"));
        CONTACT_ATTRIBUTES.add(Field.get("otherpostalcode"));
        CONTACT_ATTRIBUTES.add(Field.get("othercountry"));
        CONTACT_ATTRIBUTES.add(Field.get("othercity"));
        CONTACT_ATTRIBUTES.add(Field.get("haspicture"));
        CONTACT_ATTRIBUTES.add(Field.get("keywords"));
        CONTACT_ATTRIBUTES.add(Field.get("othermobile"));
        CONTACT_ATTRIBUTES.add(Field.get("otherTelephone"));
        CONTACT_ATTRIBUTES.add(Field.get("gender"));
        CONTACT_ATTRIBUTES.add(Field.get("private"));
        CONTACT_ATTRIBUTES.add(Field.get("sensitivity"));
        CONTACT_ATTRIBUTES.add(Field.get("fburl"));
        TODO_PROPERTIES = new HashSet<FieldURI>();
        EVENT_ATTRIBUTES = new HashSet();
        FOLDER_PROPERTIES = new HashSet();
        FOLDER_PROPERTIES.add(Field.get("lastmodified"));
        FOLDER_PROPERTIES.add(Field.get("folderclass"));
        FOLDER_PROPERTIES.add(Field.get("ctag"));
        FOLDER_PROPERTIES.add(Field.get("uidNext"));
        ITEM_PROPERTIES = new HashSet<String>();
        EVENT_REQUEST_PROPERTIES = new HashSet();
        EVENT_REQUEST_PROPERTIES.add("permanenturl");
        EVENT_REQUEST_PROPERTIES.add("etag");
        EVENT_REQUEST_PROPERTIES.add("displayname");
        EVENT_REQUEST_PROPERTIES.add("subject");
        EVENT_REQUEST_PROPERTIES.add("urlcompname");
        EVENT_REQUEST_PROPERTIES.add("displayto");
        EVENT_REQUEST_PROPERTIES.add("displaycc");
        EVENT_REQUEST_PROPERTIES.add("xmozlastack");
        EVENT_REQUEST_PROPERTIES.add("xmozsnoozetime");
        CALENDAR_ITEM_REQUEST_PROPERTIES = new HashSet();
        CALENDAR_ITEM_REQUEST_PROPERTIES.addAll(EVENT_REQUEST_PROPERTIES);
        CALENDAR_ITEM_REQUEST_PROPERTIES.add("ismeeting");
        CALENDAR_ITEM_REQUEST_PROPERTIES.add("myresponsetype");
    }

    class GraphIterator {
        private JSONObject jsonObject;
        private JSONArray values;
        private String nextLink;
        private int index;

        public GraphIterator(JSONObject jsonObject) throws JSONException {
            this.jsonObject = jsonObject;
            this.nextLink = jsonObject.optString("@odata.nextLink", null);
            this.values = jsonObject.getJSONArray("value");
        }

        public boolean hasNext() throws IOException {
            if (this.index < this.values.length()) {
                return true;
            }
            if (this.nextLink != null) {
                this.fetchNextPage();
                return this.values.length() > 0;
            }
            return false;
        }

        public JSONObject next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                if (this.index >= this.values.length() && this.nextLink != null) {
                    this.fetchNextPage();
                }
                return this.values.getJSONObject(this.index++);
            }
            catch (JSONException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        private void fetchNextPage() throws IOException {
            HttpGet request = new HttpGet(this.nextLink);
            request.setHeader("Authorization", "Bearer " + GraphExchangeSession.this.token.getAccessToken());
            try (CloseableHttpResponse response = GraphExchangeSession.this.httpClient.execute((HttpRequestBase)request);){
                this.jsonObject = new JsonResponseHandler().handleResponse((HttpResponse)response);
                this.nextLink = this.jsonObject.optString("@odata.nextLink", null);
                this.values = this.jsonObject.getJSONArray("value");
                this.index = 0;
            }
            catch (JSONException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    static class NotCondition
    extends ExchangeSession.NotCondition {
        protected NotCondition(ExchangeSession.Condition condition) {
            super(condition);
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            buffer.append("not ");
            this.condition.appendTo(buffer);
        }
    }

    static class MultiCondition
    extends ExchangeSession.MultiCondition {
        protected MultiCondition(ExchangeSession.Operator operator, ExchangeSession.Condition ... conditions) {
            super(operator, conditions);
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            int actualConditionCount = 0;
            for (ExchangeSession.Condition condition : this.conditions) {
                if (condition.isEmpty()) continue;
                ++actualConditionCount;
            }
            if (actualConditionCount > 0) {
                boolean isFirst = true;
                for (ExchangeSession.Condition condition : this.conditions) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        buffer.append(" ").append(this.operator.toString()).append(" ");
                    }
                    condition.appendTo(buffer);
                }
            }
        }
    }

    protected static class ExistsCondition
    implements ExchangeSession.Condition,
    SearchExpression {
        protected final String attributeName;

        protected ExistsCondition(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            buffer.append(Field.get(this.attributeName).getGraphId()).append(" ne null");
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isMatch(ExchangeSession.Contact contact) {
            String actualValue = (String)contact.get(this.attributeName);
            return actualValue == null;
        }
    }

    protected static class IsNullCondition
    implements ExchangeSession.Condition,
    SearchExpression {
        protected final String attributeName;

        protected IsNullCondition(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            FieldURI fieldURI = Field.get(this.attributeName);
            if (fieldURI instanceof ExtendedFieldURI) {
                buffer.append("singleValueExtendedProperties/Any(ep: ep/id eq '").append(fieldURI.getGraphId()).append("' and ep/value eq null)");
            } else {
                buffer.append(fieldURI.getGraphId()).append(" eq null");
            }
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isMatch(ExchangeSession.Contact contact) {
            String actualValue = (String)contact.get(this.attributeName);
            return actualValue == null;
        }
    }

    protected static class HeaderCondition
    extends AttributeCondition {
        protected HeaderCondition(String attributeName, String value) {
            super(attributeName, ExchangeSession.Operator.Contains, value);
        }

        @Override
        protected FieldURI getFieldURI() {
            return new ExtendedFieldURI(ExtendedFieldURI.DistinguishedPropertySetType.InternetHeaders, this.attributeName);
        }
    }

    static class AttributeCondition
    extends ExchangeSession.AttributeCondition {
        protected AttributeCondition(String attributeName, ExchangeSession.Operator operator, String value) {
            super(attributeName, operator, value);
        }

        protected FieldURI getFieldURI() {
            FieldURI fieldURI = Field.get(this.attributeName);
            if (fieldURI == null) {
                throw new IllegalArgumentException("Unknown field: " + this.attributeName);
            }
            return fieldURI;
        }

        private String convertOperator(ExchangeSession.Operator operator) {
            if (ExchangeSession.Operator.IsEqualTo.equals((Object)operator)) {
                return "eq";
            }
            if (ExchangeSession.Operator.IsGreaterThan.equals((Object)operator)) {
                return "gt";
            }
            return operator.toString();
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            FieldURI fieldURI = this.getFieldURI();
            String graphId = fieldURI.getGraphId();
            if ("String {00020386-0000-0000-c000-000000000046} Name to".equals(graphId)) {
                buffer.append("singleValueExtendedProperties/Any(ep: ep/id eq 'String {00020386-0000-0000-c000-000000000046} Name to' and contains(ep/value,'").append(StringUtil.escapeQuotes(this.value)).append("'))");
            } else if (ExchangeSession.Operator.StartsWith.equals((Object)this.operator)) {
                buffer.append("startswith(").append(graphId).append(",'").append(StringUtil.escapeQuotes(this.value)).append("')");
            } else if (ExchangeSession.Operator.Contains.equals((Object)this.operator)) {
                buffer.append("contains(").append(graphId).append(",'").append(StringUtil.escapeQuotes(this.value)).append("')");
            } else if (fieldURI instanceof ExtendedFieldURI) {
                buffer.append("singleValueExtendedProperties/Any(ep: ep/id eq '").append(graphId).append("' and ep/value ").append(this.convertOperator(this.operator)).append(" '").append(StringUtil.escapeQuotes(this.value)).append("')");
            } else if ("start".equals(graphId) || "end".equals(graphId)) {
                buffer.append(graphId).append("/dateTime ").append(this.convertOperator(this.operator)).append(" '").append(StringUtil.escapeQuotes(this.value)).append("'");
            } else {
                buffer.append(graphId).append(" ").append(this.convertOperator(this.operator)).append(" '").append(StringUtil.escapeQuotes(this.value)).append("'");
            }
        }

        @Override
        public boolean isMatch(ExchangeSession.Contact contact) {
            return false;
        }
    }

    class Message
    extends ExchangeSession.Message {
        protected FolderId folderId;
        protected String id;
        protected String changeKey;

        Message() {
        }

        @Override
        public String getPermanentId() {
            return this.id;
        }

        @Override
        protected InputStream getMimeHeaders() {
            ByteArrayInputStream result = null;
            try {
                HashSet<FieldURI> expandFields = new HashSet<FieldURI>();
                expandFields.add(Field.get("from"));
                expandFields.add(Field.get("messageheaders"));
                JSONObject response = GraphExchangeSession.this.executeJsonRequest(new GraphRequestBuilder().setMethod("GET").setMailbox(this.folderId.mailbox).setObjectType("messages").setObjectId(this.id).setExpandFields(expandFields));
                String messageHeaders = null;
                JSONArray singleValueExtendedProperties = response.optJSONArray("singleValueExtendedProperties");
                if (singleValueExtendedProperties != null) {
                    for (int i = 0; i < singleValueExtendedProperties.length(); ++i) {
                        try {
                            JSONObject responseValue = singleValueExtendedProperties.getJSONObject(i);
                            String responseId = responseValue.optString("id");
                            if (!Field.get("messageheaders").getGraphId().equals(responseId)) continue;
                            messageHeaders = responseValue.optString("value");
                            continue;
                        }
                        catch (JSONException e) {
                            LOGGER.warn((Object)"Error parsing json response value");
                        }
                    }
                }
                if (messageHeaders != null && messageHeaders.toLowerCase().contains("message-id:")) {
                    if (!messageHeaders.contains("From:")) {
                        String from = response.optString("from");
                        messageHeaders = "From: " + from + '\n' + messageHeaders;
                    }
                    result = new ByteArrayInputStream(messageHeaders.getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)e.getMessage());
            }
            return result;
        }
    }

    protected static class FolderId {
        protected String mailbox;
        protected String id;
        protected String parentFolderId;
        protected String folderClass;

        public FolderId() {
        }

        public FolderId(String mailbox, String id) {
            this.mailbox = mailbox;
            this.id = id;
        }

        public FolderId(String mailbox, String id, String folderClass) {
            this.mailbox = mailbox;
            this.id = id;
            this.folderClass = folderClass;
        }

        public FolderId(String mailbox, WellKnownFolderName wellKnownFolderName) {
            this.mailbox = mailbox;
            this.id = wellKnownFolderName.name();
        }

        public FolderId(String mailbox, WellKnownFolderName wellKnownFolderName, String folderClass) {
            this.mailbox = mailbox;
            this.id = wellKnownFolderName.name();
            this.folderClass = folderClass;
        }
    }

    public static enum WellKnownFolderName {
        archive,
        deleteditems,
        calendar,
        contacts,
        tasks,
        drafts,
        inbox,
        outbox,
        sentitems,
        junkemail,
        msgfolderroot,
        searchfolders;

    }

    protected class Contact
    extends ExchangeSession.Contact {
        FolderId folderId;
        String id;

        protected Contact(GraphObject response) throws DavMailException {
            String type;
            String email;
            JSONObject emailAddress;
            int i;
            this.id = response.optString("id");
            this.etag = response.optString("changeKey");
            this.displayName = response.optString("displayname");
            this.itemName = StringUtil.decodeUrlcompname(response.optString("urlcompname"));
            if (this.itemName == null) {
                this.itemName = StringUtil.base64ToUrl(this.id) + ".EML";
            }
            for (String attributeName : ExchangeSession.CONTACT_ATTRIBUTES) {
                String value;
                if (attributeName.startsWith("smtpemail") || (value = response.optString(attributeName)) == null || value.isEmpty()) continue;
                if ("bday".equals(attributeName) || "anniversary".equals(attributeName) || "lastmodified".equals(attributeName) || "datereceived".equals(attributeName)) {
                    value = GraphExchangeSession.this.convertDateFromExchange(value);
                }
                this.put(attributeName, value);
            }
            JSONArray emailAddresses = response.optJSONArray("emailAddresses");
            for (i = 0; i < emailAddresses.length(); ++i) {
                emailAddress = emailAddresses.optJSONObject(i);
                if (emailAddress == null) continue;
                email = emailAddress.optString("address");
                type = emailAddress.optString("type");
                if (email == null || email.isEmpty()) continue;
                if ("other".equals(type)) {
                    this.put("smtpemail3", email);
                    continue;
                }
                if ("personal".equals(type)) {
                    this.put("smtpemail2", email);
                    continue;
                }
                if (!"work".equals(type)) continue;
                this.put("smtpemail1", email);
            }
            for (i = 0; i < emailAddresses.length(); ++i) {
                emailAddress = emailAddresses.optJSONObject(i);
                if (emailAddress == null) continue;
                email = emailAddress.optString("address");
                type = emailAddress.optString("type");
                if (email == null || email.isEmpty() || !"unknown".equals(type)) continue;
                if (this.get("smtpemail1") == null) {
                    this.put("smtpemail1", email);
                    continue;
                }
                if (this.get("smtpemail2") == null) {
                    this.put("smtpemail2", email);
                    continue;
                }
                if (this.get("smtpemail3") != null) continue;
                this.put("smtpemail3", email);
            }
        }

        protected Contact(String folderPath, String itemName, Map<String, String> properties, String etag, String noneMatch) {
            super(folderPath, itemName, properties, etag, noneMatch);
        }

        protected Contact() {
        }

        @Override
        public ExchangeSession.ItemResult createOrUpdate() throws IOException {
            FolderId folderId = GraphExchangeSession.this.getFolderId(this.folderPath);
            String id = null;
            String currentEtag = null;
            JSONObject jsonContact = GraphExchangeSession.this.getContactIfExists(folderId, this.itemName);
            if (jsonContact != null) {
                id = jsonContact.optString("id", null);
                currentEtag = new GraphObject(jsonContact).optString("changeKey");
            }
            ExchangeSession.ItemResult itemResult = new ExchangeSession.ItemResult();
            if ("*".equals(this.noneMatch)) {
                if (id != null) {
                    itemResult.status = 412;
                    return itemResult;
                }
            } else if (!(this.etag == null || id != null && this.etag.equals(currentEtag))) {
                itemResult.status = 412;
                return itemResult;
            }
            try {
                String smtpemail3;
                String smtpemail2;
                JSONObject jsonObject = new JSONObject();
                GraphObject graphObject = new GraphObject(jsonObject);
                for (Map.Entry entry : this.entrySet()) {
                    if ("keywords".equals(entry.getKey())) {
                        graphObject.setCategories((String)entry.getValue());
                        continue;
                    }
                    if ("bday".equals(entry.getKey())) {
                        graphObject.put((String)entry.getKey(), GraphExchangeSession.this.convertZuluToIso((String)entry.getValue()));
                        continue;
                    }
                    if ("anniversary".equals(entry.getKey())) {
                        graphObject.put((String)entry.getKey(), GraphExchangeSession.this.convertZuluToDate((String)entry.getValue()));
                        continue;
                    }
                    if ("photo".equals(entry.getKey())) {
                        graphObject.put("haspicture", this.get("photo") != null ? "true" : "false");
                        continue;
                    }
                    if (((String)entry.getKey()).startsWith("email") || ((String)entry.getKey()).startsWith("smtpemail") || "usersmimecertificate".equals(entry.getKey()) || "msexchangecertificate".equals(entry.getKey()) || "pager".equals(entry.getKey()) || "otherTelephone".equals(entry.getKey())) continue;
                    graphObject.put((String)entry.getKey(), (String)entry.getValue());
                }
                String pager = (String)this.get("pager");
                if (pager == null) {
                    pager = (String)this.get("otherTelephone");
                }
                graphObject.put("pager", pager);
                graphObject.put("urlcompname", GraphExchangeSession.this.convertItemNameToEML(this.itemName));
                JSONArray emailAddresses = new JSONArray();
                String smtpemail1 = (String)this.get("smtpemail1");
                if (smtpemail1 != null) {
                    JSONObject emailAddress = new JSONObject();
                    emailAddress.put("address", (Object)smtpemail1);
                    emailAddress.put("type", (Object)"work");
                    emailAddresses.put((Object)emailAddress);
                }
                if ((smtpemail2 = (String)this.get("smtpemail2")) != null) {
                    JSONObject emailAddress = new JSONObject();
                    emailAddress.put("address", (Object)smtpemail2);
                    emailAddress.put("type", (Object)"personal");
                    emailAddresses.put((Object)emailAddress);
                }
                if ((smtpemail3 = (String)this.get("smtpemail3")) != null) {
                    JSONObject emailAddress = new JSONObject();
                    emailAddress.put("address", (Object)smtpemail3);
                    emailAddress.put("type", (Object)"other");
                    emailAddresses.put((Object)emailAddress);
                }
                graphObject.put("emailAddresses", emailAddresses);
                GraphRequestBuilder graphRequestBuilder = new GraphRequestBuilder();
                if (id == null) {
                    graphRequestBuilder.setMethod("POST").setMailbox(folderId.mailbox).setObjectType("contactFolders").setObjectId(folderId.id).setChildType("contacts").setJsonBody(jsonObject);
                } else {
                    graphRequestBuilder.setMethod("PATCH").setMailbox(folderId.mailbox).setObjectType("contactFolders").setObjectId(folderId.id).setChildType("contacts").setChildId(id).setJsonBody(jsonObject);
                }
                GraphObject graphResponse = GraphExchangeSession.this.executeGraphRequest(graphRequestBuilder);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)graphResponse.toString(4));
                }
                itemResult.status = graphResponse.statusCode;
                this.updatePhoto(folderId, graphResponse.optString("id"));
                graphResponse = new GraphObject(GraphExchangeSession.this.getContactIfExists(folderId, this.itemName));
                itemResult.itemName = graphResponse.optString("id");
                itemResult.etag = graphResponse.optString("etag");
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
            if (itemResult.status == 201) {
                LOGGER.debug((Object)("Created contact " + this.getHref()));
            } else {
                LOGGER.debug((Object)("Updated contact " + this.getHref()));
            }
            return itemResult;
        }

        private void updatePhoto(FolderId folderId, String contactId) throws IOException {
            String photo = (String)this.get("photo");
            if (photo != null) {
                byte[] resizedImageBytes = IOUtil.resizeImage(IOUtil.decodeBase64(photo), 90);
                JSONObject jsonResponse = GraphExchangeSession.this.executeJsonRequest(new GraphRequestBuilder().setMethod("PUT").setMailbox(folderId.mailbox).setObjectType("contactFolders").setObjectId(folderId.id).setChildType("contacts").setChildId(contactId).setChildSuffix("photo/$value").setContentType("image/jpeg").setMimeContent(resizedImageBytes));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)jsonResponse);
                }
            } else {
                GraphExchangeSession.this.executeJsonRequest(new GraphRequestBuilder().setMethod("DELETE").setMailbox(folderId.mailbox).setObjectType("contactFolders").setObjectId(folderId.id).setChildType("contacts").setChildId(contactId).setChildSuffix("photo"));
            }
        }
    }

    protected class Event
    extends ExchangeSession.Event {
        public FolderId folderId;
        public String id;
        protected GraphObject graphObject;

        public Event(FolderId folderId, GraphObject graphObject) {
            this.folderId = folderId;
            if ("IPF.Appointment".equals(folderId.folderClass) && graphObject.optString("taskstatus") != null) {
                try {
                    this.folderId = GraphExchangeSession.this.getFolderId("tasks");
                }
                catch (IOException e) {
                    LOGGER.warn((Object)"Unable to replace folder with tasks");
                }
            }
            this.graphObject = graphObject;
            this.id = graphObject.optString("id");
            this.etag = graphObject.optString("changeKey");
            this.displayName = graphObject.optString("subject");
            this.subject = graphObject.optString("subject");
            this.itemName = StringUtil.base64ToUrl(this.id) + ".EML";
        }

        public Event(String folderPath, String itemName, String contentClass, String itemBody, String etag, String noneMatch) throws IOException {
            super(folderPath, itemName, contentClass, itemBody, etag, noneMatch);
            this.folderId = GraphExchangeSession.this.getFolderId(folderPath);
        }

        @Override
        public byte[] getEventContent() throws IOException {
            byte[] content;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Get event: " + this.itemName));
            }
            try {
                if ("IPF.Task".equals(this.folderId.folderClass)) {
                    VCalendar localVCalendar = new VCalendar();
                    VObject vTodo = new VObject();
                    vTodo.type = "VTODO";
                    localVCalendar.setTimezone(GraphExchangeSession.this.getVTimezone());
                    vTodo.setPropertyValue("LAST-MODIFIED", GraphExchangeSession.this.convertDateFromExchange(this.graphObject.optString("lastModifiedDateTime")));
                    vTodo.setPropertyValue("CREATED", GraphExchangeSession.this.convertDateFromExchange(this.graphObject.optString("createdDateTime")));
                    vTodo.setPropertyValue("UID", this.graphObject.optString("id"));
                    vTodo.setPropertyValue("TITLE", this.graphObject.optString("title"));
                    vTodo.setPropertyValue("SUMMARY", this.graphObject.optString("title"));
                    vTodo.addProperty(GraphExchangeSession.this.convertBodyToVproperty("DESCRIPTION", this.graphObject));
                    vTodo.setPropertyValue("PRIORITY", GraphExchangeSession.this.convertPriorityFromExchange(this.graphObject.optString("importance")));
                    vTodo.setPropertyValue("STATUS", ExchangeSession.taskTovTodoStatusMap.get(this.graphObject.optString("status")));
                    vTodo.setPropertyValue("DUE;VALUE=DATE", GraphExchangeSession.this.convertDateTimeTimeZoneToTaskDate(this.graphObject.optDateTimeTimeZone("dueDateTime")));
                    vTodo.setPropertyValue("DTSTART;VALUE=DATE", GraphExchangeSession.this.convertDateTimeTimeZoneToTaskDate(this.graphObject.optDateTimeTimeZone("startDateTime")));
                    vTodo.setPropertyValue("COMPLETED;VALUE=DATE", GraphExchangeSession.this.convertDateTimeTimeZoneToTaskDate(this.graphObject.optDateTimeTimeZone("completedDateTime")));
                    vTodo.setPropertyValue("CATEGORIES", this.graphObject.optString("categories"));
                    localVCalendar.addVObject(vTodo);
                    content = localVCalendar.toString().getBytes(StandardCharsets.UTF_8);
                } else {
                    VCalendar localVCalendar = new VCalendar();
                    localVCalendar.setTimezone(GraphExchangeSession.this.getVTimezone());
                    VObject vEvent = new VObject();
                    vEvent.type = "VEVENT";
                    localVCalendar.addVObject(vEvent);
                    localVCalendar.setFirstVeventPropertyValue("UID", this.graphObject.optString("iCalUId"));
                    localVCalendar.setFirstVeventPropertyValue("SUMMARY", this.graphObject.optString("subject"));
                    localVCalendar.addFirstVeventProperty(GraphExchangeSession.this.convertBodyToVproperty("DESCRIPTION", this.graphObject));
                    localVCalendar.setFirstVeventPropertyValue("LAST-MODIFIED", GraphExchangeSession.this.convertDateFromExchange(this.graphObject.optString("lastModifiedDateTime")));
                    localVCalendar.setFirstVeventPropertyValue("DTSTAMP", GraphExchangeSession.this.convertDateFromExchange(this.graphObject.optString("lastModifiedDateTime")));
                    localVCalendar.addFirstVeventProperty(GraphExchangeSession.this.convertDateTimeTimeZoneToVproperty("DTSTART", this.graphObject.optJSONObject("start")));
                    localVCalendar.addFirstVeventProperty(GraphExchangeSession.this.convertDateTimeTimeZoneToVproperty("DTEND", this.graphObject.optJSONObject("end")));
                    localVCalendar.setFirstVeventPropertyValue("CLASS", GraphExchangeSession.this.convertClassFromExchange(this.graphObject.optString("sensitivity")));
                    localVCalendar.setFirstVeventPropertyValue("X-MICROSOFT-CDO-BUSYSTATUS", this.graphObject.optString("showAs").toUpperCase());
                    localVCalendar.setFirstVeventPropertyValue("X-MICROSOFT-CDO-ALLDAYEVENT", this.graphObject.optString("isAllDay").toUpperCase());
                    localVCalendar.setFirstVeventPropertyValue("X-MICROSOFT-CDO-ISRESPONSEREQUESTED", this.graphObject.optString("responseRequested").toUpperCase());
                    this.handleException(localVCalendar, this.graphObject);
                    this.handleRecurrence(localVCalendar, this.graphObject);
                    localVCalendar.setFirstVeventPropertyValue("X-MOZ-SEND-INVITATIONS", this.graphObject.optString("xmozsendinvitations"));
                    localVCalendar.setFirstVeventPropertyValue("X-MOZ-LASTACK", this.graphObject.optString("xmozlastack"));
                    localVCalendar.setFirstVeventPropertyValue("X-MOZ-SNOOZE-TIME", this.graphObject.optString("xmozsnoozetime"));
                    this.setAttendees(localVCalendar.getFirstVevent());
                    content = localVCalendar.toString().getBytes(StandardCharsets.UTF_8);
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            return content;
        }

        private void handleException(VCalendar localVCalendar, GraphObject graphObject) throws DavMailException {
            JSONArray cancelledOccurrences = graphObject.optJSONArray("cancelledOccurrences");
            if (cancelledOccurrences != null) {
                HashSet<String> exDateValues = new HashSet<String>();
                VProperty startDate = localVCalendar.getFirstVevent().getProperty("DTSTART");
                for (int i = 0; i < cancelledOccurrences.length(); ++i) {
                    String cancelledOccurrence = null;
                    try {
                        cancelledOccurrence = cancelledOccurrences.getString(i);
                        cancelledOccurrence = cancelledOccurrence.substring(cancelledOccurrence.lastIndexOf(46) + 1);
                        String cancelledDate = GraphExchangeSession.this.convertDateFromExchange(cancelledOccurrence);
                        exDateValues.add(cancelledDate.substring(0, 8) + startDate.getValue().substring(8));
                        continue;
                    }
                    catch (IndexOutOfBoundsException | JSONException e) {
                        LOGGER.warn((Object)("Invalid cancelled occurrence: " + cancelledOccurrence));
                    }
                }
                VProperty exDate = new VProperty("EXDATE", StringUtil.join(exDateValues, ","));
                exDate.setParam("TZID", startDate.getParamValue("TZID"));
                localVCalendar.addFirstVeventProperty(exDate);
            }
        }

        private void handleRecurrence(VCalendar localVCalendar, GraphObject graphObject) throws JSONException, DavMailException {
            JSONObject recurrence = graphObject.optJSONObject("recurrence");
            if (recurrence != null) {
                StringBuilder rruleValue = new StringBuilder();
                JSONObject pattern = recurrence.getJSONObject("pattern");
                JSONObject range = recurrence.getJSONObject("range");
                String patternType = pattern.getString("type");
                int interval = pattern.getInt("interval");
                String index = pattern.optString("index", null);
                if ("first".equals(index)) {
                    index = "1";
                } else if ("second".equals(index)) {
                    index = "2";
                } else if ("third".equals(index)) {
                    index = "3";
                } else if ("fourth".equals(index)) {
                    index = "4";
                } else if ("last".equals(index)) {
                    index = "-1";
                }
                String month = pattern.getString("month");
                if ("0".equals(month)) {
                    month = null;
                }
                String firstDayOfWeek = pattern.getString("firstDayOfWeek");
                String dayOfMonth = pattern.getString("dayOfMonth");
                if ("0".equals(dayOfMonth)) {
                    dayOfMonth = null;
                }
                JSONArray daysOfWeek = pattern.optJSONArray("daysOfWeek");
                String rangeType = range.getString("type");
                rruleValue.append("FREQ=");
                if (patternType.startsWith("absolute") || patternType.startsWith("relative")) {
                    rruleValue.append(patternType.substring(8).toUpperCase());
                } else {
                    rruleValue.append(patternType.toUpperCase());
                }
                if (rangeType.equals("endDate")) {
                    String endDate = this.buildUntilDate(range.getString("endDate"), range.getString("recurrenceTimeZone"), graphObject.optJSONObject("start"));
                    rruleValue.append(";UNTIL=").append(endDate);
                }
                if (interval > 0) {
                    rruleValue.append(";INTERVAL=").append(interval);
                }
                if (dayOfMonth != null && !dayOfMonth.isEmpty()) {
                    rruleValue.append(";BYMONTHDAY=").append(dayOfMonth);
                }
                if (month != null && !month.isEmpty()) {
                    rruleValue.append(";BYMONTH=").append(month);
                }
                if (daysOfWeek != null && daysOfWeek.length() > 0) {
                    ArrayList<String> days = new ArrayList<String>();
                    for (int i = 0; i < daysOfWeek.length(); ++i) {
                        StringBuilder byDay = new StringBuilder();
                        if (index != null && !"weekly".equals(patternType)) {
                            byDay.append(index);
                        }
                        byDay.append(daysOfWeek.getString(i).substring(0, 2).toUpperCase());
                        days.add(byDay.toString());
                    }
                    rruleValue.append(";BYDAY=").append(String.join((CharSequence)",", days));
                }
                if ("weekly".equals(patternType) && firstDayOfWeek.length() >= 2) {
                    rruleValue.append(";WKST=").append(firstDayOfWeek.substring(0, 2).toUpperCase());
                }
                localVCalendar.addFirstVeventProperty(new VProperty("RRULE", rruleValue.toString()));
            }
        }

        private String buildUntilDate(String date, String timeZone, JSONObject startDate) throws DavMailException {
            String result = null;
            if (date != null && date.length() == 10) {
                String startDateTimeZone = startDate.optString("timeZone");
                String startDateDateTime = startDate.optString("dateTime");
                String untilDateTime = date + startDateDateTime.substring(10);
                if (timeZone == null) {
                    timeZone = startDateTimeZone;
                }
                SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
                formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                parser.setTimeZone(TimeZone.getTimeZone(GraphObject.convertTimezoneFromExchange(timeZone)));
                try {
                    result = formatter.format(parser.parse(untilDateTime));
                }
                catch (ParseException e) {
                    throw new DavMailException("EXCEPTION_INVALID_DATE", date);
                }
            }
            return result;
        }

        private void setAttendees(VObject vEvent) throws JSONException {
            JSONArray attendees;
            JSONObject organizer = this.graphObject.optJSONObject("organizer");
            if (organizer != null) {
                vEvent.addProperty(GraphExchangeSession.this.convertEmailAddressToVproperty("ORGANIZER", organizer.optJSONObject("emailAddress")));
            }
            if ((attendees = this.graphObject.optJSONArray("attendees")) != null) {
                for (int i = 0; i < attendees.length(); ++i) {
                    JSONObject attendee = attendees.getJSONObject(i);
                    JSONObject emailAddress = attendee.getJSONObject("emailAddress");
                    VProperty attendeeProperty = GraphExchangeSession.this.convertEmailAddressToVproperty("ATTENDEE", emailAddress);
                    String responseType = attendee.getJSONObject("status").optString("response");
                    String myResponseType = this.graphObject.optString("responseStatus", "response");
                    if (GraphExchangeSession.this.email.equalsIgnoreCase(emailAddress.optString("address")) && myResponseType != null) {
                        attendeeProperty.addParam("PARTSTAT", this.responseTypeToPartstat(myResponseType));
                    } else {
                        attendeeProperty.addParam("PARTSTAT", this.responseTypeToPartstat(responseType));
                    }
                    String type = attendee.optString("type");
                    if ("required".equals(type)) {
                        attendeeProperty.addParam("ROLE", "REQ-PARTICIPANT");
                    } else if ("optional".equals(type)) {
                        attendeeProperty.addParam("ROLE", "OPT-PARTICIPANT");
                    }
                    vEvent.addProperty(attendeeProperty);
                }
            }
        }

        private String responseTypeToPartstat(String responseType) {
            if ("accepted".equals(responseType) || "organizer".equals(responseType)) {
                return "ACCEPTED";
            }
            if ("tentativelyAccepted".equals(responseType)) {
                return "TENTATIVE";
            }
            if ("declined".equals(responseType)) {
                return "DECLINED";
            }
            return "NEEDS-ACTION";
        }

        @Override
        public ExchangeSession.ItemResult createOrUpdate() throws IOException {
            String id = null;
            String currentEtag = null;
            JSONObject existingJsonEvent = GraphExchangeSession.this.getEventIfExists(this.folderId, this.itemName);
            if (existingJsonEvent != null) {
                id = existingJsonEvent.optString("id", null);
                currentEtag = new GraphObject(existingJsonEvent).optString("changeKey");
            }
            ExchangeSession.ItemResult itemResult = new ExchangeSession.ItemResult();
            if ("*".equals(this.noneMatch)) {
                if (id != null) {
                    itemResult.status = 412;
                    return itemResult;
                }
            } else if (!(this.etag == null || id != null && this.etag.equals(currentEtag))) {
                itemResult.status = 412;
                return itemResult;
            }
            VObject vEvent = this.vCalendar.getFirstVevent();
            try {
                List<VProperty> exdateProperty;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("subject", (Object)vEvent.getPropertyValue("SUMMARY"));
                VProperty dtStart = vEvent.getProperty("DTSTART");
                String dtStartTzid = dtStart.getParamValue("TZID");
                jsonObject.put("start", (Object)new JSONObject().put("dateTime", (Object)this.vCalendar.convertCalendarDateToGraph(dtStart.getValue(), dtStartTzid)).put("timeZone", (Object)dtStartTzid));
                VProperty dtEnd = vEvent.getProperty("DTEND");
                String dtEndTzid = dtEnd.getParamValue("TZID");
                jsonObject.put("end", (Object)new JSONObject().put("dateTime", (Object)this.vCalendar.convertCalendarDateToGraph(dtEnd.getValue(), dtEndTzid)).put("timeZone", (Object)dtEndTzid));
                VProperty descriptionProperty = vEvent.getProperty("DESCRIPTION");
                String description = null;
                if (descriptionProperty != null) {
                    description = vEvent.getProperty("DESCRIPTION").getParamValue("ALTREP");
                }
                if (description != null && description.startsWith("data:text/html,")) {
                    description = URIUtil.decode(description.replaceFirst("data:text/html,", ""));
                    jsonObject.put("body", (Object)new JSONObject().put("content", (Object)description).put("contentType", (Object)"html"));
                } else {
                    description = vEvent.getPropertyValue("DESCRIPTION");
                    jsonObject.put("body", (Object)new JSONObject().put("content", (Object)description).put("contentType", (Object)"text"));
                }
                if (id != null && (exdateProperty = vEvent.getProperties("EXDATE")) != null && !exdateProperty.isEmpty()) {
                    JSONArray cancelledOccurrences = new JSONArray();
                    for (VProperty exdate : exdateProperty) {
                        String exdateTzid = exdate.getParamValue("TZID");
                        String exDateValue = this.vCalendar.convertCalendarDateToGraph(exdate.getValue(), exdateTzid);
                        this.deleteEventOccurrence(id, exDateValue);
                    }
                    jsonObject.put("cancelledOccurrences", (Object)cancelledOccurrences);
                }
                GraphRequestBuilder graphRequestBuilder = new GraphRequestBuilder();
                if (id == null) {
                    graphRequestBuilder.setMethod("POST").setMailbox(this.folderId.mailbox).setObjectType("calendars").setObjectId(this.folderId.id).setChildType("events").setJsonBody(jsonObject);
                } else {
                    graphRequestBuilder.setMethod("PATCH").setMailbox(this.folderId.mailbox).setObjectType("events").setObjectId(id).setJsonBody(jsonObject);
                }
                GraphObject graphResponse = GraphExchangeSession.this.executeGraphRequest(graphRequestBuilder);
                itemResult.status = graphResponse.statusCode;
                itemResult.itemName = graphResponse.optString("id") + ".EML";
                itemResult.etag = graphResponse.optString("changeKey");
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
            return itemResult;
        }

        private void deleteEventOccurrence(String id, String exDateValue) throws IOException, JSONException {
            String startDateTime = exDateValue.substring(0, 10) + "T00:00:00.0000000";
            String endDateTime = exDateValue.substring(0, 10) + "T23:59:59.9999999";
            GraphRequestBuilder graphRequestBuilder = new GraphRequestBuilder();
            graphRequestBuilder.setMethod("GET").setMailbox(this.folderId.mailbox).setObjectType("events").setObjectId(id).setChildType("instances").setStartDateTime(startDateTime).setEndDateTime(endDateTime);
            GraphObject graphResponse = GraphExchangeSession.this.executeGraphRequest(graphRequestBuilder);
            JSONArray occurrences = graphResponse.optJSONArray("value");
            if (occurrences != null && occurrences.length() > 0) {
                for (int i = 0; i < occurrences.length(); ++i) {
                    JSONObject occurrence = occurrences.getJSONObject(i);
                    String occurrenceId = occurrence.optString("id");
                    if (occurrenceId == null) continue;
                    GraphExchangeSession.this.executeJsonRequest(new GraphRequestBuilder().setMethod("DELETE").setMailbox(this.folderId.mailbox).setObjectType("events").setObjectId(occurrenceId));
                }
            }
        }
    }

    protected class Folder
    extends ExchangeSession.Folder {
        public FolderId folderId;
        protected String specialFlag = "";

        protected Folder() {
        }

        protected void setSpecialFlag(String specialFlag) {
            this.specialFlag = "\\" + specialFlag + " ";
        }

        @Override
        public String getFlags() {
            if (this.noInferiors) {
                return this.specialFlag + "\\NoInferiors";
            }
            if (this.hasChildren) {
                return this.specialFlag + "\\HasChildren";
            }
            return this.specialFlag + "\\HasNoChildren";
        }
    }
}

