/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.ews;

import davmail.exchange.ews.FieldURI;
import davmail.util.StringUtil;
import java.util.List;

public class UnindexedFieldURI
implements FieldURI {
    protected final String fieldURI;
    protected final String fieldName;
    protected String graphId;

    public UnindexedFieldURI(String fieldURI) {
        this.fieldURI = fieldURI;
        int colonIndex = fieldURI.indexOf(58);
        this.fieldName = colonIndex < 0 ? fieldURI : fieldURI.substring(colonIndex + 1);
    }

    public UnindexedFieldURI(String fieldURI, String graphId) {
        this(fieldURI);
        this.graphId = graphId;
    }

    @Override
    public void appendTo(StringBuilder buffer) {
        buffer.append("<t:FieldURI FieldURI=\"").append(this.fieldURI).append("\"/>");
    }

    @Override
    public void appendValue(StringBuilder buffer, String itemType, String value) {
        if (this.fieldURI.startsWith("message") && itemType != null) {
            itemType = "Message";
        } else if (this.fieldURI.startsWith("calendar") && itemType != null) {
            itemType = "CalendarItem";
        } else if (this.fieldURI.startsWith("task") && itemType != null) {
            itemType = "Task";
        } else if (this.fieldURI.startsWith("contacts") && itemType != null) {
            itemType = "Contact";
        }
        if (itemType != null) {
            this.appendTo(buffer);
            buffer.append("<t:");
            buffer.append(itemType);
            buffer.append('>');
        }
        if ("MeetingTimeZone".equals(this.fieldName)) {
            buffer.append("<t:MeetingTimeZone TimeZoneName=\"");
            buffer.append(StringUtil.xmlEncodeAttribute(value));
            buffer.append("\"></t:MeetingTimeZone>");
        } else if ("StartTimeZone".equals(this.fieldName)) {
            buffer.append("<t:StartTimeZone Id=\"");
            buffer.append(StringUtil.xmlEncodeAttribute(value));
            buffer.append("\"></t:StartTimeZone>");
        } else if ("EndTimeZone".equals(this.fieldName)) {
            buffer.append("<t:EndTimeZone Id=\"");
            buffer.append(StringUtil.xmlEncodeAttribute(value));
            buffer.append("\"></t:EndTimeZone>");
        } else {
            buffer.append("<t:");
            buffer.append(this.fieldName);
            buffer.append('>');
            buffer.append(StringUtil.xmlEncodeAttribute(value));
            buffer.append("</t:");
            buffer.append(this.fieldName);
            buffer.append('>');
        }
        if (itemType != null) {
            buffer.append("</t:");
            buffer.append(itemType);
            buffer.append('>');
        }
    }

    public void appendValues(StringBuilder buffer, String itemType, List<String> values) {
        if (this.fieldURI.startsWith("message") && itemType != null) {
            itemType = "Message";
        } else if (this.fieldURI.startsWith("calendar") && itemType != null) {
            itemType = "CalendarItem";
        } else if (this.fieldURI.startsWith("task") && itemType != null) {
            itemType = "Task";
        } else if (this.fieldURI.startsWith("contacts") && itemType != null) {
            itemType = "Contact";
        } else if (this.fieldURI.startsWith("distributionlist") && itemType != null) {
            itemType = "DistributionList";
        }
        if (!values.isEmpty()) {
            if (itemType != null) {
                this.appendTo(buffer);
                buffer.append("<t:");
                buffer.append(itemType);
                buffer.append('>');
            }
            buffer.append("<t:");
            buffer.append(this.fieldName);
            buffer.append('>');
            for (String value : values) {
                if ("RequiredAttendees".equals(this.fieldName) || "OptionalAttendees".equals(this.fieldName)) {
                    buffer.append("<t:Attendee><t:Mailbox><t:EmailAddress>");
                    buffer.append(StringUtil.xmlEncodeAttribute(value));
                    buffer.append("</t:EmailAddress></t:Mailbox></t:Attendee>");
                    continue;
                }
                if ("Members".equals(this.fieldName)) {
                    if (value.toLowerCase().startsWith("mailto:")) {
                        buffer.append("<t:Member><t:Mailbox><t:EmailAddress>");
                        buffer.append(StringUtil.xmlEncodeAttribute(value.substring(7)));
                        buffer.append("</t:EmailAddress></t:Mailbox></t:Member>");
                        continue;
                    }
                    if (!value.startsWith("urn:uuid:")) continue;
                    buffer.append("<t:Member><t:Mailbox><t:MailboxType>PrivateDL</t:MailboxType><t:ItemId Id=\"");
                    buffer.append(StringUtil.xmlEncodeAttribute(value.substring(9)));
                    buffer.append("\"/></t:Mailbox></t:Member>");
                    continue;
                }
                buffer.append(StringUtil.xmlEncodeAttribute(value));
            }
            buffer.append("</t:");
            buffer.append(this.fieldName);
            buffer.append('>');
            if (itemType != null) {
                buffer.append("</t:");
                buffer.append(itemType);
                buffer.append('>');
            }
        } else if (itemType != null) {
            this.appendTo(buffer);
        }
    }

    @Override
    public String getResponseName() {
        return this.fieldName;
    }

    @Override
    public String getGraphId() {
        if (this.graphId != null) {
            return this.graphId;
        }
        return this.fieldName;
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public boolean isNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBoolean() {
        throw new UnsupportedOperationException();
    }
}

