/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.ews;

import davmail.exchange.XMLStreamUtil;
import davmail.exchange.ews.AttributeOption;
import davmail.exchange.ews.ContactDataShape;
import davmail.exchange.ews.EWSMethod;
import davmail.exchange.ews.ElementOption;
import davmail.exchange.ews.SearchScope;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ResolveNamesMethod
extends EWSMethod {
    protected static final AttributeOption RETURN_FULL_CONTACT_DATA = new AttributeOption("ReturnFullContactData", "true");

    public ResolveNamesMethod(String value) {
        super("Contact", "ResolveNames", "ResolutionSet");
        this.addMethodOption(SearchScope.ActiveDirectory);
        this.addMethodOption(RETURN_FULL_CONTACT_DATA);
        this.addMethodOption(ContactDataShape.AllProperties);
        this.unresolvedEntry = new ElementOption("m:UnresolvedEntry", value);
    }

    @Override
    protected EWSMethod.Item handleItem(XMLStreamReader reader) throws XMLStreamException {
        EWSMethod.Item responseItem = new EWSMethod.Item();
        responseItem.type = "Contact";
        while (reader.hasNext() && !XMLStreamUtil.isStartTag(reader, "Resolution")) {
            reader.next();
        }
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "Resolution")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            if ("Mailbox".equals(tagLocalName)) {
                this.handleMailbox(reader, responseItem);
                continue;
            }
            if (!"Contact".equals(tagLocalName)) continue;
            this.handleContact(reader, responseItem);
        }
        return responseItem;
    }

    protected void handleMailbox(XMLStreamReader reader, EWSMethod.Item responseItem) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "Mailbox")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            if ("Name".equals(tagLocalName)) {
                responseItem.put(tagLocalName, XMLStreamUtil.getElementText(reader));
                continue;
            }
            if (!"EmailAddress".equals(tagLocalName)) continue;
            responseItem.put(tagLocalName, XMLStreamUtil.getElementText(reader));
        }
    }

    protected void handleContact(XMLStreamReader reader, EWSMethod.Item responseItem) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "Contact")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            if ("EmailAddresses".equals(tagLocalName)) {
                this.handleEmailAddresses(reader, responseItem);
                continue;
            }
            if ("PhysicalAddresses".equals(tagLocalName)) {
                this.handlePhysicalAddresses(reader, responseItem);
                continue;
            }
            if ("PhoneNumbers".equals(tagLocalName)) {
                this.handlePhoneNumbers(reader, responseItem);
                continue;
            }
            if ("MSExchangeCertificate".equals(tagLocalName) || "UserSMIMECertificate".equals(tagLocalName)) {
                this.handleUserCertificate(reader, responseItem, tagLocalName);
                continue;
            }
            if ("ManagerMailbox".equals(tagLocalName) || "Attachments".equals(tagLocalName) || "Photo".equals(tagLocalName) || "Notes".equals(tagLocalName) || "HasPicture".equals(tagLocalName) || "DirectoryId".equals(tagLocalName) || "Alias".equals(tagLocalName) || "Categories".equals(tagLocalName) || "InternetMessageHeaders".equals(tagLocalName) || "ResponseObjects".equals(tagLocalName) || "ExtendedProperty".equals(tagLocalName) || "EffectiveRights".equals(tagLocalName) || "CompleteName".equals(tagLocalName) || "Children".equals(tagLocalName) || "Companies".equals(tagLocalName) || "ImAddresses".equals(tagLocalName) || "DirectReports".equals(tagLocalName)) {
                this.skipTag(reader, tagLocalName);
                continue;
            }
            responseItem.put(tagLocalName, XMLStreamUtil.getElementText(reader));
        }
    }

    protected void handlePhysicalAddress(XMLStreamReader reader, EWSMethod.Item responseItem, String addressType) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "Entry")) {
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader)) continue;
            String tagLocalName = reader.getLocalName();
            String value = XMLStreamUtil.getElementText(reader);
            responseItem.put(addressType + tagLocalName, value);
        }
    }

    protected void handlePhysicalAddresses(XMLStreamReader reader, EWSMethod.Item responseItem) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "PhysicalAddresses")) {
            String tagLocalName;
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader) || !"Entry".equals(tagLocalName = reader.getLocalName())) continue;
            String key = this.getAttributeValue(reader, "Key");
            this.handlePhysicalAddress(reader, responseItem, key);
        }
    }

    protected void handlePhoneNumbers(XMLStreamReader reader, EWSMethod.Item responseItem) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "PhoneNumbers")) {
            String tagLocalName;
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader) || !"Entry".equals(tagLocalName = reader.getLocalName())) continue;
            String key = this.getAttributeValue(reader, "Key");
            String value = XMLStreamUtil.getElementText(reader);
            responseItem.put(key, value);
        }
    }

    protected void handleUserCertificate(XMLStreamReader reader, EWSMethod.Item responseItem, String contextTagLocalName) throws XMLStreamException {
        boolean firstValueRead = false;
        String certificate = "";
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, contextTagLocalName)) {
            String value;
            String tagLocalName;
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader) || !"Base64Binary".equals(tagLocalName = reader.getLocalName()) || (value = reader.getElementText()) == null || value.isEmpty()) continue;
            if (!firstValueRead) {
                certificate = value;
                firstValueRead = true;
                continue;
            }
            LOGGER.debug((Object)("ResolveNames multiple certificates found, tagLocaleName=" + contextTagLocalName + " Certificate [" + value + "] ignored"));
        }
        responseItem.put(contextTagLocalName, certificate);
    }

    protected void skipTag(XMLStreamReader reader, String tagLocalName) throws XMLStreamException {
        LOGGER.debug((Object)("ResolveNames tag parsing skipped. tagLocalName=" + tagLocalName));
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, tagLocalName)) {
            reader.next();
        }
    }

    @Override
    protected void handleEmailAddresses(XMLStreamReader reader, EWSMethod.Item responseItem) throws XMLStreamException {
        while (reader.hasNext() && !XMLStreamUtil.isEndTag(reader, "EmailAddresses")) {
            String value;
            String tagLocalName;
            reader.next();
            if (!XMLStreamUtil.isStartTag(reader) || !"Entry".equals(tagLocalName = reader.getLocalName()) || (value = XMLStreamUtil.getElementText(reader)) == null || !value.startsWith("smtp:") && !value.startsWith("SMTP:")) continue;
            value = value.substring(5);
            responseItem.putIfAbsent("EmailAddress", value);
        }
    }
}

