/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.ews;

import davmail.exchange.ExchangeSession;
import davmail.exchange.ews.FieldUpdate;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RecurrenceFieldUpdate
extends FieldUpdate {
    public static final Logger LOGGER = Logger.getLogger(RecurrenceFieldUpdate.class);
    static final HashMap<String, String> calDayToDayOfWeek = new HashMap();
    protected Date startDate;
    protected Date endDate;
    protected String count;
    protected HashSet<String> byDays = null;
    RecurrencePattern recurrencePattern;
    int recurrenceInterval = 1;

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setByDay(String[] days) {
        this.byDays = new HashSet();
        for (String day : days) {
            String value = calDayToDayOfWeek.get(day);
            if (value == null) {
                LOGGER.warn((Object)("Invalid day value: " + day));
                continue;
            }
            this.byDays.add(value);
        }
        if (this.recurrencePattern == RecurrencePattern.DailyRecurrence) {
            this.recurrencePattern = RecurrencePattern.WeeklyRecurrence;
        }
    }

    public void setCount(String count) {
        this.count = count;
    }

    public void setRecurrencePattern(RecurrencePattern recurrencePattern) {
        this.recurrencePattern = recurrencePattern;
    }

    public void setRecurrencePattern(String value) {
        if ("DAILY".equals(value)) {
            this.setRecurrencePattern(RecurrencePattern.DailyRecurrence);
        } else if ("WEEKLY".equals(value)) {
            this.setRecurrencePattern(RecurrencePattern.WeeklyRecurrence);
        } else if ("MONTHLY".equals(value)) {
            this.setRecurrencePattern(RecurrencePattern.AbsoluteMonthlyRecurrence);
        } else if ("YEARLY".equals(value)) {
            this.setRecurrencePattern(RecurrencePattern.AbsoluteYearlyRecurrence);
        }
    }

    public void setRecurrenceInterval(String interval) {
        this.recurrenceInterval = Integer.parseInt(interval);
    }

    @Override
    public void write(String itemType, Writer writer) throws IOException {
        if (itemType != null) {
            writer.write("<t:Set");
            writer.write(itemType);
            writer.write("Field>");
        }
        if (itemType != null) {
            writer.write("<t:FieldURI FieldURI=\"calendar:Recurrence\"/>");
            writer.write("<t:CalendarItem>");
            writer.write("<t:Recurrence>");
            writer.write("<t:");
            writer.write(this.recurrencePattern.toString());
            writer.write(">");
            if (this.recurrencePattern == RecurrencePattern.AbsoluteYearlyRecurrence) {
                this.writeDayOfMonth(writer);
                this.writeMonth(writer);
            } else if (this.recurrencePattern == RecurrencePattern.AbsoluteMonthlyRecurrence) {
                this.writeInterval(writer);
                this.writeDayOfMonth(writer);
            } else if (this.recurrencePattern == RecurrencePattern.WeeklyRecurrence) {
                this.writeInterval(writer);
                this.writeDaysOfWeek(writer);
            } else if (this.recurrencePattern == RecurrencePattern.DailyRecurrence) {
                this.writeInterval(writer);
            }
            writer.write("</t:");
            writer.write(this.recurrencePattern.toString());
            writer.write(">");
            this.writeStartEnd(writer);
            writer.write("</t:Recurrence>");
            writer.write("</t:CalendarItem>");
        }
        if (itemType != null) {
            writer.write("</t:Set");
            writer.write(itemType);
            writer.write("Field>");
        }
    }

    private void writeInterval(Writer writer) throws IOException {
        writer.write("<t:Interval>");
        writer.write(String.valueOf(this.recurrenceInterval));
        writer.write("</t:Interval>");
    }

    private void writeStartEnd(Writer writer) throws IOException {
        if (this.count != null) {
            writer.write("<t:NumberedRecurrence>");
            writer.write("<t:StartDate>");
            writer.write(this.getFormattedDate(this.startDate));
            writer.write("</t:StartDate>");
            writer.write("<t:NumberOfOccurrences>");
            writer.write(this.count);
            writer.write("</t:NumberOfOccurrences>");
            writer.write("</t:NumberedRecurrence>");
        } else if (this.endDate == null) {
            writer.write("<t:NoEndRecurrence><t:StartDate>");
            writer.write(this.getFormattedDate(this.startDate));
            writer.write("</t:StartDate></t:NoEndRecurrence>");
        } else {
            writer.write("<t:EndDateRecurrence>");
            writer.write("<t:StartDate>");
            writer.write(this.getFormattedDate(this.startDate));
            writer.write("</t:StartDate>");
            writer.write("<t:EndDate>");
            writer.write(this.getFormattedDate(this.endDate));
            writer.write("</t:EndDate>");
            writer.write("</t:EndDateRecurrence>");
        }
    }

    private void writeDaysOfWeek(Writer writer) throws IOException {
        writer.write("<t:DaysOfWeek>");
        if (this.byDays != null) {
            boolean first = true;
            for (String dayOfeek : this.byDays) {
                if (first) {
                    first = false;
                } else {
                    writer.write(32);
                }
                writer.write(dayOfeek);
            }
        } else {
            writer.write(this.getDayOfWeek());
        }
        writer.write("</t:DaysOfWeek>");
    }

    private void writeDayOfMonth(Writer writer) throws IOException {
        writer.write("<t:DayOfMonth>");
        writer.write(this.getDayOfMonth());
        writer.write("</t:DayOfMonth>");
    }

    private void writeMonth(Writer writer) throws IOException {
        writer.write("<t:Month>");
        writer.write(this.getMonth());
        writer.write("</t:Month>");
    }

    private String getDayOfWeek() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE", Locale.ENGLISH);
        simpleDateFormat.setTimeZone(ExchangeSession.GMT_TIMEZONE);
        return simpleDateFormat.format(this.startDate);
    }

    private String getMonth() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMMM", Locale.ENGLISH);
        simpleDateFormat.setTimeZone(ExchangeSession.GMT_TIMEZONE);
        return simpleDateFormat.format(this.startDate);
    }

    private String getDayOfMonth() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d", Locale.ENGLISH);
        simpleDateFormat.setTimeZone(ExchangeSession.GMT_TIMEZONE);
        return simpleDateFormat.format(this.startDate);
    }

    private String getFormattedDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setTimeZone(ExchangeSession.GMT_TIMEZONE);
        return simpleDateFormat.format(date);
    }

    static {
        calDayToDayOfWeek.put("SU", "Sunday");
        calDayToDayOfWeek.put("MO", "Monday");
        calDayToDayOfWeek.put("TU", "Tuesday");
        calDayToDayOfWeek.put("WE", "Wednesday");
        calDayToDayOfWeek.put("TH", "Thursday");
        calDayToDayOfWeek.put("FR", "Friday");
        calDayToDayOfWeek.put("SA", "Saturday");
    }

    public static enum RecurrencePattern {
        DailyRecurrence,
        WeeklyRecurrence,
        AbsoluteMonthlyRecurrence,
        AbsoluteYearlyRecurrence;

    }
}

