/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.ews;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.exception.DavMailAuthenticationException;
import davmail.exception.DavMailException;
import davmail.exception.HttpNotFoundException;
import davmail.exchange.ExchangeSession;
import davmail.exchange.VCalendar;
import davmail.exchange.VObject;
import davmail.exchange.VProperty;
import davmail.exchange.auth.O365Token;
import davmail.exchange.ews.BaseShape;
import davmail.exchange.ews.ConflictResolution;
import davmail.exchange.ews.ContainmentComparison;
import davmail.exchange.ews.ContainmentMode;
import davmail.exchange.ews.ConvertIdMethod;
import davmail.exchange.ews.CopyItemMethod;
import davmail.exchange.ews.CreateAttachmentMethod;
import davmail.exchange.ews.CreateFolderMethod;
import davmail.exchange.ews.CreateItemMethod;
import davmail.exchange.ews.DeleteAttachmentMethod;
import davmail.exchange.ews.DeleteFolderMethod;
import davmail.exchange.ews.DeleteItemMethod;
import davmail.exchange.ews.DeleteType;
import davmail.exchange.ews.DistinguishedFolderId;
import davmail.exchange.ews.EWSException;
import davmail.exchange.ews.EWSMethod;
import davmail.exchange.ews.EWSThrottlingException;
import davmail.exchange.ews.ExtendedFieldURI;
import davmail.exchange.ews.Field;
import davmail.exchange.ews.FieldOrder;
import davmail.exchange.ews.FieldURI;
import davmail.exchange.ews.FieldUpdate;
import davmail.exchange.ews.FileAttachment;
import davmail.exchange.ews.FindFolderMethod;
import davmail.exchange.ews.FindItemMethod;
import davmail.exchange.ews.FolderId;
import davmail.exchange.ews.FolderQueryTraversal;
import davmail.exchange.ews.GetAttachmentMethod;
import davmail.exchange.ews.GetFolderMethod;
import davmail.exchange.ews.GetItemMethod;
import davmail.exchange.ews.GetUserAvailabilityMethod;
import davmail.exchange.ews.GetUserConfigurationMethod;
import davmail.exchange.ews.GetUserPhotoMethod;
import davmail.exchange.ews.IndexedFieldUpdate;
import davmail.exchange.ews.ItemId;
import davmail.exchange.ews.MessageDisposition;
import davmail.exchange.ews.MoveFolderMethod;
import davmail.exchange.ews.MoveItemMethod;
import davmail.exchange.ews.MultiValuedFieldUpdate;
import davmail.exchange.ews.RecurrenceFieldUpdate;
import davmail.exchange.ews.ResolveNamesMethod;
import davmail.exchange.ews.SearchExpression;
import davmail.exchange.ews.SendMeetingCancellations;
import davmail.exchange.ews.SendMeetingInvitations;
import davmail.exchange.ews.SendMeetingInvitationsOrCancellations;
import davmail.exchange.ews.TwoOperandExpression;
import davmail.exchange.ews.UpdateFolderMethod;
import davmail.exchange.ews.UpdateItemMethod;
import davmail.http.HttpClientAdapter;
import davmail.http.request.GetRequest;
import davmail.ui.NotificationDialog;
import davmail.util.IOUtil;
import davmail.util.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.log4j.Logger;

public class EwsExchangeSession
extends ExchangeSession {
    protected static final int PAGE_SIZE = 500;
    protected static final String ARCHIVE_ROOT = "/archive/";
    protected static final Set<String> MESSAGE_TYPES = new HashSet<String>();
    static final Map<String, String> partstatToResponseMap;
    static final Map<String, String> responseTypeToPartstatMap;
    static final Map<String, String> statusToBusyStatusMap;
    protected HttpClientAdapter httpClient;
    protected Map<String, String> folderIdMap;
    protected boolean directEws;
    private O365Token token;
    protected static final HashSet<FieldURI> FOLDER_PROPERTIES;
    protected static final Set<String> ITEM_PROPERTIES;
    protected static final HashSet<String> EVENT_REQUEST_PROPERTIES;
    protected static final HashSet<String> CALENDAR_ITEM_REQUEST_PROPERTIES;
    protected static final String USERS_ROOT = "/users/";
    long throttlingTimestamp = 0L;
    protected static final HashMap<String, String> GALFIND_ATTRIBUTE_MAP;
    protected static final HashSet<String> IGNORE_ATTRIBUTE_SET;

    public EwsExchangeSession(HttpClientAdapter httpClient, String userName) throws IOException {
        this.httpClient = httpClient;
        this.userName = userName;
        if (userName.contains("@")) {
            this.email = userName;
        }
        this.buildSessionInfo(null);
    }

    public EwsExchangeSession(HttpClientAdapter httpClient, URI uri, String userName) throws IOException {
        this.httpClient = httpClient;
        this.userName = userName;
        if (userName.contains("@")) {
            this.email = userName;
            this.alias = userName.substring(0, userName.indexOf(64));
        }
        this.buildSessionInfo(uri);
    }

    public EwsExchangeSession(HttpClientAdapter httpClient, O365Token token, String userName) throws IOException {
        this.httpClient = httpClient;
        this.userName = userName;
        if (userName.contains("@")) {
            this.email = userName;
            this.alias = userName.substring(0, userName.indexOf(64));
        }
        this.token = token;
        this.buildSessionInfo(null);
    }

    public EwsExchangeSession(URI uri, O365Token token, String userName) throws IOException {
        this(new HttpClientAdapter(uri, true), token, userName);
    }

    public EwsExchangeSession(String url, String userName, String password) throws IOException {
        this(new HttpClientAdapter(url, userName, password, true), userName);
    }

    private static int getPageSize() {
        return Settings.getIntProperty("davmail.folderFetchPageSize", 500);
    }

    protected void checkEndPointUrl() throws IOException {
        GetFolderMethod checkMethod = new GetFolderMethod(BaseShape.ID_ONLY, DistinguishedFolderId.getInstance(null, DistinguishedFolderId.Name.root), null);
        int status = this.executeMethod(checkMethod);
        if (status == 401) {
            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
        }
        if (status != 200) {
            throw new IOException("Ews endpoint not available at " + checkMethod.getURI().toString() + " status " + status);
        }
    }

    @Override
    public void buildSessionInfo(URI uri) throws IOException {
        this.checkEndPointUrl();
        if (this.email == null || this.alias == null) {
            try {
                GetFolderMethod getFolderMethod = new GetFolderMethod(BaseShape.ID_ONLY, DistinguishedFolderId.getInstance(null, DistinguishedFolderId.Name.root), null);
                this.executeMethod(getFolderMethod);
                EWSMethod.Item item = getFolderMethod.getResponseItem();
                String folderId = (String)item.get("FolderId");
                ConvertIdMethod convertIdMethod = new ConvertIdMethod(folderId);
                this.executeMethod(convertIdMethod);
                EWSMethod.Item convertIdItem = convertIdMethod.getResponseItem();
                if (convertIdItem == null || convertIdItem.isEmpty()) {
                    LOGGER.error((Object)"Unable to resolve email from root folder");
                    throw new IOException();
                }
                this.email = (String)convertIdItem.get("Mailbox");
                this.alias = this.email.substring(0, this.email.indexOf(64));
            }
            catch (IOException e) {
                throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
            }
        }
        this.directEws = uri == null || "/ews/services.wsdl".equalsIgnoreCase(uri.getPath()) || "/ews/exchange.asmx".equalsIgnoreCase(uri.getPath());
        this.currentMailboxPath = USERS_ROOT + this.email.toLowerCase();
        try {
            this.folderIdMap = new HashMap<String, String>();
            this.folderIdMap.put(this.internalGetFolder((String)"INBOX").folderId.value, "INBOX");
            this.folderIdMap.put(this.internalGetFolder((String)"calendar").folderId.value, "calendar");
            this.folderIdMap.put(this.internalGetFolder((String)"contacts").folderId.value, "contacts");
            this.folderIdMap.put(this.internalGetFolder((String)"Sent").folderId.value, "Sent");
            this.folderIdMap.put(this.internalGetFolder((String)"Drafts").folderId.value, "Drafts");
            this.folderIdMap.put(this.internalGetFolder((String)"Trash").folderId.value, "Trash");
            this.folderIdMap.put(this.internalGetFolder((String)"Junk").folderId.value, "Junk");
            this.folderIdMap.put(this.internalGetFolder((String)"Unsent Messages").folderId.value, "Unsent Messages");
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new DavMailAuthenticationException("EXCEPTION_EWS_NOT_AVAILABLE");
        }
        LOGGER.debug((Object)("Current user email is " + this.email + ", alias is " + this.alias + " on " + this.serverVersion));
    }

    protected String getEmailSuffixFromHostname() {
        String domain = this.httpClient.getHost();
        int start = domain.lastIndexOf(46, domain.lastIndexOf(46) - 1);
        if (start >= 0) {
            return '@' + domain.substring(start + 1);
        }
        return '@' + domain;
    }

    protected void resolveEmailAddress(String userName) {
        String searchValue = userName;
        int index = searchValue.indexOf(92);
        if (index >= 0) {
            searchValue = searchValue.substring(index + 1);
        }
        ResolveNamesMethod resolveNamesMethod = new ResolveNamesMethod(searchValue);
        try {
            this.internalGetFolder("");
            this.executeMethod(resolveNamesMethod);
            List<EWSMethod.Item> responses = resolveNamesMethod.getResponseItems();
            if (responses.size() == 1) {
                this.email = (String)responses.get(0).get("EmailAddress");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected List<FieldUpdate> buildProperties(Map<String, String> properties) {
        ArrayList<FieldUpdate> list = new ArrayList<FieldUpdate>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if ("read".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("read", Boolean.toString("1".equals(entry.getValue()))));
                continue;
            }
            if ("junk".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("junk", entry.getValue()));
                continue;
            }
            if ("flagged".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("flagStatus", entry.getValue()));
                continue;
            }
            if ("answered".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("lastVerbExecuted", entry.getValue()));
                if (!"102".equals(entry.getValue())) continue;
                list.add(Field.createFieldUpdate("iconIndex", "261"));
                continue;
            }
            if ("forwarded".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("lastVerbExecuted", entry.getValue()));
                if (!"104".equals(entry.getValue())) continue;
                list.add(Field.createFieldUpdate("iconIndex", "262"));
                continue;
            }
            if ("draft".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("messageFlags", entry.getValue()));
                continue;
            }
            if ("deleted".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("deleted", entry.getValue()));
                continue;
            }
            if ("datereceived".equals(entry.getKey())) {
                list.add(Field.createFieldUpdate("datereceived", entry.getValue()));
                continue;
            }
            if (!"keywords".equals(entry.getKey())) continue;
            list.add(Field.createFieldUpdate("keywords", entry.getValue()));
        }
        return list;
    }

    @Override
    public ExchangeSession.Message createMessage(String folderPath, String messageName, HashMap<String, String> properties, MimeMessage mimeMessage) throws IOException {
        EWSMethod.Item item = new EWSMethod.Item();
        item.type = "Message";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            mimeMessage.writeTo((OutputStream)baos);
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
        baos.close();
        item.mimeContent = IOUtil.encodeBase64(baos.toByteArray());
        List<FieldUpdate> fieldUpdates = this.buildProperties(properties);
        if (!properties.containsKey("draft")) {
            if (properties.containsKey("read")) {
                fieldUpdates.add(Field.createFieldUpdate("messageFlags", "1"));
            } else {
                fieldUpdates.add(Field.createFieldUpdate("messageFlags", "0"));
            }
        }
        fieldUpdates.add(Field.createFieldUpdate("urlcompname", messageName));
        item.setFieldUpdates(fieldUpdates);
        CreateItemMethod createItemMethod = new CreateItemMethod(MessageDisposition.SaveOnly, this.getFolderId(folderPath), item);
        this.executeMethod(createItemMethod);
        ItemId newItemId = new ItemId(createItemMethod.getResponseItem());
        GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, newItemId, false);
        for (String attribute : IMAP_MESSAGE_ATTRIBUTES) {
            getItemMethod.addAdditionalProperty(Field.get(attribute));
        }
        this.executeMethod(getItemMethod);
        return this.buildMessage(getItemMethod.getResponseItem());
    }

    @Override
    public void updateMessage(ExchangeSession.Message message, Map<String, String> properties) throws IOException {
        if (properties.containsKey("read") && "urn:content-classes:appointment".equals(message.contentClass)) {
            properties.remove("read");
        }
        if (!properties.isEmpty()) {
            UpdateItemMethod updateItemMethod = new UpdateItemMethod(MessageDisposition.SaveOnly, ConflictResolution.AlwaysOverwrite, SendMeetingInvitationsOrCancellations.SendToNone, ((Message)message).itemId, this.buildProperties(properties));
            this.executeMethod(updateItemMethod);
        }
    }

    @Override
    public void deleteMessage(ExchangeSession.Message message) throws IOException {
        LOGGER.debug((Object)("Delete " + message.imapUid));
        DeleteItemMethod deleteItemMethod = new DeleteItemMethod(((Message)message).itemId, DeleteType.HardDelete, SendMeetingCancellations.SendToNone);
        this.executeMethod(deleteItemMethod);
    }

    protected void sendMessage(String itemClass, byte[] messageBody) throws IOException {
        EWSMethod.Item item = new EWSMethod.Item();
        item.type = "Message";
        item.mimeContent = IOUtil.encodeBase64(messageBody);
        if (itemClass != null) {
            item.put("ItemClass", itemClass);
        }
        MessageDisposition messageDisposition = Settings.getBooleanProperty("davmail.smtpSaveInSent", true) ? MessageDisposition.SendAndSaveCopy : MessageDisposition.SendOnly;
        CreateItemMethod createItemMethod = new CreateItemMethod(messageDisposition, this.getFolderId("Sent"), item);
        this.executeMethod(createItemMethod);
    }

    @Override
    public void sendMessage(MimeMessage mimeMessage) throws IOException, MessagingException {
        String itemClass = null;
        if (mimeMessage.getContentType().startsWith("multipart/report")) {
            itemClass = "REPORT.IPM.Note.IPNRN";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            mimeMessage.writeTo((OutputStream)baos);
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
        this.sendMessage(itemClass, baos.toByteArray());
    }

    @Override
    protected byte[] getContent(ExchangeSession.Message message) throws IOException {
        return this.getContent(((Message)message).itemId);
    }

    protected byte[] getContent(ItemId itemId) throws IOException {
        GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, itemId, true);
        byte[] mimeContent = null;
        try {
            this.executeMethod(getItemMethod);
            mimeContent = getItemMethod.getMimeContent();
        }
        catch (EWSException e) {
            LOGGER.warn((Object)("GetItem with MimeContent failed: " + e.getMessage()));
        }
        if (getItemMethod.getStatusCode() == 404) {
            throw new HttpNotFoundException("Item " + itemId + " not found");
        }
        if (mimeContent == null) {
            LOGGER.warn((Object)"MimeContent not available, trying to rebuild from properties");
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, itemId, false);
                getItemMethod.addAdditionalProperty(Field.get("contentclass"));
                getItemMethod.addAdditionalProperty(Field.get("message-id"));
                getItemMethod.addAdditionalProperty(Field.get("from"));
                getItemMethod.addAdditionalProperty(Field.get("to"));
                getItemMethod.addAdditionalProperty(Field.get("cc"));
                getItemMethod.addAdditionalProperty(Field.get("subject"));
                getItemMethod.addAdditionalProperty(Field.get("date"));
                getItemMethod.addAdditionalProperty(Field.get("body"));
                this.executeMethod(getItemMethod);
                EWSMethod.Item item = getItemMethod.getResponseItem();
                if (item == null) {
                    throw new HttpNotFoundException("Item " + itemId + " not found");
                }
                MimeMessage mimeMessage = new MimeMessage((Session)null);
                mimeMessage.addHeader("Content-class", (String)item.get(Field.get("contentclass").getResponseName()));
                mimeMessage.setSentDate(this.parseDateFromExchange((String)item.get(Field.get("date").getResponseName())));
                mimeMessage.addHeader("From", (String)item.get(Field.get("from").getResponseName()));
                mimeMessage.addHeader("To", (String)item.get(Field.get("to").getResponseName()));
                mimeMessage.addHeader("Cc", (String)item.get(Field.get("cc").getResponseName()));
                mimeMessage.setSubject((String)item.get(Field.get("subject").getResponseName()));
                String propertyValue = (String)item.get(Field.get("body").getResponseName());
                if (propertyValue == null) {
                    propertyValue = "";
                }
                mimeMessage.setContent((Object)propertyValue, "text/html; charset=UTF-8");
                mimeMessage.writeTo((OutputStream)baos);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Rebuilt message content: " + new String(baos.toByteArray(), StandardCharsets.UTF_8)));
                }
                mimeContent = baos.toByteArray();
            }
            catch (IOException | MessagingException e2) {
                LOGGER.warn((Object)e2);
            }
            if (mimeContent == null) {
                throw new IOException("GetItem returned null MimeContent");
            }
        }
        return mimeContent;
    }

    protected ExchangeSession.Message buildMessage(EWSMethod.Item response) throws DavMailException {
        Message message = new Message();
        message.itemId = new ItemId(response);
        message.permanentUrl = (String)response.get(Field.get("permanenturl").getResponseName());
        message.size = response.getInt(Field.get("messageSize").getResponseName());
        message.uid = (String)response.get(Field.get("uid").getResponseName());
        message.contentClass = (String)response.get(Field.get("contentclass").getResponseName());
        message.imapUid = response.getLong(Field.get("imapUid").getResponseName());
        message.read = response.getBoolean(Field.get("read").getResponseName());
        message.junk = response.getBoolean(Field.get("junk").getResponseName());
        message.flagged = "2".equals(response.get(Field.get("flagStatus").getResponseName()));
        message.draft = (response.getInt(Field.get("messageFlags").getResponseName()) & 8) != 0;
        String lastVerbExecuted = (String)response.get(Field.get("lastVerbExecuted").getResponseName());
        message.answered = "102".equals(lastVerbExecuted) || "103".equals(lastVerbExecuted);
        message.forwarded = "104".equals(lastVerbExecuted);
        message.date = this.convertDateFromExchange((String)response.get(Field.get("date").getResponseName()));
        message.deleted = "1".equals(response.get(Field.get("deleted").getResponseName()));
        String lastmodified = this.convertDateFromExchange((String)response.get(Field.get("lastmodified").getResponseName()));
        message.recent = !message.read && lastmodified != null && lastmodified.equals(message.date);
        message.keywords = (String)response.get(Field.get("keywords").getResponseName());
        if (LOGGER.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Message");
            if (message.imapUid != 0L) {
                buffer.append(" IMAP uid: ").append(message.imapUid);
            }
            if (message.uid != null) {
                buffer.append(" uid: ").append(message.uid);
            }
            buffer.append(" ItemId: ").append(message.itemId.id);
            buffer.append(" ChangeKey: ").append(message.itemId.changeKey);
            LOGGER.debug((Object)buffer.toString());
        }
        return message;
    }

    @Override
    public ExchangeSession.MessageList searchMessages(String folderPath, Set<String> attributes, ExchangeSession.Condition condition) throws IOException {
        ExchangeSession.MessageList messages = new ExchangeSession.MessageList();
        int maxCount = Settings.getIntProperty("davmail.folderSizeLimit", 0);
        List<EWSMethod.Item> responses = this.searchItems(folderPath, attributes, condition, FolderQueryTraversal.SHALLOW, maxCount);
        for (EWSMethod.Item response : responses) {
            if (!MESSAGE_TYPES.contains(response.type)) continue;
            ExchangeSession.Message message = this.buildMessage(response);
            message.messageList = messages;
            messages.add(message);
        }
        Collections.sort(messages);
        return messages;
    }

    protected List<EWSMethod.Item> searchItems(String folderPath, Set<String> attributes, ExchangeSession.Condition condition, FolderQueryTraversal folderQueryTraversal, int maxCount) throws IOException {
        if (maxCount == 0) {
            return this.searchItems(folderPath, attributes, condition, folderQueryTraversal);
        }
        FindItemMethod findItemMethod = new FindItemMethod(folderQueryTraversal, BaseShape.ID_ONLY, this.getFolderId(folderPath), 0, maxCount);
        for (String attribute : attributes) {
            findItemMethod.addAdditionalProperty(Field.get(attribute));
        }
        if (!attributes.contains("imapUid")) {
            findItemMethod.addAdditionalProperty(Field.get("imapUid"));
        }
        findItemMethod.setFieldOrder(new FieldOrder(Field.get("imapUid"), FieldOrder.Order.Descending));
        if (condition != null && !condition.isEmpty()) {
            findItemMethod.setSearchExpression((SearchExpression)((Object)condition));
        }
        this.executeMethod(findItemMethod);
        ArrayList<EWSMethod.Item> results = new ArrayList<EWSMethod.Item>(findItemMethod.getResponseItems());
        int resultCount = results.size();
        if (resultCount > 0 && LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Folder " + folderPath + " - Search items count: " + resultCount + " maxCount: " + maxCount + " highest uid: " + ((EWSMethod.Item)results.get(0)).getLong(Field.get("imapUid").getResponseName()) + " lowest uid: " + ((EWSMethod.Item)results.get(resultCount - 1)).getLong(Field.get("imapUid").getResponseName())));
        }
        return results;
    }

    protected List<EWSMethod.Item> searchItems(String folderPath, Set<String> attributes, ExchangeSession.Condition condition, FolderQueryTraversal folderQueryTraversal) throws IOException {
        FindItemMethod findItemMethod;
        int resultCount = 0;
        ArrayList<EWSMethod.Item> results = new ArrayList<EWSMethod.Item>();
        FolderId folderId = this.getFolderId(folderPath);
        do {
            findItemMethod = new FindItemMethod(folderQueryTraversal, BaseShape.ID_ONLY, folderId, resultCount, EwsExchangeSession.getPageSize());
            for (String attribute : attributes) {
                findItemMethod.addAdditionalProperty(Field.get(attribute));
            }
            if (!attributes.contains("imapUid")) {
                findItemMethod.addAdditionalProperty(Field.get("imapUid"));
            }
            findItemMethod.setFieldOrder(new FieldOrder(Field.get("imapUid"), FieldOrder.Order.Ascending));
            if (condition != null && !condition.isEmpty()) {
                findItemMethod.setSearchExpression((SearchExpression)((Object)condition));
            }
            this.executeMethod(findItemMethod);
            if (findItemMethod.getStatusCode() == 403) {
                throw new EWSException(findItemMethod.errorDetail);
            }
            long highestUid = 0L;
            if (resultCount > 0) {
                highestUid = ((EWSMethod.Item)results.get(resultCount - 1)).getLong(Field.get("imapUid").getResponseName());
            }
            for (EWSMethod.Item item : findItemMethod.getResponseItems()) {
                long imapUid = item.getLong(Field.get("imapUid").getResponseName());
                if (imapUid <= highestUid) continue;
                results.add(item);
            }
            resultCount = results.size();
            if (resultCount > 0 && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Folder " + folderPath + " - Search items current count: " + resultCount + " fetchCount: " + EwsExchangeSession.getPageSize() + " highest uid: " + ((EWSMethod.Item)results.get(resultCount - 1)).getLong(Field.get("imapUid").getResponseName()) + " lowest uid: " + ((EWSMethod.Item)results.get(0)).getLong(Field.get("imapUid").getResponseName())));
            }
            if (!Thread.interrupted()) continue;
            LOGGER.debug((Object)("Folder " + folderPath + " - Search items failed: Interrupted by client"));
            throw new IOException("Search items failed: Interrupted by client");
        } while (!findItemMethod.includesLastItemInRange);
        return results;
    }

    @Override
    public ExchangeSession.MultiCondition and(ExchangeSession.Condition ... condition) {
        return new MultiCondition(ExchangeSession.Operator.And, condition);
    }

    @Override
    public ExchangeSession.MultiCondition or(ExchangeSession.Condition ... condition) {
        return new MultiCondition(ExchangeSession.Operator.Or, condition);
    }

    @Override
    public ExchangeSession.Condition not(ExchangeSession.Condition condition) {
        return new NotCondition(condition);
    }

    @Override
    public ExchangeSession.Condition isEqualTo(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsEqualTo, value);
    }

    @Override
    public ExchangeSession.Condition isEqualTo(String attributeName, int value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsEqualTo, String.valueOf(value));
    }

    @Override
    public ExchangeSession.Condition headerIsEqualTo(String headerName, String value) {
        if (this.serverVersion.startsWith("Exchange201")) {
            if ("from".equals(headerName) || "to".equals(headerName) || "cc".equals(headerName)) {
                return new AttributeCondition("msg" + headerName, ExchangeSession.Operator.Contains, value, ContainmentMode.Substring, ContainmentComparison.IgnoreCase);
            }
            if ("message-id".equals(headerName) || "bcc".equals(headerName)) {
                return new AttributeCondition(headerName, ExchangeSession.Operator.Contains, value, ContainmentMode.Substring, ContainmentComparison.IgnoreCase);
            }
            return new AttributeCondition("messageheaders", ExchangeSession.Operator.Contains, headerName + ": " + value, ContainmentMode.Substring, ContainmentComparison.IgnoreCase);
        }
        return new HeaderCondition(headerName, value);
    }

    @Override
    public ExchangeSession.Condition gte(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsGreaterThanOrEqualTo, value);
    }

    @Override
    public ExchangeSession.Condition lte(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsLessThanOrEqualTo, value);
    }

    @Override
    public ExchangeSession.Condition lt(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsLessThan, value);
    }

    @Override
    public ExchangeSession.Condition gt(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsGreaterThan, value);
    }

    @Override
    public ExchangeSession.Condition contains(String attributeName, String value) {
        if ("from".equals(attributeName)) {
            attributeName = "msgfrom";
        } else if ("to".equals(attributeName)) {
            attributeName = "displayto";
        } else if ("cc".equals(attributeName)) {
            attributeName = "displaycc";
        }
        return new AttributeCondition(attributeName, ExchangeSession.Operator.Contains, value, ContainmentMode.Substring, ContainmentComparison.IgnoreCase);
    }

    @Override
    public ExchangeSession.Condition startsWith(String attributeName, String value) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.Contains, value, ContainmentMode.Prefixed, ContainmentComparison.IgnoreCase);
    }

    @Override
    public ExchangeSession.Condition isNull(String attributeName) {
        return new IsNullCondition(attributeName);
    }

    @Override
    public ExchangeSession.Condition exists(String attributeName) {
        return new ExistsCondition(attributeName);
    }

    @Override
    public ExchangeSession.Condition isTrue(String attributeName) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsEqualTo, "true");
    }

    @Override
    public ExchangeSession.Condition isFalse(String attributeName) {
        return new AttributeCondition(attributeName, ExchangeSession.Operator.IsEqualTo, "false");
    }

    protected Folder buildFolder(EWSMethod.Item item) {
        Folder folder = new Folder();
        folder.folderId = new FolderId(item);
        folder.displayName = EwsExchangeSession.encodeFolderName((String)item.get(Field.get("folderDisplayName").getResponseName()));
        folder.folderClass = (String)item.get(Field.get("folderclass").getResponseName());
        folder.etag = (String)item.get(Field.get("lastmodified").getResponseName());
        folder.ctag = (String)item.get(Field.get("ctag").getResponseName());
        folder.messageCount = item.getInt(Field.get("count").getResponseName());
        folder.recent = folder.unreadCount = item.getInt(Field.get("unread").getResponseName());
        folder.hasChildren = item.getBoolean(Field.get("hassubs").getResponseName());
        folder.uidNext = item.getInt(Field.get("uidNext").getResponseName());
        return folder;
    }

    @Override
    public List<ExchangeSession.Folder> getSubFolders(String folderPath, ExchangeSession.Condition condition, boolean recursive) throws IOException {
        int index;
        String baseFolderPath = folderPath;
        if (baseFolderPath.startsWith(USERS_ROOT) && (index = baseFolderPath.indexOf(47, USERS_ROOT.length())) >= 0) {
            baseFolderPath = baseFolderPath.substring(index + 1);
        }
        ArrayList<ExchangeSession.Folder> folders = new ArrayList<ExchangeSession.Folder>();
        this.appendSubFolders(folders, baseFolderPath, this.getFolderId(folderPath), condition, recursive);
        return folders;
    }

    protected void appendSubFolders(List<ExchangeSession.Folder> folders, String parentFolderPath, FolderId parentFolderId, ExchangeSession.Condition condition, boolean recursive) throws IOException {
        FindFolderMethod findFolderMethod;
        int resultCount = 0;
        do {
            findFolderMethod = new FindFolderMethod(FolderQueryTraversal.SHALLOW, BaseShape.ID_ONLY, parentFolderId, FOLDER_PROPERTIES, (SearchExpression)((Object)condition), resultCount, EwsExchangeSession.getPageSize());
            this.executeMethod(findFolderMethod);
            for (EWSMethod.Item item : findFolderMethod.getResponseItems()) {
                ++resultCount;
                Folder folder = this.buildFolder(item);
                folder.folderPath = !parentFolderPath.isEmpty() ? (parentFolderPath.endsWith("/") ? parentFolderPath + folder.displayName : parentFolderPath + '/' + folder.displayName) : (this.folderIdMap.get(folder.folderId.value) != null ? this.folderIdMap.get(folder.folderId.value) : folder.displayName);
                folders.add(folder);
                if (!recursive || !folder.hasChildren) continue;
                this.appendSubFolders(folders, folder.folderPath, folder.folderId, condition, true);
            }
        } while (!findFolderMethod.includesLastItemInRange);
    }

    @Override
    protected Folder internalGetFolder(String folderPath) throws IOException {
        FolderId folderId = this.getFolderId(folderPath);
        GetFolderMethod getFolderMethod = new GetFolderMethod(BaseShape.ID_ONLY, folderId, FOLDER_PROPERTIES);
        this.executeMethod(getFolderMethod);
        EWSMethod.Item item = getFolderMethod.getResponseItem();
        if (item == null) {
            throw new HttpNotFoundException("Folder " + folderPath + " not found");
        }
        Folder folder = this.buildFolder(item);
        folder.folderPath = folderPath;
        return folder;
    }

    @Override
    public int createFolder(String folderPath, String folderClass, Map<String, String> properties) throws IOException {
        FolderPath path = new FolderPath(folderPath);
        EWSMethod.Item folder = new EWSMethod.Item();
        folder.type = "Folder";
        folder.put("FolderClass", folderClass);
        folder.put("DisplayName", EwsExchangeSession.decodeFolderName(path.folderName));
        CreateFolderMethod createFolderMethod = new CreateFolderMethod(this.getFolderId(path.parentPath), folder);
        this.executeMethod(createFolderMethod);
        return 201;
    }

    @Override
    public int updateFolder(String folderPath, Map<String, String> properties) throws IOException {
        ArrayList<FieldUpdate> updates = new ArrayList<FieldUpdate>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            updates.add(new FieldUpdate(Field.get(entry.getKey()), entry.getValue()));
        }
        UpdateFolderMethod updateFolderMethod = new UpdateFolderMethod(this.internalGetFolder((String)folderPath).folderId, updates);
        this.executeMethod(updateFolderMethod);
        return 201;
    }

    @Override
    public void deleteFolder(String folderPath) throws IOException {
        FolderId folderId = this.getFolderIdIfExists(folderPath);
        if (folderId != null) {
            DeleteFolderMethod deleteFolderMethod = new DeleteFolderMethod(folderId);
            this.executeMethod(deleteFolderMethod);
        } else {
            LOGGER.debug((Object)("Folder " + folderPath + " not found"));
        }
    }

    @Override
    public void moveMessage(ExchangeSession.Message message, String targetFolder) throws IOException {
        MoveItemMethod moveItemMethod = new MoveItemMethod(((Message)message).itemId, this.getFolderId(targetFolder));
        this.executeMethod(moveItemMethod);
    }

    @Override
    public void moveMessages(List<ExchangeSession.Message> messages, String targetFolder) throws IOException {
        ArrayList<ItemId> itemIds = new ArrayList<ItemId>();
        for (ExchangeSession.Message message : messages) {
            itemIds.add(((Message)message).itemId);
        }
        MoveItemMethod moveItemMethod = new MoveItemMethod(itemIds, this.getFolderId(targetFolder));
        this.executeMethod(moveItemMethod);
    }

    @Override
    public void copyMessage(ExchangeSession.Message message, String targetFolder) throws IOException {
        CopyItemMethod copyItemMethod = new CopyItemMethod(((Message)message).itemId, this.getFolderId(targetFolder));
        this.executeMethod(copyItemMethod);
    }

    @Override
    public void copyMessages(List<ExchangeSession.Message> messages, String targetFolder) throws IOException {
        ArrayList<ItemId> itemIds = new ArrayList<ItemId>();
        for (ExchangeSession.Message message : messages) {
            itemIds.add(((Message)message).itemId);
        }
        CopyItemMethod copyItemMethod = new CopyItemMethod(itemIds, this.getFolderId(targetFolder));
        this.executeMethod(copyItemMethod);
    }

    @Override
    public void moveFolder(String folderPath, String targetFolderPath) throws IOException {
        FolderPath path = new FolderPath(folderPath);
        FolderPath targetPath = new FolderPath(targetFolderPath);
        FolderId folderId = this.getFolderId(folderPath);
        FolderId toFolderId = this.getFolderId(targetPath.parentPath);
        toFolderId.changeKey = null;
        if (!path.parentPath.equals(targetPath.parentPath)) {
            MoveFolderMethod moveFolderMethod = new MoveFolderMethod(folderId, toFolderId);
            this.executeMethod(moveFolderMethod);
        }
        if (!path.folderName.equals(targetPath.folderName)) {
            ArrayList<FieldUpdate> updates = new ArrayList<FieldUpdate>();
            updates.add(new FieldUpdate(Field.get("folderDisplayName"), targetPath.folderName));
            UpdateFolderMethod updateFolderMethod = new UpdateFolderMethod(folderId, updates);
            this.executeMethod(updateFolderMethod);
        }
    }

    @Override
    public void moveItem(String sourcePath, String targetPath) throws IOException {
        FolderPath sourceFolderPath = new FolderPath(sourcePath);
        ExchangeSession.Item item = this.getItem(sourceFolderPath.parentPath, sourceFolderPath.folderName);
        FolderPath targetFolderPath = new FolderPath(targetPath);
        FolderId toFolderId = this.getFolderId(targetFolderPath.parentPath);
        MoveItemMethod moveItemMethod = new MoveItemMethod(((Event)item).itemId, toFolderId);
        this.executeMethod(moveItemMethod);
    }

    @Override
    protected void moveToTrash(ExchangeSession.Message message) throws IOException {
        MoveItemMethod moveItemMethod = new MoveItemMethod(((Message)message).itemId, this.getFolderId("Trash"));
        this.executeMethod(moveItemMethod);
    }

    private boolean isExchange2013OrLater() {
        return "Exchange2013".compareTo(this.serverVersion) <= 0;
    }

    @Override
    public List<ExchangeSession.Contact> getAllContacts(String folderPath, boolean includeDistList) throws IOException {
        ExchangeSession.Condition condition = includeDistList ? this.or(this.isEqualTo("outlookmessageclass", "IPM.Contact"), this.isEqualTo("outlookmessageclass", "IPM.DistList")) : this.isEqualTo("outlookmessageclass", "IPM.Contact");
        return this.searchContacts(folderPath, ExchangeSession.CONTACT_ATTRIBUTES, condition, 0);
    }

    @Override
    public List<ExchangeSession.Contact> searchContacts(String folderPath, Set<String> attributes, ExchangeSession.Condition condition, int maxCount) throws IOException {
        ArrayList<ExchangeSession.Contact> contacts = new ArrayList<ExchangeSession.Contact>();
        List<EWSMethod.Item> responses = this.searchItems(folderPath, attributes, condition, FolderQueryTraversal.SHALLOW, maxCount);
        for (EWSMethod.Item response : responses) {
            contacts.add(new Contact(response));
        }
        return contacts;
    }

    @Override
    protected ExchangeSession.Condition getCalendarItemCondition(ExchangeSession.Condition dateCondition) {
        return this.or(this.or(this.isTrue("isrecurring"), this.and(this.isFalse("isrecurring"), dateCondition)), this.or(this.isEqualTo("instancetype", 1), this.and(this.isEqualTo("instancetype", 0), dateCondition)));
    }

    @Override
    public List<ExchangeSession.Event> getEventMessages(String folderPath) throws IOException {
        return this.searchEvents(folderPath, ITEM_PROPERTIES, this.and(this.startsWith("outlookmessageclass", "IPM.Schedule.Meeting."), this.or(this.isNull("processed"), this.isFalse("processed"))));
    }

    @Override
    public List<ExchangeSession.Event> searchEvents(String folderPath, Set<String> attributes, ExchangeSession.Condition condition) throws IOException {
        ArrayList<ExchangeSession.Event> events = new ArrayList<ExchangeSession.Event>();
        List<EWSMethod.Item> responses = this.searchItems(folderPath, attributes, condition, FolderQueryTraversal.SHALLOW, 0);
        for (EWSMethod.Item response : responses) {
            Event event = new Event(folderPath, response);
            if ("Message".equals(event.type)) {
                try {
                    event.getEventContent();
                    events.add(event);
                }
                catch (HttpNotFoundException e) {
                    LOGGER.warn((Object)("Ignore invalid event " + event.getHref()));
                }
                continue;
            }
            if (event.isException) {
                LOGGER.debug((Object)("Exclude recurrence exception " + event.getHref()));
                continue;
            }
            events.add(event);
        }
        return events;
    }

    @Override
    protected Set<String> getItemProperties() {
        return ITEM_PROPERTIES;
    }

    protected EWSMethod.Item getEwsItem(String folderPath, String itemName, Set<String> itemProperties) throws IOException {
        List<EWSMethod.Item> responses;
        EWSMethod.Item item = null;
        String urlcompname = this.convertItemNameToEML(itemName);
        if (EwsExchangeSession.isItemId(urlcompname)) {
            ItemId itemId = new ItemId(StringUtil.urlToBase64(urlcompname.substring(0, urlcompname.indexOf(46))));
            GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, itemId, false);
            for (String attribute : itemProperties) {
                getItemMethod.addAdditionalProperty(Field.get(attribute));
            }
            this.executeMethod(getItemMethod);
            item = getItemMethod.getResponseItem();
        }
        if (item == null && !(responses = this.searchItems(folderPath, itemProperties, this.isEqualTo("urlcompname", urlcompname), FolderQueryTraversal.SHALLOW, 0)).isEmpty()) {
            item = responses.get(0);
        }
        return item;
    }

    @Override
    public ExchangeSession.Item getItem(String folderPath, String itemName) throws IOException {
        EWSMethod.Item item = this.getEwsItem(folderPath, itemName, EVENT_REQUEST_PROPERTIES);
        if (item == null && this.isMainCalendar(folderPath)) {
            item = itemName.endsWith(".ics") ? this.getEwsItem("tasks", itemName.substring(0, itemName.length() - 3) + "EML", EVENT_REQUEST_PROPERTIES) : this.getEwsItem("tasks", itemName, EVENT_REQUEST_PROPERTIES);
        }
        if (item == null) {
            throw new HttpNotFoundException(itemName + " not found in " + folderPath);
        }
        String itemType = item.type;
        if ("Contact".equals(itemType) || "DistributionList".equals(itemType)) {
            ItemId itemId = new ItemId(item);
            GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, itemId, false);
            Set attributes = CONTACT_ATTRIBUTES;
            if ("DistributionList".equals(itemType)) {
                attributes = DISTRIBUTION_LIST_ATTRIBUTES;
            }
            for (String attribute : attributes) {
                getItemMethod.addAdditionalProperty(Field.get(attribute));
            }
            this.executeMethod(getItemMethod);
            item = getItemMethod.getResponseItem();
            if (item == null) {
                throw new HttpNotFoundException(itemName + " not found in " + folderPath);
            }
            return new Contact(item);
        }
        if ("CalendarItem".equals(itemType) || "MeetingMessage".equals(itemType) || "MeetingRequest".equals(itemType) || "MeetingResponse".equals(itemType) || "MeetingCancellation".equals(itemType) || "Task".equals(itemType) || "Message".equals(itemType)) {
            Event event = new Event(folderPath, item);
            event.setItemName(itemName);
            return event;
        }
        throw new HttpNotFoundException(itemName + " not found in " + folderPath);
    }

    @Override
    public ExchangeSession.ContactPhoto getContactPhoto(ExchangeSession.Contact contact) throws IOException {
        GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, ((Contact)contact).itemId, false);
        getItemMethod.addAdditionalProperty(Field.get("attachments"));
        this.executeMethod(getItemMethod);
        EWSMethod.Item item = getItemMethod.getResponseItem();
        if (item == null) {
            throw new IOException("Missing contact picture");
        }
        FileAttachment attachment = item.getAttachmentByName("ContactPicture.jpg");
        if (attachment == null) {
            throw new IOException("Missing contact picture");
        }
        GetAttachmentMethod getAttachmentMethod = new GetAttachmentMethod(attachment.attachmentId);
        this.executeMethod(getAttachmentMethod);
        ExchangeSession.ContactPhoto contactPhoto = new ExchangeSession.ContactPhoto();
        contactPhoto.content = (String)getAttachmentMethod.getResponseItem().get("Content");
        contactPhoto.contentType = attachment.contentType == null ? "image/jpeg" : attachment.contentType;
        return contactPhoto;
    }

    @Override
    public ExchangeSession.ContactPhoto getADPhoto(String email) {
        ExchangeSession.ContactPhoto contactPhoto = null;
        if (email != null) {
            try {
                GetUserPhotoMethod userPhotoMethod = new GetUserPhotoMethod(email, GetUserPhotoMethod.SizeRequested.HR240x240);
                this.executeMethod(userPhotoMethod);
                if (userPhotoMethod.getPictureData() != null) {
                    contactPhoto = new ExchangeSession.ContactPhoto();
                    contactPhoto.content = userPhotoMethod.getPictureData();
                    contactPhoto.contentType = userPhotoMethod.getContentType();
                    if (contactPhoto.contentType == null) {
                        contactPhoto.contentType = "image/jpeg";
                    }
                }
            }
            catch (IOException e) {
                LOGGER.debug((Object)("Error loading contact image from AD " + e + " " + e.getMessage()));
            }
        }
        return contactPhoto;
    }

    @Override
    public void deleteItem(String folderPath, String itemName) throws IOException {
        EWSMethod.Item item = this.getEwsItem(folderPath, itemName, EVENT_REQUEST_PROPERTIES);
        if (item != null && "CalendarItem".equals(item.type)) {
            if (this.serverVersion.compareTo("Exchange2013") >= 0) {
                CALENDAR_ITEM_REQUEST_PROPERTIES.add("isorganizer");
            }
            item = this.getEwsItem(folderPath, itemName, CALENDAR_ITEM_REQUEST_PROPERTIES);
        }
        if (item == null && this.isMainCalendar(folderPath)) {
            item = this.getEwsItem("tasks", itemName, EVENT_REQUEST_PROPERTIES);
        }
        if (item != null) {
            boolean hasAttendees;
            boolean isMeeting = "true".equals(item.get(Field.get("ismeeting").getResponseName()));
            boolean isOrganizer = item.get(Field.get("isorganizer").getResponseName()) != null ? "true".equals(item.get(Field.get("isorganizer").getResponseName())) : "Organizer".equals(item.get(Field.get("myresponsetype").getResponseName()));
            boolean bl = hasAttendees = item.get(Field.get("displayto").getResponseName()) != null || item.get(Field.get("displaycc").getResponseName()) != null;
            if (isMeeting && isOrganizer && hasAttendees && !this.isSharedFolder(folderPath) && Settings.getBooleanProperty("davmail.caldavAutoSchedule", true)) {
                SendMeetingInvitations sendMeetingInvitations = SendMeetingInvitations.SendToAllAndSaveCopy;
                MessageDisposition messageDisposition = MessageDisposition.SendAndSaveCopy;
                String body = null;
                if (Settings.getBooleanProperty("davmail.caldavEditNotifications")) {
                    String notificationSubject;
                    NotificationDialog notificationDialog;
                    String vEventSubject = (String)item.get(Field.get("subject").getResponseName());
                    if (vEventSubject == null) {
                        vEventSubject = "";
                    }
                    if (!(notificationDialog = new NotificationDialog(notificationSubject = BundleMessage.format("CANCELLED", new Object[0]) + vEventSubject, "")).getSendNotification()) {
                        LOGGER.debug((Object)"Notification canceled by user");
                        sendMeetingInvitations = SendMeetingInvitations.SendToNone;
                        messageDisposition = MessageDisposition.SaveOnly;
                    }
                    body = notificationDialog.getBody();
                }
                EWSMethod.Item cancelItem = new EWSMethod.Item();
                cancelItem.type = "CancelCalendarItem";
                cancelItem.referenceItemId = new ItemId("ReferenceItemId", item);
                if (body != null && !body.isEmpty()) {
                    item.put("Body", body);
                }
                CreateItemMethod cancelItemMethod = new CreateItemMethod(messageDisposition, sendMeetingInvitations, this.getFolderId("Sent"), cancelItem);
                this.executeMethod(cancelItemMethod);
            } else {
                DeleteType deleteType = DeleteType.MoveToDeletedItems;
                if (this.isSharedFolder(folderPath)) {
                    deleteType = DeleteType.HardDelete;
                }
                DeleteItemMethod deleteItemMethod = new DeleteItemMethod(new ItemId(item), deleteType, SendMeetingCancellations.SendToAllAndSaveCopy);
                this.executeMethod(deleteItemMethod);
            }
        }
    }

    @Override
    public void processItem(String folderPath, String itemName) throws IOException {
        EWSMethod.Item item = this.getEwsItem(folderPath, itemName, EVENT_REQUEST_PROPERTIES);
        if (item != null) {
            HashMap<String, String> localProperties = new HashMap<String, String>();
            localProperties.put("processed", "1");
            localProperties.put("read", "1");
            UpdateItemMethod updateItemMethod = new UpdateItemMethod(MessageDisposition.SaveOnly, ConflictResolution.AlwaysOverwrite, SendMeetingInvitationsOrCancellations.SendToNone, new ItemId(item), this.buildProperties(localProperties));
            this.executeMethod(updateItemMethod);
        }
    }

    @Override
    public int sendEvent(String icsBody) throws IOException {
        String itemName = UUID.randomUUID() + ".EML";
        byte[] mimeContent = new Event("Drafts", itemName, "urn:content-classes:calendarmessage", icsBody, null, null).createMimeContent();
        if (mimeContent == null) {
            return 204;
        }
        this.sendMessage(null, mimeContent);
        return 200;
    }

    @Override
    protected Contact buildContact(String folderPath, String itemName, Map<String, String> properties, String etag, String noneMatch) {
        return new Contact(folderPath, itemName, properties, StringUtil.removeQuotes(etag), noneMatch);
    }

    @Override
    protected ExchangeSession.ItemResult internalCreateOrUpdateEvent(String folderPath, String itemName, String contentClass, String icsBody, String etag, String noneMatch) throws IOException {
        return new Event(folderPath, itemName, contentClass, icsBody, StringUtil.removeQuotes(etag), noneMatch).createOrUpdate();
    }

    @Override
    public boolean isSharedFolder(String folderPath) {
        return folderPath.startsWith("/") && !folderPath.toLowerCase().startsWith(this.currentMailboxPath);
    }

    @Override
    public boolean isMainCalendar(String folderPath) throws IOException {
        FolderId currentFolderId = this.getFolderId(folderPath);
        FolderId calendarFolderId = this.getFolderId("calendar");
        return calendarFolderId.name.equals(currentFolderId.name) && calendarFolderId.value.equals(currentFolderId.value);
    }

    @Override
    protected String getFreeBusyData(String attendee, String start, String end, int interval) {
        String result = null;
        GetUserAvailabilityMethod getUserAvailabilityMethod = new GetUserAvailabilityMethod(attendee, start, end, interval);
        try {
            this.executeMethod(getUserAvailabilityMethod);
            result = getUserAvailabilityMethod.getMergedFreeBusy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected void loadVtimezone() {
        try {
            String timezoneId = Settings.getProperty("davmail.timezoneId");
            if (timezoneId == null && !"Exchange2007_SP1".equals(this.serverVersion)) {
                GetUserConfigurationMethod getUserConfigurationMethod = new GetUserConfigurationMethod();
                this.executeMethod(getUserConfigurationMethod);
                EWSMethod.Item item = getUserConfigurationMethod.getResponseItem();
                if (item != null) {
                    timezoneId = (String)item.get("timezone");
                }
            } else if (!this.directEws) {
                timezoneId = this.getTimezoneidFromOptions();
            }
            if (timezoneId == null) {
                LOGGER.warn((Object)"Unable to get user timezone, using GMT Standard Time. Set davmail.timezoneId setting to override this.");
                timezoneId = "GMT Standard Time";
            }
            this.deleteFolder("davmailtemp");
            this.createCalendarFolder("davmailtemp", null);
            EWSMethod.Item item = new EWSMethod.Item();
            item.type = "CalendarItem";
            if (!"Exchange2007_SP1".equals(this.serverVersion)) {
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
                dateFormatter.setTimeZone(GMT_TIMEZONE);
                Calendar cal = Calendar.getInstance();
                item.put("Start", dateFormatter.format(cal.getTime()));
                cal.add(5, 1);
                item.put("End", dateFormatter.format(cal.getTime()));
                item.put("StartTimeZone", timezoneId);
            } else {
                item.put("MeetingTimeZone", timezoneId);
            }
            CreateItemMethod createItemMethod = new CreateItemMethod(MessageDisposition.SaveOnly, SendMeetingInvitations.SendToNone, this.getFolderId("davmailtemp"), item);
            this.executeMethod(createItemMethod);
            item = createItemMethod.getResponseItem();
            if (item == null) {
                throw new IOException("Empty timezone item");
            }
            VCalendar vCalendar = new VCalendar(this.getContent(new ItemId(item)), this.email, null);
            this.vTimezone = vCalendar.getVTimezone();
            this.deleteFolder("davmailtemp");
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Unable to get VTIMEZONE info: " + e), (Throwable)e);
        }
    }

    protected String getTimezoneidFromOptions() {
        String result = null;
        String optionsPath = "/owa/?ae=Options&t=Regional";
        GetRequest optionsMethod = new GetRequest(optionsPath);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpRequestBase)optionsMethod);
             BufferedReader optionsPageReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));){
            String line;
            while ((line = optionsPageReader.readLine()) != null && !line.contains("tblTmZn") && !line.contains("selTmZn")) {
            }
            if (line != null) {
                if (line.contains("tblTmZn")) {
                    int start = line.indexOf("oV=\"") + 4;
                    int end = line.indexOf(34, start);
                    result = line.substring(start, end);
                } else {
                    int end = line.lastIndexOf("\" selected>");
                    int start = line.lastIndexOf(34, end - 1);
                    result = line.substring(start + 1, end);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error parsing options page at " + optionsPath));
        }
        return result;
    }

    protected FolderId getFolderId(String folderPath) throws IOException {
        FolderId folderId = this.getFolderIdIfExists(folderPath);
        if (folderId == null) {
            throw new HttpNotFoundException("Folder '" + folderPath + "' not found");
        }
        return folderId;
    }

    protected FolderId getFolderIdIfExists(String folderPath) throws IOException {
        String lowerCaseFolderPath = folderPath.toLowerCase();
        if (lowerCaseFolderPath.equals(this.currentMailboxPath)) {
            return this.getSubFolderIdIfExists(null, "");
        }
        if (lowerCaseFolderPath.startsWith(this.currentMailboxPath + '/')) {
            return this.getSubFolderIdIfExists(null, folderPath.substring(this.currentMailboxPath.length() + 1));
        }
        if (folderPath.startsWith(USERS_ROOT)) {
            String subFolderPath;
            String mailbox;
            int slashIndex = folderPath.indexOf(47, USERS_ROOT.length());
            if (slashIndex >= 0) {
                mailbox = folderPath.substring(USERS_ROOT.length(), slashIndex);
                subFolderPath = folderPath.substring(slashIndex + 1);
            } else {
                mailbox = folderPath.substring(USERS_ROOT.length());
                subFolderPath = "";
            }
            return this.getSubFolderIdIfExists(mailbox, subFolderPath);
        }
        return this.getSubFolderIdIfExists(null, folderPath);
    }

    protected FolderId getSubFolderIdIfExists(String mailbox, String folderPath) throws IOException {
        String[] folderNames;
        FolderId currentFolderId;
        if ("/public".equals(folderPath)) {
            return DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.publicfoldersroot);
        }
        if ("/archive".equals(folderPath)) {
            return DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.archivemsgfolderroot);
        }
        if (this.isSubFolderOf(folderPath, "/public/")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.publicfoldersroot);
            folderNames = folderPath.substring("/public/".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, ARCHIVE_ROOT)) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.archivemsgfolderroot);
            folderNames = folderPath.substring(ARCHIVE_ROOT.length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "INBOX") || this.isSubFolderOf(folderPath, "inbox") || this.isSubFolderOf(folderPath, "Inbox")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.inbox);
            folderNames = folderPath.substring("INBOX".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "calendar")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.calendar);
            folderNames = folderPath.substring("calendar".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "tasks")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.tasks);
            folderNames = folderPath.substring("tasks".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "contacts")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.contacts);
            folderNames = folderPath.substring("contacts".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "Sent")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.sentitems);
            folderNames = folderPath.substring("Sent".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "Drafts")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.drafts);
            folderNames = folderPath.substring("Drafts".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "Trash")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.deleteditems);
            folderNames = folderPath.substring("Trash".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "Junk")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.junkemail);
            folderNames = folderPath.substring("Junk".length()).split("/");
        } else if (this.isSubFolderOf(folderPath, "Unsent Messages")) {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.outbox);
            folderNames = folderPath.substring("Unsent Messages".length()).split("/");
        } else {
            currentFolderId = DistinguishedFolderId.getInstance(mailbox, DistinguishedFolderId.Name.msgfolderroot);
            folderNames = folderPath.split("/");
        }
        for (String folderName : folderNames) {
            if (!folderName.isEmpty() && (currentFolderId = this.getSubFolderByName(currentFolderId, folderName)) == null) break;
        }
        return currentFolderId;
    }

    private boolean isSubFolderOf(String folderPath, String baseFolder) {
        if ("/public/".equals(baseFolder) || ARCHIVE_ROOT.equals(baseFolder)) {
            return folderPath.startsWith(baseFolder);
        }
        return folderPath.startsWith(baseFolder) && (folderPath.length() == baseFolder.length() || folderPath.charAt(baseFolder.length()) == '/');
    }

    protected FolderId getSubFolderByName(FolderId parentFolderId, String folderName) throws IOException {
        FolderId folderId = null;
        FindFolderMethod findFolderMethod = new FindFolderMethod(FolderQueryTraversal.SHALLOW, BaseShape.ID_ONLY, parentFolderId, FOLDER_PROPERTIES, new TwoOperandExpression(TwoOperandExpression.Operator.IsEqualTo, Field.get("folderDisplayName"), EwsExchangeSession.decodeFolderName(folderName)), 0, 1);
        this.executeMethod(findFolderMethod);
        EWSMethod.Item item = findFolderMethod.getResponseItem();
        if (item != null) {
            folderId = new FolderId(item);
        }
        return folderId;
    }

    public static String decodeFolderName(String folderName) {
        if (folderName.contains("_xF8FF_")) {
            return folderName.replaceAll("_xF8FF_", "/");
        }
        if (folderName.contains("_x003E_")) {
            return folderName.replaceAll("_x003E_", ">");
        }
        return folderName;
    }

    public static String encodeFolderName(String folderName) {
        if (folderName.contains("/")) {
            folderName = folderName.replaceAll("/", "_xF8FF_");
        }
        if (folderName.contains(">")) {
            folderName = folderName.replaceAll(">", "_x003E_");
        }
        return folderName;
    }

    protected int executeMethod(EWSMethod ewsMethod) throws IOException {
        long throttlingDelay = this.throttlingTimestamp - System.currentTimeMillis();
        try {
            if (throttlingDelay > 0L) {
                LOGGER.warn((Object)("Throttling active on server, waiting " + throttlingDelay / 1000L + " seconds"));
                try {
                    Thread.sleep(throttlingDelay);
                }
                catch (InterruptedException e1) {
                    LOGGER.error((Object)("Throttling delay interrupted " + e1.getMessage()));
                    Thread.currentThread().interrupt();
                }
            }
            this.internalExecuteMethod(ewsMethod);
        }
        catch (EWSThrottlingException e) {
            throttlingDelay = 60000L;
            if (ewsMethod.backOffMilliseconds > 0L) {
                throttlingDelay = ewsMethod.backOffMilliseconds + 10000L;
            }
            this.throttlingTimestamp = System.currentTimeMillis() + throttlingDelay;
            LOGGER.warn((Object)("Throttling active on server, waiting " + throttlingDelay / 1000L + " seconds"));
            try {
                Thread.sleep(throttlingDelay);
            }
            catch (InterruptedException e1) {
                LOGGER.error((Object)("Throttling delay interrupted " + e1.getMessage()));
                Thread.currentThread().interrupt();
            }
            this.internalExecuteMethod(ewsMethod);
        }
        return ewsMethod.getStatusCode();
    }

    protected void internalExecuteMethod(EWSMethod ewsMethod) throws IOException {
        ewsMethod.setServerVersion(this.serverVersion);
        if (this.token != null) {
            ewsMethod.setHeader("Authorization", "Bearer " + this.token.getAccessToken());
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpRequestBase)ewsMethod);){
            ewsMethod.handleResponse((HttpResponse)response);
        }
        if (this.serverVersion == null) {
            this.serverVersion = ewsMethod.getServerVersion();
        }
        ewsMethod.checkSuccess();
    }

    protected Contact buildGalfindContact(EWSMethod.Item response) {
        Contact contact = new Contact();
        contact.setName((String)response.get("Name"));
        contact.put("imapUid", response.get("Name"));
        contact.put("uid", response.get("Name"));
        if (LOGGER.isDebugEnabled()) {
            for (Map.Entry<Object, Object> entry : response.entrySet()) {
                String key = (String)entry.getKey();
                if (IGNORE_ATTRIBUTE_SET.contains(key) || GALFIND_ATTRIBUTE_MAP.containsValue(key)) continue;
                LOGGER.debug((Object)("Unsupported ResolveNames " + contact.getName() + " response attribute: " + key + " value: " + (String)entry.getValue()));
            }
        }
        for (Map.Entry<Object, Object> entry : GALFIND_ATTRIBUTE_MAP.entrySet()) {
            String attributeValue = (String)response.get(entry.getValue());
            if (attributeValue == null || attributeValue.isEmpty()) continue;
            contact.put(entry.getKey(), attributeValue);
        }
        return contact;
    }

    @Override
    public Map<String, ExchangeSession.Contact> galFind(ExchangeSession.Condition condition, Set<String> returningAttributes, int sizeLimit) throws IOException {
        HashMap<String, ExchangeSession.Contact> contacts;
        block9: {
            String mappedAttributeName;
            block7: {
                ExchangeSession.Operator operator;
                List<ExchangeSession.Condition> conditions;
                block8: {
                    contacts = new HashMap<String, ExchangeSession.Contact>();
                    if (!(condition instanceof MultiCondition)) break block7;
                    conditions = ((ExchangeSession.MultiCondition)condition).getConditions();
                    operator = ((ExchangeSession.MultiCondition)condition).getOperator();
                    if (operator != ExchangeSession.Operator.Or) break block8;
                    for (ExchangeSession.Condition innerCondition : conditions) {
                        contacts.putAll(this.galFind(innerCondition, returningAttributes, sizeLimit));
                    }
                    break block9;
                }
                if (operator != ExchangeSession.Operator.And || conditions.isEmpty()) break block9;
                Map<String, ExchangeSession.Contact> innerContacts = this.galFind(conditions.get(0), returningAttributes, sizeLimit);
                for (ExchangeSession.Contact contact : innerContacts.values()) {
                    if (!condition.isMatch(contact)) continue;
                    contacts.put(contact.getName().toLowerCase(), contact);
                }
                break block9;
            }
            if (condition instanceof AttributeCondition && (mappedAttributeName = GALFIND_ATTRIBUTE_MAP.get(((ExchangeSession.AttributeCondition)condition).getAttributeName())) != null) {
                String value = ((ExchangeSession.AttributeCondition)condition).getValue().toLowerCase();
                ExchangeSession.Operator operator = ((AttributeCondition)condition).getOperator();
                String searchValue = value;
                if (mappedAttributeName.startsWith("EmailAddress")) {
                    searchValue = "smtp:" + searchValue;
                }
                if (operator == ExchangeSession.Operator.IsEqualTo) {
                    searchValue = '=' + searchValue;
                }
                ResolveNamesMethod resolveNamesMethod = new ResolveNamesMethod(searchValue);
                this.executeMethod(resolveNamesMethod);
                List<EWSMethod.Item> responses = resolveNamesMethod.getResponseItems();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ResolveNames(" + searchValue + ") returned " + responses.size() + " results"));
                }
                for (EWSMethod.Item response : responses) {
                    Contact contact = this.buildGalfindContact(response);
                    if (!condition.isMatch(contact)) continue;
                    contacts.put(contact.getName().toLowerCase(), contact);
                }
            }
        }
        return contacts;
    }

    protected Date parseDateFromExchange(String exchangeDateValue) throws DavMailException {
        Date dateValue = null;
        if (exchangeDateValue != null) {
            try {
                dateValue = EwsExchangeSession.getExchangeZuluDateFormat().parse(exchangeDateValue);
            }
            catch (ParseException e) {
                throw new DavMailException("EXCEPTION_INVALID_DATE", exchangeDateValue);
            }
        }
        return dateValue;
    }

    protected String convertDateFromExchange(String exchangeDateValue) throws DavMailException {
        if (exchangeDateValue == null) {
            return null;
        }
        if (exchangeDateValue.length() != 20) {
            throw new DavMailException("EXCEPTION_INVALID_DATE", exchangeDateValue);
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < exchangeDateValue.length(); ++i) {
            if (i == 4 || i == 7 || i == 13 || i == 16) {
                ++i;
            }
            buffer.append(exchangeDateValue.charAt(i));
        }
        return buffer.toString();
    }

    protected String convertCalendarDateToExchange(String vcalendarDateValue) throws DavMailException {
        String zuluDateValue = null;
        if (vcalendarDateValue != null) {
            try {
                SimpleDateFormat dateParser = vcalendarDateValue.length() == 8 ? new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH) : new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.ENGLISH);
                dateParser.setTimeZone(GMT_TIMEZONE);
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
                dateFormatter.setTimeZone(GMT_TIMEZONE);
                zuluDateValue = dateFormatter.format(dateParser.parse(vcalendarDateValue));
            }
            catch (ParseException e) {
                throw new DavMailException("EXCEPTION_INVALID_DATE", vcalendarDateValue);
            }
        }
        return zuluDateValue;
    }

    public static String convertDateFromExchangeToTaskDate(String exchangeDateValue) throws DavMailException {
        String zuluDateValue = null;
        if (exchangeDateValue != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
                dateFormat.setTimeZone(GMT_TIMEZONE);
                zuluDateValue = dateFormat.format(EwsExchangeSession.getExchangeZuluDateFormat().parse(exchangeDateValue));
            }
            catch (ParseException e) {
                throw new DavMailException("EXCEPTION_INVALID_DATE", exchangeDateValue);
            }
        }
        return zuluDateValue;
    }

    protected String convertTaskDateToZulu(String value) {
        String result = null;
        if (value != null && !value.isEmpty()) {
            try {
                SimpleDateFormat parser = ExchangeSession.getExchangeDateFormat(value);
                Calendar calendarValue = Calendar.getInstance(GMT_TIMEZONE);
                calendarValue.setTime(parser.parse(value));
                if (value.length() == 16) {
                    calendarValue.add(10, 12);
                }
                calendarValue.set(10, 0);
                calendarValue.set(12, 0);
                calendarValue.set(13, 0);
                result = ExchangeSession.getExchangeZuluDateFormat().format(calendarValue.getTime());
            }
            catch (ParseException e) {
                LOGGER.warn((Object)("Invalid date: " + value));
            }
        }
        return result;
    }

    @Override
    public String formatSearchDate(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        dateFormatter.setTimeZone(GMT_TIMEZONE);
        return dateFormatter.format(date);
    }

    protected static boolean isItemId(String itemName) {
        return itemName.length() >= 140 && itemName.matches("^([A-Za-z0-9-_]{4})*([A-Za-z0-9-_]{4}|[A-Za-z0-9-_]{3}=|[A-Za-z0-9-_]{2}==)\\.EML$") && itemName.indexOf(32) < 0;
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    static /* synthetic */ Logger access$500() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$600() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$700() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$800() {
        return LOGGER;
    }

    static /* synthetic */ String access$900(EwsExchangeSession x0) {
        return x0.serverVersion;
    }

    static /* synthetic */ String access$1000(EwsExchangeSession x0) {
        return x0.serverVersion;
    }

    static /* synthetic */ Logger access$1100() {
        return LOGGER;
    }

    static {
        MESSAGE_TYPES.add("Message");
        MESSAGE_TYPES.add("CalendarItem");
        MESSAGE_TYPES.add("MeetingMessage");
        MESSAGE_TYPES.add("MeetingRequest");
        MESSAGE_TYPES.add("MeetingResponse");
        MESSAGE_TYPES.add("MeetingCancellation");
        MESSAGE_TYPES.add("Item");
        MESSAGE_TYPES.add("PostItem");
        partstatToResponseMap = new HashMap<String, String>();
        responseTypeToPartstatMap = new HashMap<String, String>();
        statusToBusyStatusMap = new HashMap<String, String>();
        partstatToResponseMap.put("ACCEPTED", "AcceptItem");
        partstatToResponseMap.put("TENTATIVE", "TentativelyAcceptItem");
        partstatToResponseMap.put("DECLINED", "DeclineItem");
        partstatToResponseMap.put("NEEDS-ACTION", "ReplyToItem");
        responseTypeToPartstatMap.put("Accept", "ACCEPTED");
        responseTypeToPartstatMap.put("Tentative", "TENTATIVE");
        responseTypeToPartstatMap.put("Decline", "DECLINED");
        responseTypeToPartstatMap.put("NoResponseReceived", "NEEDS-ACTION");
        responseTypeToPartstatMap.put("Unknown", "NEEDS-ACTION");
        statusToBusyStatusMap.put("TENTATIVE", "Tentative");
        statusToBusyStatusMap.put("CONFIRMED", "Busy");
        FOLDER_PROPERTIES = new HashSet();
        FOLDER_PROPERTIES.add(Field.get("urlcompname"));
        FOLDER_PROPERTIES.add(Field.get("folderDisplayName"));
        FOLDER_PROPERTIES.add(Field.get("lastmodified"));
        FOLDER_PROPERTIES.add(Field.get("folderclass"));
        FOLDER_PROPERTIES.add(Field.get("ctag"));
        FOLDER_PROPERTIES.add(Field.get("count"));
        FOLDER_PROPERTIES.add(Field.get("unread"));
        FOLDER_PROPERTIES.add(Field.get("hassubs"));
        FOLDER_PROPERTIES.add(Field.get("uidNext"));
        FOLDER_PROPERTIES.add(Field.get("highestUid"));
        ITEM_PROPERTIES = new HashSet<String>();
        ITEM_PROPERTIES.add("etag");
        ITEM_PROPERTIES.add("displayname");
        ITEM_PROPERTIES.add("instancetype");
        ITEM_PROPERTIES.add("urlcompname");
        ITEM_PROPERTIES.add("subject");
        EVENT_REQUEST_PROPERTIES = new HashSet();
        EVENT_REQUEST_PROPERTIES.add("permanenturl");
        EVENT_REQUEST_PROPERTIES.add("etag");
        EVENT_REQUEST_PROPERTIES.add("displayname");
        EVENT_REQUEST_PROPERTIES.add("subject");
        EVENT_REQUEST_PROPERTIES.add("urlcompname");
        EVENT_REQUEST_PROPERTIES.add("displayto");
        EVENT_REQUEST_PROPERTIES.add("displaycc");
        EVENT_REQUEST_PROPERTIES.add("xmozlastack");
        EVENT_REQUEST_PROPERTIES.add("xmozsnoozetime");
        CALENDAR_ITEM_REQUEST_PROPERTIES = new HashSet();
        CALENDAR_ITEM_REQUEST_PROPERTIES.addAll(EVENT_REQUEST_PROPERTIES);
        CALENDAR_ITEM_REQUEST_PROPERTIES.add("ismeeting");
        CALENDAR_ITEM_REQUEST_PROPERTIES.add("myresponsetype");
        GALFIND_ATTRIBUTE_MAP = new HashMap();
        GALFIND_ATTRIBUTE_MAP.put("imapUid", "Name");
        GALFIND_ATTRIBUTE_MAP.put("cn", "DisplayName");
        GALFIND_ATTRIBUTE_MAP.put("givenName", "GivenName");
        GALFIND_ATTRIBUTE_MAP.put("sn", "Surname");
        GALFIND_ATTRIBUTE_MAP.put("smtpemail1", "EmailAddress");
        GALFIND_ATTRIBUTE_MAP.put("roomnumber", "OfficeLocation");
        GALFIND_ATTRIBUTE_MAP.put("street", "BusinessStreet");
        GALFIND_ATTRIBUTE_MAP.put("l", "BusinessCity");
        GALFIND_ATTRIBUTE_MAP.put("o", "CompanyName");
        GALFIND_ATTRIBUTE_MAP.put("postalcode", "BusinessPostalCode");
        GALFIND_ATTRIBUTE_MAP.put("st", "BusinessState");
        GALFIND_ATTRIBUTE_MAP.put("co", "BusinessCountryOrRegion");
        GALFIND_ATTRIBUTE_MAP.put("manager", "Manager");
        GALFIND_ATTRIBUTE_MAP.put("middlename", "Initials");
        GALFIND_ATTRIBUTE_MAP.put("title", "JobTitle");
        GALFIND_ATTRIBUTE_MAP.put("department", "Department");
        GALFIND_ATTRIBUTE_MAP.put("otherTelephone", "OtherTelephone");
        GALFIND_ATTRIBUTE_MAP.put("telephoneNumber", "BusinessPhone");
        GALFIND_ATTRIBUTE_MAP.put("mobile", "MobilePhone");
        GALFIND_ATTRIBUTE_MAP.put("facsimiletelephonenumber", "BusinessFax");
        GALFIND_ATTRIBUTE_MAP.put("secretarycn", "AssistantName");
        GALFIND_ATTRIBUTE_MAP.put("homePhone", "HomePhone");
        GALFIND_ATTRIBUTE_MAP.put("pager", "Pager");
        GALFIND_ATTRIBUTE_MAP.put("msexchangecertificate", "MSExchangeCertificate");
        GALFIND_ATTRIBUTE_MAP.put("usersmimecertificate", "UserSMIMECertificate");
        IGNORE_ATTRIBUTE_SET = new HashSet();
        IGNORE_ATTRIBUTE_SET.add("ContactSource");
        IGNORE_ATTRIBUTE_SET.add("Culture");
        IGNORE_ATTRIBUTE_SET.add("AssistantPhone");
    }

    protected class Event
    extends ExchangeSession.Event {
        ItemId itemId;
        String type;
        boolean isException;

        protected Event(String folderPath, EWSMethod.Item response) {
            this.folderPath = folderPath;
            this.itemId = new ItemId(response);
            this.type = response.type;
            this.permanentUrl = (String)response.get(Field.get("permanenturl").getResponseName());
            this.etag = (String)response.get(Field.get("etag").getResponseName());
            this.displayName = (String)response.get(Field.get("displayname").getResponseName());
            this.subject = (String)response.get(Field.get("subject").getResponseName());
            this.itemName = StringUtil.base64ToUrl(this.itemId.id) + ".EML";
            String instancetype = (String)response.get(Field.get("instancetype").getResponseName());
            this.isException = "3".equals(instancetype);
        }

        protected Event(String folderPath, String itemName, String contentClass, String itemBody, String etag, String noneMatch) throws IOException {
            super(folderPath, itemName, contentClass, itemBody, etag, noneMatch);
        }

        /*
         * Exception decompiling
         */
        protected void handleExcludedDates(ItemId currentItemId, VCalendar vCalendar) throws DavMailException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        protected void handleModifiedOccurrences(ItemId currentItemId, VCalendar vCalendar, SendMeetingInvitationsOrCancellations sendMeetingInvitationsOrCancellations) throws DavMailException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected List<FieldUpdate> buildFieldUpdates(VCalendar vCalendar, VObject vEvent, boolean isMozDismiss) throws DavMailException {
            String xMozSnoozeTime;
            String xMozLastack;
            ArrayList<FieldUpdate> updates = new ArrayList<FieldUpdate>();
            if (isMozDismiss || "1".equals(vEvent.getPropertyValue("X-MOZ-FAKED-MASTER"))) {
                String xMozSnoozeTime2;
                String xMozLastack2 = vCalendar.getFirstVeventPropertyValue("X-MOZ-LASTACK");
                if (xMozLastack2 != null) {
                    updates.add(Field.createFieldUpdate("xmozlastack", xMozLastack2));
                }
                if ((xMozSnoozeTime2 = vCalendar.getFirstVeventPropertyValue("X-MOZ-SNOOZE-TIME")) != null) {
                    updates.add(Field.createFieldUpdate("xmozsnoozetime", xMozSnoozeTime2));
                }
                return updates;
            }
            if (!vCalendar.isMeeting() || vCalendar.isMeetingOrganizer()) {
                String string;
                VProperty rrule;
                updates.add(Field.createFieldUpdate("dtstart", EwsExchangeSession.this.convertCalendarDateToExchange(vEvent.getPropertyValue("DTSTART"))));
                updates.add(Field.createFieldUpdate("dtend", EwsExchangeSession.this.convertCalendarDateToExchange(vEvent.getPropertyValue("DTEND"))));
                if ("Exchange2007_SP1".equals(EwsExchangeSession.this.serverVersion)) {
                    updates.add(Field.createFieldUpdate("meetingtimezone", vEvent.getProperty("DTSTART").getParamValue("TZID")));
                } else {
                    String starttimezone;
                    String endtimezone = starttimezone = vEvent.getProperty("DTSTART").getParamValue("TZID");
                    if (vEvent.getProperty("DTEND") != null) {
                        endtimezone = vEvent.getProperty("DTEND").getParamValue("TZID");
                    }
                    updates.add(Field.createFieldUpdate("starttimezone", starttimezone));
                    updates.add(Field.createFieldUpdate("endtimezone", endtimezone));
                }
                String status = statusToBusyStatusMap.get(vEvent.getPropertyValue("STATUS"));
                if (status != null) {
                    updates.add(Field.createFieldUpdate("busystatus", status));
                }
                updates.add(Field.createFieldUpdate("isalldayevent", Boolean.toString(vCalendar.isCdoAllDay())));
                String eventClass = vEvent.getPropertyValue("CLASS");
                eventClass = "PRIVATE".equals(eventClass) ? "Private" : ("CONFIDENTIAL".equals(eventClass) ? "Confidential" : "Normal");
                updates.add(Field.createFieldUpdate("itemsensitivity", eventClass));
                updates.add(Field.createFieldUpdate("description", vEvent.getPropertyValue("DESCRIPTION")));
                updates.add(Field.createFieldUpdate("subject", vEvent.getPropertyValue("SUMMARY")));
                updates.add(Field.createFieldUpdate("location", vEvent.getPropertyValue("LOCATION")));
                List<VProperty> categories = vEvent.getProperties("CATEGORIES");
                if (categories != null) {
                    HashSet<String> categoryValues = new HashSet<String>();
                    for (VProperty category : categories) {
                        categoryValues.add(category.getValue());
                    }
                    updates.add(Field.createFieldUpdate("keywords", StringUtil.join(categoryValues, ",")));
                }
                if ((rrule = vEvent.getProperty("RRULE")) != null) {
                    RecurrenceFieldUpdate recurrenceFieldUpdate = new RecurrenceFieldUpdate();
                    List<String> rruleValues = rrule.getValues();
                    for (String string2 : rruleValues) {
                        int index = string2.indexOf("=");
                        if (index < 0) continue;
                        String key = string2.substring(0, index);
                        String value = string2.substring(index + 1);
                        switch (key) {
                            case "FREQ": {
                                recurrenceFieldUpdate.setRecurrencePattern(value);
                                break;
                            }
                            case "UNTIL": {
                                recurrenceFieldUpdate.setEndDate(EwsExchangeSession.this.parseDateFromExchange(EwsExchangeSession.this.convertCalendarDateToExchange(value) + "Z"));
                                break;
                            }
                            case "COUNT": {
                                recurrenceFieldUpdate.setCount(value);
                                break;
                            }
                            case "BYDAY": {
                                recurrenceFieldUpdate.setByDay(value.split(","));
                                break;
                            }
                            case "INTERVAL": {
                                recurrenceFieldUpdate.setRecurrenceInterval(value);
                            }
                        }
                    }
                    recurrenceFieldUpdate.setStartDate(EwsExchangeSession.this.parseDateFromExchange(EwsExchangeSession.this.convertCalendarDateToExchange(vEvent.getPropertyValue("DTSTART")) + "Z"));
                    updates.add(recurrenceFieldUpdate);
                }
                MultiValuedFieldUpdate requiredAttendees = new MultiValuedFieldUpdate(Field.get("requiredattendees"));
                MultiValuedFieldUpdate optionalAttendees = new MultiValuedFieldUpdate(Field.get("optionalattendees"));
                updates.add(requiredAttendees);
                updates.add(optionalAttendees);
                List<VProperty> attendees = vEvent.getProperties("ATTENDEE");
                if (attendees != null) {
                    for (VProperty property : attendees) {
                        String attendeeEmail = vCalendar.getEmailValue(property);
                        if (attendeeEmail == null || attendeeEmail.indexOf(64) < 0 || EwsExchangeSession.this.email.equals(attendeeEmail)) continue;
                        String attendeeRole = property.getParamValue("ROLE");
                        if ("REQ-PARTICIPANT".equals(attendeeRole)) {
                            requiredAttendees.addValue(attendeeEmail);
                            continue;
                        }
                        optionalAttendees.addValue(attendeeEmail);
                    }
                }
                if ((string = vCalendar.getFirstVeventPropertyValue("X-MOZ-SEND-INVITATIONS")) != null) {
                    updates.add(Field.createFieldUpdate("xmozsendinvitations", string));
                }
            }
            updates.add(Field.createFieldUpdate("reminderset", String.valueOf(vCalendar.hasVAlarm())));
            if (vCalendar.hasVAlarm()) {
                updates.add(Field.createFieldUpdate("reminderminutesbeforestart", vCalendar.getReminderMinutesBeforeStart()));
            }
            if ((xMozLastack = vCalendar.getFirstVeventPropertyValue("X-MOZ-LASTACK")) != null) {
                updates.add(Field.createFieldUpdate("xmozlastack", xMozLastack));
            }
            if ((xMozSnoozeTime = vCalendar.getFirstVeventPropertyValue("X-MOZ-SNOOZE-TIME")) != null) {
                updates.add(Field.createFieldUpdate("xmozsnoozetime", xMozSnoozeTime));
            }
            return updates;
        }

        @Override
        public ExchangeSession.ItemResult createOrUpdate() throws IOException {
            ArrayList<FieldUpdate> updates;
            EWSMethod.Item newItem;
            EWSMethod.Item currentItem;
            if (this.vCalendar.isTodo() && EwsExchangeSession.this.isMainCalendar(this.folderPath)) {
                this.folderPath = "tasks";
            }
            ExchangeSession.ItemResult itemResult = new ExchangeSession.ItemResult();
            EWSMethod createOrUpdateItemMethod = null;
            String currentEtag = null;
            ItemId currentItemId = null;
            String ownerResponseReply = null;
            boolean isMeetingResponse = false;
            boolean isMozSendInvitations = true;
            boolean isMozDismiss = false;
            HashSet<String> itemRequestProperties = CALENDAR_ITEM_REQUEST_PROPERTIES;
            if (this.vCalendar.isTodo()) {
                itemRequestProperties = EVENT_REQUEST_PROPERTIES;
            }
            if ((currentItem = EwsExchangeSession.this.getEwsItem(this.folderPath, this.itemName, itemRequestProperties)) != null) {
                currentItemId = new ItemId(currentItem);
                currentEtag = (String)currentItem.get(Field.get("etag").getResponseName());
                String currentAttendeeStatus = responseTypeToPartstatMap.get(currentItem.get(Field.get("myresponsetype").getResponseName()));
                String newAttendeeStatus = this.vCalendar.getAttendeeStatus();
                isMeetingResponse = this.vCalendar.isMeeting() && !this.vCalendar.isMeetingOrganizer() && newAttendeeStatus != null && !newAttendeeStatus.equals(currentAttendeeStatus) && partstatToResponseMap.get(newAttendeeStatus) != null;
                String newmozlastack = this.vCalendar.getFirstVeventPropertyValue("X-MOZ-LASTACK");
                String currentmozlastack = (String)currentItem.get(Field.get("xmozlastack").getResponseName());
                boolean ismozack = newmozlastack != null && !newmozlastack.equals(currentmozlastack);
                String newmozsnoozetime = this.vCalendar.getFirstVeventPropertyValue("X-MOZ-SNOOZE-TIME");
                String currentmozsnoozetime = (String)currentItem.get(Field.get("xmozsnoozetime").getResponseName());
                boolean ismozsnooze = newmozsnoozetime != null && !newmozsnoozetime.equals(currentmozsnoozetime);
                isMozSendInvitations = newmozlastack == null && newmozsnoozetime == null || !ismozack && !ismozsnooze;
                isMozDismiss = ismozack || ismozsnooze;
                LOGGER.debug((Object)("Existing item found with etag: " + currentEtag + " client etag: " + this.etag + " id: " + currentItemId.id));
            }
            if (isMeetingResponse) {
                LOGGER.debug((Object)"Ignore etag check, meeting response");
            } else if ("*".equals(this.noneMatch) && !Settings.getBooleanProperty("davmail.ignoreNoneMatchStar", true)) {
                if (currentItemId != null) {
                    itemResult.status = 412;
                    return itemResult;
                }
            } else if (!(this.etag == null || currentItemId != null && this.etag.equals(currentEtag))) {
                itemResult.status = 412;
                return itemResult;
            }
            SendMeetingInvitationsOrCancellations sendMeetingInvitationsOrCancellations = SendMeetingInvitationsOrCancellations.SendToNone;
            if (this.vCalendar.isTodo()) {
                newItem = new EWSMethod.Item();
                newItem.type = "Task";
                updates = new ArrayList<FieldUpdate>();
                updates.add(Field.createFieldUpdate("importance", EwsExchangeSession.this.convertPriorityToExchange(this.vCalendar.getFirstVeventPropertyValue("PRIORITY"))));
                updates.add(Field.createFieldUpdate("calendaruid", this.vCalendar.getFirstVeventPropertyValue("UID")));
                updates.add(Field.createFieldUpdate("urlcompname", EwsExchangeSession.this.convertItemNameToEML(this.itemName)));
                updates.add(Field.createFieldUpdate("subject", this.vCalendar.getFirstVeventPropertyValue("SUMMARY")));
                updates.add(Field.createFieldUpdate("description", this.vCalendar.getFirstVeventPropertyValue("DESCRIPTION")));
                List<VProperty> categories = this.vCalendar.getFirstVeventProperties("CATEGORIES");
                if (categories != null) {
                    HashSet<String> categoryValues = new HashSet<String>();
                    for (VProperty category : categories) {
                        categoryValues.add(category.getValue());
                    }
                    updates.add(Field.createFieldUpdate("keywords", StringUtil.join(categoryValues, ",")));
                }
                updates.add(Field.createFieldUpdate("startdate", EwsExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("DTSTART"))));
                updates.add(Field.createFieldUpdate("duedate", EwsExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("DUE"))));
                updates.add(Field.createFieldUpdate("datecompleted", EwsExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("COMPLETED"))));
                updates.add(Field.createFieldUpdate("commonstart", EwsExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("DTSTART"))));
                updates.add(Field.createFieldUpdate("commonend", EwsExchangeSession.this.convertTaskDateToZulu(this.vCalendar.getFirstVeventPropertyValue("DUE"))));
                String percentComplete = this.vCalendar.getFirstVeventPropertyValue("PERCENT-COMPLETE");
                if (percentComplete == null) {
                    percentComplete = "0";
                }
                updates.add(Field.createFieldUpdate("percentcomplete", percentComplete));
                String vTodoStatus = this.vCalendar.getFirstVeventPropertyValue("STATUS");
                if (vTodoStatus == null) {
                    updates.add(Field.createFieldUpdate("taskstatus", "NotStarted"));
                } else {
                    updates.add(Field.createFieldUpdate("taskstatus", ExchangeSession.vTodoToTaskStatusMap.get(vTodoStatus)));
                }
                if (currentItemId != null) {
                    createOrUpdateItemMethod = new UpdateItemMethod(MessageDisposition.SaveOnly, ConflictResolution.AutoResolve, SendMeetingInvitationsOrCancellations.SendToNone, currentItemId, updates);
                } else {
                    newItem.setFieldUpdates(updates);
                    createOrUpdateItemMethod = new CreateItemMethod(MessageDisposition.SaveOnly, SendMeetingInvitations.SendToNone, EwsExchangeSession.this.getFolderId(this.folderPath), newItem);
                }
            } else {
                if (currentItemId != null) {
                    if (isMeetingResponse && Settings.getBooleanProperty("davmail.caldavAutoSchedule", true)) {
                        SendMeetingInvitations sendMeetingInvitations = SendMeetingInvitations.SendToAllAndSaveCopy;
                        MessageDisposition messageDisposition = MessageDisposition.SendAndSaveCopy;
                        String body = null;
                        if (Settings.getBooleanProperty("davmail.caldavEditNotifications")) {
                            String status;
                            String notificationSubject;
                            NotificationDialog notificationDialog;
                            String vEventSubject = this.vCalendar.getFirstVeventPropertyValue("SUMMARY");
                            if (vEventSubject == null) {
                                vEventSubject = BundleMessage.format("MEETING_REQUEST", new Object[0]);
                            }
                            if (!(notificationDialog = new NotificationDialog(notificationSubject = (status = this.vCalendar.getAttendeeStatus()) != null ? BundleMessage.format(status, new Object[0]) + vEventSubject : this.subject, "")).getSendNotification()) {
                                LOGGER.debug((Object)"Notification canceled by user");
                                sendMeetingInvitations = SendMeetingInvitations.SendToNone;
                                messageDisposition = MessageDisposition.SaveOnly;
                            }
                            body = notificationDialog.getBody();
                        }
                        EWSMethod.Item item = new EWSMethod.Item();
                        item.type = partstatToResponseMap.get(this.vCalendar.getAttendeeStatus());
                        item.referenceItemId = new ItemId("ReferenceItemId", currentItemId.id, currentItemId.changeKey);
                        if (body != null && !body.isEmpty()) {
                            item.put("Body", body);
                        }
                        createOrUpdateItemMethod = new CreateItemMethod(messageDisposition, sendMeetingInvitations, EwsExchangeSession.this.getFolderId("Sent"), item);
                    } else if (Settings.getBooleanProperty("davmail.caldavAutoSchedule", true)) {
                        MessageDisposition messageDisposition = MessageDisposition.SaveOnly;
                        if (this.vCalendar.isMeeting() && this.vCalendar.isMeetingOrganizer() && isMozSendInvitations) {
                            messageDisposition = MessageDisposition.SendAndSaveCopy;
                            sendMeetingInvitationsOrCancellations = SendMeetingInvitationsOrCancellations.SendToAllAndSaveCopy;
                        }
                        createOrUpdateItemMethod = new UpdateItemMethod(messageDisposition, ConflictResolution.AutoResolve, sendMeetingInvitationsOrCancellations, currentItemId, this.buildFieldUpdates(this.vCalendar, this.vCalendar.getFirstVevent(), isMozDismiss));
                        if (EwsExchangeSession.this.serverVersion != null && EwsExchangeSession.this.serverVersion.startsWith("Exchange201")) {
                            createOrUpdateItemMethod.setTimezoneContext(EwsExchangeSession.this.getVTimezone().getPropertyValue("TZID"));
                        }
                    } else {
                        DeleteItemMethod deleteItemMethod = new DeleteItemMethod(currentItemId, DeleteType.HardDelete, SendMeetingCancellations.SendToNone);
                        EwsExchangeSession.this.executeMethod(deleteItemMethod);
                    }
                }
                if (createOrUpdateItemMethod == null) {
                    String status;
                    String xMozSnoozeTime;
                    String xMozLastack;
                    newItem = new EWSMethod.Item();
                    newItem.type = "CalendarItem";
                    newItem.mimeContent = IOUtil.encodeBase64(this.vCalendar.toString());
                    updates = new ArrayList();
                    if (!this.vCalendar.hasVAlarm()) {
                        updates.add(Field.createFieldUpdate("reminderset", "false"));
                    }
                    updates.add(Field.createFieldUpdate("urlcompname", EwsExchangeSession.this.convertItemNameToEML(this.itemName)));
                    if (this.vCalendar.isMeeting()) {
                        if (this.vCalendar.isMeetingOrganizer()) {
                            updates.add(Field.createFieldUpdate("apptstateflags", "1"));
                        } else {
                            updates.add(Field.createFieldUpdate("apptstateflags", "3"));
                        }
                    } else {
                        updates.add(Field.createFieldUpdate("apptstateflags", "0"));
                    }
                    String xMozSendInvitations = this.vCalendar.getFirstVeventPropertyValue("X-MOZ-SEND-INVITATIONS");
                    if (xMozSendInvitations != null) {
                        updates.add(Field.createFieldUpdate("xmozsendinvitations", xMozSendInvitations));
                    }
                    if ((xMozLastack = this.vCalendar.getFirstVeventPropertyValue("X-MOZ-LASTACK")) != null) {
                        updates.add(Field.createFieldUpdate("xmozlastack", xMozLastack));
                    }
                    if ((xMozSnoozeTime = this.vCalendar.getFirstVeventPropertyValue("X-MOZ-SNOOZE-TIME")) != null) {
                        updates.add(Field.createFieldUpdate("xmozsnoozetime", xMozSnoozeTime));
                    }
                    if (this.vCalendar.isMeeting() && "Exchange2007_SP1".equals(EwsExchangeSession.this.serverVersion)) {
                        String organizerEmail;
                        List<VProperty> organizerProperties;
                        VProperty property2;
                        HashSet<String> requiredAttendees = new HashSet<String>();
                        HashSet<String> optionalAttendees = new HashSet<String>();
                        List<VProperty> attendeeProperties = this.vCalendar.getFirstVeventProperties("ATTENDEE");
                        if (attendeeProperties != null) {
                            for (VProperty property2 : attendeeProperties) {
                                String attendeeEmail = this.vCalendar.getEmailValue(property2);
                                if (attendeeEmail == null || attendeeEmail.indexOf(64) < 0) continue;
                                if (EwsExchangeSession.this.email.equals(attendeeEmail)) {
                                    String ownerPartStat = property2.getParamValue("PARTSTAT");
                                    if ("ACCEPTED".equals(ownerPartStat)) {
                                        ownerResponseReply = "AcceptItem";
                                    } else if ("DECLINED".equals(ownerPartStat) || "TENTATIVE".equals(ownerPartStat)) {
                                        ownerResponseReply = "TentativelyAcceptItem";
                                    }
                                }
                                InternetAddress internetAddress = new InternetAddress(attendeeEmail, property2.getParamValue("CN"));
                                String attendeeRole = property2.getParamValue("ROLE");
                                if ("REQ-PARTICIPANT".equals(attendeeRole)) {
                                    requiredAttendees.add(internetAddress.toString());
                                    continue;
                                }
                                optionalAttendees.add(internetAddress.toString());
                            }
                        }
                        if ((organizerProperties = this.vCalendar.getFirstVeventProperties("ORGANIZER")) != null && (organizerEmail = this.vCalendar.getEmailValue(property2 = organizerProperties.get(0))) != null && organizerEmail.indexOf(64) >= 0) {
                            updates.add(Field.createFieldUpdate("from", organizerEmail));
                        }
                        if (!requiredAttendees.isEmpty()) {
                            updates.add(Field.createFieldUpdate("to", StringUtil.join(requiredAttendees, ", ")));
                        }
                        if (!optionalAttendees.isEmpty()) {
                            updates.add(Field.createFieldUpdate("cc", StringUtil.join(optionalAttendees, ", ")));
                        }
                    }
                    if ("Exchange2007_SP1".equals(EwsExchangeSession.this.serverVersion) && this.vCalendar.isCdoAllDay()) {
                        updates.add(Field.createFieldUpdate("dtstart", EwsExchangeSession.this.convertCalendarDateToExchange(this.vCalendar.getFirstVeventPropertyValue("DTSTART"))));
                        updates.add(Field.createFieldUpdate("dtend", EwsExchangeSession.this.convertCalendarDateToExchange(this.vCalendar.getFirstVeventPropertyValue("DTEND"))));
                    }
                    if ("TENTATIVE".equals(status = this.vCalendar.getFirstVeventPropertyValue("STATUS"))) {
                        updates.add(Field.createFieldUpdate("busystatus", "Tentative"));
                    } else {
                        updates.add(Field.createFieldUpdate("busystatus", "BUSY".equals(this.vCalendar.getFirstVeventPropertyValue("X-MICROSOFT-CDO-BUSYSTATUS")) ? "Busy" : "Free"));
                    }
                    if ("Exchange2007_SP1".equals(EwsExchangeSession.this.serverVersion) && this.vCalendar.isCdoAllDay()) {
                        updates.add(Field.createFieldUpdate("meetingtimezone", this.vCalendar.getVTimezone().getPropertyValue("TZID")));
                    }
                    newItem.setFieldUpdates(updates);
                    MessageDisposition messageDisposition = MessageDisposition.SaveOnly;
                    SendMeetingInvitations sendMeetingInvitations = SendMeetingInvitations.SendToNone;
                    if (this.vCalendar.isMeeting() && this.vCalendar.isMeetingOrganizer() && isMozSendInvitations && Settings.getBooleanProperty("davmail.caldavAutoSchedule", true)) {
                        messageDisposition = MessageDisposition.SendAndSaveCopy;
                        sendMeetingInvitations = SendMeetingInvitations.SendToAllAndSaveCopy;
                    }
                    createOrUpdateItemMethod = new CreateItemMethod(messageDisposition, sendMeetingInvitations, EwsExchangeSession.this.getFolderId(this.folderPath), newItem);
                    if (EwsExchangeSession.this.serverVersion != null && EwsExchangeSession.this.serverVersion.startsWith("Exchange201")) {
                        createOrUpdateItemMethod.setTimezoneContext(EwsExchangeSession.this.getVTimezone().getPropertyValue("TZID"));
                    }
                }
            }
            EwsExchangeSession.this.executeMethod(createOrUpdateItemMethod);
            itemResult.status = createOrUpdateItemMethod.getStatusCode();
            if (itemResult.status == 200) {
                if (currentItemId == null) {
                    itemResult.status = 201;
                    LOGGER.debug((Object)("Created event " + this.getHref()));
                } else {
                    LOGGER.warn((Object)("Overwritten event " + this.getHref()));
                }
            }
            if (ownerResponseReply != null) {
                EWSMethod.Item responseTypeItem = new EWSMethod.Item();
                responseTypeItem.referenceItemId = new ItemId("ReferenceItemId", createOrUpdateItemMethod.getResponseItem());
                responseTypeItem.type = ownerResponseReply;
                createOrUpdateItemMethod = new CreateItemMethod(MessageDisposition.SaveOnly, SendMeetingInvitations.SendToNone, null, responseTypeItem);
                EwsExchangeSession.this.executeMethod(createOrUpdateItemMethod);
                updates = new ArrayList();
                updates.add(Field.createFieldUpdate("urlcompname", EwsExchangeSession.this.convertItemNameToEML(this.itemName)));
                createOrUpdateItemMethod = new UpdateItemMethod(MessageDisposition.SaveOnly, ConflictResolution.AlwaysOverwrite, SendMeetingInvitationsOrCancellations.SendToNone, new ItemId(createOrUpdateItemMethod.getResponseItem()), updates);
                EwsExchangeSession.this.executeMethod(createOrUpdateItemMethod);
            }
            if (!(this.vCalendar.isTodo() || currentItemId == null || isMeetingResponse || isMozDismiss)) {
                this.handleExcludedDates(currentItemId, this.vCalendar);
                this.handleModifiedOccurrences(currentItemId, this.vCalendar, sendMeetingInvitationsOrCancellations);
            }
            if (createOrUpdateItemMethod.getResponseItem() != null) {
                ItemId newItemId = new ItemId(createOrUpdateItemMethod.getResponseItem());
                GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, newItemId, false);
                getItemMethod.addAdditionalProperty(Field.get("etag"));
                EwsExchangeSession.this.executeMethod(getItemMethod);
                itemResult.etag = (String)getItemMethod.getResponseItem().get(Field.get("etag").getResponseName());
                itemResult.itemName = StringUtil.base64ToUrl(newItemId.id) + ".EML";
            }
            return itemResult;
        }

        @Override
        public byte[] getEventContent() throws IOException {
            byte[] content;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Get event: " + this.itemName));
            }
            try {
                GetItemMethod getItemMethod;
                if ("Task".equals(this.type)) {
                    getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, this.itemId, false);
                    getItemMethod.addAdditionalProperty(Field.get("importance"));
                    getItemMethod.addAdditionalProperty(Field.get("subject"));
                    getItemMethod.addAdditionalProperty(Field.get("created"));
                    getItemMethod.addAdditionalProperty(Field.get("lastmodified"));
                    getItemMethod.addAdditionalProperty(Field.get("calendaruid"));
                    getItemMethod.addAdditionalProperty(Field.get("description"));
                    if (EwsExchangeSession.this.isExchange2013OrLater()) {
                        getItemMethod.addAdditionalProperty(Field.get("textbody"));
                    }
                    getItemMethod.addAdditionalProperty(Field.get("percentcomplete"));
                    getItemMethod.addAdditionalProperty(Field.get("taskstatus"));
                    getItemMethod.addAdditionalProperty(Field.get("startdate"));
                    getItemMethod.addAdditionalProperty(Field.get("duedate"));
                    getItemMethod.addAdditionalProperty(Field.get("datecompleted"));
                    getItemMethod.addAdditionalProperty(Field.get("keywords"));
                } else if (!("Message".equals(this.type) || "MeetingCancellation".equals(this.type) || "MeetingResponse".equals(this.type))) {
                    getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, this.itemId, true);
                    getItemMethod.addAdditionalProperty(Field.get("lastmodified"));
                    getItemMethod.addAdditionalProperty(Field.get("reminderset"));
                    getItemMethod.addAdditionalProperty(Field.get("calendaruid"));
                    getItemMethod.addAdditionalProperty(Field.get("myresponsetype"));
                    getItemMethod.addAdditionalProperty(Field.get("requiredattendees"));
                    getItemMethod.addAdditionalProperty(Field.get("optionalattendees"));
                    getItemMethod.addAdditionalProperty(Field.get("modifiedoccurrences"));
                    getItemMethod.addAdditionalProperty(Field.get("xmozlastack"));
                    getItemMethod.addAdditionalProperty(Field.get("xmozsnoozetime"));
                    getItemMethod.addAdditionalProperty(Field.get("xmozsendinvitations"));
                } else {
                    getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, this.itemId, true);
                }
                EwsExchangeSession.this.executeMethod(getItemMethod);
                if ("Task".equals(this.type)) {
                    VCalendar localVCalendar = new VCalendar();
                    VObject vTodo = new VObject();
                    vTodo.type = "VTODO";
                    localVCalendar.setTimezone(EwsExchangeSession.this.getVTimezone());
                    vTodo.setPropertyValue("LAST-MODIFIED", EwsExchangeSession.this.convertDateFromExchange((String)getItemMethod.getResponseItem().get(Field.get("lastmodified").getResponseName())));
                    vTodo.setPropertyValue("CREATED", EwsExchangeSession.this.convertDateFromExchange((String)getItemMethod.getResponseItem().get(Field.get("created").getResponseName())));
                    String calendarUid = (String)getItemMethod.getResponseItem().get(Field.get("calendaruid").getResponseName());
                    if (calendarUid == null) {
                        calendarUid = this.itemId.id;
                    }
                    vTodo.setPropertyValue("UID", calendarUid);
                    vTodo.setPropertyValue("SUMMARY", (String)getItemMethod.getResponseItem().get(Field.get("subject").getResponseName()));
                    String description = (String)getItemMethod.getResponseItem().get(Field.get("description").getResponseName());
                    if (description == null) {
                        description = (String)getItemMethod.getResponseItem().get(Field.get("textbody").getResponseName());
                    }
                    vTodo.setPropertyValue("DESCRIPTION", description);
                    vTodo.setPropertyValue("PRIORITY", EwsExchangeSession.this.convertPriorityFromExchange((String)getItemMethod.getResponseItem().get(Field.get("importance").getResponseName())));
                    vTodo.setPropertyValue("PERCENT-COMPLETE", (String)getItemMethod.getResponseItem().get(Field.get("percentcomplete").getResponseName()));
                    vTodo.setPropertyValue("STATUS", ExchangeSession.taskTovTodoStatusMap.get(getItemMethod.getResponseItem().get(Field.get("taskstatus").getResponseName())));
                    vTodo.setPropertyValue("DUE;VALUE=DATE", EwsExchangeSession.convertDateFromExchangeToTaskDate((String)getItemMethod.getResponseItem().get(Field.get("duedate").getResponseName())));
                    vTodo.setPropertyValue("DTSTART;VALUE=DATE", EwsExchangeSession.convertDateFromExchangeToTaskDate((String)getItemMethod.getResponseItem().get(Field.get("startdate").getResponseName())));
                    vTodo.setPropertyValue("COMPLETED;VALUE=DATE", EwsExchangeSession.convertDateFromExchangeToTaskDate((String)getItemMethod.getResponseItem().get(Field.get("datecompleted").getResponseName())));
                    vTodo.setPropertyValue("CATEGORIES", (String)getItemMethod.getResponseItem().get(Field.get("keywords").getResponseName()));
                    localVCalendar.addVObject(vTodo);
                    content = localVCalendar.toString().getBytes(StandardCharsets.UTF_8);
                } else {
                    content = getItemMethod.getMimeContent();
                    if (content == null) {
                        throw new IOException("empty event body");
                    }
                    if (!"CalendarItem".equals(this.type)) {
                        content = this.getICS((InputStream)new SharedByteArrayInputStream(content));
                    }
                    VCalendar localVCalendar = new VCalendar(content, EwsExchangeSession.this.email, EwsExchangeSession.this.getVTimezone());
                    String calendaruid = (String)getItemMethod.getResponseItem().get(Field.get("calendaruid").getResponseName());
                    if ("Exchange2007_SP1".equals(EwsExchangeSession.this.serverVersion)) {
                        if (!"true".equals(getItemMethod.getResponseItem().get(Field.get("reminderset").getResponseName()))) {
                            localVCalendar.removeVAlarm();
                        }
                        if (calendaruid != null) {
                            localVCalendar.setFirstVeventPropertyValue("UID", calendaruid);
                        }
                    }
                    this.fixAttendees(getItemMethod, localVCalendar.getFirstVevent());
                    List<EWSMethod.Occurrence> occurences = getItemMethod.getResponseItem().getOccurrences();
                    if (occurences != null) {
                        Iterator<VObject> modifiedOccurrencesIterator = localVCalendar.getModifiedOccurrences().iterator();
                        for (EWSMethod.Occurrence occurrence : occurences) {
                            VProperty recurrenceId;
                            if (!modifiedOccurrencesIterator.hasNext()) continue;
                            VObject modifiedOccurrence = modifiedOccurrencesIterator.next();
                            GetItemMethod getOccurrenceMethod = new GetItemMethod(BaseShape.ID_ONLY, occurrence.itemId, false);
                            getOccurrenceMethod.addAdditionalProperty(Field.get("requiredattendees"));
                            getOccurrenceMethod.addAdditionalProperty(Field.get("optionalattendees"));
                            getOccurrenceMethod.addAdditionalProperty(Field.get("modifiedoccurrences"));
                            getOccurrenceMethod.addAdditionalProperty(Field.get("lastmodified"));
                            EwsExchangeSession.this.executeMethod(getOccurrenceMethod);
                            this.fixAttendees(getOccurrenceMethod, modifiedOccurrence);
                            modifiedOccurrence.setPropertyValue("LAST-MODIFIED", EwsExchangeSession.this.convertDateFromExchange((String)getOccurrenceMethod.getResponseItem().get(Field.get("lastmodified").getResponseName())));
                            if (calendaruid != null) {
                                modifiedOccurrence.setPropertyValue("UID", calendaruid);
                            }
                            if ((recurrenceId = modifiedOccurrence.getProperty("RECURRENCE-ID")) == null) continue;
                            recurrenceId.removeParam("TZID");
                            recurrenceId.getValues().set(0, EwsExchangeSession.this.convertDateFromExchange(occurrence.originalStart));
                        }
                    }
                    localVCalendar.setFirstVeventPropertyValue("LAST-MODIFIED", EwsExchangeSession.this.convertDateFromExchange((String)getItemMethod.getResponseItem().get(Field.get("lastmodified").getResponseName())));
                    localVCalendar.setFirstVeventPropertyValue("X-MOZ-SEND-INVITATIONS", (String)getItemMethod.getResponseItem().get(Field.get("xmozsendinvitations").getResponseName()));
                    localVCalendar.setFirstVeventPropertyValue("X-MOZ-LASTACK", (String)getItemMethod.getResponseItem().get(Field.get("xmozlastack").getResponseName()));
                    localVCalendar.setFirstVeventPropertyValue("X-MOZ-SNOOZE-TIME", (String)getItemMethod.getResponseItem().get(Field.get("xmozsnoozetime").getResponseName()));
                    content = localVCalendar.toString().getBytes(StandardCharsets.UTF_8);
                }
            }
            catch (IOException | MessagingException e) {
                throw this.buildHttpNotFoundException((Exception)e);
            }
            return content;
        }

        protected void fixAttendees(GetItemMethod getItemMethod, VObject vEvent) throws EWSException {
            List<EWSMethod.Attendee> attendees;
            if (getItemMethod.getResponseItem() != null && (attendees = getItemMethod.getResponseItem().getAttendees()) != null) {
                for (EWSMethod.Attendee attendee : attendees) {
                    VProperty attendeeProperty = new VProperty("ATTENDEE", "mailto:" + attendee.email);
                    attendeeProperty.addParam("CN", attendee.name);
                    String myResponseType = (String)getItemMethod.getResponseItem().get(Field.get("myresponsetype").getResponseName());
                    if (EwsExchangeSession.this.email.equalsIgnoreCase(attendee.email) && myResponseType != null) {
                        attendeeProperty.addParam("PARTSTAT", EWSMethod.responseTypeToPartstat(myResponseType));
                    } else {
                        attendeeProperty.addParam("PARTSTAT", attendee.partstat);
                    }
                    attendeeProperty.addParam("ROLE", attendee.role);
                    vEvent.addProperty(attendeeProperty);
                }
            }
        }
    }

    protected class Contact
    extends ExchangeSession.Contact {
        ItemId itemId;

        protected Contact(EWSMethod.Item response) throws DavMailException {
            this.itemId = new ItemId(response);
            this.permanentUrl = (String)response.get(Field.get("permanenturl").getResponseName());
            this.etag = (String)response.get(Field.get("etag").getResponseName());
            this.displayName = (String)response.get(Field.get("displayname").getResponseName());
            this.itemName = StringUtil.decodeUrlcompname((String)response.get(Field.get("urlcompname").getResponseName()));
            if (this.itemName == null || EwsExchangeSession.isItemId(this.itemName)) {
                this.itemName = StringUtil.base64ToUrl(this.itemId.id) + ".EML";
            }
            for (String attributeName : ExchangeSession.CONTACT_ATTRIBUTES) {
                String value = (String)response.get(Field.get(attributeName).getResponseName());
                if (value == null || value.isEmpty()) continue;
                if ("bday".equals(attributeName) || "anniversary".equals(attributeName) || "lastmodified".equals(attributeName) || "datereceived".equals(attributeName)) {
                    value = EwsExchangeSession.this.convertDateFromExchange(value);
                }
                this.put(attributeName, value);
            }
            if (response.getMembers() != null) {
                for (String member : response.getMembers()) {
                    this.addMember(member);
                }
            }
        }

        protected Contact(String folderPath, String itemName, Map<String, String> properties, String etag, String noneMatch) {
            super(folderPath, itemName, properties, etag, noneMatch);
        }

        protected Contact() {
        }

        protected void buildFieldUpdates(List<FieldUpdate> updates, boolean create) {
            for (Map.Entry entry : this.entrySet()) {
                if ("photo".equals(entry.getKey())) {
                    updates.add(Field.createFieldUpdate("haspicture", "true"));
                    continue;
                }
                if (((String)entry.getKey()).startsWith("email") || ((String)entry.getKey()).startsWith("smtpemail") || "fileas".equals(entry.getKey())) continue;
                updates.add(Field.createFieldUpdate((String)entry.getKey(), (String)entry.getValue()));
            }
            if (create && this.get("fileas") != null) {
                updates.add(Field.createFieldUpdate("fileas", (String)this.get("fileas")));
            }
            IndexedFieldUpdate emailFieldUpdate = null;
            for (Map.Entry entry : this.entrySet()) {
                if (!((String)entry.getKey()).startsWith("smtpemail")) continue;
                if (emailFieldUpdate == null) {
                    emailFieldUpdate = new IndexedFieldUpdate("EmailAddresses");
                }
                emailFieldUpdate.addFieldValue(Field.createFieldUpdate((String)entry.getKey(), (String)entry.getValue()));
            }
            if (emailFieldUpdate != null) {
                updates.add(emailFieldUpdate);
            }
            MultiValuedFieldUpdate memberFieldUpdate = null;
            if (this.distributionListMembers != null) {
                for (String member : this.distributionListMembers) {
                    if (memberFieldUpdate == null) {
                        memberFieldUpdate = new MultiValuedFieldUpdate(Field.get("members"));
                    }
                    memberFieldUpdate.addValue(member);
                }
            }
            if (memberFieldUpdate != null) {
                updates.add(memberFieldUpdate);
            }
        }

        @Override
        public ExchangeSession.ItemResult createOrUpdate() throws IOException {
            EWSMethod createOrUpdateItemMethod;
            String photo = (String)this.get("photo");
            ExchangeSession.ItemResult itemResult = new ExchangeSession.ItemResult();
            String currentEtag = null;
            ItemId currentItemId = null;
            FileAttachment currentFileAttachment = null;
            EWSMethod.Item currentItem = EwsExchangeSession.this.getEwsItem(this.folderPath, this.itemName, ITEM_PROPERTIES);
            if (currentItem != null) {
                currentItemId = new ItemId(currentItem);
                currentEtag = (String)currentItem.get(Field.get("etag").getResponseName());
                GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, currentItemId, false);
                getItemMethod.addAdditionalProperty(Field.get("attachments"));
                EwsExchangeSession.this.executeMethod(getItemMethod);
                EWSMethod.Item item = getItemMethod.getResponseItem();
                if (item != null) {
                    currentFileAttachment = item.getAttachmentByName("ContactPicture.jpg");
                }
            }
            if ("*".equals(this.noneMatch)) {
                if (currentItemId != null) {
                    itemResult.status = 412;
                    return itemResult;
                }
            } else if (!(this.etag == null || currentItemId != null && this.etag.equals(currentEtag))) {
                itemResult.status = 412;
                return itemResult;
            }
            ArrayList<FieldUpdate> fieldUpdates = new ArrayList<FieldUpdate>();
            if (currentItemId != null) {
                this.buildFieldUpdates(fieldUpdates, false);
                createOrUpdateItemMethod = new UpdateItemMethod(MessageDisposition.SaveOnly, ConflictResolution.AlwaysOverwrite, SendMeetingInvitationsOrCancellations.SendToNone, currentItemId, fieldUpdates);
            } else {
                EWSMethod.Item newItem = new EWSMethod.Item();
                newItem.type = "IPM.DistList".equals(this.get("outlookmessageclass")) ? "DistributionList" : "Contact";
                fieldUpdates.add(Field.createFieldUpdate("urlcompname", EwsExchangeSession.this.convertItemNameToEML(this.itemName)));
                this.buildFieldUpdates(fieldUpdates, true);
                newItem.setFieldUpdates(fieldUpdates);
                createOrUpdateItemMethod = new CreateItemMethod(MessageDisposition.SaveOnly, EwsExchangeSession.this.getFolderId(this.folderPath), newItem);
            }
            EwsExchangeSession.this.executeMethod(createOrUpdateItemMethod);
            itemResult.status = createOrUpdateItemMethod.getStatusCode();
            if (itemResult.status == 200) {
                if (this.etag == null) {
                    itemResult.status = 201;
                    LOGGER.debug((Object)("Created contact " + this.getHref()));
                } else {
                    LOGGER.debug((Object)("Updated contact " + this.getHref()));
                }
            } else {
                return itemResult;
            }
            ItemId newItemId = new ItemId(createOrUpdateItemMethod.getResponseItem());
            if (!"Exchange2007_SP1".equals(EwsExchangeSession.this.serverVersion) && EwsExchangeSession.this.getADPhoto((String)this.get("smtpemail1")) == null) {
                if (currentFileAttachment != null) {
                    DeleteAttachmentMethod deleteAttachmentMethod = new DeleteAttachmentMethod(currentFileAttachment.attachmentId);
                    EwsExchangeSession.this.executeMethod(deleteAttachmentMethod);
                }
                if (photo != null) {
                    byte[] resizedImageBytes = IOUtil.resizeImage(IOUtil.decodeBase64(photo), 90);
                    FileAttachment attachment = new FileAttachment("ContactPicture.jpg", "image/jpeg", IOUtil.encodeBase64AsString(resizedImageBytes));
                    attachment.setIsContactPhoto(true);
                    CreateAttachmentMethod createAttachmentMethod = new CreateAttachmentMethod(newItemId, attachment);
                    EwsExchangeSession.this.executeMethod(createAttachmentMethod);
                }
            }
            GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, newItemId, false);
            getItemMethod.addAdditionalProperty(Field.get("etag"));
            EwsExchangeSession.this.executeMethod(getItemMethod);
            itemResult.etag = (String)getItemMethod.getResponseItem().get(Field.get("etag").getResponseName());
            return itemResult;
        }
    }

    protected static class ExistsCondition
    implements ExchangeSession.Condition,
    SearchExpression {
        protected final String attributeName;

        protected ExistsCondition(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            buffer.append("<t:Exists>");
            Field.get(this.attributeName).appendTo(buffer);
            buffer.append("</t:Exists>");
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isMatch(ExchangeSession.Contact contact) {
            String actualValue = (String)contact.get(this.attributeName);
            return actualValue == null;
        }
    }

    protected static class IsNullCondition
    implements ExchangeSession.Condition,
    SearchExpression {
        protected final String attributeName;

        protected IsNullCondition(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            buffer.append("<t:Not><t:Exists>");
            Field.get(this.attributeName).appendTo(buffer);
            buffer.append("</t:Exists></t:Not>");
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isMatch(ExchangeSession.Contact contact) {
            String actualValue = (String)contact.get(this.attributeName);
            return actualValue == null;
        }
    }

    protected static class HeaderCondition
    extends AttributeCondition {
        protected HeaderCondition(String attributeName, String value) {
            super(attributeName, ExchangeSession.Operator.Contains, value);
            this.containmentMode = ContainmentMode.Substring;
            this.containmentComparison = ContainmentComparison.IgnoreCase;
        }

        @Override
        protected FieldURI getFieldURI() {
            return new ExtendedFieldURI(ExtendedFieldURI.DistinguishedPropertySetType.InternetHeaders, this.attributeName);
        }
    }

    protected static class AttributeCondition
    extends ExchangeSession.AttributeCondition
    implements SearchExpression {
        protected ContainmentMode containmentMode;
        protected ContainmentComparison containmentComparison;

        protected AttributeCondition(String attributeName, ExchangeSession.Operator operator, String value) {
            super(attributeName, operator, value);
        }

        protected AttributeCondition(String attributeName, ExchangeSession.Operator operator, String value, ContainmentMode containmentMode, ContainmentComparison containmentComparison) {
            super(attributeName, operator, value);
            this.containmentMode = containmentMode;
            this.containmentComparison = containmentComparison;
        }

        protected FieldURI getFieldURI() {
            FieldURI fieldURI = Field.get(this.attributeName);
            if (fieldURI == null) {
                throw new IllegalArgumentException("Unknown field: " + this.attributeName);
            }
            return fieldURI;
        }

        protected ExchangeSession.Operator getOperator() {
            return this.operator;
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            buffer.append("<t:").append(this.operator.toString());
            if (this.containmentMode != null) {
                this.containmentMode.appendTo(buffer);
            }
            if (this.containmentComparison != null) {
                this.containmentComparison.appendTo(buffer);
            }
            buffer.append('>');
            FieldURI fieldURI = this.getFieldURI();
            fieldURI.appendTo(buffer);
            if (this.operator != ExchangeSession.Operator.Contains) {
                buffer.append("<t:FieldURIOrConstant>");
            }
            buffer.append("<t:Constant Value=\"");
            if (fieldURI instanceof ExtendedFieldURI && "0x10f3".equals(((ExtendedFieldURI)fieldURI).propertyTag)) {
                buffer.append(StringUtil.xmlEncodeAttribute(StringUtil.encodeUrlcompname(this.value)));
            } else if (fieldURI instanceof ExtendedFieldURI && ((ExtendedFieldURI)fieldURI).propertyType == ExtendedFieldURI.PropertyType.Integer) {
                try {
                    Integer.parseInt(this.value);
                    buffer.append(this.value);
                }
                catch (NumberFormatException e) {
                    buffer.append('0');
                }
            } else {
                buffer.append(StringUtil.xmlEncodeAttribute(this.value));
            }
            buffer.append("\"/>");
            if (this.operator != ExchangeSession.Operator.Contains) {
                buffer.append("</t:FieldURIOrConstant>");
            }
            buffer.append("</t:").append((Object)this.operator).append('>');
        }

        @Override
        public boolean isMatch(ExchangeSession.Contact contact) {
            String lowerCaseValue = this.value.toLowerCase();
            String actualValue = (String)contact.get(this.attributeName);
            if (actualValue == null) {
                return false;
            }
            actualValue = actualValue.toLowerCase();
            if (this.operator == ExchangeSession.Operator.IsEqualTo) {
                return lowerCaseValue.equals(actualValue);
            }
            return this.operator == ExchangeSession.Operator.Contains && (this.containmentMode.equals(ContainmentMode.Substring) && actualValue.contains(lowerCaseValue) || this.containmentMode.equals(ContainmentMode.Prefixed) && actualValue.startsWith(lowerCaseValue));
        }
    }

    protected static class NotCondition
    extends ExchangeSession.NotCondition
    implements SearchExpression {
        protected NotCondition(ExchangeSession.Condition condition) {
            super(condition);
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            buffer.append("<t:Not>");
            this.condition.appendTo(buffer);
            buffer.append("</t:Not>");
        }
    }

    protected static class MultiCondition
    extends ExchangeSession.MultiCondition
    implements SearchExpression {
        protected MultiCondition(ExchangeSession.Operator operator, ExchangeSession.Condition ... condition) {
            super(operator, condition);
        }

        @Override
        public void appendTo(StringBuilder buffer) {
            int actualConditionCount = 0;
            for (ExchangeSession.Condition condition : this.conditions) {
                if (condition.isEmpty()) continue;
                ++actualConditionCount;
            }
            if (actualConditionCount > 0) {
                if (actualConditionCount > 1) {
                    buffer.append("<t:").append(this.operator.toString()).append('>');
                }
                for (ExchangeSession.Condition condition : this.conditions) {
                    condition.appendTo(buffer);
                }
                if (actualConditionCount > 1) {
                    buffer.append("</t:").append((Object)this.operator).append('>');
                }
            }
        }
    }

    class Message
    extends ExchangeSession.Message {
        ItemId itemId;

        Message() {
        }

        @Override
        public String getPermanentId() {
            return this.itemId.id;
        }

        @Override
        protected InputStream getMimeHeaders() {
            ByteArrayInputStream result = null;
            try {
                GetItemMethod getItemMethod = new GetItemMethod(BaseShape.ID_ONLY, this.itemId, false);
                getItemMethod.addAdditionalProperty(Field.get("messageheaders"));
                getItemMethod.addAdditionalProperty(Field.get("from"));
                EwsExchangeSession.this.executeMethod(getItemMethod);
                EWSMethod.Item item = getItemMethod.getResponseItem();
                String messageHeaders = (String)item.get(Field.get("messageheaders").getResponseName());
                if (messageHeaders != null && messageHeaders.toLowerCase().contains("message-id:")) {
                    if (!messageHeaders.contains("From:")) {
                        String from = (String)item.get(Field.get("from").getResponseName());
                        messageHeaders = "From: " + from + '\n' + messageHeaders;
                    }
                    result = new ByteArrayInputStream(messageHeaders.getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)e.getMessage());
            }
            return result;
        }
    }

    protected static class FolderPath {
        protected final String parentPath;
        protected final String folderName;

        protected FolderPath(String folderPath) {
            int slashIndex = folderPath.lastIndexOf(47);
            if (slashIndex < 0) {
                this.parentPath = "";
                this.folderName = folderPath;
            } else {
                this.parentPath = folderPath.substring(0, slashIndex);
                this.folderName = folderPath.substring(slashIndex + 1);
            }
        }
    }

    protected class Folder
    extends ExchangeSession.Folder {
        public FolderId folderId;

        protected Folder() {
        }
    }
}

