/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.auth;

import davmail.Settings;
import davmail.exchange.auth.ExchangeAuthenticator;
import davmail.exchange.auth.O365Token;
import davmail.http.HttpClientAdapter;
import java.io.IOException;
import java.net.URI;
import org.apache.log4j.Logger;

public class O365StoredTokenAuthenticator
implements ExchangeAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(O365StoredTokenAuthenticator.class);
    URI ewsUrl = URI.create(Settings.getO365Url());
    private String username;
    private String password;
    private O365Token token;

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public HttpClientAdapter getHttpClientAdapter() {
        return new HttpClientAdapter(this.getExchangeUri(), this.username, this.password, true);
    }

    @Override
    public void authenticate() throws IOException {
        String clientId = Settings.getProperty("davmail.oauth.clientId", "facd6cff-a294-4415-b59f-c5b01937d7bd");
        String redirectUri = Settings.getProperty("davmail.oauth.redirectUri", Settings.getO365LoginUrl() + "/common/oauth2/nativeclient");
        String tenantId = Settings.getProperty("davmail.oauth.tenantId", "common");
        this.token = O365Token.load(tenantId, clientId, redirectUri, this.username, this.password);
        if (this.token == null) {
            throw new IOException("No valid refresh token found for " + this.username);
        }
    }

    @Override
    public O365Token getToken() {
        return this.token;
    }

    @Override
    public URI getExchangeUri() {
        return this.ewsUrl;
    }
}

