/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.auth;

import davmail.BundleMessage;
import davmail.ui.browser.DesktopBrowser;
import davmail.ui.tray.DavGatewayTray;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class O365ManualAuthenticatorDialog
extends JDialog {
    final JTextField codeField = new JTextField(30);
    protected String code;

    public String getCode() {
        if (this.code != null && this.code.contains("code=") && this.code.contains("&session_state=")) {
            this.code = this.code.substring(this.code.indexOf("code=") + 5, this.code.indexOf("&session_state="));
        }
        return this.code;
    }

    public O365ManualAuthenticatorDialog(String initUrl) {
        this.setAlwaysOnTop(true);
        this.setTitle(BundleMessage.format("UI_O365_MANUAL_PROMPT", new Object[0]));
        try {
            this.setIconImages(DavGatewayTray.getFrameIcons());
        }
        catch (NoSuchMethodError error) {
            DavGatewayTray.debug(new BundleMessage("LOG_UNABLE_TO_SET_ICON_IMAGE", new Object[0]));
        }
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new BoxLayout(messagePanel, 0));
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        messagePanel.add(imageLabel);
        messagePanel.add(this.getEditorPane(BundleMessage.format("UI_0365_AUTHENTICATION_PROMPT", initUrl)));
        JPanel credentialPanel = new JPanel();
        credentialPanel.setLayout(new BoxLayout(credentialPanel, 0));
        JLabel promptLabel = new JLabel(BundleMessage.format("UI_0365_AUTHENTICATION_CODE", new Object[0]));
        promptLabel.setHorizontalAlignment(4);
        promptLabel.setVerticalAlignment(0);
        credentialPanel.add(promptLabel);
        this.codeField.setMaximumSize(this.codeField.getPreferredSize());
        this.codeField.addActionListener(evt -> {
            this.code = this.codeField.getText();
            this.setVisible(false);
        });
        credentialPanel.add(this.codeField);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.add(messagePanel);
        centerPanel.add(this.getOpenButtonPanel(initUrl));
        centerPanel.add(this.getEditorPane(BundleMessage.format("UI_0365_AUTHENTICATION_CODE_PROMPT", new Object[0])));
        centerPanel.add(credentialPanel);
        centerPanel.add(Box.createVerticalGlue());
        this.add((Component)centerPanel, "Center");
        this.add((Component)this.getSendButtonPanel(), "South");
        this.setModal(true);
        this.pack();
        this.setLocation(this.getToolkit().getScreenSize().width / 2 - this.getSize().width / 2, this.getToolkit().getScreenSize().height / 2 - this.getSize().height / 2);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    private JEditorPane getEditorPane(String text) {
        JEditorPane jEditorPane = new JEditorPane();
        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        StyleSheet stylesheet = htmlEditorKit.getStyleSheet();
        Font font = jEditorPane.getFont();
        stylesheet.addRule("body { font-size:small;font-family: " + (font == null ? "Arial" : font.getFamily()) + '}');
        jEditorPane.setEditorKit(htmlEditorKit);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(text);
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(false);
        jEditorPane.addHyperlinkListener(hle -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                try {
                    DesktopBrowser.browse(hle.getURL().toURI());
                }
                catch (URISyntaxException e) {
                    DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_OPEN_LINK", new Object[0]), e);
                }
            }
        });
        return jEditorPane;
    }

    protected JPanel getOpenButtonPanel(String initUrl) {
        JPanel buttonPanel = new JPanel();
        JButton openButton = new JButton(BundleMessage.format("UI_BUTTON_OPEN", new Object[0]));
        JButton copyButton = new JButton(BundleMessage.format("UI_BUTTON_COPY", new Object[0]));
        openButton.addActionListener(evt -> DesktopBrowser.browse(initUrl));
        copyButton.addActionListener(evt -> {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(initUrl), null);
        });
        buttonPanel.add(openButton);
        buttonPanel.add(copyButton);
        return buttonPanel;
    }

    protected JPanel getSendButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton sendButton = new JButton(BundleMessage.format("UI_BUTTON_SEND", new Object[0]));
        JButton cancelButton = new JButton(BundleMessage.format("UI_BUTTON_CANCEL", new Object[0]));
        sendButton.addActionListener(evt -> {
            this.code = this.codeField.getText();
            this.setVisible(false);
        });
        cancelButton.addActionListener(evt -> {
            this.code = null;
            this.setVisible(false);
        });
        buttonPanel.add(sendButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }
}

