/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.auth;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.exchange.auth.O365InteractiveAuthenticator;
import davmail.ui.tray.DavGatewayTray;
import davmail.ui.tray.SwtGatewayTray;
import org.apache.log4j.Logger;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class O365InteractiveAuthenticatorSWT {
    private static final Logger LOGGER = Logger.getLogger(O365InteractiveAuthenticatorSWT.class);
    private O365InteractiveAuthenticator authenticator;
    Shell shell;
    Browser browser;
    private final Object LOCK = new Object();
    private boolean isReady = false;
    private SWTError error;

    public void setO365InteractiveAuthenticator(O365InteractiveAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void authenticate(String initUrl, final String redirectUri) {
        SwtGatewayTray.initDisplay();
        System.setProperty("org.eclipse.swt.browser.Edge.allowSingleSignOnUsingOSPrimaryAccount", Settings.getProperty("davmail.oauth.allowSingleSignOnUsingOSPrimaryAccount", "true"));
        Display.getDefault().asyncExec(() -> {
            try {
                this.shell = new Shell(Display.getDefault());
                this.shell.setText(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]));
                this.shell.setSize(600, 600);
                this.shell.setLayout((Layout)new FillLayout());
                this.shell.setImage(SwtGatewayTray.loadSwtImage("tray.png", 32));
                this.shell.addListener(21, event -> {
                    if (!this.authenticator.isAuthenticated && this.authenticator.errorCode == null) {
                        this.authenticator.errorCode = "user closed authentication window";
                    }
                    this.dispose();
                });
                this.browser = new Browser((Composite)this.shell, 0);
                this.browser.setUrl(initUrl);
                this.browser.addTitleListener(titleEvent -> this.shell.setText("DavMail: " + titleEvent.title));
                this.browser.addLocationListener(new LocationListener(){

                    public void changing(LocationEvent locationEvent) {
                        LOGGER.debug((Object)("Navigate to " + locationEvent.toString()));
                        String location = locationEvent.location;
                        if (location.startsWith(redirectUri)) {
                            LOGGER.debug((Object)"Location starts with redirectUri, check code");
                            O365InteractiveAuthenticatorSWT.this.authenticator.handleCode(location);
                            O365InteractiveAuthenticatorSWT.this.shell.close();
                            O365InteractiveAuthenticatorSWT.this.dispose();
                        }
                    }

                    public void changed(LocationEvent locationEvent) {
                        LOGGER.debug((Object)("Page changed: " + locationEvent.toString()));
                    }
                });
                Object object = this.LOCK;
                synchronized (object) {
                    this.isReady = true;
                    this.LOCK.notifyAll();
                }
                this.shell.open();
                this.shell.setActive();
            }
            catch (SWTError e) {
                this.error = e;
            }
        });
        while (true) {
            try {
                while (true) {
                    Object object = this.LOCK;
                    synchronized (object) {
                        if (this.error != null) {
                            throw this.error;
                        }
                        if (this.isReady) {
                            return;
                        }
                        this.LOCK.wait(1000L);
                    }
                }
            }
            catch (InterruptedException e) {
                DavGatewayTray.error(new BundleMessage("LOG_ERROR_WAITING_FOR_SWT_INIT", new Object[0]), e);
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    protected void dispose() {
        Display.getDefault().asyncExec(() -> {
            if (this.browser != null) {
                this.browser.dispose();
            }
            if (this.shell != null) {
                this.shell.dispose();
            }
        });
    }
}

