/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.auth;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.exchange.auth.O365InteractiveAuthenticator;
import davmail.exchange.auth.O365InteractiveJSLogger;
import davmail.ui.tray.DavGatewayTray;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class O365InteractiveAuthenticatorFrame
extends JFrame {
    private static final Logger LOGGER = Logger.getLogger(O365InteractiveAuthenticatorFrame.class);
    private O365InteractiveAuthenticator authenticator;
    String location;
    final JFXPanel fxPanel = new JFXPanel();

    public O365InteractiveAuthenticatorFrame() {
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!((O365InteractiveAuthenticatorFrame)O365InteractiveAuthenticatorFrame.this).authenticator.isAuthenticated && ((O365InteractiveAuthenticatorFrame)O365InteractiveAuthenticatorFrame.this).authenticator.errorCode == null) {
                    ((O365InteractiveAuthenticatorFrame)O365InteractiveAuthenticatorFrame.this).authenticator.errorCode = "user closed authentication window";
                }
            }
        });
        this.setTitle(BundleMessage.format("UI_DAVMAIL_GATEWAY", new Object[0]));
        try {
            this.setIconImages(DavGatewayTray.getFrameIcons());
        }
        catch (NoSuchMethodError error) {
            DavGatewayTray.debug(new BundleMessage("LOG_UNABLE_TO_SET_ICON_IMAGE", new Object[0]));
        }
        JPanel mainPanel = new JPanel();
        mainPanel.add((Component)this.fxPanel);
        this.add("Center", mainPanel);
        this.pack();
        this.setResizable(true);
        this.setSize(600, 600);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        this.setAlwaysOnTop(false);
    }

    public void setO365InteractiveAuthenticator(O365InteractiveAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    private void initFX(JFXPanel fxPanel, String url, String redirectUri) {
        WebView webView = new WebView();
        WebEngine webViewEngine = webView.getEngine();
        ProgressBar loadProgress = new ProgressBar();
        loadProgress.progressProperty().bind((ObservableValue)webViewEngine.getLoadWorker().progressProperty());
        StackPane hBox = new StackPane();
        hBox.getChildren().setAll((Object[])new Node[]{webView, loadProgress});
        Scene scene = new Scene((Parent)hBox);
        fxPanel.setScene(scene);
        webViewEngine.setUserAgent(Settings.getUserAgent());
        webViewEngine.setOnAlert(stringWebEvent -> SwingUtilities.invokeLater(() -> {
            String message = (String)stringWebEvent.getData();
            JOptionPane.showMessageDialog(this, message);
        }));
        webViewEngine.setOnError(event -> LOGGER.error((Object)event.getMessage()));
        webViewEngine.getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED || newState == Worker.State.CANCELLED) {
                loadProgress.setVisible(false);
                this.location = webViewEngine.getLocation();
                this.updateTitleAndFocus(this.location);
                LOGGER.debug((Object)("Webview location: " + this.location));
                O365InteractiveJSLogger.register(webViewEngine);
                if (Settings.getBooleanProperty("davmail.webview.debug", false)) {
                    LOGGER.debug((Object)this.dumpDocument(webViewEngine.getDocument()));
                }
                if (this.location.startsWith(redirectUri)) {
                    LOGGER.debug((Object)"Location starts with redirectUri, check code");
                    this.authenticator.handleCode(this.location);
                    this.close();
                }
            } else if (newState == Worker.State.FAILED) {
                Throwable e = webViewEngine.getLoadWorker().getException();
                if (e != null) {
                    this.handleError(e);
                }
                this.close();
            } else {
                LOGGER.debug((Object)(webViewEngine.getLoadWorker().getState() + " " + webViewEngine.getLoadWorker().getMessage() + " " + webViewEngine.getLocation() + " "));
            }
        });
        webViewEngine.load(url);
    }

    private void updateTitleAndFocus(String location) {
        SwingUtilities.invokeLater(() -> {
            this.setState(0);
            this.setAlwaysOnTop(true);
            this.setAlwaysOnTop(false);
            this.setTitle("DavMail: " + location);
        });
    }

    public String dumpDocument(Document document) {
        String result;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(document), new StreamResult(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8)));
            result = baos.toString("UTF-8");
        }
        catch (Exception e) {
            result = e + " " + e.getMessage();
        }
        return result;
    }

    public void authenticate(String initUrl, String redirectUri) {
        Platform.runLater(() -> {
            try {
                Platform.setImplicitExit((boolean)false);
                this.initFX(this.fxPanel, initUrl, redirectUri);
            }
            catch (Exception e) {
                this.handleError(e);
                this.close();
            }
        });
    }

    public void handleError(Throwable t) {
        LOGGER.error((Object)(t + " " + t.getMessage()));
        this.authenticator.errorCode = t.getMessage();
        if (this.authenticator.errorCode == null) {
            this.authenticator.errorCode = t.toString();
        }
    }

    public void close() {
        SwingUtilities.invokeLater(() -> {
            this.setVisible(false);
            this.dispose();
        });
    }

    static {
        URL.setURLStreamHandlerFactory(protocol -> {
            if ("msauth".equals(protocol) || "urn".equals(protocol)) {
                return new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) {
                        return new URLConnection(u){

                            @Override
                            public void connect() {
                            }
                        };
                    }
                };
            }
            return null;
        });
    }
}

