/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.auth;

import davmail.Settings;
import davmail.exception.DavMailAuthenticationException;
import davmail.exception.DavMailException;
import davmail.exchange.auth.ExchangeAuthenticator;
import davmail.exchange.auth.O365Authenticator;
import davmail.exchange.auth.O365InteractiveAuthenticatorFrame;
import davmail.exchange.auth.O365InteractiveAuthenticatorSWT;
import davmail.exchange.auth.O365ManualAuthenticatorDialog;
import davmail.exchange.auth.O365Token;
import davmail.exchange.ews.BaseShape;
import davmail.exchange.ews.DistinguishedFolderId;
import davmail.exchange.ews.GetFolderMethod;
import davmail.exchange.ews.GetUserConfigurationMethod;
import davmail.http.HttpClientAdapter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.security.Security;
import javax.swing.SwingUtilities;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.log4j.Logger;

public class O365InteractiveAuthenticator
implements ExchangeAuthenticator {
    private static final int MAX_COUNT = 300;
    private static final Logger LOGGER = Logger.getLogger(O365InteractiveAuthenticator.class);
    boolean isAuthenticated = false;
    String errorCode = null;
    String code = null;
    URI ewsUrl = URI.create(Settings.getO365Url());
    private O365InteractiveAuthenticatorFrame o365InteractiveAuthenticatorFrame;
    private O365InteractiveAuthenticatorSWT o365InteractiveAuthenticatorSWT;
    private O365ManualAuthenticatorDialog o365ManualAuthenticatorDialog;
    private String username;
    private String password;
    private O365Token token;

    @Override
    public O365Token getToken() {
        return this.token;
    }

    @Override
    public URI getExchangeUri() {
        return this.ewsUrl;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public HttpClientAdapter getHttpClientAdapter() {
        return new HttpClientAdapter(this.getExchangeUri(), this.username, this.password, true);
    }

    @Override
    public void authenticate() throws IOException {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        System.setProperty("jdk.http.ntlm.transparentAuth", "allHosts");
        String clientId = Settings.getProperty("davmail.oauth.clientId", "facd6cff-a294-4415-b59f-c5b01937d7bd");
        String redirectUri = Settings.getProperty("davmail.oauth.redirectUri", Settings.getO365LoginUrl() + "/common/oauth2/nativeclient");
        String tenantId = Settings.getProperty("davmail.oauth.tenantId", "common");
        this.token = O365Token.load(tenantId, clientId, redirectUri, this.username, this.password);
        if (this.token != null) {
            this.isAuthenticated = true;
            return;
        }
        String initUrl = O365Authenticator.buildAuthorizeUrl(tenantId, clientId, redirectUri, this.username);
        Authenticator.setDefault(new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                    String proxyUser = Settings.getProperty("davmail.proxyUser");
                    String proxyPassword = Settings.getProperty("davmail.proxyPassword");
                    if (proxyUser != null && proxyPassword != null) {
                        LOGGER.debug((Object)("Proxy authentication with user " + proxyUser));
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                    LOGGER.debug((Object)"Missing proxy credentials ");
                    return null;
                }
                LOGGER.debug((Object)("Password authentication with user " + O365InteractiveAuthenticator.this.username));
                return new PasswordAuthentication(O365InteractiveAuthenticator.this.username, O365InteractiveAuthenticator.this.password.toCharArray());
            }
        });
        boolean isSWTAvailable = Settings.isSWTAvailable();
        boolean isDocker = Settings.isDocker();
        boolean isJFXAvailable = Settings.isJFXAvailable();
        if (isSWTAvailable && !isDocker) {
            LOGGER.debug((Object)"Open SWT browser");
            try {
                this.o365InteractiveAuthenticatorSWT = new O365InteractiveAuthenticatorSWT();
                this.o365InteractiveAuthenticatorSWT.setO365InteractiveAuthenticator(this);
                this.o365InteractiveAuthenticatorSWT.authenticate(initUrl, redirectUri);
            }
            catch (Error e) {
                LOGGER.warn((Object)"Unable to load SWT browser");
                if (this.o365InteractiveAuthenticatorSWT != null) {
                    this.o365InteractiveAuthenticatorSWT.dispose();
                }
                this.o365InteractiveAuthenticatorSWT = null;
            }
        }
        if (this.o365InteractiveAuthenticatorSWT == null && isJFXAvailable) {
            LOGGER.info((Object)"Open JavaFX (OpenJFX) browser");
            SwingUtilities.invokeLater(() -> {
                try {
                    this.o365InteractiveAuthenticatorFrame = new O365InteractiveAuthenticatorFrame();
                    this.o365InteractiveAuthenticatorFrame.setO365InteractiveAuthenticator(this);
                    this.o365InteractiveAuthenticatorFrame.authenticate(initUrl, redirectUri);
                }
                catch (NoClassDefFoundError e) {
                    LOGGER.warn((Object)"Unable to load JavaFX (OpenJFX)");
                }
                catch (IllegalAccessError e) {
                    LOGGER.warn((Object)"Unable to load JavaFX (OpenJFX), append --add-exports java.base/sun.net.www.protocol.https=ALL-UNNAMED to java options");
                }
            });
        } else if (this.o365InteractiveAuthenticatorFrame == null && this.o365InteractiveAuthenticatorSWT == null) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    this.o365ManualAuthenticatorDialog = new O365ManualAuthenticatorDialog(initUrl);
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException e) {
                throw new IOException(e);
            }
            this.code = this.o365ManualAuthenticatorDialog.getCode();
            boolean bl = this.isAuthenticated = this.code != null;
            if (!this.isAuthenticated) {
                this.errorCode = "User did not provide authentication code";
            }
        }
        int count = 0;
        while (!this.isAuthenticated && this.errorCode == null && count++ < 300) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (count > 300) {
            this.errorCode = "Timed out waiting for interactive authentication";
        }
        if (this.o365InteractiveAuthenticatorFrame != null && this.o365InteractiveAuthenticatorFrame.isVisible()) {
            this.o365InteractiveAuthenticatorFrame.close();
        }
        if (this.o365InteractiveAuthenticatorSWT != null) {
            this.o365InteractiveAuthenticatorSWT.dispose();
        }
        if (this.isAuthenticated) {
            this.token = O365Token.build(tenantId, clientId, redirectUri, this.code, this.password);
            LOGGER.debug((Object)("Authenticated username: " + this.token.getUsername()));
            if (this.username != null && !this.username.isEmpty() && !this.username.equalsIgnoreCase(this.token.getUsername())) {
                throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED_MISMATCH", this.token.getUsername(), this.username);
            }
        } else {
            LOGGER.error((Object)("Authentication failed " + this.errorCode));
            throw new DavMailException("EXCEPTION_AUTHENTICATION_FAILED_REASON", this.errorCode);
        }
    }

    public void handleCode(String location) {
        this.isAuthenticated = location.contains("code=");
        if (!this.isAuthenticated && location.contains("error=")) {
            this.errorCode = location.substring(location.indexOf("error="));
        }
        if (this.isAuthenticated) {
            LOGGER.debug((Object)("Authenticated location: " + location));
            this.code = location.contains("&session_state=") ? location.substring(location.indexOf("code=") + 5, location.indexOf("&session_state=")) : location.substring(location.indexOf("code=") + 5);
            String sessionState = location.substring(location.lastIndexOf(61) + 1);
            LOGGER.debug((Object)("Authentication Code: " + this.code));
            LOGGER.debug((Object)("Authentication session state: " + sessionState));
        }
    }

    public static void main(String[] argv) {
        try {
            Security.setProperty("ssl.SocketFactory.provider", "davmail.http.DavGatewaySSLSocketFactory");
            Settings.setDefaultSettings();
            Settings.setConfigFilePath("davmail-interactive.properties");
            Settings.load();
            O365InteractiveAuthenticator authenticator = new O365InteractiveAuthenticator();
            authenticator.setUsername("demo@demo.onmicrosoft.com");
            authenticator.authenticate();
            try (HttpClientAdapter httpClientAdapter = new HttpClientAdapter(authenticator.getExchangeUri(), true);){
                GetFolderMethod checkMethod = new GetFolderMethod(BaseShape.ID_ONLY, DistinguishedFolderId.getInstance(null, DistinguishedFolderId.Name.root), null);
                checkMethod.setHeader("Authorization", "Bearer " + authenticator.getToken().getAccessToken());
                try (CloseableHttpResponse response = httpClientAdapter.execute((HttpRequestBase)checkMethod);){
                    checkMethod.handleResponse((HttpResponse)response);
                    checkMethod.checkSuccess();
                }
                LOGGER.info((Object)("Retrieved folder id " + (String)checkMethod.getResponseItem().get("FolderId")));
                int i = 0;
                while (i++ < 1440) {
                    GetUserConfigurationMethod getUserConfigurationMethod = new GetUserConfigurationMethod();
                    getUserConfigurationMethod.setHeader("Authorization", "Bearer " + authenticator.getToken().getAccessToken());
                    try (CloseableHttpResponse response = httpClientAdapter.execute((HttpRequestBase)getUserConfigurationMethod);){
                        getUserConfigurationMethod.handleResponse((HttpResponse)response);
                        getUserConfigurationMethod.checkSuccess();
                    }
                    LOGGER.info((Object)getUserConfigurationMethod.getResponseItem());
                    Thread.sleep(5000L);
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn((Object)"Thread interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error((Object)(e + " " + e.getMessage()), (Throwable)e);
        }
        System.exit(0);
    }

    static {
        System.setProperty("com.sun.webkit.useHTTP2Loader", "false");
    }
}

