/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.auth;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.exception.DavMailAuthenticationException;
import davmail.exchange.auth.ExchangeAuthenticator;
import davmail.exchange.auth.O365Token;
import davmail.http.HttpClientAdapter;
import davmail.http.request.GetRequest;
import davmail.http.request.PostRequest;
import davmail.http.request.RestRequest;
import davmail.ui.NumberMatchingFrame;
import davmail.ui.PasswordPromptDialog;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class O365Authenticator
implements ExchangeAuthenticator {
    protected static final Logger LOGGER = Logger.getLogger(O365Authenticator.class);
    private String tenantId;
    private String username;
    private String userid;
    private String password;
    private O365Token token;

    public static String buildAuthorizeUrl(String tenantId, String clientId, String redirectUri, String username) throws IOException {
        URI uri;
        try {
            URIBuilder uriBuilder = new URIBuilder(Settings.getO365LoginUrl()).addParameter("client_id", clientId).addParameter("response_type", "code").addParameter("redirect_uri", redirectUri).addParameter("response_mode", "query").addParameter("login_hint", username);
            if ("https://outlook.live.com".equals(Settings.getOutlookUrl())) {
                String liveAuthorizeUrl = "https://login.live.com/oauth20_authorize.srf";
                uriBuilder = new URIBuilder(liveAuthorizeUrl).addParameter("client_id", clientId).addParameter("response_type", "code").addParameter("redirect_uri", redirectUri).addParameter("response_mode", "query").addParameter("login_hint", username).addParameter("scope", "openid offline_access https://outlook.live.com/EWS.AccessAsUser.All Mail.ReadWrite MailboxSettings.Read").addParameter("resource", "https://outlook.live.com");
            } else if (Settings.getBooleanProperty("davmail.enableGraph", false)) {
                if (Settings.getBooleanProperty("davmail.enableOidc", false)) {
                    uriBuilder.setPath("/" + tenantId + "/oauth2/v2.0/authorize").addParameter("scope", Settings.getProperty("davmail.oauth.scope", "openid profile offline_access Mail.ReadWrite Calendars.ReadWrite MailboxSettings.Read Mail.ReadWrite.Shared Contacts.ReadWrite Tasks.ReadWrite Mail.Send"));
                } else {
                    uriBuilder.setPath("/" + tenantId + "/oauth2/authorize").addParameter("resource", Settings.getGraphUrl());
                }
            } else if (Settings.getBooleanProperty("davmail.enableOidc", false)) {
                uriBuilder.setPath("/" + tenantId + "/oauth2/v2.0/authorize").addParameter("scope", Settings.getProperty("davmail.oauth.scope", "openid profile offline_access " + Settings.getOutlookUrl() + "/EWS.AccessAsUser.All"));
            } else {
                uriBuilder.setPath("/" + tenantId + "/oauth2/authorize").addParameter("resource", Settings.getOutlookUrl());
            }
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return uri.toString();
    }

    @Override
    public void setUsername(String username) {
        if (username.contains("|")) {
            this.userid = username.substring(0, username.indexOf("|"));
            this.username = username.substring(username.indexOf("|") + 1);
        } else {
            this.username = username;
            this.userid = username;
        }
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public O365Token getToken() {
        return this.token;
    }

    @Override
    public URI getExchangeUri() {
        return URI.create(Settings.getO365Url());
    }

    @Override
    public HttpClientAdapter getHttpClientAdapter() {
        return new HttpClientAdapter(this.getExchangeUri(), this.username, this.password, true);
    }

    @Override
    public void authenticate() throws IOException {
        String clientId = Settings.getProperty("davmail.oauth.clientId", "facd6cff-a294-4415-b59f-c5b01937d7bd");
        String redirectUri = Settings.getProperty("davmail.oauth.redirectUri", Settings.getO365LoginUrl() + "/common/oauth2/nativeclient");
        this.tenantId = Settings.getProperty("davmail.oauth.tenantId", "common");
        this.token = O365Token.load(this.tenantId, clientId, redirectUri, this.username, this.password);
        if (this.token != null) {
            return;
        }
        String url = O365Authenticator.buildAuthorizeUrl(this.tenantId, clientId, redirectUri, this.username);
        try (HttpClientAdapter httpClientAdapter = new HttpClientAdapter(url, this.userid, this.password);){
            String code;
            GetRequest getRequest = new GetRequest(url);
            String responseBodyAsString = this.executeFollowRedirect(httpClientAdapter, getRequest);
            if (!responseBodyAsString.contains("Config=") && responseBodyAsString.contains("ServerData =")) {
                JSONObject config = this.extractServerData(responseBodyAsString);
                String referer = getRequest.getURI().toString();
                code = this.authenticateLive(httpClientAdapter, config, referer);
            } else if (!responseBodyAsString.contains("Config=")) {
                code = this.authenticateADFS(httpClientAdapter, responseBodyAsString, url);
            } else {
                JSONObject config = this.extractConfig(responseBodyAsString);
                this.checkConfigErrors(config);
                String context = config.getString("sCtx");
                String apiCanary = config.getString("apiCanary");
                String clientRequestId = config.getString("correlationId");
                String hpgact = config.getString("hpgact");
                String hpgid = config.getString("hpgid");
                String flowToken = config.getString("sFT");
                String canary = config.getString("canary");
                String sessionId = config.getString("sessionId");
                String referer = getRequest.getURI().toString();
                RestRequest getCredentialMethod = new RestRequest(Settings.getO365LoginUrl() + "/" + this.tenantId + "/GetCredentialType");
                getCredentialMethod.setRequestHeader("Accept", "application/json");
                getCredentialMethod.setRequestHeader("canary", apiCanary);
                getCredentialMethod.setRequestHeader("client-request-id", clientRequestId);
                getCredentialMethod.setRequestHeader("hpgact", hpgact);
                getCredentialMethod.setRequestHeader("hpgid", hpgid);
                getCredentialMethod.setRequestHeader("hpgrequestid", sessionId);
                getCredentialMethod.setRequestHeader("Referer", referer);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("username", (Object)this.username);
                jsonObject.put("isOtherIdpSupported", true);
                jsonObject.put("checkPhones", false);
                jsonObject.put("isRemoteNGCSupported", false);
                jsonObject.put("isCookieBannerShown", false);
                jsonObject.put("isFidoSupported", false);
                jsonObject.put("flowToken", (Object)flowToken);
                jsonObject.put("originalRequest", (Object)context);
                getCredentialMethod.setJsonBody(jsonObject);
                JSONObject credentialType = httpClientAdapter.executeRestRequest(getCredentialMethod);
                LOGGER.debug((Object)("CredentialType=" + credentialType));
                JSONObject credentials = credentialType.getJSONObject("Credentials");
                String federationRedirectUrl = credentials.optString("FederationRedirectUrl");
                if (federationRedirectUrl != null && !federationRedirectUrl.isEmpty()) {
                    LOGGER.debug((Object)("Detected ADFS, redirecting to " + federationRedirectUrl));
                    code = this.authenticateRedirectADFS(httpClientAdapter, federationRedirectUrl, url);
                } else {
                    PostRequest logonMethod = new PostRequest(Settings.getO365LoginUrl() + "/" + this.tenantId + "/login");
                    logonMethod.setRequestHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
                    logonMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                    logonMethod.setRequestHeader("Referer", referer);
                    logonMethod.setParameter("canary", canary);
                    logonMethod.setParameter("ctx", context);
                    logonMethod.setParameter("flowToken", flowToken);
                    logonMethod.setParameter("hpgrequestid", sessionId);
                    logonMethod.setParameter("login", this.username);
                    logonMethod.setParameter("loginfmt", this.username);
                    logonMethod.setParameter("passwd", this.password);
                    responseBodyAsString = httpClientAdapter.executePostRequest(logonMethod);
                    URI location = logonMethod.getRedirectLocation();
                    if (responseBodyAsString != null && responseBodyAsString.contains("arrUserProofs")) {
                        logonMethod = this.handleMfa(httpClientAdapter, logonMethod, this.username, clientRequestId);
                        location = logonMethod.getRedirectLocation();
                    }
                    if (location == null || !location.toString().startsWith(redirectUri)) {
                        config = this.extractConfig(logonMethod.getResponseBodyAsString());
                        if (config.optJSONArray("arrScopes") != null || config.optJSONArray("urlPostRedirect") != null) {
                            LOGGER.warn((Object)"Authentication successful but user consent or validation needed, please open the following url in a browser");
                            LOGGER.warn((Object)url);
                            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
                        }
                        if ("ConvergedChangePassword".equals(config.optString("pgid"))) {
                            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED_PASSWORD_EXPIRED");
                        }
                        if ("50126".equals(config.optString("sErrorCode"))) {
                            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
                        }
                        if ("50125".equals(config.optString("sErrorCode"))) {
                            throw new DavMailAuthenticationException("LOG_MESSAGE", "Your organization needs more information to keep your account secure, authenticate once in a web browser and try again");
                        }
                        if ("50128".equals(config.optString("sErrorCode"))) {
                            throw new DavMailAuthenticationException("LOG_MESSAGE", "Invalid domain name - No tenant-identifying information found in either the request or implied by any provided credentials.");
                        }
                        if (config.optString("strServiceExceptionMessage", null) != null) {
                            LOGGER.debug((Object)("O365 returned error: " + config.optString("strServiceExceptionMessage")));
                            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
                        }
                        throw new DavMailAuthenticationException("LOG_MESSAGE", "Authentication failed, unknown error: " + config);
                    }
                    String query = location.toString();
                    if (query.contains("code=")) {
                        code = query.substring(query.indexOf("code=") + 5, query.indexOf("&session_state="));
                    } else {
                        throw new DavMailAuthenticationException("LOG_MESSAGE", "Authentication failed, unknown error: " + query);
                    }
                }
            }
            LOGGER.debug((Object)("Authentication Code: " + code));
            this.token = O365Token.build(this.tenantId, clientId, redirectUri, code, this.password);
            LOGGER.debug((Object)("Authenticated username: " + this.token.getUsername()));
            if (!this.username.equalsIgnoreCase(this.token.getUsername())) {
                throw new IOException("Authenticated username " + this.token.getUsername() + " does not match " + this.username);
            }
        }
        catch (JSONException e) {
            throw new IOException((Object)((Object)e) + " " + e.getMessage());
        }
    }

    private void checkConfigErrors(JSONObject config) throws DavMailAuthenticationException {
        if (config.optString("strServiceExceptionMessage", null) != null) {
            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED_REASON", config.optString("strServiceExceptionMessage"));
        }
    }

    private String authenticateLive(HttpClientAdapter httpClientAdapter, JSONObject config, String referer) throws JSONException, IOException {
        String urlPost = config.getString("urlPost");
        PostRequest logonMethod = new PostRequest(urlPost);
        logonMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        logonMethod.setRequestHeader("Referer", referer);
        String sFTTag = config.optString("sFTTag");
        String ppft = "";
        if (sFTTag.contains("value=")) {
            ppft = sFTTag.substring(sFTTag.indexOf("value=\"") + 7, sFTTag.indexOf("\"/>"));
        }
        logonMethod.setParameter("PPFT", ppft);
        logonMethod.setParameter("login", this.username);
        logonMethod.setParameter("loginfmt", this.username);
        logonMethod.setParameter("passwd", this.password);
        String responseBodyAsString = httpClientAdapter.executePostRequest(logonMethod);
        URI location = logonMethod.getRedirectLocation();
        if (location == null) {
            if (responseBodyAsString.contains("ServerData =")) {
                String errorMessage = this.extractServerData(responseBodyAsString).optString("sErrTxt");
                throw new IOException("Live.com authentication failure: " + errorMessage);
            }
        } else {
            String query = location.getQuery();
            if (query.contains("code=")) {
                String code = query.substring(query.indexOf("code=") + 5);
                LOGGER.debug((Object)("Authentication Code: " + code));
                return code;
            }
        }
        throw new IOException("Unknown Live.com authentication failure");
    }

    private String authenticateRedirectADFS(HttpClientAdapter httpClientAdapter, String federationRedirectUrl, String authorizeUrl) throws IOException, JSONException {
        GetRequest logonFormMethod = new GetRequest(federationRedirectUrl);
        logonFormMethod = httpClientAdapter.executeFollowRedirect(logonFormMethod);
        String responseBodyAsString = logonFormMethod.getResponseBodyAsString();
        return this.authenticateADFS(httpClientAdapter, responseBodyAsString, authorizeUrl);
    }

    private String authenticateADFS(HttpClientAdapter httpClientAdapter, String responseBodyAsString, String authorizeUrl) throws IOException, JSONException {
        String query;
        URI location;
        if (responseBodyAsString.contains(Settings.getO365LoginUrl())) {
            LOGGER.info((Object)"Already authenticated through Basic or NTLM");
        } else {
            PostRequest logonMethod = new PostRequest(this.extract("method=\"post\" action=\"([^\"]+)\"", responseBodyAsString));
            logonMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            logonMethod.setParameter("UserName", this.userid);
            logonMethod.setParameter("Password", this.password);
            logonMethod.setParameter("AuthMethod", "FormsAuthentication");
            httpClientAdapter.executePostRequest(logonMethod);
            location = logonMethod.getRedirectLocation();
            if (location == null) {
                throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
            }
            GetRequest redirectMethod = new GetRequest(location);
            responseBodyAsString = httpClientAdapter.executeGetRequest(redirectMethod);
        }
        if (!responseBodyAsString.contains(Settings.getO365LoginUrl())) {
            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
        }
        String targetUrl = this.extract("action=\"([^\"]+)\"", responseBodyAsString);
        String wa = this.extract("name=\"wa\" value=\"([^\"]+)\"", responseBodyAsString);
        String wresult = this.extract("name=\"wresult\" value=\"([^\"]+)\"", responseBodyAsString);
        wresult = wresult.replaceAll("&quot;", "\"");
        wresult = wresult.replaceAll("&lt;", "<");
        wresult = wresult.replaceAll("&gt;", ">");
        String wctx = this.extract("name=\"wctx\" value=\"([^\"]+)\"", responseBodyAsString);
        wctx = wctx.replaceAll("&amp;", "&");
        PostRequest targetMethod = new PostRequest(targetUrl);
        targetMethod.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        targetMethod.setParameter("wa", wa);
        targetMethod.setParameter("wresult", wresult);
        targetMethod.setParameter("wctx", wctx);
        responseBodyAsString = httpClientAdapter.executePostRequest(targetMethod);
        location = targetMethod.getRedirectLocation();
        LOGGER.debug((Object)targetMethod.getURI().toString());
        LOGGER.debug((Object)targetMethod.getReasonPhrase());
        LOGGER.debug((Object)responseBodyAsString);
        if (targetMethod.getStatusCode() == 200) {
            JSONObject config = this.extractConfig(responseBodyAsString);
            if (config.optJSONArray("arrScopes") != null || config.optJSONArray("urlPostRedirect") != null) {
                LOGGER.warn((Object)"Authentication successful but user consent or validation needed, please open the following url in a browser");
                LOGGER.warn((Object)authorizeUrl);
                throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
            }
        } else if (targetMethod.getStatusCode() != 302 || location == null) {
            throw new IOException("Unknown ADFS authentication failure");
        }
        if (location.getHost().startsWith("device")) {
            location = this.processDeviceLogin(httpClientAdapter, location);
        }
        if ((query = location.getQuery()) == null) {
            query = location.getSchemeSpecificPart();
        }
        if (query.contains("code=") && query.contains("&session_state=")) {
            String code = query.substring(query.indexOf("code=") + 5, query.indexOf("&session_state="));
            LOGGER.debug((Object)("Authentication Code: " + code));
            return code;
        }
        throw new IOException("Unknown ADFS authentication failure");
    }

    private URI processDeviceLogin(HttpClientAdapter httpClient, URI location) throws IOException, JSONException {
        GetRequest deviceLoginMethod;
        String responseBodyAsString;
        URI result = location;
        LOGGER.debug((Object)"Proceed to device authentication, must have access to a client certificate signed by MS-Organization-Access");
        if (Settings.isWindows() && (System.getProperty("java.version").compareTo("13") < 0 || !"MSCAPI".equals(Settings.getProperty("davmail.ssl.clientKeystoreType")))) {
            LOGGER.warn((Object)"MSCAPI and Java version 13 or higher required to access TPM protected client certificate on Windows");
        }
        if ((responseBodyAsString = httpClient.executeGetRequest(deviceLoginMethod = new GetRequest(location))).contains(Settings.getO365LoginUrl())) {
            String ctx = this.extract("name=\"ctx\" value=\"([^\"]+)\"", responseBodyAsString);
            String flowtoken = this.extract("name=\"flowtoken\" value=\"([^\"]+)\"", responseBodyAsString);
            PostRequest processMethod = new PostRequest(this.extract("action=\"([^\"]+)\"", responseBodyAsString));
            processMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            processMethod.setParameter("ctx", ctx);
            processMethod.setParameter("flowtoken", flowtoken);
            responseBodyAsString = httpClient.executePostRequest(processMethod);
            result = processMethod.getRedirectLocation();
            if (result == null && responseBodyAsString != null && responseBodyAsString.contains("arrUserProofs")) {
                processMethod = this.handleMfa(httpClient, processMethod, this.username, null);
                result = processMethod.getRedirectLocation();
            }
            if (result == null) {
                throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PostRequest handleMfa(HttpClientAdapter httpClientAdapter, PostRequest logonMethod, String username, String clientRequestId) throws IOException, JSONException {
        JSONObject config = this.extractConfig(logonMethod.getResponseBodyAsString());
        LOGGER.debug((Object)("Config=" + config));
        String urlBeginAuth = config.getString("urlBeginAuth");
        String urlEndAuth = config.getString("urlEndAuth");
        String urlProcessAuth = config.optString("urlPost", Settings.getO365LoginUrl() + "/" + this.tenantId + "/SAS/ProcessAuth");
        boolean isMFAMethodSupported = false;
        String chosenAuthMethodId = null;
        String chosenAuthMethodPrompt = null;
        for (int i = 0; i < config.getJSONArray("arrUserProofs").length(); ++i) {
            JSONObject authMethod = (JSONObject)config.getJSONArray("arrUserProofs").get(i);
            String authMethodId = authMethod.getString("authMethodId");
            LOGGER.debug((Object)("Authentication method: " + authMethodId));
            if ("PhoneAppNotification".equals(authMethodId)) {
                LOGGER.debug((Object)("Found phone app auth method " + authMethod.getString("display")));
                isMFAMethodSupported = true;
                chosenAuthMethodId = authMethodId;
                chosenAuthMethodPrompt = authMethod.getString("display");
                break;
            }
            if (!"OneWaySMS".equals(authMethodId)) continue;
            LOGGER.debug((Object)("Found OneWaySMS auth method " + authMethod.getString("display")));
            chosenAuthMethodId = authMethodId;
            chosenAuthMethodPrompt = authMethod.getString("display");
            isMFAMethodSupported = true;
        }
        if (!isMFAMethodSupported) {
            throw new IOException("MFA authentication methods not supported");
        }
        String context = config.getString("sCtx");
        String flowToken = config.getString("sFT");
        String canary = config.getString("canary");
        String apiCanary = config.getString("apiCanary");
        String hpgrequestid = logonMethod.getResponseHeader("x-ms-request-id").getValue();
        String hpgact = config.getString("hpgact");
        String hpgid = config.getString("hpgid");
        String correlationId = clientRequestId;
        if (correlationId == null) {
            correlationId = config.getString("correlationId");
        }
        RestRequest beginAuthMethod = new RestRequest(urlBeginAuth);
        beginAuthMethod.setRequestHeader("Accept", "application/json");
        beginAuthMethod.setRequestHeader("canary", apiCanary);
        beginAuthMethod.setRequestHeader("client-request-id", correlationId);
        beginAuthMethod.setRequestHeader("hpgact", hpgact);
        beginAuthMethod.setRequestHeader("hpgid", hpgid);
        beginAuthMethod.setRequestHeader("hpgrequestid", hpgrequestid);
        JSONObject beginAuthJson = new JSONObject();
        beginAuthJson.put("AuthMethodId", (Object)chosenAuthMethodId);
        beginAuthJson.put("Ctx", (Object)context);
        beginAuthJson.put("FlowToken", (Object)flowToken);
        beginAuthJson.put("Method", (Object)"BeginAuth");
        beginAuthMethod.setJsonBody(beginAuthJson);
        config = httpClientAdapter.executeRestRequest(beginAuthMethod);
        LOGGER.debug((Object)config);
        if (!config.getBoolean("Success")) {
            throw new IOException("Authentication failed: " + config);
        }
        String entropy = config.optString("Entropy", null);
        NumberMatchingFrame numberMatchingFrame = null;
        if (entropy != null && !"0".equals(entropy)) {
            LOGGER.info((Object)("Number matching value for " + username + ": " + entropy));
            if (!Settings.getBooleanProperty("davmail.server") && !GraphicsEnvironment.isHeadless()) {
                numberMatchingFrame = new NumberMatchingFrame(entropy);
            }
        }
        String smsCode = this.retrieveSmsCode(chosenAuthMethodId, chosenAuthMethodPrompt);
        context = config.getString("Ctx");
        flowToken = config.getString("FlowToken");
        String sessionId = config.getString("SessionId");
        int i = 0;
        boolean success = false;
        try {
            while (!success && i++ < 12) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    LOGGER.debug((Object)"Interrupted");
                    Thread.currentThread().interrupt();
                }
                RestRequest endAuthMethod = new RestRequest(urlEndAuth);
                endAuthMethod.setRequestHeader("Accept", "application/json");
                endAuthMethod.setRequestHeader("canary", apiCanary);
                endAuthMethod.setRequestHeader("client-request-id", clientRequestId);
                endAuthMethod.setRequestHeader("hpgact", hpgact);
                endAuthMethod.setRequestHeader("hpgid", hpgid);
                endAuthMethod.setRequestHeader("hpgrequestid", hpgrequestid);
                JSONObject endAuthJson = new JSONObject();
                endAuthJson.put("AuthMethodId", (Object)chosenAuthMethodId);
                endAuthJson.put("Ctx", (Object)context);
                endAuthJson.put("FlowToken", (Object)flowToken);
                endAuthJson.put("Method", (Object)"EndAuth");
                endAuthJson.put("PollCount", (Object)"1");
                endAuthJson.put("SessionId", (Object)sessionId);
                endAuthJson.put("AdditionalAuthData", (Object)smsCode);
                endAuthMethod.setJsonBody(endAuthJson);
                config = httpClientAdapter.executeRestRequest(endAuthMethod);
                LOGGER.debug((Object)config);
                String resultValue = config.getString("ResultValue");
                if ("PhoneAppDenied".equals(resultValue) || "PhoneAppNoResponse".equals(resultValue)) {
                    throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED_REASON", resultValue);
                }
                if ("SMSAuthFailedWrongCodeEntered".equals(resultValue)) {
                    smsCode = this.retrieveSmsCode(chosenAuthMethodId, chosenAuthMethodPrompt);
                }
                if (!config.getBoolean("Success")) continue;
                success = true;
            }
        }
        finally {
            if (numberMatchingFrame != null && numberMatchingFrame.isVisible()) {
                NumberMatchingFrame finalNumberMatchingFrame = numberMatchingFrame;
                SwingUtilities.invokeLater(() -> {
                    finalNumberMatchingFrame.setVisible(false);
                    finalNumberMatchingFrame.dispose();
                });
            }
        }
        if (!success) {
            throw new IOException("Authentication failed: " + config);
        }
        String authMethod = chosenAuthMethodId;
        String type = "22";
        context = config.getString("Ctx");
        flowToken = config.getString("FlowToken");
        PostRequest processAuthMethod = new PostRequest(urlProcessAuth);
        processAuthMethod.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        processAuthMethod.setParameter("type", type);
        processAuthMethod.setParameter("request", context);
        processAuthMethod.setParameter("mfaAuthMethod", authMethod);
        processAuthMethod.setParameter("canary", canary);
        processAuthMethod.setParameter("login", username);
        processAuthMethod.setParameter("flowToken", flowToken);
        processAuthMethod.setParameter("hpgrequestid", hpgrequestid);
        httpClientAdapter.executePostRequest(processAuthMethod);
        return processAuthMethod;
    }

    private String retrieveSmsCode(String chosenAuthMethodId, String chosenAuthMethodPrompt) throws IOException {
        String smsCode = null;
        if ("OneWaySMS".equals(chosenAuthMethodId)) {
            LOGGER.info((Object)("Need to retrieve SMS verification code for " + this.username));
            if (Settings.getBooleanProperty("davmail.server") || GraphicsEnvironment.isHeadless()) {
                System.out.print(BundleMessage.format("UI_SMS_PHONE_CODE", chosenAuthMethodPrompt));
                BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in));
                smsCode = inReader.readLine();
            } else {
                PasswordPromptDialog passwordPromptDialog = new PasswordPromptDialog(BundleMessage.format("UI_SMS_PHONE_CODE", chosenAuthMethodPrompt));
                smsCode = String.valueOf(passwordPromptDialog.getPassword());
            }
        }
        return smsCode;
    }

    private String executeFollowRedirect(HttpClientAdapter httpClientAdapter, GetRequest getRequest) throws IOException {
        LOGGER.debug((Object)getRequest.getURI());
        GetRequest responseWrapper = httpClientAdapter.executeFollowRedirect(getRequest);
        String responseHost = responseWrapper.getURI().getHost();
        if (responseHost.endsWith("okta.com")) {
            throw new DavMailAuthenticationException("LOG_MESSAGE", "Okta authentication not supported, please try O365Interactive");
        }
        return responseWrapper.getResponseBodyAsString();
    }

    public JSONObject extractConfig(String content) throws IOException {
        try {
            return new JSONObject(this.extract("Config=([^\n]+);", content));
        }
        catch (JSONException e1) {
            LOGGER.debug((Object)content);
            throw new IOException("Unable to extract config from response body");
        }
    }

    public JSONObject extractServerData(String content) throws IOException {
        try {
            return new JSONObject(this.extract("ServerData =([^\n]+);", content));
        }
        catch (JSONException e1) {
            LOGGER.debug((Object)content);
            throw new IOException("Unable to extract config from response body");
        }
    }

    public String extract(String pattern, String content) throws IOException {
        Matcher matcher = Pattern.compile(pattern).matcher(content);
        if (!matcher.find()) {
            throw new IOException("pattern not found");
        }
        String value = matcher.group(1);
        return value;
    }
}

