/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.auth;

import davmail.BundleMessage;
import davmail.exception.DavMailAuthenticationException;
import davmail.exception.DavMailException;
import davmail.exception.WebdavNotAvailableException;
import davmail.exchange.auth.ExchangeAuthenticator;
import davmail.exchange.auth.O365Token;
import davmail.http.DavGatewayOTPPrompt;
import davmail.http.HttpClientAdapter;
import davmail.http.URIUtil;
import davmail.http.request.GetRequest;
import davmail.http.request.PostRequest;
import davmail.http.request.ResponseWrapper;
import davmail.util.StringUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.log4j.Logger;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;

public class ExchangeFormAuthenticator
implements ExchangeAuthenticator {
    protected static final Logger LOGGER = Logger.getLogger((String)"davmail.exchange.ExchangeSession");
    protected static final Set<String> USER_NAME_FIELDS = new HashSet<String>();
    protected static final Set<String> PASSWORD_FIELDS;
    protected static final Set<String> TOKEN_FIELDS;
    private String username;
    private String password;
    private String url;
    private HttpClientAdapter httpClientAdapter;
    private String preAuthusername;
    private final List<String> usernameInputs = new ArrayList<String>();
    private String passwordInput = null;
    private boolean otpPreAuthFound = false;
    private int otpPreAuthRetries = 0;
    private static final int MAX_OTP_RETRIES = 3;
    private URI exchangeUri;

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void authenticate() throws DavMailException {
        try {
            this.httpClientAdapter = new HttpClientAdapter(this.url, true);
            boolean isHttpAuthentication = this.isHttpAuthentication(this.httpClientAdapter, this.url);
            if (this.preAuthusername == null) {
                int doubleQuoteIndex = this.username.indexOf(34);
                if (doubleQuoteIndex > 0) {
                    this.preAuthusername = this.username.substring(0, doubleQuoteIndex);
                    this.username = this.username.substring(doubleQuoteIndex + 1);
                } else {
                    this.preAuthusername = this.username;
                }
            }
            this.httpClientAdapter.setCredentials(this.username, this.password);
            GetRequest getRequest = this.httpClientAdapter.executeFollowRedirect(new GetRequest(this.url));
            if (!this.isAuthenticated(getRequest)) {
                if (isHttpAuthentication) {
                    int status = getRequest.getStatusCode();
                    if (status == 401) {
                        throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
                    }
                    if (status != 200) {
                        throw HttpClientAdapter.buildHttpResponseException((HttpRequestBase)getRequest, getRequest.getHttpResponse());
                    }
                    if ("/owa/auth/logon.aspx".equals(getRequest.getURI().getPath())) {
                        this.formLogin(this.httpClientAdapter, getRequest, this.password);
                    }
                } else {
                    this.formLogin(this.httpClientAdapter, getRequest, this.password);
                }
            }
        }
        catch (DavMailAuthenticationException exc) {
            this.close();
            LOGGER.error((Object)exc.getMessage());
            throw exc;
        }
        catch (ConnectException | UnknownHostException exc) {
            this.close();
            BundleMessage message = new BundleMessage("EXCEPTION_CONNECT", exc.getClass().getName(), exc.getMessage());
            LOGGER.error((Object)message);
            throw new DavMailException("EXCEPTION_DAVMAIL_CONFIGURATION", message);
        }
        catch (WebdavNotAvailableException exc) {
            this.close();
            throw exc;
        }
        catch (IOException exc) {
            this.close();
            LOGGER.error((Object)BundleMessage.formatLog("EXCEPTION_EXCHANGE_LOGIN_FAILED", exc));
            throw new DavMailException("EXCEPTION_EXCHANGE_LOGIN_FAILED", new Object[]{exc});
        }
        LOGGER.debug((Object)("Successfully authenticated to " + this.exchangeUri));
    }

    protected boolean isHttpAuthentication(HttpClientAdapter httpClient, String url) {
        boolean isHttpAuthentication = false;
        HttpGet httpGet = new HttpGet(url);
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore((CookieStore)new BasicCookieStore());
        try (CloseableHttpResponse response = httpClient.execute((HttpRequestBase)httpGet, context);){
            isHttpAuthentication = response.getStatusLine().getStatusCode() == 401;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isHttpAuthentication;
    }

    protected boolean isAuthenticated(ResponseWrapper getRequest) {
        boolean authenticated = false;
        if (getRequest.getStatusCode() == 200 && "/ews/services.wsdl".equalsIgnoreCase(getRequest.getURI().getPath())) {
            authenticated = true;
        } else {
            for (Cookie cookie : this.httpClientAdapter.getCookies()) {
                if (!cookie.getName().startsWith("cadata") && !"sessionid".equals(cookie.getName()) && !"UserContext".equals(cookie.getName()) && !"TimeWindowSig".equals(cookie.getName())) continue;
                authenticated = true;
                break;
            }
        }
        return authenticated;
    }

    protected void formLogin(HttpClientAdapter httpClient, ResponseWrapper initRequest, String password) throws IOException {
        LOGGER.debug((Object)"Form based authentication detected");
        PostRequest postRequest = this.buildLogonMethod(httpClient, initRequest);
        if (postRequest == null) {
            LOGGER.debug((Object)("Authentication form not found at " + initRequest.getURI() + ", trying default url"));
            postRequest = new PostRequest("/owa/auth/owaauth.dll");
        }
        this.exchangeUri = this.postLogonMethod(httpClient, postRequest, password).getURI();
    }

    protected PostRequest buildLogonMethod(HttpClientAdapter httpClient, ResponseWrapper responseWrapper) {
        PostRequest logonMethod;
        block38: {
            logonMethod = null;
            HtmlCleaner cleaner = new HtmlCleaner();
            cleaner.getProperties().setAllowHtmlInsideAttributes(true);
            this.usernameInputs.clear();
            try {
                URI uri = responseWrapper.getURI();
                String responseBody = responseWrapper.getResponseBodyAsString();
                TagNode node = cleaner.clean((InputStream)new ByteArrayInputStream(responseBody.getBytes(StandardCharsets.UTF_8)));
                List forms = node.getElementListByName("form", true);
                TagNode logonForm = null;
                if (forms.size() == 1) {
                    logonForm = (TagNode)forms.get(0);
                } else if (forms.size() > 1) {
                    for (TagNode form : forms) {
                        if ("logonForm".equals(form.getAttributeByName("name"))) {
                            logonForm = form;
                            continue;
                        }
                        if (!"loginForm".equals(form.getAttributeByName("id"))) continue;
                        logonForm = form;
                    }
                }
                if (logonForm != null) {
                    String logonMethodPath = logonForm.getAttributeByName("action");
                    if (logonMethodPath != null && logonMethodPath.isEmpty()) {
                        logonMethodPath = "/owa/auth.owa";
                    }
                    logonMethod = new PostRequest(this.getAbsoluteUri(uri, logonMethodPath));
                    List inputList = node.getElementListByName("input", true);
                    for (TagNode input : inputList) {
                        String type = input.getAttributeByName("type");
                        String name = input.getAttributeByName("name");
                        String value = input.getAttributeByName("value");
                        if ("hidden".equalsIgnoreCase(type) && name != null && value != null) {
                            String decoded;
                            if ("wresult".equals(name)) {
                                decoded = value.replaceAll("&quot;", "\"").replaceAll("&lt;", "<");
                                logonMethod.setParameter(name, decoded);
                                logonMethod.setRequestHeader("Referer", this.url);
                            } else if ("wctx".equals(name)) {
                                decoded = value.replaceAll("&amp;", "&");
                                logonMethod.setParameter(name, decoded);
                            } else {
                                logonMethod.setParameter(name, value);
                            }
                        }
                        if (USER_NAME_FIELDS.contains(name) && !this.usernameInputs.contains(name)) {
                            this.usernameInputs.add(name);
                            continue;
                        }
                        if (PASSWORD_FIELDS.contains(name)) {
                            this.passwordInput = name;
                            continue;
                        }
                        if ("addr".equals(name)) {
                            logonMethod = this.buildLogonMethod(httpClient, httpClient.executeFollowRedirect(logonMethod));
                            continue;
                        }
                        if (TOKEN_FIELDS.contains(name)) {
                            logonMethod.setParameter(name, DavGatewayOTPPrompt.getOneTimePassword());
                            continue;
                        }
                        if (!"otc".equals(name)) continue;
                        String pinsafeUser = this.getAliasFromLogin();
                        if (pinsafeUser == null) {
                            pinsafeUser = this.username;
                        }
                        HttpGet pinRequest = new HttpGet("/PINsafeISAFilter.dll?username=" + pinsafeUser);
                        CloseableHttpResponse pinResponse = httpClient.execute((HttpRequestBase)pinRequest);
                        Throwable throwable = null;
                        try {
                            int status = pinResponse.getStatusLine().getStatusCode();
                            if (status != 200) {
                                throw HttpClientAdapter.buildHttpResponseException((HttpRequestBase)pinRequest, pinResponse.getStatusLine());
                            }
                            BufferedImage captchaImage = ImageIO.read(pinResponse.getEntity().getContent());
                            logonMethod.setParameter(name, DavGatewayOTPPrompt.getCaptchaValue(captchaImage));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (pinResponse == null) continue;
                            if (throwable != null) {
                                try {
                                    pinResponse.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            pinResponse.close();
                        }
                    }
                    break block38;
                }
                List frameList = node.getElementListByName("frame", true);
                if (frameList.size() == 1) {
                    String src = ((TagNode)frameList.get(0)).getAttributeByName("src");
                    if (src != null) {
                        LOGGER.debug((Object)"Frames detected in form page, try frame content");
                        logonMethod = this.buildLogonMethod(httpClient, httpClient.executeFollowRedirect(new GetRequest(src)));
                    }
                } else {
                    List scriptList = node.getElementListByName("script", true);
                    for (TagNode script : scriptList) {
                        List contents = script.getAllChildren();
                        for (Object content : contents) {
                            String location;
                            String scriptValue;
                            if (content instanceof CommentNode) {
                                scriptValue = ((CommentNode)content).getCommentedContent();
                                String sUrl = StringUtil.getToken(scriptValue, "var a_sUrl = \"", "\"");
                                String sLgn = StringUtil.getToken(scriptValue, "var a_sLgnQS = \"", "\"");
                                if (sLgn == null) {
                                    sLgn = StringUtil.getToken(scriptValue, "var a_sLgn = \"", "\"");
                                }
                                if (sUrl == null || sLgn == null) continue;
                                URI src = this.getScriptBasedFormURL(uri, sLgn + sUrl);
                                LOGGER.debug((Object)("Detected script based logon, redirect to form at " + src));
                                logonMethod = this.buildLogonMethod(httpClient, httpClient.executeFollowRedirect(new GetRequest(src)));
                                continue;
                            }
                            if (!(content instanceof ContentNode) || (location = StringUtil.getToken(scriptValue = ((ContentNode)content).getContent(), "window.location.replace(\"", "\"")) == null) continue;
                            LOGGER.debug((Object)("Post logon redirect to: " + location));
                            logonMethod = this.buildLogonMethod(httpClient, httpClient.executeFollowRedirect(new GetRequest(location)));
                        }
                    }
                }
            }
            catch (IOException | URISyntaxException e) {
                LOGGER.error((Object)("Error parsing login form at " + responseWrapper.getURI()));
            }
        }
        return logonMethod;
    }

    protected ResponseWrapper postLogonMethod(HttpClientAdapter httpClient, PostRequest logonMethod, String password) throws IOException {
        this.setAuthFormFields((HttpRequestBase)logonMethod, httpClient, password);
        BasicClientCookie pBackCookie = new BasicClientCookie("PBack", "0");
        pBackCookie.setPath("/");
        pBackCookie.setDomain(this.httpClientAdapter.getHost());
        httpClient.addCookie((Cookie)pBackCookie);
        ResponseWrapper resultRequest = httpClient.executeFollowRedirect(logonMethod);
        this.checkFormLoginQueryString(resultRequest);
        if (!this.isAuthenticated(resultRequest)) {
            logonMethod = this.buildLogonMethod(httpClient, resultRequest);
            if (logonMethod != null) {
                if (this.otpPreAuthFound && this.otpPreAuthRetries < 3) {
                    return this.postLogonMethod(httpClient, logonMethod, password);
                }
                resultRequest = httpClient.executeFollowRedirect(logonMethod);
                this.checkFormLoginQueryString(resultRequest);
                if (!this.isAuthenticated(resultRequest)) {
                    this.throwAuthenticationFailed();
                }
            } else {
                this.throwAuthenticationFailed();
            }
        }
        if ("/owa/languageselection.aspx".equals(resultRequest.getURI().getPath())) {
            resultRequest = this.submitLanguageSelectionForm(resultRequest.getURI(), resultRequest.getResponseBodyAsString());
        }
        return resultRequest;
    }

    protected ResponseWrapper submitLanguageSelectionForm(URI uri, String responseBodyAsString) throws IOException {
        PostRequest postLanguageFormMethod;
        HtmlCleaner cleaner = new HtmlCleaner();
        try {
            TagNode node = cleaner.clean(responseBodyAsString);
            List forms = node.getElementListByName("form", true);
            if (forms.size() != 1) {
                throw new IOException("Form not found");
            }
            TagNode languageForm = (TagNode)forms.get(0);
            String languageMethodPath = languageForm.getAttributeByName("action");
            postLanguageFormMethod = new PostRequest(this.getAbsoluteUri(uri, languageMethodPath));
            List inputList = languageForm.getElementListByName("input", true);
            for (TagNode input : inputList) {
                String name = input.getAttributeByName("name");
                String value = input.getAttributeByName("value");
                if (name == null || value == null) continue;
                postLanguageFormMethod.setParameter(name, value);
            }
            List selectList = languageForm.getElementListByName("select", true);
            for (TagNode select : selectList) {
                String name = select.getAttributeByName("name");
                List optionList = select.getElementListByName("option", true);
                String value = null;
                for (TagNode option : optionList) {
                    if (option.getAttributeByName("selected") == null) continue;
                    value = option.getAttributeByName("value");
                    break;
                }
                if (name == null || value == null) continue;
                postLanguageFormMethod.setParameter(name, value);
            }
        }
        catch (IOException | URISyntaxException e) {
            String errorMessage = "Error parsing language selection form at " + uri;
            LOGGER.error((Object)errorMessage);
            throw new IOException(errorMessage);
        }
        return this.httpClientAdapter.executeFollowRedirect(postLanguageFormMethod);
    }

    protected void setAuthFormFields(HttpRequestBase logonMethod, HttpClientAdapter httpClient, String password) throws IllegalArgumentException {
        String usernameInput;
        if (this.usernameInputs.size() == 2) {
            String userid;
            int pipeIndex = this.username.indexOf(124);
            if (pipeIndex < 0) {
                LOGGER.debug((Object)"Multiple user fields detected, please use userid|username as user name in client, except when userid is username");
                userid = this.username;
            } else {
                userid = this.username.substring(0, pipeIndex);
                this.username = this.username.substring(pipeIndex + 1);
                httpClient.setCredentials(this.username, password);
            }
            ((PostRequest)logonMethod).removeParameter("userid");
            ((PostRequest)logonMethod).setParameter("userid", userid);
            usernameInput = "username";
        } else {
            usernameInput = this.usernameInputs.size() == 1 ? this.usernameInputs.get(0) : "username";
        }
        ((PostRequest)logonMethod).removeParameter(usernameInput);
        if (this.passwordInput != null) {
            ((PostRequest)logonMethod).removeParameter(this.passwordInput);
        }
        ((PostRequest)logonMethod).removeParameter("trusted");
        ((PostRequest)logonMethod).removeParameter("flags");
        if (this.passwordInput == null) {
            this.otpPreAuthFound = true;
            ++this.otpPreAuthRetries;
            ((PostRequest)logonMethod).setParameter(usernameInput, this.preAuthusername);
        } else {
            this.otpPreAuthFound = false;
            this.otpPreAuthRetries = 0;
            ((PostRequest)logonMethod).setParameter(usernameInput, this.username);
            ((PostRequest)logonMethod).setParameter(this.passwordInput, password);
            ((PostRequest)logonMethod).setParameter("trusted", "4");
            ((PostRequest)logonMethod).setParameter("flags", "4");
        }
    }

    protected URI getAbsoluteUri(URI uri, String path) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(uri);
        if (path != null) {
            uriBuilder.clearParameters();
            if (path.startsWith("/")) {
                uriBuilder.setPath(path);
            } else {
                if (path.startsWith("http://") || path.startsWith("https://")) {
                    return URI.create(path);
                }
                String currentPath = uri.getPath();
                int end = currentPath.lastIndexOf(47);
                if (end >= 0) {
                    uriBuilder.setPath(currentPath.substring(0, end + 1) + path);
                } else {
                    throw new URISyntaxException(uriBuilder.build().toString(), "Invalid path");
                }
            }
        }
        return uriBuilder.build();
    }

    protected URI getScriptBasedFormURL(URI uri, String pathQuery) throws URISyntaxException, IOException {
        URIBuilder uriBuilder = new URIBuilder(uri);
        int queryIndex = pathQuery.indexOf(63);
        if (queryIndex >= 0) {
            if (queryIndex > 0) {
                String newPath = pathQuery.substring(0, queryIndex);
                if (newPath.startsWith("/")) {
                    uriBuilder.setPath(newPath);
                } else {
                    String currentPath = uriBuilder.getPath();
                    int folderIndex = currentPath.lastIndexOf(47);
                    if (folderIndex >= 0) {
                        uriBuilder.setPath(currentPath.substring(0, folderIndex + 1) + newPath);
                    } else {
                        uriBuilder.setPath('/' + newPath);
                    }
                }
            }
            uriBuilder.setCustomQuery(URIUtil.decode(pathQuery.substring(queryIndex + 1)));
        }
        return uriBuilder.build();
    }

    protected void checkFormLoginQueryString(ResponseWrapper logonMethod) throws DavMailAuthenticationException {
        String queryString = logonMethod.getURI().getRawQuery();
        if (queryString != null && (queryString.contains("reason=2") || queryString.contains("reason=4"))) {
            this.throwAuthenticationFailed();
        }
    }

    protected void throwAuthenticationFailed() throws DavMailAuthenticationException {
        if (this.username != null && this.username.contains("\\")) {
            throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED");
        }
        throw new DavMailAuthenticationException("EXCEPTION_AUTHENTICATION_FAILED_RETRY");
    }

    public String getAliasFromLogin() {
        if (this.username.indexOf(64) >= 0) {
            return null;
        }
        String result = this.username;
        int index = Math.max(result.indexOf(92), result.indexOf(47));
        if (index >= 0) {
            result = result.substring(index + 1);
        }
        return result;
    }

    public void close() {
        this.httpClientAdapter.close();
    }

    @Override
    public O365Token getToken() {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI getExchangeUri() {
        return this.exchangeUri;
    }

    @Override
    public HttpClientAdapter getHttpClientAdapter() {
        return this.httpClientAdapter;
    }

    public String getUsername() {
        return this.username;
    }

    static {
        USER_NAME_FIELDS.add("username");
        USER_NAME_FIELDS.add("txtusername");
        USER_NAME_FIELDS.add("userid");
        USER_NAME_FIELDS.add("SafeWordUser");
        USER_NAME_FIELDS.add("user_name");
        USER_NAME_FIELDS.add("login");
        USER_NAME_FIELDS.add("UserName");
        PASSWORD_FIELDS = new HashSet<String>();
        PASSWORD_FIELDS.add("password");
        PASSWORD_FIELDS.add("txtUserPass");
        PASSWORD_FIELDS.add("pw");
        PASSWORD_FIELDS.add("basicPassword");
        PASSWORD_FIELDS.add("passwd");
        PASSWORD_FIELDS.add("Password");
        TOKEN_FIELDS = new HashSet<String>();
        TOKEN_FIELDS.add("SafeWordPassword");
        TOKEN_FIELDS.add("passcode");
    }
}

