/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange;

import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ICSCalendarValidator {
    protected static final Logger LOGGER = Logger.getLogger(ICSCalendarValidator.class);
    private static final Pattern VALID_CHARS_PATTERN = Pattern.compile("^[\r\n\t\\x20-\\x7E\u0080-\uffff]*$");
    private static final char NULL_BYTE = '\u0000';
    private static final char SPACE = ' ';
    private static final char DELETE = '\u007f';

    public static boolean isValidICSContent(String content) {
        return content != null && VALID_CHARS_PATTERN.matcher(content).matches();
    }

    public static ValidationResult validateWithDetails(String content) {
        if (content == null) {
            return new ValidationResult(false, "Content is null");
        }
        StringBuilder issues = new StringBuilder();
        int nullByteCount = 0;
        StringBuilder invalidChars = new StringBuilder();
        for (char c : content.toCharArray()) {
            if (c == '\u0000') {
                ++nullByteCount;
                continue;
            }
            if ((c >= ' ' || c == '\r' || c == '\n' || c == '\t') && c != '\u007f' && (c < '\u0080' || c > '\u009f')) continue;
            invalidChars.append(String.format("\\u%04x,", c));
        }
        if (nullByteCount > 0) {
            issues.append(nullByteCount).append(" null byte(s) found");
        }
        if (invalidChars.length() > 0) {
            if (issues.length() > 0) {
                issues.append(", ");
            }
            issues.append("Invalid character(s): ").append(invalidChars.substring(0, invalidChars.length() - 1));
        }
        return new ValidationResult(issues.length() == 0, issues.toString());
    }

    public static String repairICSContent(String content) {
        if (content == null) {
            return null;
        }
        String message = "ICSCalendarValidator repair characters in ICS content:";
        StringBuilder repaired = new StringBuilder();
        boolean lastWasInvalid = false;
        for (char c : content.toCharArray()) {
            if (ICSCalendarValidator.isValidChar(c)) {
                repaired.append(c);
                lastWasInvalid = false;
                continue;
            }
            if (lastWasInvalid) continue;
            repaired.append(' ');
            lastWasInvalid = true;
        }
        String fixed = repaired.toString().trim();
        if (!content.equals(fixed)) {
            LOGGER.debug((Object)(message + "\n[" + content + "]\n => [" + fixed + "]\n fix complete."));
        }
        return fixed;
    }

    static boolean isValidChar(char c) {
        return c > '\u0000' && c != '\u007f' && (c < '\u0080' || c > '\u009f');
    }

    public static class ValidationResult {
        private final boolean isValid;
        private final String reason;

        public ValidationResult(boolean isValid, String reason) {
            this.isValid = isValid;
            this.reason = reason;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public String showReason() {
            return this.reason;
        }
    }
}

