/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange;

import davmail.BundleMessage;
import davmail.Settings;
import davmail.exception.DavMailException;
import davmail.exception.HttpNotFoundException;
import davmail.exchange.ICSBufferedReader;
import davmail.exchange.ICSCalendarValidator;
import davmail.exchange.MimeOutputStreamWriter;
import davmail.exchange.VCalendar;
import davmail.exchange.VCardWriter;
import davmail.exchange.VObject;
import davmail.exchange.VProperty;
import davmail.http.URIUtil;
import davmail.ui.NotificationDialog;
import davmail.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.NoRouteToHostException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.log4j.Logger;

public abstract class ExchangeSession {
    protected static final Logger LOGGER = Logger.getLogger((String)"davmail.exchange.ExchangeSession");
    public static final SimpleTimeZone GMT_TIMEZONE = new SimpleTimeZone(0, "GMT");
    protected static final int FREE_BUSY_INTERVAL = 15;
    protected static final String PUBLIC_ROOT = "/public/";
    protected static final String CALENDAR = "calendar";
    protected static final String TASKS = "tasks";
    public static final String CONTACTS = "contacts";
    protected static final String ADDRESSBOOK = "addressbook";
    protected static final String ARCHIVE = "Archive";
    protected static final String INBOX = "INBOX";
    protected static final String LOWER_CASE_INBOX = "inbox";
    protected static final String MIXED_CASE_INBOX = "Inbox";
    protected static final String SENT = "Sent";
    protected static final String SENDMSG = "##DavMailSubmissionURI##";
    protected static final String DRAFTS = "Drafts";
    protected static final String TRASH = "Trash";
    protected static final String JUNK = "Junk";
    protected static final String UNSENT = "Unsent Messages";
    protected static final List<String> SPECIAL = Arrays.asList("Sent", "Drafts", "Trash", "Junk");
    protected String publicFolderUrl;
    protected String mailPath;
    protected String rootPath;
    protected String email;
    protected String alias;
    protected String currentMailboxPath;
    protected String userName;
    protected String serverVersion;
    protected static final String YYYY_MM_DD_HH_MM_SS = "yyyy/MM/dd HH:mm:ss";
    private static final String YYYYMMDD_T_HHMMSS_Z = "yyyyMMdd'T'HHmmss'Z'";
    protected static final String YYYY_MM_DD_T_HHMMSS_Z = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String YYYY_MM_DD_T_HHMMSS_SSS_Z = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    protected static final Set<String> POP_MESSAGE_ATTRIBUTES;
    protected static final Set<String> IMAP_MESSAGE_ATTRIBUTES;
    protected static final Set<String> UID_MESSAGE_ATTRIBUTES;
    protected String lastSentMessageId;
    static final String[] RECIPIENT_HEADERS;
    private static int dumpIndex;
    static final String[] VCARD_N_PROPERTIES;
    static final String[] VCARD_ADR_HOME_PROPERTIES;
    static final String[] VCARD_ADR_WORK_PROPERTIES;
    static final String[] VCARD_ADR_OTHER_PROPERTIES;
    static final String[] VCARD_ORG_PROPERTIES;
    protected static final String MAILBOX_BASE = "/cn=";
    public static final Set<String> CONTACT_ATTRIBUTES;
    protected static final Set<String> DISTRIBUTION_LIST_ATTRIBUTES;
    protected VObject vTimezone;
    public static final Map<String, String> vTodoToTaskStatusMap;
    public static final Map<String, String> taskTovTodoStatusMap;
    protected static final Map<String, String> importanceToPriorityMap;
    protected static final Map<String, String> priorityToImportanceMap;

    public abstract void close();

    public abstract String formatSearchDate(Date var1);

    public static SimpleDateFormat getZuluDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(YYYYMMDD_T_HHMMSS_Z, Locale.ENGLISH);
        dateFormat.setTimeZone(GMT_TIMEZONE);
        return dateFormat;
    }

    protected static SimpleDateFormat getVcardBdayFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD, Locale.ENGLISH);
        dateFormat.setTimeZone(GMT_TIMEZONE);
        return dateFormat;
    }

    protected static SimpleDateFormat getExchangeDateFormat(String value) {
        SimpleDateFormat dateFormat;
        if (value.length() == 8) {
            dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
            dateFormat.setTimeZone(GMT_TIMEZONE);
        } else if (value.length() == 15) {
            dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.ENGLISH);
            dateFormat.setTimeZone(GMT_TIMEZONE);
        } else if (value.length() == 16) {
            dateFormat = new SimpleDateFormat(YYYYMMDD_T_HHMMSS_Z, Locale.ENGLISH);
            dateFormat.setTimeZone(GMT_TIMEZONE);
        } else {
            dateFormat = ExchangeSession.getExchangeZuluDateFormat();
        }
        return dateFormat;
    }

    protected static SimpleDateFormat getExchangeZuluDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD_T_HHMMSS_Z, Locale.ENGLISH);
        dateFormat.setTimeZone(GMT_TIMEZONE);
        return dateFormat;
    }

    protected static SimpleDateFormat getExchangeZuluDateFormatMillisecond() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD_T_HHMMSS_SSS_Z, Locale.ENGLISH);
        dateFormat.setTimeZone(GMT_TIMEZONE);
        return dateFormat;
    }

    protected static Date parseDate(String dateString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        dateFormat.setTimeZone(GMT_TIMEZONE);
        return dateFormat.parse(dateString);
    }

    public boolean isExpired() throws NoRouteToHostException, UnknownHostException {
        boolean isExpired = false;
        try {
            this.getFolder("");
        }
        catch (NoRouteToHostException | UnknownHostException exc) {
            throw exc;
        }
        catch (IOException e) {
            isExpired = true;
        }
        return isExpired;
    }

    protected abstract void buildSessionInfo(URI var1) throws IOException;

    public abstract Message createMessage(String var1, String var2, HashMap<String, String> var3, MimeMessage var4) throws IOException;

    public abstract void updateMessage(Message var1, Map<String, String> var2) throws IOException;

    public abstract void deleteMessage(Message var1) throws IOException;

    protected abstract byte[] getContent(Message var1) throws IOException;

    public MessageList getAllMessageUidAndSize(String folderName) throws IOException {
        return this.searchMessages(folderName, POP_MESSAGE_ATTRIBUTES, null);
    }

    public MessageList searchMessages(String folderPath) throws IOException {
        return this.searchMessages(folderPath, IMAP_MESSAGE_ATTRIBUTES, null);
    }

    public MessageList searchMessages(String folderName, Condition condition) throws IOException {
        return this.searchMessages(folderName, IMAP_MESSAGE_ATTRIBUTES, condition);
    }

    public abstract MessageList searchMessages(String var1, Set<String> var2, Condition var3) throws IOException;

    public String getServerVersion() {
        return this.serverVersion;
    }

    public abstract MultiCondition and(Condition ... var1);

    public abstract MultiCondition or(Condition ... var1);

    public abstract Condition not(Condition var1);

    public abstract Condition isEqualTo(String var1, String var2);

    public abstract Condition isEqualTo(String var1, int var2);

    public abstract Condition headerIsEqualTo(String var1, String var2);

    public abstract Condition gte(String var1, String var2);

    public abstract Condition gt(String var1, String var2);

    public abstract Condition lt(String var1, String var2);

    public abstract Condition lte(String var1, String var2);

    public abstract Condition contains(String var1, String var2);

    public abstract Condition startsWith(String var1, String var2);

    public abstract Condition isNull(String var1);

    public abstract Condition exists(String var1);

    public abstract Condition isTrue(String var1);

    public abstract Condition isFalse(String var1);

    public List<Folder> getSubFolders(String folderName, boolean recursive, boolean wildcard) throws IOException {
        MultiCondition folderCondition = this.and(new Condition[0]);
        if (!Settings.getBooleanProperty("davmail.imapIncludeSpecialFolders", false)) {
            folderCondition.add(this.or(this.isEqualTo("folderclass", "IPF.Note"), this.isEqualTo("folderclass", "IPF.Note.Microsoft.Conversation"), this.isNull("folderclass")));
        }
        if (wildcard) {
            folderCondition.add(this.startsWith("displayname", folderName));
            folderName = "";
        }
        List<Folder> results = this.getSubFolders(folderName, folderCondition, recursive);
        if (recursive && !folderName.isEmpty()) {
            results.add(this.getFolder(folderName));
        }
        return results;
    }

    public List<Folder> getSubCalendarFolders(String folderName, boolean recursive) throws IOException {
        return this.getSubFolders(folderName, this.isEqualTo("folderclass", "IPF.Appointment"), recursive);
    }

    public abstract List<Folder> getSubFolders(String var1, Condition var2, boolean var3) throws IOException;

    public void purgeOldestTrashAndSentMessages() throws IOException {
        int sentKeepDelay;
        int keepDelay = Settings.getIntProperty("davmail.keepDelay");
        if (keepDelay != 0) {
            this.purgeOldestFolderMessages(TRASH, keepDelay);
        }
        if ((sentKeepDelay = Settings.getIntProperty("davmail.sentKeepDelay")) != 0) {
            this.purgeOldestFolderMessages(SENT, sentKeepDelay);
        }
    }

    protected void purgeOldestFolderMessages(String folderPath, int keepDelay) throws IOException {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -keepDelay);
        LOGGER.debug((Object)("Delete messages in " + folderPath + " not modified since " + cal.getTime()));
        MessageList messages = this.searchMessages(folderPath, UID_MESSAGE_ATTRIBUTES, this.lt("lastmodified", this.formatSearchDate(cal.getTime())));
        for (Message message : messages) {
            message.delete();
        }
    }

    protected void convertResentHeader(MimeMessage mimeMessage, String headerName) throws MessagingException {
        String[] resentHeader = mimeMessage.getHeader("Resent-" + headerName);
        if (resentHeader != null) {
            mimeMessage.removeHeader("Resent-" + headerName);
            mimeMessage.removeHeader(headerName);
            for (String value : resentHeader) {
                mimeMessage.addHeader(headerName, value);
            }
        }
    }

    public void sendMessage(List<String> rcptToRecipients, MimeMessage mimeMessage) throws IOException, MessagingException {
        String messageId = mimeMessage.getMessageID();
        if (this.lastSentMessageId != null && this.lastSentMessageId.equals(messageId)) {
            LOGGER.debug((Object)("Dropping message id " + messageId + ": already sent"));
            return;
        }
        this.lastSentMessageId = messageId;
        this.convertResentHeader(mimeMessage, "From");
        this.convertResentHeader(mimeMessage, "To");
        this.convertResentHeader(mimeMessage, "Cc");
        this.convertResentHeader(mimeMessage, "Bcc");
        this.convertResentHeader(mimeMessage, "Message-Id");
        if ("Exchange2003".equals(this.serverVersion) || Settings.getBooleanProperty("davmail.smtpStripFrom", false)) {
            mimeMessage.removeHeader("From");
        }
        HashSet<String> visibleRecipients = new HashSet<String>();
        List<InternetAddress> recipients = this.getAllRecipients(mimeMessage);
        for (InternetAddress address : recipients) {
            visibleRecipients.add(address.getAddress().toLowerCase());
        }
        for (String recipient : rcptToRecipients) {
            if (visibleRecipients.contains(recipient.toLowerCase())) continue;
            mimeMessage.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(recipient));
        }
        this.sendMessage(mimeMessage);
    }

    protected List<InternetAddress> getAllRecipients(MimeMessage mimeMessage) throws MessagingException {
        ArrayList<InternetAddress> recipientList = new ArrayList<InternetAddress>();
        for (String recipientHeader : RECIPIENT_HEADERS) {
            String recipientHeaderValue = mimeMessage.getHeader(recipientHeader, ",");
            if (recipientHeaderValue == null) continue;
            recipientList.addAll(Arrays.asList(InternetAddress.parseHeader((String)recipientHeaderValue, (boolean)false)));
        }
        return recipientList;
    }

    public abstract void sendMessage(MimeMessage var1) throws IOException, MessagingException;

    public Folder getFolder(String folderPath) throws IOException {
        Folder folder = this.internalGetFolder(folderPath);
        if (this.isMainCalendar(folderPath)) {
            Folder taskFolder = this.internalGetFolder(TASKS);
            folder.ctag = folder.ctag + taskFolder.ctag;
        }
        return folder;
    }

    protected abstract Folder internalGetFolder(String var1) throws IOException;

    public boolean refreshFolder(Folder currentFolder) throws IOException {
        Folder newFolder = this.getFolder(currentFolder.folderPath);
        if (currentFolder.ctag == null || !currentFolder.ctag.equals(newFolder.ctag) || currentFolder.messageCount != newFolder.messageCount) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Contenttag or count changed on " + currentFolder.folderPath + " ctag: " + currentFolder.ctag + " => " + newFolder.ctag + " count: " + currentFolder.messageCount + " => " + newFolder.messageCount + ", reloading messages"));
            }
            currentFolder.hasChildren = newFolder.hasChildren;
            currentFolder.noInferiors = newFolder.noInferiors;
            currentFolder.unreadCount = newFolder.unreadCount;
            currentFolder.ctag = newFolder.ctag;
            currentFolder.etag = newFolder.etag;
            if (newFolder.uidNext > currentFolder.uidNext) {
                currentFolder.uidNext = newFolder.uidNext;
            }
            currentFolder.loadMessages();
            return true;
        }
        return false;
    }

    public void createMessageFolder(String folderName) throws IOException {
        this.createFolder(folderName, "IPF.Note", null);
    }

    public int createCalendarFolder(String folderName, Map<String, String> properties) throws IOException {
        return this.createFolder(folderName, "IPF.Appointment", properties);
    }

    public void createContactFolder(String folderName, Map<String, String> properties) throws IOException {
        this.createFolder(folderName, "IPF.Contact", properties);
    }

    public abstract int createFolder(String var1, String var2, Map<String, String> var3) throws IOException;

    public abstract int updateFolder(String var1, Map<String, String> var2) throws IOException;

    public abstract void deleteFolder(String var1) throws IOException;

    public abstract void copyMessage(Message var1, String var2) throws IOException;

    public void copyMessages(List<Message> messages, String targetFolder) throws IOException {
        for (Message message : messages) {
            this.copyMessage(message, targetFolder);
        }
    }

    public abstract void moveMessage(Message var1, String var2) throws IOException;

    public void moveMessages(List<Message> messages, String targetFolder) throws IOException {
        for (Message message : messages) {
            this.moveMessage(message, targetFolder);
        }
    }

    public abstract void moveFolder(String var1, String var2) throws IOException;

    public abstract void moveItem(String var1, String var2) throws IOException;

    protected abstract void moveToTrash(Message var1) throws IOException;

    public String convertKeywordToFlag(String value) {
        Properties flagSettings = Settings.getSubProperties("davmail.imapFlags");
        Enumeration<?> flagSettingsEnum = flagSettings.propertyNames();
        while (flagSettingsEnum.hasMoreElements()) {
            String key = (String)flagSettingsEnum.nextElement();
            if (!value.equalsIgnoreCase(flagSettings.getProperty(key))) continue;
            return key;
        }
        ResourceBundle flagBundle = ResourceBundle.getBundle("imapflags");
        Enumeration<String> flagBundleEnum = flagBundle.getKeys();
        while (flagBundleEnum.hasMoreElements()) {
            String key = flagBundleEnum.nextElement();
            if (!value.equalsIgnoreCase(flagBundle.getString(key))) continue;
            return key;
        }
        return value;
    }

    public String convertFlagToKeyword(String value) {
        Properties flagSettings = Settings.getSubProperties("davmail.imapFlags");
        for (String key : flagSettings.stringPropertyNames()) {
            if (!key.equalsIgnoreCase(value)) continue;
            return flagSettings.getProperty(key);
        }
        ResourceBundle flagBundle = ResourceBundle.getBundle("imapflags");
        for (String key : flagBundle.keySet()) {
            if (!key.equalsIgnoreCase(value)) continue;
            return flagBundle.getString(key);
        }
        return value;
    }

    public String convertFlagsToKeywords(HashSet<String> flags) {
        HashSet<String> keywordSet = new HashSet<String>();
        for (String flag : flags) {
            keywordSet.add(this.decodeKeyword(this.convertFlagToKeyword(flag)));
        }
        return StringUtil.join(keywordSet, ",");
    }

    protected String decodeKeyword(String keyword) {
        String result = keyword;
        if (keyword.contains("_x0028_") || keyword.contains("_x0029_")) {
            result = result.replaceAll("_x0028_", "(").replaceAll("_x0029_", ")");
        }
        return result;
    }

    protected String encodeKeyword(String keyword) {
        String result = keyword;
        if (keyword.indexOf(40) >= 0 || keyword.indexOf(41) >= 0) {
            result = result.replaceAll("\\(", "_x0028_").replaceAll("\\)", "_x0029_");
        }
        return result;
    }

    protected abstract Set<String> getItemProperties();

    public List<Contact> getAllContacts(String folderPath, boolean includeDistList) throws IOException {
        return this.searchContacts(folderPath, CONTACT_ATTRIBUTES, this.isEqualTo("outlookmessageclass", "IPM.Contact"), 0);
    }

    public abstract List<Contact> searchContacts(String var1, Set<String> var2, Condition var3, int var4) throws IOException;

    public abstract List<Event> getEventMessages(String var1) throws IOException;

    public List<Event> getAllEvents(String folderPath) throws IOException {
        List<Event> results = this.searchEvents(folderPath, this.getCalendarItemCondition(this.getPastDelayCondition("dtstart")));
        if (!Settings.getBooleanProperty("davmail.caldavDisableTasks", false) && this.isMainCalendar(folderPath)) {
            results.addAll(this.searchTasksOnly(TASKS));
        }
        return results;
    }

    protected abstract Condition getCalendarItemCondition(Condition var1);

    protected Condition getPastDelayCondition(String attribute) {
        int caldavPastDelay = Settings.getIntProperty("davmail.caldavPastDelay");
        Condition dateCondition = null;
        if (caldavPastDelay != 0) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -caldavPastDelay);
            dateCondition = this.gt(attribute, this.formatSearchDate(cal.getTime()));
        }
        return dateCondition;
    }

    protected Condition getRangeCondition(String timeRangeStart, String timeRangeEnd) throws IOException {
        try {
            SimpleDateFormat parser = ExchangeSession.getZuluDateFormat();
            MultiCondition andCondition = this.and(new Condition[0]);
            if (timeRangeStart != null) {
                andCondition.add(this.gt("dtend", this.formatSearchDate(parser.parse(timeRangeStart))));
            }
            if (timeRangeEnd != null) {
                andCondition.add(this.lt("dtstart", this.formatSearchDate(parser.parse(timeRangeEnd))));
            }
            return andCondition;
        }
        catch (ParseException e) {
            throw new IOException(e + " " + e.getMessage());
        }
    }

    public List<Event> searchEvents(String folderPath, String timeRangeStart, String timeRangeEnd) throws IOException {
        Condition dateCondition = this.getRangeCondition(timeRangeStart, timeRangeEnd);
        Condition condition = this.getCalendarItemCondition(dateCondition);
        return this.searchEvents(folderPath, condition);
    }

    public List<Event> searchEventsOnly(String folderPath, String timeRangeStart, String timeRangeEnd) throws IOException {
        Condition dateCondition = this.getRangeCondition(timeRangeStart, timeRangeEnd);
        return this.searchEvents(folderPath, this.getCalendarItemCondition(dateCondition));
    }

    public List<Event> searchTasksOnly(String folderPath) throws IOException {
        return this.searchEvents(folderPath, this.and(this.isEqualTo("outlookmessageclass", "IPM.Task"), this.or(this.isNull("datecompleted"), this.getPastDelayCondition("datecompleted"))));
    }

    public List<Event> searchEvents(String folderPath, Condition filter) throws IOException {
        Condition privateCondition = null;
        if (this.isSharedFolder(folderPath) && Settings.getBooleanProperty("davmail.excludePrivateEvents", true)) {
            LOGGER.debug((Object)"Shared or public calendar: exclude private events");
            privateCondition = this.isEqualTo("sensitivity", 0);
        }
        return this.searchEvents(folderPath, this.getItemProperties(), this.and(filter, privateCondition));
    }

    public abstract List<Event> searchEvents(String var1, Set<String> var2, Condition var3) throws IOException;

    protected String convertItemNameToEML(String itemName) {
        if (itemName.endsWith(".vcf")) {
            return itemName.substring(0, itemName.length() - 3) + "EML";
        }
        return itemName;
    }

    public abstract Item getItem(String var1, String var2) throws IOException;

    public abstract ContactPhoto getContactPhoto(Contact var1) throws IOException;

    public ContactPhoto getADPhoto(String email) {
        return null;
    }

    public abstract void deleteItem(String var1, String var2) throws IOException;

    public abstract void processItem(String var1, String var2) throws IOException;

    protected String replaceIcal4Principal(String value) {
        if (value != null && value.contains("/principals/__uuids__/")) {
            return value.replaceAll("/principals/__uuids__/([^/]*)__AT__([^/]*)/", "mailto:$1@$2");
        }
        return value;
    }

    public abstract int sendEvent(String var1) throws IOException;

    public ItemResult createOrUpdateItem(String folderPath, String itemName, String itemBody, String etag, String noneMatch) throws IOException {
        if (itemBody.startsWith("BEGIN:VCALENDAR")) {
            return this.internalCreateOrUpdateEvent(folderPath, itemName, "urn:content-classes:appointment", itemBody, etag, noneMatch);
        }
        if (itemBody.startsWith("BEGIN:VCARD")) {
            return this.createOrUpdateContact(folderPath, itemName, itemBody, etag, noneMatch);
        }
        throw new IOException(BundleMessage.format("EXCEPTION_INVALID_MESSAGE_CONTENT", itemBody));
    }

    protected void convertContactProperties(Map<String, String> properties, String[] contactProperties, List<String> values) {
        for (int i = 0; i < values.size() && i < contactProperties.length; ++i) {
            if (contactProperties[i] == null) continue;
            properties.put(contactProperties[i], values.get(i));
        }
    }

    protected ItemResult createOrUpdateContact(String folderPath, String itemName, String itemBody, String etag, String noneMatch) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        VObject vcard = new VObject(new ICSBufferedReader(new StringReader(itemBody)));
        if ("group".equalsIgnoreCase(vcard.getPropertyValue("KIND"))) {
            properties.put("outlookmessageclass", "IPM.DistList");
            properties.put("displayname", vcard.getPropertyValue("FN"));
        } else {
            properties.put("outlookmessageclass", "IPM.Contact");
            for (VProperty property : vcard.getProperties()) {
                if ("FN".equals(property.getKey())) {
                    properties.put("cn", property.getValue());
                    properties.put("subject", property.getValue());
                    properties.put("fileas", property.getValue());
                    continue;
                }
                if ("N".equals(property.getKey())) {
                    this.convertContactProperties(properties, VCARD_N_PROPERTIES, property.getValues());
                    continue;
                }
                if ("NICKNAME".equals(property.getKey())) {
                    properties.put("nickname", property.getValue());
                    continue;
                }
                if ("TEL".equals(property.getKey())) {
                    if (property.hasParam("TYPE", "cell") || property.hasParam("X-GROUP", "cell")) {
                        properties.put("mobile", property.getValue());
                        continue;
                    }
                    if (property.hasParam("TYPE", "work") || property.hasParam("X-GROUP", "work")) {
                        properties.put("telephoneNumber", property.getValue());
                        continue;
                    }
                    if (property.hasParam("TYPE", "home") || property.hasParam("X-GROUP", "home")) {
                        properties.put("homePhone", property.getValue());
                        continue;
                    }
                    if (property.hasParam("TYPE", "fax")) {
                        if (property.hasParam("TYPE", "home")) {
                            properties.put("homefax", property.getValue());
                            continue;
                        }
                        properties.put("facsimiletelephonenumber", property.getValue());
                        continue;
                    }
                    if (property.hasParam("TYPE", "pager")) {
                        properties.put("pager", property.getValue());
                        continue;
                    }
                    if (property.hasParam("TYPE", "car")) {
                        properties.put("othermobile", property.getValue());
                        continue;
                    }
                    properties.put("otherTelephone", property.getValue());
                    continue;
                }
                if ("ADR".equals(property.getKey())) {
                    if (property.hasParam("TYPE", "home")) {
                        this.convertContactProperties(properties, VCARD_ADR_HOME_PROPERTIES, property.getValues());
                        continue;
                    }
                    if (property.hasParam("TYPE", "work")) {
                        this.convertContactProperties(properties, VCARD_ADR_WORK_PROPERTIES, property.getValues());
                        continue;
                    }
                    this.convertContactProperties(properties, VCARD_ADR_OTHER_PROPERTIES, property.getValues());
                    continue;
                }
                if ("EMAIL".equals(property.getKey())) {
                    if (property.hasParam("TYPE", "home")) {
                        properties.put("email2", property.getValue());
                        properties.put("smtpemail2", property.getValue());
                        continue;
                    }
                    if (property.hasParam("TYPE", "other")) {
                        properties.put("email3", property.getValue());
                        properties.put("smtpemail3", property.getValue());
                        continue;
                    }
                    properties.put("email1", property.getValue());
                    properties.put("smtpemail1", property.getValue());
                    continue;
                }
                if ("ORG".equals(property.getKey())) {
                    this.convertContactProperties(properties, VCARD_ORG_PROPERTIES, property.getValues());
                    continue;
                }
                if ("URL".equals(property.getKey())) {
                    if (property.hasParam("TYPE", "work")) {
                        properties.put("businesshomepage", property.getValue());
                        continue;
                    }
                    if (property.hasParam("TYPE", "home")) {
                        properties.put("personalHomePage", property.getValue());
                        continue;
                    }
                    properties.put("personalHomePage", property.getValue());
                    continue;
                }
                if ("TITLE".equals(property.getKey())) {
                    properties.put("title", property.getValue());
                    continue;
                }
                if ("NOTE".equals(property.getKey())) {
                    properties.put("description", property.getValue());
                    continue;
                }
                if ("CUSTOM1".equals(property.getKey())) {
                    properties.put("extensionattribute1", property.getValue());
                    continue;
                }
                if ("CUSTOM2".equals(property.getKey())) {
                    properties.put("extensionattribute2", property.getValue());
                    continue;
                }
                if ("CUSTOM3".equals(property.getKey())) {
                    properties.put("extensionattribute3", property.getValue());
                    continue;
                }
                if ("CUSTOM4".equals(property.getKey())) {
                    properties.put("extensionattribute4", property.getValue());
                    continue;
                }
                if ("ROLE".equals(property.getKey())) {
                    properties.put("profession", property.getValue());
                    continue;
                }
                if ("X-AIM".equals(property.getKey())) {
                    properties.put("im", property.getValue());
                    continue;
                }
                if ("BDAY".equals(property.getKey())) {
                    properties.put("bday", this.convertBDayToZulu(property.getValue()));
                    continue;
                }
                if ("ANNIVERSARY".equals(property.getKey()) || "X-ANNIVERSARY".equals(property.getKey())) {
                    properties.put("anniversary", this.convertBDayToZulu(property.getValue()));
                    continue;
                }
                if ("CATEGORIES".equals(property.getKey())) {
                    properties.put("keywords", property.getValue());
                    continue;
                }
                if ("CLASS".equals(property.getKey())) {
                    if ("PUBLIC".equals(property.getValue())) {
                        properties.put("sensitivity", "0");
                        properties.put("private", "false");
                        continue;
                    }
                    properties.put("sensitivity", "2");
                    properties.put("private", "true");
                    continue;
                }
                if ("SEX".equals(property.getKey())) {
                    String propertyValue = property.getValue();
                    if ("1".equals(propertyValue)) {
                        properties.put("gender", "2");
                        continue;
                    }
                    if (!"2".equals(propertyValue)) continue;
                    properties.put("gender", "1");
                    continue;
                }
                if ("FBURL".equals(property.getKey())) {
                    properties.put("fburl", property.getValue());
                    continue;
                }
                if ("X-ASSISTANT".equals(property.getKey())) {
                    properties.put("secretarycn", property.getValue());
                    continue;
                }
                if ("X-MANAGER".equals(property.getKey())) {
                    properties.put("manager", property.getValue());
                    continue;
                }
                if ("X-SPOUSE".equals(property.getKey())) {
                    properties.put("spousecn", property.getValue());
                    continue;
                }
                if ("PHOTO".equals(property.getKey())) {
                    properties.put("photo", property.getValue());
                    properties.put("haspicture", "true");
                    continue;
                }
                if ("KEY1".equals(property.getKey())) {
                    properties.put("msexchangecertificate", property.getValue());
                    continue;
                }
                if (!"KEY2".equals(property.getKey())) continue;
                properties.put("usersmimecertificate", property.getValue());
            }
            LOGGER.debug((Object)("Create or update contact " + itemName + ": " + properties));
            for (String key : CONTACT_ATTRIBUTES) {
                if ("imapUid".equals(key) || "etag".equals(key) || "urlcompname".equals(key) || "lastmodified".equals(key) || "sensitivity".equals(key) || properties.containsKey(key)) continue;
                properties.put(key, null);
            }
        }
        Contact contact = this.buildContact(folderPath, itemName, properties, etag, noneMatch);
        for (VProperty property : vcard.getProperties()) {
            Item item;
            if (!"MEMBER".equals(property.getKey())) continue;
            String member = property.getValue();
            if (member.startsWith("urn:uuid:") && (item = this.getItem(folderPath, member.substring(9) + ".EML")) != null) {
                if (item.get("smtpemail1") != null) {
                    member = "mailto:" + (String)item.get("smtpemail1");
                } else if (item.get("smtpemail2") != null) {
                    member = "mailto:" + (String)item.get("smtpemail2");
                } else if (item.get("smtpemail3") != null) {
                    member = "mailto:" + (String)item.get("smtpemail3");
                }
            }
            contact.addMember(member);
        }
        return contact.createOrUpdate();
    }

    protected String convertZuluDateToBday(String value) {
        String result = null;
        if (value != null && !value.isEmpty()) {
            try {
                SimpleDateFormat parser = ExchangeSession.getZuluDateFormat();
                Calendar cal = Calendar.getInstance();
                cal.setTime(parser.parse(value));
                cal.add(11, 12);
                result = ExchangeSession.getVcardBdayFormat().format(cal.getTime());
            }
            catch (ParseException e) {
                LOGGER.warn((Object)("Invalid date: " + value));
            }
        }
        return result;
    }

    protected String convertBDayToZulu(String value) {
        String result = null;
        if (value != null && !value.isEmpty()) {
            try {
                SimpleDateFormat parser;
                if (value.length() == 10) {
                    parser = ExchangeSession.getVcardBdayFormat();
                } else if (value.length() == 15) {
                    parser = new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.ENGLISH);
                    parser.setTimeZone(GMT_TIMEZONE);
                } else {
                    parser = ExchangeSession.getExchangeZuluDateFormat();
                }
                result = ExchangeSession.getExchangeZuluDateFormatMillisecond().format(parser.parse(value));
            }
            catch (ParseException e) {
                LOGGER.warn((Object)("Invalid date: " + value));
            }
        }
        return result;
    }

    protected abstract Contact buildContact(String var1, String var2, Map<String, String> var3, String var4, String var5) throws IOException;

    protected abstract ItemResult internalCreateOrUpdateEvent(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException;

    public String getAliasFromLogin() {
        if (this.userName.indexOf(64) >= 0) {
            return null;
        }
        String result = this.userName;
        int index = Math.max(result.indexOf(92), result.indexOf(47));
        if (index >= 0) {
            result = result.substring(index + 1);
        }
        return result;
    }

    public abstract boolean isSharedFolder(String var1);

    public abstract boolean isMainCalendar(String var1) throws IOException;

    public String getEmail() {
        return this.email;
    }

    public String getAlias() {
        return this.alias;
    }

    public abstract Map<String, Contact> galFind(Condition var1, Set<String> var2, int var3) throws IOException;

    protected abstract String getFreeBusyData(String var1, String var2, String var3, int var4) throws IOException;

    public FreeBusy getFreebusy(String attendee, String startDateValue, String endDateValue) throws IOException {
        Date endDate;
        Date startDate;
        if ((attendee = this.replaceIcal4Principal(attendee)) == null || attendee.indexOf(64) < 0 || attendee.charAt(attendee.length() - 1) == '@') {
            return null;
        }
        if (attendee.startsWith("mailto:") || attendee.startsWith("MAILTO:")) {
            attendee = attendee.substring("mailto:".length());
        }
        SimpleDateFormat exchangeZuluDateFormat = ExchangeSession.getExchangeZuluDateFormat();
        SimpleDateFormat icalDateFormat = ExchangeSession.getZuluDateFormat();
        try {
            startDate = startDateValue.length() == 8 ? ExchangeSession.parseDate(startDateValue) : icalDateFormat.parse(startDateValue);
            endDate = endDateValue.length() == 8 ? ExchangeSession.parseDate(endDateValue) : icalDateFormat.parse(endDateValue);
        }
        catch (ParseException e) {
            throw new DavMailException("EXCEPTION_INVALID_DATES", e.getMessage());
        }
        FreeBusy freeBusy = null;
        String fbdata = this.getFreeBusyData(attendee, exchangeZuluDateFormat.format(startDate), exchangeZuluDateFormat.format(endDate), 15);
        if (fbdata != null) {
            freeBusy = new FreeBusy(icalDateFormat, startDate, fbdata);
        }
        if (freeBusy != null && freeBusy.knownAttendee) {
            return freeBusy;
        }
        return null;
    }

    public VObject getVTimezone() {
        if (this.vTimezone == null) {
            this.loadVtimezone();
        }
        return this.vTimezone;
    }

    public void clearVTimezone() {
        this.vTimezone = null;
    }

    protected abstract void loadVtimezone();

    protected String convertPriorityFromExchange(String exchangeImportanceValue) {
        String value = null;
        if (exchangeImportanceValue != null) {
            value = importanceToPriorityMap.get(exchangeImportanceValue);
        }
        return value;
    }

    protected String convertPriorityToExchange(String vTodoPriorityValue) {
        String value = null;
        if (vTodoPriorityValue != null) {
            value = priorityToImportanceMap.get(vTodoPriorityValue);
        }
        return value;
    }

    protected String convertClassFromExchange(String sensitivity) {
        String eventClass = "private".equals(sensitivity) ? "PRIVATE" : ("confidential".equals(sensitivity) ? "CONFIDENTIAL" : ("personal".equals(sensitivity) ? "PRIVATE" : "PUBLIC"));
        return eventClass;
    }

    protected String convertClassToExchange(String eventClass) {
        String sensitivity = "PRIVATE".equals(eventClass) ? "Private" : ("CONFIDENTIAL".equals(eventClass) ? "Confidential" : "Normal");
        return sensitivity;
    }

    static {
        System.setProperty("mail.mime.ignoreunknownencoding", "true");
        System.setProperty("mail.mime.decodetext.strict", "false");
        POP_MESSAGE_ATTRIBUTES = new HashSet<String>();
        POP_MESSAGE_ATTRIBUTES.add("uid");
        POP_MESSAGE_ATTRIBUTES.add("imapUid");
        POP_MESSAGE_ATTRIBUTES.add("messageSize");
        IMAP_MESSAGE_ATTRIBUTES = new HashSet<String>();
        IMAP_MESSAGE_ATTRIBUTES.add("permanenturl");
        IMAP_MESSAGE_ATTRIBUTES.add("urlcompname");
        IMAP_MESSAGE_ATTRIBUTES.add("uid");
        IMAP_MESSAGE_ATTRIBUTES.add("messageSize");
        IMAP_MESSAGE_ATTRIBUTES.add("imapUid");
        IMAP_MESSAGE_ATTRIBUTES.add("junk");
        IMAP_MESSAGE_ATTRIBUTES.add("flagStatus");
        IMAP_MESSAGE_ATTRIBUTES.add("messageFlags");
        IMAP_MESSAGE_ATTRIBUTES.add("lastVerbExecuted");
        IMAP_MESSAGE_ATTRIBUTES.add("read");
        IMAP_MESSAGE_ATTRIBUTES.add("deleted");
        IMAP_MESSAGE_ATTRIBUTES.add("date");
        IMAP_MESSAGE_ATTRIBUTES.add("lastmodified");
        IMAP_MESSAGE_ATTRIBUTES.add("contentclass");
        IMAP_MESSAGE_ATTRIBUTES.add("keywords");
        UID_MESSAGE_ATTRIBUTES = new HashSet<String>();
        UID_MESSAGE_ATTRIBUTES.add("uid");
        RECIPIENT_HEADERS = new String[]{"to", "cc", "bcc"};
        VCARD_N_PROPERTIES = new String[]{"sn", "givenName", "middlename", "personaltitle", "namesuffix"};
        VCARD_ADR_HOME_PROPERTIES = new String[]{"homepostofficebox", null, "homeStreet", "homeCity", "homeState", "homePostalCode", "homeCountry"};
        VCARD_ADR_WORK_PROPERTIES = new String[]{"postofficebox", "roomnumber", "street", "l", "st", "postalcode", "co"};
        VCARD_ADR_OTHER_PROPERTIES = new String[]{"otherpostofficebox", null, "otherstreet", "othercity", "otherstate", "otherpostalcode", "othercountry"};
        VCARD_ORG_PROPERTIES = new String[]{"o", "department"};
        CONTACT_ATTRIBUTES = new HashSet<String>();
        CONTACT_ATTRIBUTES.add("imapUid");
        CONTACT_ATTRIBUTES.add("etag");
        CONTACT_ATTRIBUTES.add("urlcompname");
        CONTACT_ATTRIBUTES.add("extensionattribute1");
        CONTACT_ATTRIBUTES.add("extensionattribute2");
        CONTACT_ATTRIBUTES.add("extensionattribute3");
        CONTACT_ATTRIBUTES.add("extensionattribute4");
        CONTACT_ATTRIBUTES.add("bday");
        CONTACT_ATTRIBUTES.add("anniversary");
        CONTACT_ATTRIBUTES.add("businesshomepage");
        CONTACT_ATTRIBUTES.add("personalHomePage");
        CONTACT_ATTRIBUTES.add("cn");
        CONTACT_ATTRIBUTES.add("co");
        CONTACT_ATTRIBUTES.add("department");
        CONTACT_ATTRIBUTES.add("smtpemail1");
        CONTACT_ATTRIBUTES.add("smtpemail2");
        CONTACT_ATTRIBUTES.add("smtpemail3");
        CONTACT_ATTRIBUTES.add("facsimiletelephonenumber");
        CONTACT_ATTRIBUTES.add("givenName");
        CONTACT_ATTRIBUTES.add("homeCity");
        CONTACT_ATTRIBUTES.add("homeCountry");
        CONTACT_ATTRIBUTES.add("homePhone");
        CONTACT_ATTRIBUTES.add("homePostalCode");
        CONTACT_ATTRIBUTES.add("homeState");
        CONTACT_ATTRIBUTES.add("homeStreet");
        CONTACT_ATTRIBUTES.add("homepostofficebox");
        CONTACT_ATTRIBUTES.add("l");
        CONTACT_ATTRIBUTES.add("manager");
        CONTACT_ATTRIBUTES.add("mobile");
        CONTACT_ATTRIBUTES.add("namesuffix");
        CONTACT_ATTRIBUTES.add("nickname");
        CONTACT_ATTRIBUTES.add("o");
        CONTACT_ATTRIBUTES.add("pager");
        CONTACT_ATTRIBUTES.add("personaltitle");
        CONTACT_ATTRIBUTES.add("postalcode");
        CONTACT_ATTRIBUTES.add("postofficebox");
        CONTACT_ATTRIBUTES.add("profession");
        CONTACT_ATTRIBUTES.add("roomnumber");
        CONTACT_ATTRIBUTES.add("secretarycn");
        CONTACT_ATTRIBUTES.add("sn");
        CONTACT_ATTRIBUTES.add("spousecn");
        CONTACT_ATTRIBUTES.add("st");
        CONTACT_ATTRIBUTES.add("street");
        CONTACT_ATTRIBUTES.add("telephoneNumber");
        CONTACT_ATTRIBUTES.add("title");
        CONTACT_ATTRIBUTES.add("description");
        CONTACT_ATTRIBUTES.add("im");
        CONTACT_ATTRIBUTES.add("middlename");
        CONTACT_ATTRIBUTES.add("lastmodified");
        CONTACT_ATTRIBUTES.add("otherstreet");
        CONTACT_ATTRIBUTES.add("otherstate");
        CONTACT_ATTRIBUTES.add("otherpostofficebox");
        CONTACT_ATTRIBUTES.add("otherpostalcode");
        CONTACT_ATTRIBUTES.add("othercountry");
        CONTACT_ATTRIBUTES.add("othercity");
        CONTACT_ATTRIBUTES.add("haspicture");
        CONTACT_ATTRIBUTES.add("keywords");
        CONTACT_ATTRIBUTES.add("othermobile");
        CONTACT_ATTRIBUTES.add("otherTelephone");
        CONTACT_ATTRIBUTES.add("gender");
        CONTACT_ATTRIBUTES.add("private");
        CONTACT_ATTRIBUTES.add("sensitivity");
        CONTACT_ATTRIBUTES.add("fburl");
        CONTACT_ATTRIBUTES.add("msexchangecertificate");
        CONTACT_ATTRIBUTES.add("usersmimecertificate");
        DISTRIBUTION_LIST_ATTRIBUTES = new HashSet<String>();
        DISTRIBUTION_LIST_ATTRIBUTES.add("imapUid");
        DISTRIBUTION_LIST_ATTRIBUTES.add("etag");
        DISTRIBUTION_LIST_ATTRIBUTES.add("urlcompname");
        DISTRIBUTION_LIST_ATTRIBUTES.add("cn");
        DISTRIBUTION_LIST_ATTRIBUTES.add("members");
        vTodoToTaskStatusMap = new HashMap<String, String>();
        taskTovTodoStatusMap = new HashMap<String, String>();
        taskTovTodoStatusMap.put("InProgress", "IN-PROCESS");
        taskTovTodoStatusMap.put("Completed", "COMPLETED");
        taskTovTodoStatusMap.put("WaitingOnOthers", "NEEDS-ACTION");
        taskTovTodoStatusMap.put("Deferred", "CANCELLED");
        vTodoToTaskStatusMap.put("IN-PROCESS", "InProgress");
        vTodoToTaskStatusMap.put("COMPLETED", "Completed");
        vTodoToTaskStatusMap.put("NEEDS-ACTION", "WaitingOnOthers");
        vTodoToTaskStatusMap.put("CANCELLED", "Deferred");
        importanceToPriorityMap = new HashMap<String, String>();
        importanceToPriorityMap.put("High", "1");
        importanceToPriorityMap.put("Normal", "5");
        importanceToPriorityMap.put("Low", "9");
        priorityToImportanceMap = new HashMap<String, String>();
        priorityToImportanceMap.put("0", "Normal");
        priorityToImportanceMap.put("1", "High");
        priorityToImportanceMap.put("2", "High");
        priorityToImportanceMap.put("3", "High");
        priorityToImportanceMap.put("4", "Normal");
        priorityToImportanceMap.put("5", "Normal");
        priorityToImportanceMap.put("6", "Normal");
        priorityToImportanceMap.put("7", "Low");
        priorityToImportanceMap.put("8", "Low");
        priorityToImportanceMap.put("9", "Low");
    }

    public static final class FreeBusy {
        final SimpleDateFormat icalParser;
        boolean knownAttendee = true;
        static final HashMap<Character, String> FBTYPES = new HashMap();
        final HashMap<String, StringBuilder> busyMap = new HashMap();

        StringBuilder getBusyBuffer(char type) {
            String fbType = FBTYPES.get(Character.valueOf(type));
            return this.busyMap.computeIfAbsent(fbType, k -> new StringBuilder());
        }

        void startBusy(char type, Calendar currentCal) {
            if (type == '4') {
                this.knownAttendee = false;
            } else if (type != '0') {
                StringBuilder busyBuffer = this.getBusyBuffer(type);
                if (busyBuffer.length() > 0) {
                    busyBuffer.append(',');
                }
                busyBuffer.append(this.icalParser.format(currentCal.getTime()));
            }
        }

        void endBusy(char type, Calendar currentCal) {
            if (type != '0' && type != '4') {
                this.getBusyBuffer(type).append('/').append(this.icalParser.format(currentCal.getTime()));
            }
        }

        FreeBusy(SimpleDateFormat icalParser, Date startDate, String fbdata) {
            this.icalParser = icalParser;
            if (!fbdata.isEmpty()) {
                Calendar currentCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                currentCal.setTime(startDate);
                this.startBusy(fbdata.charAt(0), currentCal);
                for (int i = 1; i < fbdata.length() && this.knownAttendee; ++i) {
                    currentCal.add(12, 15);
                    char previousState = fbdata.charAt(i - 1);
                    char currentState = fbdata.charAt(i);
                    if (previousState == currentState) continue;
                    this.endBusy(previousState, currentCal);
                    this.startBusy(currentState, currentCal);
                }
                currentCal.add(12, 15);
                this.endBusy(fbdata.charAt(fbdata.length() - 1), currentCal);
            }
        }

        public void appendTo(StringBuilder buffer) {
            for (Map.Entry<String, StringBuilder> entry : this.busyMap.entrySet()) {
                buffer.append("FREEBUSY;FBTYPE=").append(entry.getKey()).append(':').append((CharSequence)entry.getValue()).append('\r').append('\n');
            }
        }

        static {
            FBTYPES.put(Character.valueOf('1'), "BUSY-TENTATIVE");
            FBTYPES.put(Character.valueOf('2'), "BUSY");
            FBTYPES.put(Character.valueOf('3'), "BUSY-UNAVAILABLE");
        }
    }

    public static class ItemResult {
        public int status;
        public String etag;
        public String itemName;
    }

    public static class ContactPhoto {
        public String contentType;
        public String content;
    }

    public abstract class Event
    extends Item {
        protected String contentClass;
        protected String subject;
        protected VCalendar vCalendar;
        protected static final String TEXT_CALENDAR = "text/calendar";
        protected static final String APPLICATION_ICS = "application/ics";

        public Event(String folderPath, String itemName, String contentClass, String itemBody, String etag, String noneMatch) throws IOException {
            super(folderPath, itemName, etag, noneMatch);
            this.contentClass = contentClass;
            this.fixICS(itemBody.getBytes(StandardCharsets.UTF_8), false);
            if (this.vCalendar.isTodo() && this.itemName.endsWith(".ics")) {
                this.itemName = itemName.substring(0, itemName.length() - 3) + "EML";
            }
        }

        protected Event() {
        }

        @Override
        public String getContentType() {
            return "text/calendar;charset=UTF-8";
        }

        @Override
        public String getBody() throws IOException {
            if (this.vCalendar == null) {
                this.fixICS(this.getEventContent(), true);
            }
            return this.vCalendar.toString();
        }

        protected HttpNotFoundException buildHttpNotFoundException(Exception e) {
            String message = "Unable to get event " + this.getName() + " subject: " + this.subject + " at " + this.permanentUrl + ": " + e.getMessage();
            LOGGER.warn((Object)message);
            return new HttpNotFoundException(message);
        }

        public abstract byte[] getEventContent() throws IOException;

        protected boolean isCalendarContentType(String contentType) {
            return TEXT_CALENDAR.regionMatches(true, 0, contentType, 0, TEXT_CALENDAR.length()) || APPLICATION_ICS.regionMatches(true, 0, contentType, 0, APPLICATION_ICS.length());
        }

        protected MimePart getCalendarMimePart(MimeMultipart multiPart) throws IOException, MessagingException {
            MimePart bodyPart = null;
            for (int i = 0; i < multiPart.getCount(); ++i) {
                Object content;
                String contentType = multiPart.getBodyPart(i).getContentType();
                if (this.isCalendarContentType(contentType)) {
                    bodyPart = (MimePart)multiPart.getBodyPart(i);
                    break;
                }
                if (!contentType.startsWith("multipart") || !((content = multiPart.getBodyPart(i).getContent()) instanceof MimeMultipart)) continue;
                bodyPart = this.getCalendarMimePart((MimeMultipart)content);
            }
            return bodyPart;
        }

        protected byte[] getICS(InputStream mimeInputStream) throws IOException, MessagingException {
            byte[] result;
            MimeMessage mimeMessage = new MimeMessage(null, mimeInputStream);
            String[] contentClassHeader = mimeMessage.getHeader("Content-class");
            if (contentClassHeader != null && contentClassHeader.length > 0 && "urn:content-classes:task".equals(contentClassHeader[0])) {
                return null;
            }
            Object mimeBody = mimeMessage.getContent();
            MimePart bodyPart = null;
            if (mimeBody instanceof MimeMultipart) {
                bodyPart = this.getCalendarMimePart((MimeMultipart)mimeBody);
            } else if (this.isCalendarContentType(mimeMessage.getContentType())) {
                bodyPart = mimeMessage;
            }
            if (bodyPart != null) {
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    bodyPart.getDataHandler().writeTo(baos);
                    result = baos.toByteArray();
                }
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    try {
                        mimeMessage.writeTo((OutputStream)baos);
                        throw new DavMailException("EXCEPTION_INVALID_MESSAGE_CONTENT", new String(baos.toByteArray(), StandardCharsets.UTF_8));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (baos != null) {
                        if (throwable != null) {
                            try {
                                baos.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            baos.close();
                        }
                    }
                    throw throwable3;
                }
            }
            return result;
        }

        protected void fixICS(byte[] icsContent, boolean fromServer) throws IOException {
            ICSCalendarValidator.ValidationResult vr;
            if (LOGGER.isDebugEnabled() && fromServer) {
                dumpIndex++;
                String icsBody = new String(icsContent, StandardCharsets.UTF_8);
                vr = ICSCalendarValidator.validateWithDetails(icsBody);
                this.dumpICS(icsBody, true, false);
                LOGGER.debug((Object)("Vcalendar body ValidationResult: " + vr.isValid() + " " + vr.showReason()));
                LOGGER.debug((Object)("Vcalendar body received from server:\n" + icsBody));
            }
            this.vCalendar = new VCalendar(icsContent, ExchangeSession.this.getEmail(), ExchangeSession.this.getVTimezone());
            this.vCalendar.fixVCalendar(fromServer);
            if (LOGGER.isDebugEnabled() && !fromServer) {
                String resultString = this.vCalendar.toString();
                vr = ICSCalendarValidator.validateWithDetails(resultString);
                LOGGER.debug((Object)("Fixed Vcalendar body ValidationResult: " + vr.isValid() + " " + vr.showReason()));
                LOGGER.debug((Object)("Fixed Vcalendar body to server:\n" + resultString));
                this.dumpICS(resultString, false, true);
            }
        }

        protected void dumpICS(String icsBody, boolean fromServer, boolean after) {
            String logFileDirectory = Settings.getLogFileDirectory();
            int dumpMax = Settings.getIntProperty("davmail.dumpICS");
            if (dumpMax > 0) {
                if (dumpIndex > dumpMax) {
                    int oldest = dumpIndex - dumpMax;
                    try {
                        File[] oldestFiles = new File(logFileDirectory).listFiles((dir, name) -> {
                            int dashIndex;
                            if (name.endsWith(".ics") && (dashIndex = name.indexOf(45)) > 0) {
                                try {
                                    int fileIndex = Integer.parseInt(name.substring(0, dashIndex));
                                    return fileIndex < oldest;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            return false;
                        });
                        if (oldestFiles != null) {
                            for (File file : oldestFiles) {
                                if (file.delete()) continue;
                                LOGGER.warn((Object)("Unable to delete " + file.getAbsolutePath()));
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn((Object)("Error deleting ics dump: " + ex.getMessage()));
                    }
                }
                StringBuilder filePath = new StringBuilder();
                filePath.append(logFileDirectory).append('/').append(dumpIndex).append(after ? "-to" : "-from").append(after ^ fromServer ? "-server" : "-client").append(".ics");
                if (icsBody != null && !icsBody.isEmpty()) {
                    try {
                        OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(Paths.get(filePath.toString(), new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);
                        Object object = null;
                        try {
                            writer.write(icsBody);
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (writer != null) {
                                if (object != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    writer.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)e);
                    }
                }
            }
        }

        public byte[] createMimeContent() throws IOException {
            String boundary = UUID.randomUUID().toString();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MimeOutputStreamWriter writer = new MimeOutputStreamWriter(baos);
            writer.writeHeader("Content-Transfer-Encoding", "7bit");
            writer.writeHeader("Content-class", this.contentClass);
            writer.writeHeader("Date", new Date());
            String vEventSubject = this.vCalendar.getFirstVeventPropertyValue("SUMMARY");
            if (vEventSubject == null) {
                vEventSubject = BundleMessage.format("MEETING_REQUEST", new Object[0]);
            }
            String description = this.vCalendar.getFirstVeventPropertyValue("DESCRIPTION");
            if ("urn:content-classes:calendarmessage".equals(this.contentClass)) {
                String notificationSubject;
                String cc;
                String to;
                VCalendar.Recipients recipients = this.vCalendar.getRecipients(true);
                if (ExchangeSession.this.email.equalsIgnoreCase(recipients.organizer)) {
                    to = recipients.attendees;
                    cc = recipients.optionalAttendees;
                    notificationSubject = this.subject;
                } else {
                    String status = this.vCalendar.getAttendeeStatus();
                    to = recipients.organizer;
                    cc = null;
                    notificationSubject = status != null ? BundleMessage.format(status, new Object[0]) + vEventSubject : this.subject;
                    description = "";
                }
                if (Settings.getBooleanProperty("davmail.caldavEditNotifications")) {
                    NotificationDialog notificationDialog = new NotificationDialog(to, cc, notificationSubject, description);
                    if (!notificationDialog.getSendNotification()) {
                        LOGGER.debug((Object)"Notification canceled by user");
                        return null;
                    }
                    to = notificationDialog.getTo();
                    cc = notificationDialog.getCc();
                    notificationSubject = notificationDialog.getSubject();
                    description = notificationDialog.getBody();
                }
                if ((to == null || to.isEmpty()) && (cc == null || cc.isEmpty())) {
                    return null;
                }
                writer.writeHeader("To", to);
                writer.writeHeader("Cc", cc);
                writer.writeHeader("Subject", notificationSubject);
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder logBuffer = new StringBuilder("Sending notification ");
                    if (to != null) {
                        logBuffer.append("to: ").append(to);
                    }
                    if (cc != null) {
                        logBuffer.append("cc: ").append(cc);
                    }
                    LOGGER.debug((Object)logBuffer.toString());
                }
            } else {
                VCalendar.Recipients recipients = this.vCalendar.getRecipients(false);
                if (recipients.attendees != null) {
                    writer.writeHeader("To", recipients.attendees);
                } else {
                    writer.writeHeader("To", ExchangeSession.this.email);
                }
                writer.writeHeader("Cc", recipients.optionalAttendees);
                if (recipients.organizer != null) {
                    writer.writeHeader("From", recipients.organizer);
                } else {
                    writer.writeHeader("From", ExchangeSession.this.email);
                }
            }
            if (this.vCalendar.getMethod() == null) {
                this.vCalendar.setPropertyValue("METHOD", "REQUEST");
            }
            writer.writeHeader("MIME-Version", "1.0");
            writer.writeHeader("Content-Type", "multipart/alternative;\r\n\tboundary=\"----=_NextPart_" + boundary + '\"');
            writer.writeLn();
            writer.writeLn("This is a multi-part message in MIME format.");
            writer.writeLn();
            writer.writeLn("------=_NextPart_" + boundary);
            if (description != null && !description.isEmpty()) {
                writer.writeHeader("Content-Type", "text/plain;\r\n\tcharset=\"utf-8\"");
                writer.writeHeader("content-transfer-encoding", "8bit");
                writer.writeLn();
                writer.flush();
                baos.write(description.getBytes(StandardCharsets.UTF_8));
                writer.writeLn();
                writer.writeLn("------=_NextPart_" + boundary);
            }
            writer.writeHeader("Content-class", this.contentClass);
            writer.writeHeader("Content-Type", "text/calendar;\r\n\tmethod=" + this.vCalendar.getMethod() + ";\r\n\tcharset=\"utf-8\"");
            writer.writeHeader("Content-Transfer-Encoding", "8bit");
            writer.writeLn();
            writer.flush();
            baos.write(this.vCalendar.toString().getBytes(StandardCharsets.UTF_8));
            writer.writeLn();
            writer.writeLn("------=_NextPart_" + boundary + "--");
            writer.close();
            return baos.toByteArray();
        }

        public abstract ItemResult createOrUpdate() throws IOException;
    }

    public abstract class Contact
    extends Item {
        protected ArrayList<String> distributionListMembers;
        protected String vCardVersion;

        public Contact(String folderPath, String itemName, Map<String, String> properties, String etag, String noneMatch) {
            super(folderPath, itemName.endsWith(".vcf") ? itemName.substring(0, itemName.length() - 3) + "EML" : itemName, etag, noneMatch);
            this.distributionListMembers = null;
            this.putAll(properties);
        }

        protected Contact() {
            this.distributionListMembers = null;
        }

        public void setVCardVersion(String vCardVersion) {
            this.vCardVersion = vCardVersion;
        }

        public abstract ItemResult createOrUpdate() throws IOException;

        @Override
        public String getName() {
            String name = super.getName();
            if (name.endsWith(".EML")) {
                name = name.substring(0, name.length() - 3) + "vcf";
            }
            return name;
        }

        public void setName(String name) {
            this.itemName = name;
        }

        public String getUid() {
            String uid = this.getName();
            int dotIndex = uid.lastIndexOf(46);
            if (dotIndex > 0) {
                uid = uid.substring(0, dotIndex);
            }
            return URIUtil.encodePath(uid);
        }

        @Override
        public String getContentType() {
            return "text/vcard";
        }

        public void addMember(String member) {
            if (this.distributionListMembers == null) {
                this.distributionListMembers = new ArrayList();
            }
            this.distributionListMembers.add(member);
        }

        @Override
        public String getBody() {
            String sn;
            VCardWriter writer = new VCardWriter();
            writer.startCard(this.vCardVersion);
            writer.appendProperty("UID", this.getUid());
            String cn = (String)this.get("cn");
            if (cn == null) {
                cn = (String)this.get("displayname");
            }
            if ((sn = (String)this.get("sn")) == null) {
                sn = cn;
            }
            writer.appendProperty("FN", cn);
            writer.appendProperty("N", sn, (String)this.get("givenName"), (String)this.get("middlename"), (String)this.get("personaltitle"), (String)this.get("namesuffix"));
            if (this.distributionListMembers != null) {
                writer.appendProperty("KIND", "group");
                for (String member : this.distributionListMembers) {
                    writer.appendProperty("MEMBER", member);
                }
            }
            writer.appendProperty("TEL;TYPE=cell", (String)this.get("mobile"));
            writer.appendProperty("TEL;TYPE=work", (String)this.get("telephoneNumber"));
            writer.appendProperty("TEL;TYPE=home", (String)this.get("homePhone"));
            writer.appendProperty("TEL;TYPE=fax", (String)this.get("facsimiletelephonenumber"));
            writer.appendProperty("TEL;TYPE=pager", (String)this.get("pager"));
            writer.appendProperty("TEL;TYPE=car", (String)this.get("othermobile"));
            writer.appendProperty("TEL;TYPE=home,fax", (String)this.get("homefax"));
            writer.appendProperty("TEL;TYPE=isdn", (String)this.get("internationalisdnnumber"));
            writer.appendProperty("TEL;TYPE=msg", (String)this.get("otherTelephone"));
            writer.appendProperty("ADR;TYPE=home", (String)this.get("homepostofficebox"), null, (String)this.get("homeStreet"), (String)this.get("homeCity"), (String)this.get("homeState"), (String)this.get("homePostalCode"), (String)this.get("homeCountry"));
            writer.appendProperty("ADR;TYPE=work", (String)this.get("postofficebox"), (String)this.get("roomnumber"), (String)this.get("street"), (String)this.get("l"), (String)this.get("st"), (String)this.get("postalcode"), (String)this.get("co"));
            writer.appendProperty("ADR;TYPE=other", (String)this.get("otherpostofficebox"), null, (String)this.get("otherstreet"), (String)this.get("othercity"), (String)this.get("otherstate"), (String)this.get("otherpostalcode"), (String)this.get("othercountry"));
            writer.appendProperty("EMAIL;TYPE=work", (String)this.get("smtpemail1"));
            writer.appendProperty("EMAIL;TYPE=home", (String)this.get("smtpemail2"));
            writer.appendProperty("EMAIL;TYPE=other", (String)this.get("smtpemail3"));
            writer.appendProperty("ORG", (String)this.get("o"), (String)this.get("department"));
            writer.appendProperty("URL;TYPE=work", (String)this.get("businesshomepage"));
            writer.appendProperty("URL;TYPE=home", (String)this.get("personalHomePage"));
            writer.appendProperty("TITLE", (String)this.get("title"));
            writer.appendProperty("NOTE", (String)this.get("description"));
            writer.appendProperty("CUSTOM1", (String)this.get("extensionattribute1"));
            writer.appendProperty("CUSTOM2", (String)this.get("extensionattribute2"));
            writer.appendProperty("CUSTOM3", (String)this.get("extensionattribute3"));
            writer.appendProperty("CUSTOM4", (String)this.get("extensionattribute4"));
            writer.appendProperty("ROLE", (String)this.get("profession"));
            writer.appendProperty("NICKNAME", (String)this.get("nickname"));
            writer.appendProperty("X-AIM", (String)this.get("im"));
            writer.appendProperty("BDAY", ExchangeSession.this.convertZuluDateToBday((String)this.get("bday")));
            writer.appendProperty("ANNIVERSARY", ExchangeSession.this.convertZuluDateToBday((String)this.get("anniversary")));
            String gender = (String)this.get("gender");
            if ("1".equals(gender)) {
                writer.appendProperty("SEX", "2");
            } else if ("2".equals(gender)) {
                writer.appendProperty("SEX", "1");
            }
            writer.appendProperty("CATEGORIES", (String)this.get("keywords"));
            writer.appendProperty("FBURL", (String)this.get("fburl"));
            if ("1".equals(this.get("private"))) {
                writer.appendProperty("CLASS", "PRIVATE");
            }
            writer.appendProperty("X-ASSISTANT", (String)this.get("secretarycn"));
            writer.appendProperty("X-MANAGER", (String)this.get("manager"));
            writer.appendProperty("X-SPOUSE", (String)this.get("spousecn"));
            writer.appendProperty("REV", (String)this.get("lastmodified"));
            ContactPhoto contactPhoto = null;
            if (Settings.getBooleanProperty("davmail.carddavReadPhoto", true)) {
                if ("true".equals(this.get("haspicture"))) {
                    try {
                        contactPhoto = ExchangeSession.this.getContactPhoto(this);
                    }
                    catch (IOException e) {
                        LOGGER.warn((Object)("Unable to get photo from contact " + (String)this.get("cn")));
                    }
                }
                if (contactPhoto == null) {
                    contactPhoto = ExchangeSession.this.getADPhoto((String)this.get("smtpemail1"));
                }
            }
            if (contactPhoto != null) {
                writer.writeLine("PHOTO;TYPE=" + contactPhoto.contentType + ";ENCODING=BASE64:");
                writer.writeLine(contactPhoto.content, true);
            }
            writer.appendProperty("KEY1;X509;ENCODING=BASE64", (String)this.get("msexchangecertificate"));
            writer.appendProperty("KEY2;X509;ENCODING=BASE64", (String)this.get("usersmimecertificate"));
            writer.endCard();
            return writer.toString();
        }
    }

    public static abstract class Item
    extends HashMap<String, String> {
        protected String folderPath;
        protected String itemName;
        protected String permanentUrl;
        public String displayName;
        public String etag;
        protected String noneMatch;

        public Item(String folderPath, String itemName, String etag, String noneMatch) {
            this.folderPath = folderPath;
            this.itemName = itemName;
            this.etag = etag;
            this.noneMatch = noneMatch;
        }

        protected Item() {
        }

        public abstract String getContentType();

        public abstract String getBody() throws IOException;

        public String getName() {
            return this.itemName;
        }

        public String getEtag() {
            return this.etag;
        }

        public void setHref(String href) {
            int index = href.lastIndexOf(47);
            if (index < 0) {
                throw new IllegalArgumentException(href);
            }
            this.folderPath = href.substring(0, index);
            this.itemName = href.substring(index + 1);
        }

        public String getHref() {
            return this.folderPath + '/' + this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }
    }

    public static class MessageList
    extends ArrayList<Message> {
        protected transient MimeMessage cachedMimeMessage;
        protected transient long cachedMessageImapUid;
        protected transient byte[] cachedMimeContent;
    }

    public abstract class Message
    implements Comparable<Message> {
        public MessageList messageList;
        public String messageUrl;
        public String permanentUrl;
        public String uid;
        public String contentClass;
        public String keywords;
        public long imapUid;
        public int size;
        public String date;
        public boolean read;
        public boolean deleted;
        public boolean junk;
        public boolean flagged;
        public boolean recent;
        public boolean draft;
        public boolean answered;
        public boolean forwarded;
        protected byte[] mimeContent;
        protected MimeMessage mimeMessage;

        public abstract String getPermanentId();

        public long getImapUid() {
            return this.imapUid;
        }

        public void setImapUid(long imapUid) {
            this.imapUid = imapUid;
        }

        public String getUid() {
            return this.uid;
        }

        public String getImapFlags() {
            StringBuilder buffer = new StringBuilder();
            if (this.read) {
                buffer.append("\\Seen ");
            }
            if (this.deleted) {
                buffer.append("\\Deleted ");
            }
            if (this.recent) {
                buffer.append("\\Recent ");
            }
            if (this.flagged) {
                buffer.append("\\Flagged ");
            }
            if (this.junk) {
                buffer.append("Junk ");
            }
            if (this.draft) {
                buffer.append("\\Draft ");
            }
            if (this.answered) {
                buffer.append("\\Answered ");
            }
            if (this.forwarded) {
                buffer.append("$Forwarded ");
            }
            if (this.keywords != null) {
                for (String keyword : this.keywords.split(",")) {
                    buffer.append(ExchangeSession.this.encodeKeyword(ExchangeSession.this.convertKeywordToFlag(keyword))).append(" ");
                }
            }
            return buffer.toString().trim();
        }

        public void loadMimeMessage() throws IOException, MessagingException {
            if (this.mimeMessage == null) {
                if (this.imapUid == this.messageList.cachedMessageImapUid && this.messageList.cachedMimeContent != null && this.messageList.cachedMimeMessage != null) {
                    this.mimeContent = this.messageList.cachedMimeContent;
                    this.mimeMessage = this.messageList.cachedMimeMessage;
                    LOGGER.debug((Object)("Got message content for " + this.imapUid + " from cache"));
                } else {
                    this.mimeContent = ExchangeSession.this.getContent(this);
                    this.mimeMessage = new MimeMessage(null, (InputStream)new SharedByteArrayInputStream(this.mimeContent));
                    if (this.mimeMessage.getHeader("MAIL FROM") != null) {
                        byte[] mimeContentCopy = new byte[((SharedByteArrayInputStream)this.mimeMessage.getRawInputStream()).available()];
                        int offset = this.mimeContent.length - mimeContentCopy.length;
                        System.arraycopy(this.mimeContent, offset, mimeContentCopy, 0, mimeContentCopy.length);
                        this.mimeContent = mimeContentCopy;
                        this.mimeMessage = new MimeMessage(null, (InputStream)new SharedByteArrayInputStream(this.mimeContent));
                    }
                    LOGGER.debug((Object)("Downloaded full message content for IMAP UID " + this.imapUid + " (" + this.mimeContent.length + " bytes)"));
                }
            }
        }

        public MimeMessage getMimeMessage() throws IOException, MessagingException {
            this.loadMimeMessage();
            return this.mimeMessage;
        }

        public Enumeration<?> getMatchingHeaderLinesFromHeaders(String[] headerNames) throws MessagingException {
            InputStream headers;
            Enumeration result = null;
            if (this.mimeMessage == null && (headers = this.getMimeHeaders()) != null) {
                InternetHeaders internetHeaders = new InternetHeaders(headers);
                if (internetHeaders.getHeader("Subject") == null) {
                    return null;
                }
                result = headerNames == null ? internetHeaders.getAllHeaderLines() : internetHeaders.getMatchingHeaderLines(headerNames);
            }
            return result;
        }

        public Enumeration<?> getMatchingHeaderLines(String[] headerNames) throws MessagingException, IOException {
            Enumeration result = this.getMatchingHeaderLinesFromHeaders(headerNames);
            if (result == null) {
                result = headerNames == null ? this.getMimeMessage().getAllHeaderLines() : this.getMimeMessage().getMatchingHeaderLines(headerNames);
            }
            return result;
        }

        protected abstract InputStream getMimeHeaders();

        public int getMimeMessageSize() throws IOException, MessagingException {
            this.loadMimeMessage();
            return this.mimeContent.length;
        }

        public InputStream getRawInputStream() throws IOException, MessagingException {
            this.loadMimeMessage();
            return new SharedByteArrayInputStream(this.mimeContent);
        }

        public void dropMimeMessage() {
            if (this.mimeMessage != null) {
                this.messageList.cachedMessageImapUid = this.imapUid;
                this.messageList.cachedMimeContent = this.mimeContent;
                this.messageList.cachedMimeMessage = this.mimeMessage;
            }
            this.mimeMessage = null;
            this.mimeContent = null;
        }

        public boolean isLoaded() {
            if (this.imapUid == this.messageList.cachedMessageImapUid) {
                this.mimeContent = this.messageList.cachedMimeContent;
                this.mimeMessage = this.messageList.cachedMimeMessage;
            }
            return this.mimeMessage != null;
        }

        public void delete() throws IOException {
            ExchangeSession.this.deleteMessage(this);
        }

        public void moveToTrash() throws IOException {
            this.markRead();
            ExchangeSession.this.moveToTrash(this);
        }

        public void markRead() throws IOException {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("read", "1");
            ExchangeSession.this.updateMessage(this, properties);
        }

        @Override
        public int compareTo(Message message) {
            long compareValue = this.imapUid - message.imapUid;
            if (compareValue > 0L) {
                return 1;
            }
            if (compareValue < 0L) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object message) {
            return message instanceof Message && this.imapUid == ((Message)message).imapUid;
        }

        public int hashCode() {
            return Long.hashCode(this.imapUid);
        }

        public String removeFlag(String flag) {
            if (this.keywords != null) {
                String[] keywordArray;
                String exchangeFlag = ExchangeSession.this.convertFlagToKeyword(flag);
                HashSet<String> keywordSet = new HashSet<String>();
                for (String value : keywordArray = this.keywords.split(",")) {
                    if (value.equalsIgnoreCase(exchangeFlag)) continue;
                    keywordSet.add(value);
                }
                this.keywords = StringUtil.join(keywordSet, ",");
            }
            return this.keywords;
        }

        public String addFlag(String flag) {
            String exchangeFlag = ExchangeSession.this.convertFlagToKeyword(flag);
            HashSet<String> keywordSet = new HashSet<String>();
            boolean hasFlag = false;
            if (this.keywords != null) {
                String[] keywordArray;
                for (String value : keywordArray = this.keywords.split(",")) {
                    keywordSet.add(value);
                    if (!value.equalsIgnoreCase(exchangeFlag)) continue;
                    hasFlag = true;
                }
            }
            if (!hasFlag) {
                keywordSet.add(exchangeFlag);
            }
            this.keywords = StringUtil.join(keywordSet, ",");
            return this.keywords;
        }

        public String setFlags(HashSet<String> flags) {
            this.keywords = ExchangeSession.this.convertFlagsToKeywords(flags);
            return this.keywords;
        }
    }

    public class Folder {
        public String folderPath;
        public String displayName;
        public String folderClass;
        public int messageCount;
        public int unreadCount;
        public boolean hasChildren;
        public boolean noInferiors;
        public String ctag;
        public String etag;
        public long uidNext;
        public int recent;
        public MessageList messages;
        private final HashMap<String, Long> permanentUrlToImapUidMap = new HashMap();

        public String getFlags() {
            String specialFlag = "";
            if (this.isSpecial()) {
                specialFlag = "\\" + this.folderPath + " ";
            }
            if (this.noInferiors) {
                return specialFlag + "\\NoInferiors";
            }
            if (this.hasChildren) {
                return specialFlag + "\\HasChildren";
            }
            return specialFlag + "\\HasNoChildren";
        }

        public boolean isSpecial() {
            return SPECIAL.contains(this.folderPath);
        }

        public void loadMessages() throws IOException {
            this.messages = ExchangeSession.this.searchMessages(this.folderPath, null);
            this.fixUids(this.messages);
            this.recent = 0;
            for (Message message : this.messages) {
                if (!message.recent) continue;
                ++this.recent;
            }
            long computedUidNext = 1L;
            if (!this.messages.isEmpty()) {
                computedUidNext = ((Message)this.messages.get(this.messages.size() - 1)).getImapUid() + 1L;
            }
            if (computedUidNext > this.uidNext) {
                this.uidNext = computedUidNext;
            }
        }

        public MessageList searchMessages(Condition condition) throws IOException {
            MessageList localMessages = ExchangeSession.this.searchMessages(this.folderPath, condition);
            this.fixUids(localMessages);
            return localMessages;
        }

        protected void fixUids(MessageList messages) {
            boolean sortNeeded = false;
            for (Message message : messages) {
                if (this.permanentUrlToImapUidMap.containsKey(message.getPermanentId())) {
                    long previousUid = this.permanentUrlToImapUidMap.get(message.getPermanentId());
                    if (message.getImapUid() == previousUid) continue;
                    LOGGER.debug((Object)("Restoring IMAP uid " + message.getImapUid() + " -> " + previousUid + " for message " + message.getPermanentId()));
                    message.setImapUid(previousUid);
                    sortNeeded = true;
                    continue;
                }
                this.permanentUrlToImapUidMap.put(message.getPermanentId(), message.getImapUid());
            }
            if (sortNeeded) {
                Collections.sort(messages);
            }
        }

        public int count() {
            if (this.messages == null) {
                return this.messageCount;
            }
            return this.messages.size();
        }

        public long getUidNext() {
            return this.uidNext;
        }

        public Message get(int index) {
            return (Message)this.messages.get(index);
        }

        public TreeMap<Long, String> getImapFlagMap() {
            TreeMap<Long, String> imapFlagMap = new TreeMap<Long, String>();
            for (Message message : this.messages) {
                imapFlagMap.put(message.getImapUid(), message.getImapFlags());
            }
            return imapFlagMap;
        }

        public boolean isCalendar() {
            return "IPF.Appointment".equals(this.folderClass);
        }

        public boolean isContact() {
            return "IPF.Contact".equals(this.folderClass);
        }

        public boolean isTask() {
            return "IPF.Task".equals(this.folderClass);
        }

        public void clearCache() {
            this.messages.cachedMimeContent = null;
            this.messages.cachedMimeMessage = null;
            this.messages.cachedMessageImapUid = 0L;
        }
    }

    public static abstract class MonoCondition
    implements Condition {
        protected final String attributeName;
        protected final Operator operator;

        protected MonoCondition(String attributeName, Operator operator) {
            this.attributeName = attributeName;
            this.operator = operator;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isMatch(Contact contact) {
            String actualValue = (String)contact.get(this.attributeName);
            return this.operator == Operator.IsNull && actualValue == null || this.operator == Operator.IsFalse && "false".equals(actualValue) || this.operator == Operator.IsTrue && "true".equals(actualValue);
        }
    }

    public static abstract class NotCondition
    implements Condition {
        protected final Condition condition;

        protected NotCondition(Condition condition) {
            this.condition = condition;
        }

        @Override
        public boolean isEmpty() {
            return this.condition.isEmpty();
        }

        @Override
        public boolean isMatch(Contact contact) {
            return !this.condition.isMatch(contact);
        }
    }

    public static abstract class MultiCondition
    implements Condition {
        protected final Operator operator;
        protected final List<Condition> conditions;

        protected MultiCondition(Operator operator, Condition ... conditions) {
            this.operator = operator;
            this.conditions = new ArrayList<Condition>();
            for (Condition condition : conditions) {
                if (condition == null) continue;
                this.conditions.add(condition);
            }
        }

        public List<Condition> getConditions() {
            return this.conditions;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public void add(Condition condition) {
            if (condition != null) {
                this.conditions.add(condition);
            }
        }

        @Override
        public boolean isEmpty() {
            boolean isEmpty = true;
            for (Condition condition : this.conditions) {
                if (condition.isEmpty()) continue;
                isEmpty = false;
                break;
            }
            return isEmpty;
        }

        @Override
        public boolean isMatch(Contact contact) {
            if (this.operator == Operator.And) {
                for (Condition condition : this.conditions) {
                    if (condition.isMatch(contact)) continue;
                    return false;
                }
                return true;
            }
            if (this.operator == Operator.Or) {
                for (Condition condition : this.conditions) {
                    if (!condition.isMatch(contact)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    public static abstract class AttributeCondition
    implements Condition {
        protected final String attributeName;
        protected final Operator operator;
        protected final String value;

        protected AttributeCondition(String attributeName, Operator operator, String value) {
            this.attributeName = attributeName;
            this.operator = operator;
            this.value = value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static interface Condition {
        public void appendTo(StringBuilder var1);

        public boolean isEmpty();

        public boolean isMatch(Contact var1);
    }

    public static enum Operator {
        Or,
        And,
        Not,
        IsEqualTo,
        IsGreaterThan,
        IsGreaterThanOrEqualTo,
        IsLessThan,
        IsLessThanOrEqualTo,
        IsNull,
        IsTrue,
        IsFalse,
        Like,
        StartsWith,
        Contains;

    }
}

