/*
 * Decompiled with CFR 0.152.
 */
package davmail;

import davmail.BundleMessage;
import davmail.ui.tray.DavGatewayTray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.http.util.TextUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;

public final class Settings {
    private static final Logger LOGGER = Logger.getLogger(Settings.class);
    public static final String OUTLOOK_URL = "https://outlook.office365.com";
    public static final String O365_URL = "https://outlook.office365.com/EWS/Exchange.asmx";
    public static final String GRAPH_URL = "https://graph.microsoft.com";
    public static final String O365_LOGIN_URL = "https://login.microsoftonline.com";
    public static final String O365 = "O365";
    public static final String O365_MODERN = "O365Modern";
    public static final String O365_INTERACTIVE = "O365Interactive";
    public static final String O365_MANUAL = "O365Manual";
    public static final String WEBDAV = "WebDav";
    public static final String EWS = "EWS";
    public static final String AUTO = "Auto";
    public static final String EDGE_USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36 Edg/90.0.818.49";
    private static final Properties SETTINGS_PROPERTIES = new Properties(){

        @Override
        public synchronized Enumeration<Object> keys() {
            Enumeration<Object> keysEnumeration = super.keys();
            TreeSet<String> sortedKeySet = new TreeSet<String>();
            while (keysEnumeration.hasMoreElements()) {
                sortedKeySet.add((String)keysEnumeration.nextElement());
            }
            final Iterator sortedKeysIterator = sortedKeySet.iterator();
            return new Enumeration<Object>(){

                @Override
                public boolean hasMoreElements() {
                    return sortedKeysIterator.hasNext();
                }

                @Override
                public Object nextElement() {
                    return sortedKeysIterator.next();
                }
            };
        }
    };
    private static String configFilePath;
    private static boolean isFirstStart;

    private Settings() {
    }

    public static synchronized void setConfigFilePath(String path) {
        configFilePath = path;
    }

    public static synchronized boolean isFirstStart() {
        return isFirstStart;
    }

    public static synchronized void load(InputStream inputStream) throws IOException {
        SETTINGS_PROPERTIES.load(inputStream);
        Settings.updateLoggingConfig();
    }

    public static synchronized void load() {
        block16: {
            try {
                File configFile;
                if (configFilePath == null) {
                    configFilePath = System.getProperty("user.home") + "/.davmail.properties";
                }
                if ((configFile = new File(configFilePath)).exists()) {
                    try (FileInputStream fileInputStream = new FileInputStream(configFile);){
                        Settings.load(fileInputStream);
                        break block16;
                    }
                }
                isFirstStart = true;
                Settings.setDefaultSettings();
                Settings.save();
            }
            catch (IOException e) {
                DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_LOAD_SETTINGS", new Object[0]), e);
            }
        }
        Settings.updateLoggingConfig();
    }

    public static void setDefaultSettings() {
        SETTINGS_PROPERTIES.put("davmail.mode", O365_INTERACTIVE);
        SETTINGS_PROPERTIES.put("davmail.url", Settings.getO365Url());
        SETTINGS_PROPERTIES.put("davmail.popPort", "1110");
        SETTINGS_PROPERTIES.put("davmail.imapPort", "1143");
        SETTINGS_PROPERTIES.put("davmail.smtpPort", "1025");
        SETTINGS_PROPERTIES.put("davmail.caldavPort", "1080");
        SETTINGS_PROPERTIES.put("davmail.ldapPort", "1389");
        SETTINGS_PROPERTIES.put("davmail.clientSoTimeout", "");
        SETTINGS_PROPERTIES.put("davmail.keepDelay", "30");
        SETTINGS_PROPERTIES.put("davmail.sentKeepDelay", "0");
        SETTINGS_PROPERTIES.put("davmail.caldavPastDelay", "0");
        SETTINGS_PROPERTIES.put("davmail.caldavAutoSchedule", Boolean.TRUE.toString());
        SETTINGS_PROPERTIES.put("davmail.imapIdleDelay", "");
        SETTINGS_PROPERTIES.put("davmail.folderSizeLimit", "");
        SETTINGS_PROPERTIES.put("davmail.enableKeepAlive", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("davmail.allowRemote", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("davmail.bindAddress", "");
        SETTINGS_PROPERTIES.put("davmail.useSystemProxies", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("davmail.enableProxy", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("davmail.enableKerberos", "false");
        SETTINGS_PROPERTIES.put("davmail.disableUpdateCheck", "false");
        SETTINGS_PROPERTIES.put("davmail.proxyHost", "");
        SETTINGS_PROPERTIES.put("davmail.proxyPort", "");
        SETTINGS_PROPERTIES.put("davmail.proxyUser", "");
        SETTINGS_PROPERTIES.put("davmail.proxyPassword", "");
        SETTINGS_PROPERTIES.put("davmail.noProxyFor", "");
        SETTINGS_PROPERTIES.put("davmail.server", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("davmail.server.certificate.hash", "");
        SETTINGS_PROPERTIES.put("davmail.caldavAlarmSound", "");
        SETTINGS_PROPERTIES.put("davmail.carddavReadPhoto", Boolean.TRUE.toString());
        SETTINGS_PROPERTIES.put("davmail.forceActiveSyncUpdate", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("davmail.showStartupBanner", Boolean.TRUE.toString());
        SETTINGS_PROPERTIES.put("davmail.disableGuiNotifications", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("davmail.disableTrayActivitySwitch", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("davmail.imapAutoExpunge", Boolean.TRUE.toString());
        SETTINGS_PROPERTIES.put("davmail.imapAlwaysApproxMsgSize", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("davmail.popMarkReadOnRetr", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("davmail.smtpSaveInSent", Boolean.TRUE.toString());
        SETTINGS_PROPERTIES.put("davmail.ssl.keystoreType", "");
        SETTINGS_PROPERTIES.put("davmail.ssl.keystoreFile", "");
        SETTINGS_PROPERTIES.put("davmail.ssl.keystorePass", "");
        SETTINGS_PROPERTIES.put("davmail.ssl.keyPass", "");
        if (Settings.isWindows()) {
            SETTINGS_PROPERTIES.put("davmail.ssl.clientKeystoreType", "MSCAPI");
        } else {
            SETTINGS_PROPERTIES.put("davmail.ssl.clientKeystoreType", "");
        }
        SETTINGS_PROPERTIES.put("davmail.ssl.clientKeystoreFile", "");
        SETTINGS_PROPERTIES.put("davmail.ssl.clientKeystorePass", "");
        SETTINGS_PROPERTIES.put("davmail.ssl.pkcs11Library", "");
        SETTINGS_PROPERTIES.put("davmail.ssl.pkcs11Config", "");
        SETTINGS_PROPERTIES.put("davmail.ssl.nosecurepop", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("davmail.ssl.nosecureimap", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("davmail.ssl.nosecuresmtp", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("davmail.ssl.nosecurecaldav", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("davmail.ssl.nosecureldap", Boolean.FALSE.toString());
        SETTINGS_PROPERTIES.put("log4j.rootLogger", Level.WARN.toString());
        SETTINGS_PROPERTIES.put("log4j.logger.davmail", Level.DEBUG.toString());
        SETTINGS_PROPERTIES.put("log4j.logger.httpclient.wire", Level.WARN.toString());
        SETTINGS_PROPERTIES.put("log4j.logger.httpclient", Level.WARN.toString());
        String logFilePath = "";
        if (Settings.isFlatpak()) {
            logFilePath = System.getenv("XDG_DATA_HOME") + "/davmail.log";
        }
        SETTINGS_PROPERTIES.put("davmail.logFilePath", logFilePath);
    }

    public static String getLogFilePath() {
        String logFilePath = Settings.getProperty("davmail.logFilePath");
        if (logFilePath == null || logFilePath.isEmpty()) {
            logFilePath = Settings.getBooleanProperty("davmail.server") ? "davmail.log" : (System.getProperty("os.name").toLowerCase().startsWith("mac os x") ? System.getProperty("user.home") + "/Library/Logs/DavMail/davmail.log" : System.getProperty("user.home") + "/davmail.log");
        } else {
            File logFile = new File(logFilePath);
            if (logFile.isDirectory()) {
                logFilePath = logFilePath + "/davmail.log";
            }
        }
        return logFilePath;
    }

    public static String getLogFileDirectory() {
        String logFilePath = Settings.getLogFilePath();
        if (logFilePath == null || logFilePath.isEmpty()) {
            return ".";
        }
        int lastSlashIndex = logFilePath.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            lastSlashIndex = logFilePath.lastIndexOf(92);
        }
        if (lastSlashIndex >= 0) {
            return logFilePath.substring(0, lastSlashIndex);
        }
        return ".";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLoggingConfig() {
        String logFilePath = Settings.getLogFilePath();
        try {
            ConsoleAppender consoleAppender;
            if (!Settings.isDocker()) {
                Object logFile;
                if (logFilePath != null && !logFilePath.isEmpty()) {
                    logFile = new File(logFilePath);
                    File logFileDir = ((File)logFile).getParentFile();
                    if (logFileDir != null && !logFileDir.exists() && !logFileDir.mkdirs()) {
                        DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_CREATE_LOG_FILE_DIR", new Object[0]));
                        throw new IOException();
                    }
                } else {
                    logFilePath = "davmail.log";
                }
                logFile = Logger.getRootLogger();
                synchronized (logFile) {
                    FileAppender fileAppender = (FileAppender)Logger.getRootLogger().getAppender("FileAppender");
                    if (fileAppender == null) {
                        String logFileSize = Settings.getProperty("davmail.logFileSize");
                        if (logFileSize == null || logFileSize.isEmpty()) {
                            logFileSize = "1MB";
                        }
                        if ("0".equals(logFileSize)) {
                            fileAppender = new FileAppender();
                        } else {
                            fileAppender = new RollingFileAppender();
                            ((RollingFileAppender)fileAppender).setMaxBackupIndex(2);
                            ((RollingFileAppender)fileAppender).setMaxFileSize(logFileSize);
                        }
                        fileAppender.setName("FileAppender");
                        fileAppender.setEncoding("UTF-8");
                        fileAppender.setLayout((Layout)new PatternLayout("%d{ISO8601} %-5p [%t] %c %x - %m%n"));
                    }
                    fileAppender.setFile(logFilePath, true, false, 8192);
                    Logger.getRootLogger().addAppender((Appender)fileAppender);
                }
            }
            if ((consoleAppender = (ConsoleAppender)Logger.getRootLogger().getAppender("ConsoleAppender")) != null) {
                if (Settings.getBooleanProperty("davmail.server")) {
                    consoleAppender.setThreshold((Priority)Level.ALL);
                } else {
                    consoleAppender.setThreshold((Priority)Level.INFO);
                }
            }
        }
        catch (IOException e) {
            DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_SET_LOG_FILE_PATH", new Object[0]));
        }
        Settings.setLoggingLevel("rootLogger", Settings.getLoggingLevel("rootLogger"));
        Settings.setLoggingLevel("davmail", Settings.getLoggingLevel("davmail"));
        Settings.setLoggingLevel("org.apache.http.wire", Settings.getLoggingLevel("httpclient.wire"));
        Settings.setLoggingLevel("org.apache.http.conn.ssl", Settings.getLoggingLevel("httpclient.wire"));
        Settings.setLoggingLevel("org.apache.http", Settings.getLoggingLevel("httpclient"));
    }

    public static synchronized void save() {
        if (configFilePath != null) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)SETTINGS_PROPERTIES);
            ArrayList<String> lines = new ArrayList<String>();
            Path path = Paths.get(configFilePath, new String[0]);
            if (!Files.exists(path, new LinkOption[0]) && Settings.isUnix()) {
                FileAttribute<Set<PosixFilePermission>> permissions = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------"));
                try {
                    Files.createFile(path, permissions);
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage());
                }
            }
            Settings.readLines(lines, properties);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(configFilePath, new String[0]), new OpenOption[0]), StandardCharsets.ISO_8859_1));){
                for (String value : lines) {
                    writer.write(value);
                    writer.newLine();
                }
                Enumeration<?> propertyEnumeration = properties.propertyNames();
                while (propertyEnumeration.hasMoreElements()) {
                    String propertyName = (String)propertyEnumeration.nextElement();
                    writer.write(propertyName + "=" + Settings.escapeValue(properties.getProperty(propertyName)));
                    writer.newLine();
                }
            }
            catch (IOException e) {
                DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_STORE_SETTINGS", new Object[0]), e);
            }
        }
        Settings.updateLoggingConfig();
    }

    private static void readLines(ArrayList<String> lines, Properties properties) {
        block15: {
            try {
                File configFile = new File(configFilePath);
                if (!configFile.exists()) break block15;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(configFile.toPath(), new OpenOption[0]), StandardCharsets.ISO_8859_1));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        lines.add(Settings.convertLine(line, properties));
                    }
                }
            }
            catch (IOException e) {
                DavGatewayTray.error(new BundleMessage("LOG_UNABLE_TO_LOAD_SETTINGS", new Object[0]), e);
            }
        }
    }

    private static String convertLine(String line, Properties properties) {
        String key;
        String value;
        int hashIndex = line.indexOf(35);
        int equalsIndex = line.indexOf(61);
        if (equalsIndex >= 0 && (hashIndex < 0 || hashIndex >= equalsIndex) && (value = properties.getProperty(key = line.substring(0, equalsIndex))) != null) {
            line = key + "=" + Settings.escapeValue(value);
            properties.remove(key);
        }
        return line;
    }

    private static String escapeValue(String value) {
        StringBuilder buffer = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (c == '\\') {
                buffer.append('\\');
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static synchronized String getProperty(String property) {
        String value = SETTINGS_PROPERTIES.getProperty(property);
        if (value != null && value.isEmpty()) {
            value = null;
        }
        return value;
    }

    public static synchronized String getProperty(String property, String defaultValue) {
        String value = Settings.getProperty(property);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static synchronized char[] getCharArrayProperty(String property) {
        String propertyValue = Settings.getProperty(property);
        char[] value = null;
        if (propertyValue != null) {
            value = propertyValue.toCharArray();
        }
        return value;
    }

    public static synchronized void setProperty(String property, String value) {
        if (value != null) {
            SETTINGS_PROPERTIES.setProperty(property, value);
        } else {
            SETTINGS_PROPERTIES.setProperty(property, "");
        }
    }

    public static synchronized int getIntProperty(String property) {
        return Settings.getIntProperty(property, 0);
    }

    public static synchronized int getIntProperty(String property, int defaultValue) {
        int value = defaultValue;
        try {
            String propertyValue = SETTINGS_PROPERTIES.getProperty(property);
            if (propertyValue != null && !propertyValue.isEmpty()) {
                value = Integer.parseInt(propertyValue);
            }
        }
        catch (NumberFormatException e) {
            DavGatewayTray.error(new BundleMessage("LOG_INVALID_SETTING_VALUE", property), e);
        }
        return value;
    }

    public static synchronized boolean getBooleanProperty(String property) {
        String propertyValue = SETTINGS_PROPERTIES.getProperty(property);
        return Boolean.parseBoolean(propertyValue);
    }

    public static synchronized boolean getBooleanProperty(String property, boolean defaultValue) {
        boolean value = defaultValue;
        String propertyValue = SETTINGS_PROPERTIES.getProperty(property);
        if (propertyValue != null && !propertyValue.isEmpty()) {
            value = Boolean.parseBoolean(propertyValue);
        }
        return value;
    }

    public static synchronized String loadRefreshToken(String username) {
        String tokenFilePath = Settings.getProperty("davmail.oauth.tokenFilePath");
        if (TextUtils.isEmpty((CharSequence)tokenFilePath)) {
            return Settings.getProperty("davmail.oauth." + username.toLowerCase() + ".refreshToken");
        }
        return Settings.loadtokenFromFile(tokenFilePath, username.toLowerCase());
    }

    public static synchronized void storeRefreshToken(String username, String refreshToken) {
        String tokenFilePath = Settings.getProperty("davmail.oauth.tokenFilePath");
        if (TextUtils.isEmpty((CharSequence)tokenFilePath)) {
            Settings.setProperty("davmail.oauth." + username.toLowerCase() + ".refreshToken", refreshToken);
            Settings.save();
        } else {
            Settings.savetokentoFile(tokenFilePath, username.toLowerCase(), refreshToken);
        }
    }

    private static void savetokentoFile(String tokenFilePath, String username, String refreshToken) {
        try {
            Settings.checkCreateTokenFilePath(tokenFilePath);
            Properties properties = new Properties();
            try (FileInputStream fis = new FileInputStream(tokenFilePath);){
                properties.load(fis);
            }
            properties.setProperty(username, refreshToken);
            var5_6 = null;
            try (FileOutputStream fos = new FileOutputStream(tokenFilePath);){
                properties.store(fos, "Oauth tokens");
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.getLogger(Settings.class).warn((Object)(e + " " + e.getMessage()));
        }
    }

    private static String loadtokenFromFile(String tokenFilePath, String username) {
        try {
            Settings.checkCreateTokenFilePath(tokenFilePath);
            Properties properties = new Properties();
            try (FileInputStream fis = new FileInputStream(tokenFilePath);){
                properties.load(fis);
            }
            return properties.getProperty(username);
        }
        catch (IOException e) {
            Logger.getLogger(Settings.class).warn((Object)(e + " " + e.getMessage()));
            return null;
        }
    }

    private static void checkCreateTokenFilePath(String tokenFilePath) throws IOException {
        File file = new File(tokenFilePath);
        File parentFile = file.getParentFile();
        if (parentFile != null && parentFile.mkdirs()) {
            LOGGER.info((Object)("Created token file directory " + parentFile.getAbsolutePath()));
        }
        if (file.createNewFile()) {
            LOGGER.info((Object)("Created token file " + tokenFilePath));
        }
    }

    private static String getLoggingPrefix(String category) {
        String prefix = "rootLogger".equals(category) ? "log4j." : "log4j.logger.";
        return prefix;
    }

    public static synchronized Level getLoggingLevel(String category) {
        String prefix = Settings.getLoggingPrefix(category);
        String currentValue = SETTINGS_PROPERTIES.getProperty(prefix + category);
        if (currentValue != null && !currentValue.isEmpty()) {
            return Level.toLevel((String)currentValue);
        }
        if ("rootLogger".equals(category)) {
            return Logger.getRootLogger().getLevel();
        }
        return Logger.getLogger((String)category).getLevel();
    }

    public static synchronized Properties getSubProperties(String scope) {
        String keyStart = scope == null || scope.isEmpty() ? "" : (scope.endsWith(".") ? scope : scope + '.');
        Properties result = new Properties();
        for (Map.Entry<Object, Object> entry : SETTINGS_PROPERTIES.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(keyStart)) continue;
            String value = (String)entry.getValue();
            result.setProperty(key.substring(keyStart.length()), value);
        }
        return result;
    }

    public static synchronized void setLoggingLevel(String category, Level level) {
        if (level != null) {
            String prefix = Settings.getLoggingPrefix(category);
            SETTINGS_PROPERTIES.setProperty(prefix + category, level.toString());
            if ("rootLogger".equals(category)) {
                Logger.getRootLogger().setLevel(level);
            } else {
                Logger.getLogger((String)category).setLevel(level);
            }
        }
    }

    public static synchronized void saveProperty(String property, String value) {
        Settings.load();
        Settings.setProperty(property, value);
        Settings.save();
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    public static boolean isUnix() {
        return Settings.isLinux() || System.getProperty("os.name").toLowerCase().startsWith("freebsd");
    }

    public static String getUserAgent() {
        return Settings.getProperty("davmail.userAgent", EDGE_USER_AGENT);
    }

    public static String getOutlookUrl() {
        String tld = Settings.getProperty("davmail.tld");
        String outlookUrl = Settings.getProperty("davmail.outlookUrl");
        if (outlookUrl != null) {
            return outlookUrl;
        }
        if (tld == null) {
            return OUTLOOK_URL;
        }
        return "https://outlook.office365." + tld;
    }

    public static String getO365Url() {
        String tld = Settings.getProperty("davmail.tld");
        String outlookUrl = Settings.getProperty("davmail.outlookUrl");
        if (outlookUrl != null) {
            return outlookUrl + "/EWS/Exchange.asmx";
        }
        if (tld == null) {
            return O365_URL;
        }
        return "https://outlook.office365." + tld + "/EWS/Exchange.asmx";
    }

    public static String getGraphUrl() {
        String tld = Settings.getProperty("davmail.tld");
        String graphUrl = Settings.getProperty("davmail.graphUrl");
        if (graphUrl != null) {
            return graphUrl;
        }
        if (tld == null) {
            return GRAPH_URL;
        }
        return "https://graph.microsoft." + tld;
    }

    public static String getO365LoginUrl() {
        String tld = Settings.getProperty("davmail.tld");
        String loginUrl = Settings.getProperty("davmail.loginUrl");
        if (loginUrl != null) {
            return loginUrl;
        }
        if (tld == null) {
            return O365_LOGIN_URL;
        }
        return "https://login.microsoftonline." + tld;
    }

    public static boolean isSWTAvailable() {
        boolean isSWTAvailable = false;
        ClassLoader classloader = Settings.class.getClassLoader();
        try {
            classloader.loadClass("org.eclipse.swt.SWT");
            isSWTAvailable = true;
        }
        catch (Throwable e) {
            LOGGER.info((Object)new BundleMessage("LOG_SWT_NOT_AVAILABLE", new Object[0]));
        }
        return isSWTAvailable;
    }

    public static boolean isJFXAvailable() {
        boolean isJFXAvailable = false;
        try {
            Class.forName("javafx.application.Platform");
            isJFXAvailable = true;
        }
        catch (ClassNotFoundException | NullPointerException e) {
            LOGGER.info((Object)"JavaFX (OpenJFX) not available");
        }
        return isJFXAvailable;
    }

    public static boolean isDocker() {
        boolean isDocker = new File("/.dockerenv").exists();
        if (isDocker) {
            LOGGER.info((Object)"Running in docker");
        }
        return isDocker;
    }

    public static boolean isFlatpak() {
        boolean isFlatpak = "flatpak".equals(System.getenv("container"));
        if (isFlatpak) {
            LOGGER.info((Object)"Running in Flatpak");
        }
        return isFlatpak;
    }

    public static synchronized String getConfigFilePath() {
        if (Settings.isFlatpak()) {
            return System.getenv("XDG_CONFIG_HOME") + "/davmail.properties";
        }
        return System.getenv("DAVMAIL_PROPERTIES");
    }
}

