/*
 * Decompiled with CFR 0.152.
 */
package davmail;

import davmail.AbstractServer;
import davmail.BundleMessage;
import davmail.Settings;
import davmail.caldav.CaldavServer;
import davmail.exception.DavMailException;
import davmail.exchange.ExchangeSessionFactory;
import davmail.exchange.auth.ExchangeAuthenticator;
import davmail.http.HttpClientAdapter;
import davmail.http.request.GetRequest;
import davmail.imap.ImapServer;
import davmail.ldap.LdapServer;
import davmail.pop.PopServer;
import davmail.smtp.SmtpServer;
import davmail.ui.tray.DavGatewayTray;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class DavGateway {
    private static final Logger LOGGER = Logger.getLogger(DavGateway.class);
    private static final String HTTP_DAVMAIL_SOURCEFORGE_NET_VERSION_TXT = "https://davmail.sourceforge.net/version.txt";
    private static final Object LOCK = new Object();
    private static boolean shutdown = false;
    private static final ArrayList<AbstractServer> SERVER_LIST = new ArrayList();

    private DavGateway() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean notray = false;
        boolean server = false;
        boolean token = false;
        String configFilePath = Settings.getConfigFilePath();
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if ("-notray".equals(arg)) {
                    notray = true;
                    continue;
                }
                if ("-server".equals(arg)) {
                    server = true;
                    continue;
                }
                if (!"-token".equals(arg)) continue;
                token = true;
                continue;
            }
            configFilePath = arg;
        }
        Settings.setConfigFilePath(configFilePath);
        Settings.load();
        if (token) {
            try {
                ExchangeAuthenticator exchangeAuthenticator = (ExchangeAuthenticator)Class.forName("davmail.exchange.auth.O365InteractiveAuthenticator").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                exchangeAuthenticator.setUsername("");
                exchangeAuthenticator.authenticate();
                System.out.println(exchangeAuthenticator.getToken().getRefreshToken());
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                System.err.println(exception + " " + exception.getMessage());
            }
            System.exit(0);
        } else {
            if (GraphicsEnvironment.isHeadless()) {
                LOGGER.debug((Object)"Headless mode, do not create GUI");
                server = true;
            }
            if (server) {
                Settings.setProperty("davmail.server", "true");
                Settings.updateLoggingConfig();
            }
            if (Settings.getBooleanProperty("davmail.server")) {
                LOGGER.debug((Object)"Start DavMail in server mode");
            } else {
                LOGGER.debug((Object)"Start DavMail in GUI mode");
                DavGatewayTray.init(notray);
            }
            DavGateway.start();
            if (Settings.getBooleanProperty("davmail.server")) {
                Runtime.getRuntime().addShutdownHook(new Thread("Shutdown"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        shutdown = true;
                        DavGatewayTray.debug(new BundleMessage("LOG_GATEWAY_INTERRUPTED", new Object[0]));
                        DavGateway.stop();
                        Object object = LOCK;
                        synchronized (object) {
                            LOCK.notifyAll();
                        }
                    }
                });
                Object object = LOCK;
                synchronized (object) {
                    try {
                        while (!shutdown) {
                            LOCK.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        DavGatewayTray.debug(new BundleMessage("LOG_GATEWAY_INTERRUPTED", new Object[0]));
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    public static void start() {
        int ldapPort;
        int caldavPort;
        int imapPort;
        int popPort;
        SERVER_LIST.clear();
        int smtpPort = Settings.getIntProperty("davmail.smtpPort");
        if (smtpPort != 0) {
            SERVER_LIST.add(new SmtpServer(smtpPort));
        }
        if ((popPort = Settings.getIntProperty("davmail.popPort")) != 0) {
            SERVER_LIST.add(new PopServer(popPort));
        }
        if ((imapPort = Settings.getIntProperty("davmail.imapPort")) != 0) {
            SERVER_LIST.add(new ImapServer(imapPort));
        }
        if ((caldavPort = Settings.getIntProperty("davmail.caldavPort")) != 0) {
            SERVER_LIST.add(new CaldavServer(caldavPort));
        }
        if ((ldapPort = Settings.getIntProperty("davmail.ldapPort")) != 0) {
            SERVER_LIST.add(new LdapServer(ldapPort));
        }
        BundleMessage.BundleMessageList messages = new BundleMessage.BundleMessageList();
        BundleMessage.BundleMessageList errorMessages = new BundleMessage.BundleMessageList();
        for (AbstractServer server : SERVER_LIST) {
            try {
                server.bind();
                server.start();
                messages.add(new BundleMessage("LOG_PROTOCOL_PORT", server.getProtocolName(), server.getPort()));
            }
            catch (DavMailException e) {
                errorMessages.add(e.getBundleMessage());
            }
        }
        final String currentVersion = DavGateway.getCurrentVersion();
        boolean showStartupBanner = Settings.getBooleanProperty("davmail.showStartupBanner", true);
        if (showStartupBanner) {
            DavGatewayTray.info(new BundleMessage("LOG_DAVMAIL_GATEWAY_LISTENING", currentVersion, messages));
        }
        if (!errorMessages.isEmpty()) {
            DavGatewayTray.error(new BundleMessage("LOG_MESSAGE", errorMessages));
        }
        new Thread("CheckRelease"){

            @Override
            public void run() {
                String releasedVersion = DavGateway.getReleasedVersion();
                if (!currentVersion.isEmpty() && releasedVersion != null && currentVersion.compareTo(releasedVersion) < 0) {
                    DavGatewayTray.info(new BundleMessage("LOG_NEW_VERSION_AVAILABLE", releasedVersion));
                }
            }
        }.start();
    }

    public static void stop() {
        DavGateway.stopServers();
        ExchangeSessionFactory.shutdown();
        DavGatewayTray.info(new BundleMessage("LOG_GATEWAY_STOP", new Object[0]));
        DavGatewayTray.dispose();
    }

    public static void restart() {
        DavGateway.stopServers();
        ExchangeSessionFactory.shutdown();
        DavGateway.start();
    }

    private static void stopServers() {
        for (AbstractServer server : SERVER_LIST) {
            server.close();
            try {
                server.join();
            }
            catch (InterruptedException e) {
                DavGatewayTray.warn(new BundleMessage("LOG_EXCEPTION_WAITING_SERVER_THREAD_DIE", new Object[0]), e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static String getCurrentVersion() {
        Package davmailPackage = DavGateway.class.getPackage();
        String currentVersion = davmailPackage.getImplementationVersion();
        if (currentVersion == null) {
            currentVersion = "";
        }
        return currentVersion;
    }

    public static String getReleasedVersion() {
        String version = null;
        if (!Settings.getBooleanProperty("davmail.disableUpdateCheck")) {
            try (HttpClientAdapter httpClientAdapter = new HttpClientAdapter(HTTP_DAVMAIL_SOURCEFORGE_NET_VERSION_TXT);){
                GetRequest getRequest = new GetRequest(HTTP_DAVMAIL_SOURCEFORGE_NET_VERSION_TXT);
                getRequest.setHeader("User-Agent", "Mozilla/5.0");
                getRequest = httpClientAdapter.executeFollowRedirect(getRequest);
                version = getRequest.getResponseBodyAsString();
                LOGGER.debug((Object)("DavMail released version: " + version));
            }
            catch (IOException e) {
                DavGatewayTray.debug(new BundleMessage("LOG_UNABLE_TO_GET_RELEASED_VERSION", new Object[0]));
            }
        }
        return version;
    }
}

